/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.API.Interfaces;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.world.IBlockAccess;

public interface EnvironmentalHeatSource {
    public SourceType getSourceType(IBlockAccess var1, int var2, int var3, int var4);

    public boolean isActive(IBlockAccess var1, int var2, int var3, int var4);

    public static enum SourceType {
        ICY(-15),
        WATER(12),
        FIRE(300),
        LAVA(1200),
        AMBIENT(25),
        CRYO(-196),
        PLASMA(8000),
        NUCLEAR(150000000);

        public final int approxTemperature;
        private static final TreeMap<Integer, SourceType> temperatureMap;

        private SourceType(int t) {
            this.approxTemperature = t;
        }

        public static SourceType getByTemperature(int temp) {
            if (temp > 1000000) {
                return NUCLEAR;
            }
            if (temp > 4000) {
                return PLASMA;
            }
            Map.Entry<Integer, SourceType> colder = temperatureMap.floorEntry(temp);
            Map.Entry<Integer, SourceType> hotter = temperatureMap.ceilingEntry(temp);
            if (colder == null) {
                return hotter.getValue();
            }
            if (hotter == null) {
                return colder.getValue();
            }
            return temp - colder.getKey() < hotter.getKey() - temp ? colder.getValue() : hotter.getValue();
        }

        public boolean isHot() {
            return this.approxTemperature > 30;
        }

        public boolean isCold() {
            return this.approxTemperature <= 0;
        }

        static {
            temperatureMap = new TreeMap();
            for (SourceType s : SourceType.values()) {
                temperatureMap.put(s.approxTemperature, s);
            }
        }
    }
}

