/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.api.hunger;

import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;

public abstract class ExhaustionEvent
extends Event {
    public final EntityPlayer player;

    public ExhaustionEvent(EntityPlayer player) {
        this.player = player;
    }

    @Cancelable
    public static class ExhaustFromHurt
    extends ExhaustionEvent {
        public DamageSource source;
        public float damage;

        public ExhaustFromHurt(EntityPlayer player, DamageSource source, float damage) {
            super(player);
            this.source = source;
            this.damage = damage;
        }
    }

    @Cancelable
    public static class Exhausted
    extends ExhaustionEvent {
        public final float currentExhaustionLevel;
        public float deltaExhaustion;
        public int deltaHunger = -1;
        public float deltaSaturation = -1.0f;

        public Exhausted(EntityPlayer player, float exhaustionToRemove, float currentExhaustionLevel) {
            super(player);
            boolean shouldDecreaseFoodLevel;
            boolean shouldDecreaseSaturationLevel;
            this.deltaExhaustion = -exhaustionToRemove;
            this.currentExhaustionLevel = currentExhaustionLevel;
            boolean bl = shouldDecreaseSaturationLevel = player.func_71024_bL().func_75115_e() > 0.0f;
            if (!shouldDecreaseSaturationLevel) {
                this.deltaSaturation = 0.0f;
            }
            EnumDifficulty difficulty = player.field_70170_p.field_73013_u;
            boolean bl2 = shouldDecreaseFoodLevel = !shouldDecreaseSaturationLevel && difficulty != EnumDifficulty.PEACEFUL;
            if (!shouldDecreaseFoodLevel) {
                this.deltaHunger = 0;
            }
        }
    }

    public static class GetMaxExhaustion
    extends ExhaustionEvent {
        public float maxExhaustionLevel = 4.0f;

        public GetMaxExhaustion(EntityPlayer player) {
            super(player);
        }
    }

    @Event.HasResult
    public static class AllowExhaustion
    extends ExhaustionEvent {
        public AllowExhaustion(EntityPlayer player) {
            super(player);
        }
    }
}

