/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.mixins.early.minecraft;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.mixinplugin.ducks.EntityPlayerExt;
import squeek.applecore.mixinplugin.ducks.FoodStatsExt;

@Mixin(value={EntityPlayer.class})
public abstract class EntityPlayerMixin
extends EntityLivingBase
implements EntityPlayerExt {
    @Unique
    private int itemInUseMaxDuration;
    @Shadow
    protected FoodStats field_71100_bB;

    private EntityPlayerMixin() {
        super(null);
    }

    @Shadow
    @SideOnly(value=Side.CLIENT)
    public abstract ItemStack func_71011_bu();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void redirectNewFoodStats(World world, GameProfile gameProfile, CallbackInfo callbackInfo) {
        ((FoodStatsExt)this.field_71100_bB).setPlayer((EntityPlayer)this);
    }

    @Inject(method={"setItemInUse"}, at={@At(value="FIELD", target="net/minecraft/entity/player/EntityPlayer.itemInUseCount : I", shift=At.Shift.AFTER)})
    private void onSetItemInUse(ItemStack itemStack, int maxItemUseDuration, CallbackInfo callbackInfo) {
        this.itemInUseMaxDuration = maxItemUseDuration;
    }

    @Redirect(method={"getItemInUseDuration"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getMaxItemUseDuration()I"))
    @SideOnly(value=Side.CLIENT)
    private int redirect(ItemStack instance) {
        EnumAction useAction = this.func_71011_bu().func_77975_n();
        if (useAction == EnumAction.eat || useAction == EnumAction.drink) {
            return this.itemInUseMaxDuration;
        }
        return this.func_71011_bu().func_77988_m();
    }

    @Override
    public int getItemInUseMaxDuration() {
        return this.itemInUseMaxDuration;
    }

    @Redirect(method={"onLivingUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;heal (F)V"))
    private void redirectHeal(EntityPlayer thiz, float value) {
        HealthRegenEvent.PeacefulRegen peacefulRegenEvent = new HealthRegenEvent.PeacefulRegen((EntityPlayer)this);
        MinecraftForge.EVENT_BUS.post((Event)peacefulRegenEvent);
        if (!peacefulRegenEvent.isCanceled()) {
            this.func_70691_i(peacefulRegenEvent.deltaHealth);
        }
    }

    @Redirect(method={"damageEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;addExhaustion(F)V"))
    private void redirectExhaustionFromHurt(EntityPlayer instance, float p_71020_1_, @Local(name={"p_70665_1_"}) DamageSource source, @Local(name={"p_70665_2_"}) float damage) {
        ExhaustionEvent.ExhaustFromHurt ExhaustFromHurtEvent = new ExhaustionEvent.ExhaustFromHurt((EntityPlayer)this, source, damage);
        MinecraftForge.EVENT_BUS.post((Event)ExhaustFromHurtEvent);
        if (!ExhaustFromHurtEvent.isCanceled()) {
            instance.func_71020_j(ExhaustFromHurtEvent.source.func_76345_d());
        }
    }
}

