/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.GraveProcessor;
import de.maxhenkel.gravestone.Log;
import de.maxhenkel.gravestone.ModItems;
import de.maxhenkel.gravestone.util.BlockPos;
import de.maxhenkel.gravestone.util.Tools;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class DeathEvents {
    private boolean livingGraves;
    private boolean givePlayerNote;

    public DeathEvents() {
        this.livingGraves = Config.instance().livingGraves;
        this.givePlayerNote = Config.instance().giveDeathNotes;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!this.givePlayerNote) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.wasDeath) {
            return;
        }
        if (Tools.keepInventory(event.entityPlayer)) {
            return;
        }
        for (ItemStack stack : event.original.field_71071_by.field_70462_a) {
            if (!DeathInfo.isDeathInfoItem(stack)) continue;
            event.entityPlayer.field_71071_by.func_70441_a(stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.entity instanceof EntityLivingBase)) {
            return;
        }
        if (!(event.entity instanceof EntityPlayer) && !this.livingGraves) {
            return;
        }
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        try {
            ArrayList drops = event.drops;
            EntityLivingBase entity = (EntityLivingBase)event.entity;
            GraveProcessor graveProcessor = new GraveProcessor(entity);
            if (graveProcessor.placeGraveStone(drops)) {
                event.setCanceled(true);
            } else if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).func_145747_a((IChatComponent)new ChatComponentText("[" + Tools.translate("message.name", new Object[0]) + "] " + Tools.translate("message.create_grave_failed", new Object[0])));
            }
            if (this.givePlayerNote) {
                graveProcessor.givePlayerNote();
            }
        }
        catch (Exception e) {
            Log.w("Failed to process death of '" + event.entity.func_70005_c_() + "'");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        if (!Tools.keepInventory(player)) {
            return;
        }
        try {
            DeathEvents.givePlayerNote(player);
        }
        catch (Exception e) {
            Log.w("Failed to give player '" + player.getDisplayName() + "' death note");
        }
    }

    public static void givePlayerNote(EntityPlayer player) {
        DeathInfo info = new DeathInfo(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), player.field_71093_bK, new DeathInfo.ItemInfo[0], player.getDisplayName(), System.currentTimeMillis(), player.func_110124_au());
        ItemStack stack = new ItemStack((Item)ModItems.DEATH_INFO);
        info.addToItemStack(stack);
        player.field_71071_by.func_70441_a(stack);
    }
}

