/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft;

import com.pam.harvestcraft.ItemRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public class TrapRecipes {
    public static final Map<Item, List<WeightedItemStack>> ANIMAL_TRAP_RECIPES = new HashMap<Item, List<WeightedItemStack>>();
    public static final Map<Item, List<WeightedItemStack>> FISH_TRAP_RECIPES = new HashMap<Item, List<WeightedItemStack>>();
    private static final Random RANDOM = new Random();

    public static void initRecipes() {
        TrapRecipes.addAnimalRecipe(ItemRegistry.grainbaitItem, new ItemStack(ItemRegistry.turkeyrawItem), 2);
        TrapRecipes.addAnimalRecipe(ItemRegistry.grainbaitItem, new ItemStack(Items.field_151082_bd));
        TrapRecipes.addAnimalRecipe(ItemRegistry.grainbaitItem, new ItemStack(Items.field_151076_bf), 3);
        TrapRecipes.addAnimalRecipe(ItemRegistry.grainbaitItem, new ItemStack(Items.field_151116_aA));
        TrapRecipes.addAnimalRecipe(ItemRegistry.grainbaitItem, new ItemStack(Items.field_151008_G), 2);
        TrapRecipes.addAnimalRecipe(ItemRegistry.grainbaitItem, new ItemStack(Items.field_151110_aK));
        TrapRecipes.addAnimalRecipe(ItemRegistry.grainbaitItem, new ItemStack(Items.field_151103_aS));
        TrapRecipes.addAnimalRecipe(ItemRegistry.fruitbaitItem, new ItemStack(ItemRegistry.rabbitrawItem), 3);
        TrapRecipes.addAnimalRecipe(ItemRegistry.fruitbaitItem, new ItemStack(Items.field_151076_bf), 3);
        TrapRecipes.addAnimalRecipe(ItemRegistry.fruitbaitItem, new ItemStack(Items.field_151116_aA));
        TrapRecipes.addAnimalRecipe(ItemRegistry.fruitbaitItem, new ItemStack(Items.field_151008_G), 2);
        TrapRecipes.addAnimalRecipe(ItemRegistry.fruitbaitItem, new ItemStack(Items.field_151110_aK));
        TrapRecipes.addAnimalRecipe(ItemRegistry.fruitbaitItem, new ItemStack(Items.field_151103_aS));
        TrapRecipes.addAnimalRecipe(ItemRegistry.veggiebaitItem, new ItemStack(ItemRegistry.venisonrawItem));
        TrapRecipes.addAnimalRecipe(ItemRegistry.veggiebaitItem, new ItemStack(ItemRegistry.muttonrawItem));
        TrapRecipes.addAnimalRecipe(ItemRegistry.veggiebaitItem, new ItemStack(Items.field_151147_al));
        TrapRecipes.addAnimalRecipe(ItemRegistry.veggiebaitItem, new ItemStack(Items.field_151076_bf), 3);
        TrapRecipes.addAnimalRecipe(ItemRegistry.veggiebaitItem, new ItemStack(Items.field_151116_aA));
        TrapRecipes.addAnimalRecipe(ItemRegistry.veggiebaitItem, new ItemStack(Items.field_151008_G), 2);
        TrapRecipes.addAnimalRecipe(ItemRegistry.veggiebaitItem, new ItemStack(Items.field_151110_aK));
        TrapRecipes.addAnimalRecipe(ItemRegistry.veggiebaitItem, new ItemStack(Items.field_151103_aS));
        if (ItemRegistry.enableharvestcraftfish) {
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(Items.field_151115_aP, 1, 0), 3);
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(Items.field_151115_aP, 1, 1));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(Items.field_151115_aP, 1, 2));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(Items.field_151115_aP, 1, 3));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.anchovyrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.bassrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.carprawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.catfishrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.charrrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.clamrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.crabrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.crayfishrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.eelrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.frograwItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.greenheartfishItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.grouperrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.herringrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.jellyfishrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.mudfishrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.octopusrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.perchrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.scalloprawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.shrimprawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.snailrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.snapperrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.tilapiarawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.troutrawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.tunarawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.turtlerawItem));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(ItemRegistry.walleyerawItem));
        } else {
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(Items.field_151115_aP, 1, 0), 7);
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(Items.field_151115_aP, 1, 1), 2);
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(Items.field_151115_aP, 1, 2));
            TrapRecipes.addFishRecipe(ItemRegistry.fishtrapbaitItem, new ItemStack(Items.field_151115_aP, 1, 3));
        }
    }

    public static void addAnimalRecipe(@Nullable Item bait, @Nullable ItemStack out) {
        TrapRecipes.addAnimalRecipe(bait, out, 1);
    }

    public static void addAnimalRecipe(@Nullable Item bait, @Nullable ItemStack out, @Nonnegative @Nonnull int weight) {
        TrapRecipes.addRecipe(ANIMAL_TRAP_RECIPES, bait, out, weight);
    }

    public static void addFishRecipe(@Nullable Item bait, @Nullable ItemStack out) {
        TrapRecipes.addFishRecipe(bait, out, 1);
    }

    public static void addFishRecipe(@Nullable Item bait, @Nullable ItemStack out, @Nonnegative @Nonnull int weight) {
        TrapRecipes.addRecipe(FISH_TRAP_RECIPES, bait, out, weight);
    }

    public static void addRecipe(@Nonnull Map<Item, List<WeightedItemStack>> recipes, @Nullable Item bait, @Nullable ItemStack out, @Nonnegative @Nonnull int weight) {
        List<WeightedItemStack> recipe = recipes.get(bait);
        if (recipe == null) {
            recipe = new ArrayList<WeightedItemStack>();
            recipes.put(bait, recipe);
        }
        recipe.add(new WeightedItemStack(out, weight));
    }

    @Nullable
    public static ItemStack getRandomOutputForBait(@Nonnull Map<Item, List<WeightedItemStack>> recipes, @Nullable Item bait) {
        List<WeightedItemStack> possibleOutput = recipes.get(bait);
        if (possibleOutput == null || possibleOutput.isEmpty()) {
            return null;
        }
        return ((WeightedItemStack)WeightedRandom.func_76271_a((Random)TrapRecipes.RANDOM, possibleOutput)).stack;
    }

    public static class WeightedItemStack
    extends WeightedRandom.Item {
        @Nullable
        public final ItemStack stack;

        public WeightedItemStack(@Nullable ItemStack stack, @Nonnegative @Nonnull int weight) {
            super(weight);
            this.stack = stack;
        }
    }
}

