/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.util.ItemUtil;
import java.util.Objects;
import javax.annotation.Nonnegative;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class InsertionItemStack
implements ImmutableItemStack {
    private boolean useImmutable = false;
    private ItemStack stack;
    private ImmutableItemStack immutable;
    @Nonnegative
    private int amountToInsert;

    public InsertionItemStack() {
    }

    public InsertionItemStack(@NotNull ItemStack stack) {
        this.set(stack, stack.field_77994_a);
    }

    public InsertionItemStack(@NotNull ItemStack stack, @Nonnegative int amountToInsert) {
        this.set(stack, amountToInsert);
    }

    public InsertionItemStack(@NotNull ImmutableItemStack stack) {
        this.set(stack, stack.getStackSize());
    }

    public InsertionItemStack(@NotNull ImmutableItemStack stack, @Nonnegative int amountToInsert) {
        this.set(stack, amountToInsert);
    }

    public InsertionItemStack set(ItemStack stack) {
        this.useImmutable = false;
        this.stack = Objects.requireNonNull(stack, "stack cannot be null");
        this.amountToInsert = Math.max(0, stack.field_77994_a);
        return this;
    }

    public InsertionItemStack set(ItemStack stack, int amount) {
        this.useImmutable = false;
        this.stack = Objects.requireNonNull(stack, "stack cannot be null");
        this.amountToInsert = Math.max(0, amount);
        return this;
    }

    public InsertionItemStack set(ImmutableItemStack stack) {
        this.useImmutable = true;
        this.immutable = Objects.requireNonNull(stack, "stack cannot be null");
        this.amountToInsert = Math.max(0, stack.getStackSize());
        return this;
    }

    public InsertionItemStack set(ImmutableItemStack stack, int amount) {
        this.useImmutable = true;
        this.immutable = Objects.requireNonNull(stack, "stack cannot be null");
        this.amountToInsert = Math.max(0, amount);
        return this;
    }

    public InsertionItemStack set(int amount) {
        this.amountToInsert = Math.max(0, amount);
        return this;
    }

    public InsertionItemStack decrement(int amount) {
        this.amountToInsert = Math.max(0, this.amountToInsert - amount);
        return this;
    }

    @Override
    public int getStackSize() {
        return this.amountToInsert;
    }

    @Override
    @NotNull
    public Item getItem() {
        return Objects.requireNonNull(this.useImmutable ? this.immutable.getItem() : this.stack.func_77973_b(), "item cannot be null");
    }

    @Override
    public int getItemMeta() {
        return this.useImmutable ? this.immutable.getItemMeta() : ItemUtil.getStackMeta(this.stack);
    }

    @Override
    public NBTTagCompound getTag() {
        return this.useImmutable ? this.immutable.getTag() : this.stack.func_77978_p();
    }
}

