/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.capability.item.ItemIO;
import com.gtnewhorizon.gtnhlib.capability.item.ItemSink;
import com.gtnewhorizon.gtnhlib.capability.item.ItemSource;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InventoryIterator;
import com.gtnewhorizon.gtnhlib.item.ItemStack2IntFunction;
import com.gtnewhorizon.gtnhlib.item.ItemStackPredicate;
import java.util.OptionalInt;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WrappedItemIO
implements ItemIO {
    @Nullable
    public final ItemSource source;
    @Nullable
    public final ItemSink sink;

    public WrappedItemIO(@Nullable ItemSource source, @Nullable ItemSink sink) {
        this.source = source;
        this.sink = sink;
    }

    @Override
    public void resetSink() {
        if (this.sink != null) {
            this.sink.resetSink();
        }
    }

    @Override
    public int store(ImmutableItemStack stack) {
        return this.sink == null ? stack.getStackSize() : this.sink.store(stack);
    }

    @Override
    public void setAllowedSinkSlots(int @Nullable [] slots) {
        if (this.sink != null) {
            this.sink.setAllowedSinkSlots(slots);
        }
    }

    @Override
    public OptionalInt getStoredItemsInSink(@Nullable ItemStackPredicate filter) {
        return this.sink == null ? OptionalInt.empty() : this.sink.getStoredItemsInSink(filter);
    }

    @Override
    public WrappedItemIO then(ItemSink next) {
        return new WrappedItemIO(this.source, ItemSink.chain(this.sink, next));
    }

    @Override
    public void resetSource() {
        if (this.source != null) {
            this.source.resetSource();
        }
    }

    @Override
    @Nullable
    public ItemStack pull(@Nullable ItemStackPredicate filter, @Nullable ItemStack2IntFunction amount) {
        return this.source == null ? null : this.source.pull(filter, amount);
    }

    @Override
    @Nullable
    public InventoryIterator sourceIterator() {
        return this.source == null ? InventoryIterator.EMPTY : this.source.sourceIterator();
    }

    @Override
    public void setAllowedSourceSlots(int @Nullable [] slots) {
        if (this.source != null) {
            this.source.setAllowedSourceSlots(slots);
        }
    }
}

