/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.common.blocks.BOPBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBOPCoral
extends BOPBlock {
    private static final String[] coral = new String[]{"kelpbottom", "kelpmiddle", "kelptop", "kelpsingle", "pinkcoral", "orangecoral", "bluecoral", "glowcoral", "algae"};
    private IIcon[] textures;
    private final CoralCategory category;

    public BlockBOPCoral(CoralCategory category) {
        super(Material.field_151586_h);
        this.category = category;
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149675_a(true);
        float f = 0.4f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.8f, 0.5f + f);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        return meta < 8 ? meta + 8 : meta;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean func_149705_a(World world, int x, int y, int z, int side, ItemStack itemStack) {
        int metadata = itemStack != null ? itemStack.func_77960_j() : 0;
        return world.func_147439_a(x, y + 1, z) == Blocks.field_150355_j && this.canBlockStay(world, x, y, z, metadata);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        int meta = world.func_72805_g(x, y, z);
        if (this.category == CoralCategory.CAT1 && meta >= 8 && meta <= 11) {
            if (world.func_147439_a(x, y - 1, z) != this) {
                if (world.func_147439_a(x, y + 1, z) != this) {
                    world.func_147465_d(x, y, z, (Block)this, 11, 2);
                } else {
                    world.func_147465_d(x, y, z, (Block)this, 8, 2);
                }
            } else if (world.func_147439_a(x, y + 1, z) != this && world.func_147439_a(x, y - 1, z) == this) {
                world.func_147465_d(x, y, z, (Block)this, 10, 2);
            } else if (world.func_147439_a(x, y + 1, z) == this) {
                world.func_147465_d(x, y, z, (Block)this, 9, 2);
            }
        }
        super.func_149695_a(world, x, y, z, neighborBlock);
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z, int metadata) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (this.category == CoralCategory.CAT1) {
            switch (metadata) {
                case 9: {
                    return block == this;
                }
                case 10: {
                    return block == this;
                }
                case 11: {
                    return block == this || block == Blocks.field_150346_d || block == Blocks.field_150354_m || block == Blocks.field_150360_v || block == Blocks.field_150348_b || block == Blocks.field_150435_aG || block == Blocks.field_150351_n || block == Blocks.field_150349_c || block == BOPCBlocks.mud;
                }
            }
        }
        return block == Blocks.field_150346_d || block == Blocks.field_150354_m || block == Blocks.field_150360_v || block == Blocks.field_150348_b || block == Blocks.field_150435_aG || block == Blocks.field_150351_n || block == Blocks.field_150349_c || block == BOPCBlocks.mud;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (this.category == CoralCategory.CAT1 && meta == 15) {
            return 10;
        }
        return 0;
    }

    public void func_149664_b(World world, int x, int y, int z, int silkTouch) {
        world.func_147449_b(x, y, z, Blocks.field_150355_j);
    }

    @Override
    public int func_149692_a(int meta) {
        return this.category == CoralCategory.CAT1 && meta < 11 ? 11 : meta;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.category == CoralCategory.CAT1 && meta < 11 ? 11 : meta;
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        for (int i = 8; i < this.getCategorySize() + 8; ++i) {
            if (this.category == CoralCategory.CAT1 && i <= 10) continue;
            list.add(new ItemStack(block, 1, i));
        }
    }

    public int func_149645_b() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[coral.length];
        for (int i = 0; i < coral.length; ++i) {
            this.textures[i] = iconRegister.func_94245_a("biomesoplenty:" + coral[i]);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta < 8 || meta >= coral.length + 8) {
            meta = 8;
        }
        return this.textures[this.getMetaIndex(meta)];
    }

    public String getCoralType(int meta) {
        if (meta < 8 || meta >= coral.length + 8) {
            meta = 8;
        }
        return coral[this.getMetaIndex(meta)];
    }

    public int getMetaIndex(int meta) {
        return meta - 8 + this.category.ordinal() * 8;
    }

    public int getCategorySize() {
        BlockBOPCoral blockBOPCoral = this;
        return this.category.ordinal() == blockBOPCoral.category.values().length - 1 ? coral.length - this.category.ordinal() * 8 : 8;
    }

    public static enum CoralCategory {
        CAT1,
        CAT2;

    }
}

