/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.StructBuffer;
import org.lwjgl.MemoryUtil;

public abstract class ChunkDrawParamsVector
extends StructBuffer {
    protected int capacity;
    protected int count;

    protected ChunkDrawParamsVector(int capacity) {
        super(capacity, 16);
        this.capacity = capacity;
    }

    public static ChunkDrawParamsVector create(int capacity) {
        return SodiumClientMod.isDirectMemoryAccessEnabled() ? new UnsafeChunkDrawCallVector(capacity) : new NioChunkDrawCallVector(capacity);
    }

    public abstract void pushChunkDrawParams(float var1, float var2, float var3);

    public void reset() {
        this.count = 0;
    }

    protected void growBuffer() {
        this.capacity *= 2;
        this.buffer = MemoryUtilities.memRealloc((ByteBuffer)this.buffer, (int)(this.capacity * this.stride));
    }

    public static class UnsafeChunkDrawCallVector
    extends ChunkDrawParamsVector {
        private long basePointer;
        private long writePointer;

        public UnsafeChunkDrawCallVector(int capacity) {
            super(capacity);
            this.basePointer = MemoryUtil.getAddress((ByteBuffer)this.buffer);
        }

        @Override
        public void pushChunkDrawParams(float x, float y, float z) {
            if (this.count++ >= this.capacity) {
                this.growBuffer();
            }
            MemoryUtilities.memPutFloat((long)this.writePointer, (float)x);
            MemoryUtilities.memPutFloat((long)(this.writePointer + 4L), (float)y);
            MemoryUtilities.memPutFloat((long)(this.writePointer + 8L), (float)z);
            this.writePointer += (long)this.stride;
        }

        @Override
        protected void growBuffer() {
            super.growBuffer();
            long offset = this.writePointer - this.basePointer;
            this.basePointer = MemoryUtilities.memAddress((ByteBuffer)this.buffer);
            this.writePointer = this.basePointer + offset;
        }

        @Override
        public void reset() {
            super.reset();
            this.writePointer = this.basePointer;
        }
    }

    public static class NioChunkDrawCallVector
    extends ChunkDrawParamsVector {
        private int writeOffset;

        public NioChunkDrawCallVector(int capacity) {
            super(capacity);
        }

        @Override
        public void pushChunkDrawParams(float x, float y, float z) {
            if (this.count++ >= this.capacity) {
                this.growBuffer();
            }
            ByteBuffer buf = this.buffer;
            buf.putFloat(this.writeOffset, x);
            buf.putFloat(this.writeOffset + 4, y);
            buf.putFloat(this.writeOffset + 8, z);
            this.writeOffset += this.stride;
        }

        @Override
        public void reset() {
            super.reset();
            this.writeOffset = 0;
        }
    }
}

