/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.data;

import com.gtnewhorizon.gtnhlib.client.renderer.quad.properties.ModelQuadFacing;
import com.gtnewhorizons.angelica.compat.mojang.ChunkOcclusionData;
import com.gtnewhorizons.angelica.mixins.interfaces.ISpriteExt;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import me.jellysquid.mods.sodium.client.gl.util.BufferSlice;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class ChunkRenderData {
    public static final ChunkRenderData ABSENT = new Builder().build();
    public static final ChunkRenderData EMPTY = ChunkRenderData.createEmptyData();
    private Set<TileEntity> globalTileEntities;
    private List<TileEntity> tileEntities;
    private EnumMap<BlockRenderPass, ChunkMeshData> meshes;
    private ChunkOcclusionData occlusionData;
    private ChunkRenderBounds bounds;
    private List<TextureAtlasSprite> animatedSprites;
    private boolean isEmpty;
    private int meshByteSize;
    private int facesWithData;

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public Collection<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    public Collection<TileEntity> getGlobalTileEntities() {
        return this.globalTileEntities;
    }

    public ChunkMeshData getMesh(BlockRenderPass pass) {
        return this.meshes.get((Object)pass);
    }

    public void setMesh(BlockRenderPass pass, ChunkMeshData data) {
        if (this.meshes.get((Object)pass) == null) {
            throw new IllegalStateException("No mesh found");
        }
        this.meshes.put(pass, data);
    }

    public int getMeshSize() {
        return this.meshByteSize;
    }

    public ChunkRenderData copyAndReplaceMesh(Map<BlockRenderPass, ChunkMeshData> replacements) {
        ChunkRenderData data = new ChunkRenderData();
        data.globalTileEntities = this.globalTileEntities;
        data.tileEntities = this.tileEntities;
        data.occlusionData = this.occlusionData;
        data.meshes = new EnumMap<BlockRenderPass, ChunkMeshData>(this.meshes);
        data.bounds = this.bounds;
        data.animatedSprites = new ObjectArrayList(this.animatedSprites);
        data.meshes.putAll(replacements);
        int facesWithData = 0;
        int size = 0;
        for (ChunkMeshData meshData : this.meshes.values()) {
            size += meshData.getVertexDataSize();
            for (Map.Entry<ModelQuadFacing, BufferSlice> entry : meshData.getSlices()) {
                facesWithData |= 1 << entry.getKey().ordinal();
            }
        }
        data.isEmpty = this.globalTileEntities.isEmpty() && this.tileEntities.isEmpty() && facesWithData == 0;
        data.meshByteSize = size;
        data.facesWithData = facesWithData;
        return data;
    }

    private static ChunkRenderData createEmptyData() {
        ChunkOcclusionData occlusionData = new ChunkOcclusionData();
        occlusionData.addOpenEdgeFaces(EnumSet.allOf(ForgeDirection.class));
        Builder meshInfo = new Builder();
        meshInfo.setOcclusionData(occlusionData);
        return meshInfo.build();
    }

    @Generated
    public ChunkOcclusionData getOcclusionData() {
        return this.occlusionData;
    }

    @Generated
    public ChunkRenderBounds getBounds() {
        return this.bounds;
    }

    @Generated
    public List<TextureAtlasSprite> getAnimatedSprites() {
        return this.animatedSprites;
    }

    @Generated
    public int getFacesWithData() {
        return this.facesWithData;
    }

    public static class Builder {
        private final List<TileEntity> globalTileEntities = new ArrayList<TileEntity>();
        private final List<TileEntity> tileEntities = new ArrayList<TileEntity>();
        private final Set<TextureAtlasSprite> animatedSprites = new ObjectOpenHashSet();
        private final EnumMap<BlockRenderPass, ChunkMeshData> meshes = new EnumMap(BlockRenderPass.class);
        private ChunkOcclusionData occlusionData;
        private ChunkRenderBounds bounds = ChunkRenderBounds.ALWAYS_FALSE;

        public Builder() {
            for (BlockRenderPass pass : BlockRenderPass.VALUES) {
                this.setMesh(pass, ChunkMeshData.EMPTY);
            }
        }

        public void setBounds(ChunkRenderBounds bounds) {
            this.bounds = bounds;
        }

        public void setOcclusionData(ChunkOcclusionData data) {
            this.occlusionData = data;
        }

        public void addSprite(TextureAtlasSprite sprite) {
            if (((ISpriteExt)sprite).isAnimation()) {
                this.animatedSprites.add(sprite);
            }
        }

        public void setMesh(BlockRenderPass pass, ChunkMeshData data) {
            this.meshes.put(pass, data);
        }

        public void addTileEntity(TileEntity entity, boolean cull) {
            (cull ? this.tileEntities : this.globalTileEntities).add(entity);
        }

        public ChunkRenderData build() {
            ChunkRenderData data = new ChunkRenderData();
            data.globalTileEntities = (Set)new ObjectOpenHashSet(this.globalTileEntities);
            data.tileEntities = this.tileEntities;
            data.occlusionData = this.occlusionData;
            data.meshes = this.meshes;
            data.bounds = this.bounds;
            data.animatedSprites = (List)new ObjectArrayList(this.animatedSprites);
            int facesWithData = 0;
            int size = 0;
            for (ChunkMeshData meshData : this.meshes.values()) {
                size += meshData.getVertexDataSize();
                for (Map.Entry<ModelQuadFacing, BufferSlice> entry : meshData.getSlices()) {
                    facesWithData |= 1 << entry.getKey().ordinal();
                }
            }
            data.isEmpty = this.globalTileEntities.isEmpty() && this.tileEntities.isEmpty() && facesWithData == 0;
            data.meshByteSize = size;
            data.facesWithData = facesWithData;
            return data;
        }
    }
}

