/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.block_rendering;

import com.gtnewhorizons.angelica.compat.toremove.RenderLayer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.shaderpack.materialmap.BlockEntry;
import net.coderbot.iris.shaderpack.materialmap.BlockRenderType;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

public class BlockMaterialMapping {
    public static Object2IntMap<Block> createBlockStateIdMap(Int2ObjectMap<List<BlockEntry>> blockPropertiesMap) {
        Object2IntOpenHashMap blockMatches = new Object2IntOpenHashMap();
        blockPropertiesMap.forEach((arg_0, arg_1) -> BlockMaterialMapping.lambda$createBlockStateIdMap$0((Object2IntMap)blockMatches, arg_0, arg_1));
        return blockMatches;
    }

    public static Map<Block, RenderLayer> createBlockTypeMap(Map<NamespacedId, BlockRenderType> blockPropertiesMap) {
        Reference2ReferenceOpenHashMap blockTypeIds = new Reference2ReferenceOpenHashMap();
        blockPropertiesMap.forEach((arg_0, arg_1) -> BlockMaterialMapping.lambda$createBlockTypeMap$1((Map)blockTypeIds, arg_0, arg_1));
        return blockTypeIds;
    }

    private static RenderLayer convertBlockToRenderType(BlockRenderType type) {
        RenderLayer renderLayer;
        if (type == null) {
            return null;
        }
        switch (type) {
            case SOLID: 
            case CUTOUT: 
            case CUTOUT_MIPPED: {
                renderLayer = RenderLayer.cutout();
                break;
            }
            case TRANSLUCENT: {
                renderLayer = RenderLayer.translucent();
                break;
            }
            default: {
                renderLayer = null;
            }
        }
        return renderLayer;
    }

    private static void addBlock(BlockEntry entry, Object2IntMap<Block> idMap, int intId) {
        NamespacedId id = entry.getId();
        ResourceLocation resourceLocation = new ResourceLocation(id.getNamespace(), id.getName());
        Block block = (Block)Block.field_149771_c.func_82594_a(resourceLocation.toString());
        if (block == null || block == Blocks.field_150350_a) {
            return;
        }
        idMap.put((Object)block, intId);
    }

    private static /* synthetic */ void lambda$createBlockTypeMap$1(Map blockTypeIds, NamespacedId id, BlockRenderType blockType) {
        ResourceLocation resourceLocation = new ResourceLocation(id.getNamespace(), id.getName());
        Block block = Block.func_149684_b((String)resourceLocation.toString());
        blockTypeIds.put(block, BlockMaterialMapping.convertBlockToRenderType(blockType));
    }

    private static /* synthetic */ void lambda$createBlockStateIdMap$0(Object2IntMap blockMatches, Integer intId, List entries) {
        for (BlockEntry entry : entries) {
            BlockMaterialMapping.addBlock(entry, (Object2IntMap<Block>)blockMatches, intId);
        }
    }
}

