/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.API.BlockColorInterface;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.RotaryCraft;
import com.google.common.base.Charsets;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockColorMapper {
    public static final BlockColorMapper instance = new BlockColorMapper();
    public static final GPRBlockColor UNKNOWN_COLOR = new BasicBlockColor(-2851073);
    public static final GPRBlockColor AIR_COLOR = new BasicBlockColor(ReikaColorAPI.GStoHex((int)33));
    private final BlockMap<GPRBlockColor> map = new BlockMap();
    private final BlockMap<BlockKey> mimics = new BlockMap();

    private BlockColorMapper() {
        boolean renderore;
        this.addBlockColor(Blocks.field_150348_b, ReikaColorAPI.RGBtoHex((int)126, (int)126, (int)126));
        this.addBlockColor((Block)Blocks.field_150349_c, ReikaColorAPI.RGBtoHex((int)104, (int)167, (int)65));
        this.addBlockColor(Blocks.field_150346_d, ReikaColorAPI.RGBtoHex((int)120, (int)85, (int)60));
        this.addBlockColor(Blocks.field_150347_e, ReikaColorAPI.RGBtoHex((int)99, (int)99, (int)99));
        this.addBlockColor(Blocks.field_150344_f, ReikaColorAPI.RGBtoHex((int)178, (int)142, (int)90));
        this.addBlockColor(Blocks.field_150345_g, ReikaColorAPI.RGBtoHex((int)0, (int)255, (int)0));
        this.addBlockColor(Blocks.field_150357_h, ReikaColorAPI.RGBtoHex((int)50, (int)50, (int)50));
        this.addBlockColor((Block)Blocks.field_150358_i, ReikaColorAPI.RGBtoHex((int)0, (int)0, (int)255));
        this.addBlockMimic(Blocks.field_150355_j, (Block)Blocks.field_150358_i);
        this.addBlockColor((Block)Blocks.field_150356_k, ReikaColorAPI.RGBtoHex((int)255, (int)40, (int)0));
        this.addBlockMimic(Blocks.field_150353_l, (Block)Blocks.field_150356_k);
        this.addBlockColor((Block)Blocks.field_150354_m, ReikaColorAPI.RGBtoHex((int)225, (int)219, (int)163));
        this.addBlockColor(Blocks.field_150351_n, ReikaColorAPI.RGBtoHex((int)159, (int)137, (int)131));
        this.addBlockColor(Blocks.field_150352_o, ReikaColorAPI.RGBtoHex((int)251, (int)237, (int)76));
        this.addBlockColor(Blocks.field_150366_p, ReikaColorAPI.RGBtoHex((int)214, (int)173, (int)145));
        this.addBlockColor(Blocks.field_150365_q, ReikaColorAPI.RGBtoHex((int)70, (int)70, (int)70));
        this.addBlockColor(Blocks.field_150364_r, ReikaColorAPI.RGBtoHex((int)103, (int)83, (int)53));
        this.addBlockColor(Blocks.field_150363_s, ReikaColorAPI.RGBtoHex((int)103, (int)83, (int)53));
        this.addBlockColor((Block)Blocks.field_150362_t, ReikaColorAPI.RGBtoHex((int)87, (int)171, (int)65));
        this.addBlockColor((Block)Blocks.field_150361_u, ReikaColorAPI.RGBtoHex((int)87, (int)171, (int)65));
        this.addBlockColor(Blocks.field_150360_v, ReikaColorAPI.RGBtoHex((int)204, (int)204, (int)71));
        this.addBlockColor(Blocks.field_150359_w, ReikaColorAPI.RGBtoHex((int)190, (int)244, (int)254));
        this.addBlockColor(Blocks.field_150369_x, ReikaColorAPI.RGBtoHex((int)40, (int)98, (int)175));
        this.addBlockColor(Blocks.field_150368_y, ReikaColorAPI.RGBtoHex((int)21, (int)52, (int)188));
        this.addBlockColor(Blocks.field_150367_z, ReikaColorAPI.RGBtoHex((int)119, (int)119, (int)119));
        this.addBlockColor(Blocks.field_150322_A, ReikaColorAPI.RGBtoHex((int)212, (int)205, (int)153));
        this.addBlockColor(Blocks.field_150323_B, ReikaColorAPI.RGBtoHex((int)147, (int)90, (int)64));
        this.addBlockColor(Blocks.field_150324_C, ReikaColorAPI.RGBtoHex((int)136, (int)27, (int)27));
        this.addBlockColor(Blocks.field_150318_D, ReikaColorAPI.RGBtoHex((int)220, (int)182, (int)47));
        this.addBlockColor(Blocks.field_150319_E, ReikaColorAPI.RGBtoHex((int)134, (int)0, (int)0));
        this.addBlockColor((Block)Blocks.field_150320_F, ReikaColorAPI.RGBtoHex((int)122, (int)190, (int)111));
        this.addBlockColor(Blocks.field_150321_G, ReikaColorAPI.RGBtoHex((int)220, (int)220, (int)220));
        this.addBlockColor((Block)Blocks.field_150329_H, ReikaColorAPI.RGBtoHex((int)104, (int)167, (int)65));
        this.addBlockColor((Block)Blocks.field_150330_I, ReikaColorAPI.RGBtoHex((int)146, (int)99, (int)44));
        this.addBlockColor((Block)Blocks.field_150331_J, ReikaColorAPI.RGBtoHex((int)178, (int)142, (int)90));
        this.addBlockColor((Block)Blocks.field_150332_K, UNKNOWN_COLOR);
        this.addWool();
        this.addBlockColor((Block)Blocks.field_150326_M, UNKNOWN_COLOR);
        this.addBlockColor((Block)Blocks.field_150327_N, ReikaColorAPI.RGBtoHex((int)255, (int)255, (int)0));
        this.addFlowers();
        this.addBlockColor((Block)Blocks.field_150338_P, ReikaColorAPI.RGBtoHex((int)202, (int)151, (int)119));
        this.addBlockColor((Block)Blocks.field_150337_Q, ReikaColorAPI.RGBtoHex((int)225, (int)24, (int)25));
        this.addBlockColor(Blocks.field_150340_R, ReikaColorAPI.RGBtoHex((int)255, (int)240, (int)69));
        this.addBlockColor(Blocks.field_150339_S, ReikaColorAPI.RGBtoHex((int)232, (int)232, (int)232));
        this.addBlockMimic((Block)Blocks.field_150334_T, (Block)Blocks.field_150333_U);
        this.addSlabs();
        this.addBlockColor(Blocks.field_150336_V, ReikaColorAPI.RGBtoHex((int)175, (int)91, (int)72));
        this.addBlockColor(Blocks.field_150335_W, ReikaColorAPI.RGBtoHex((int)216, (int)58, (int)19));
        this.addBlockColor(Blocks.field_150342_X, ReikaColorAPI.RGBtoHex((int)186, (int)150, (int)98));
        this.addBlockColor(Blocks.field_150341_Y, ReikaColorAPI.RGBtoHex((int)69, (int)143, (int)69));
        this.addBlockColor(Blocks.field_150343_Z, ReikaColorAPI.RGBtoHex((int)62, (int)51, (int)86));
        this.addBlockColor(Blocks.field_150478_aa, ReikaColorAPI.RGBtoHex((int)255, (int)214, (int)0));
        this.addBlockColor((Block)Blocks.field_150480_ab, ReikaColorAPI.RGBtoHex((int)255, (int)170, (int)0));
        this.addBlockColor(Blocks.field_150474_ac, ReikaColorAPI.RGBtoHex((int)39, (int)64, (int)81));
        this.addBlockMimic(Blocks.field_150476_ad, Blocks.field_150344_f);
        this.addBlockMimic((Block)Blocks.field_150486_ae, Blocks.field_150344_f);
        this.addBlockColor((Block)Blocks.field_150488_af, ReikaColorAPI.RGBtoHex((int)145, (int)0, (int)16));
        this.addBlockColor(Blocks.field_150482_ag, ReikaColorAPI.RGBtoHex((int)93, (int)235, (int)244));
        this.addBlockColor(Blocks.field_150484_ah, ReikaColorAPI.RGBtoHex((int)104, (int)222, (int)217));
        this.addBlockMimic(Blocks.field_150462_ai, Blocks.field_150344_f);
        this.addBlockColor(Blocks.field_150464_aj, ReikaColorAPI.RGBtoHex((int)4, (int)189, (int)18));
        this.addBlockColor(Blocks.field_150458_ak, ReikaColorAPI.RGBtoHex((int)96, (int)55, (int)27));
        this.addBlockColor(Blocks.field_150460_al, ReikaColorAPI.RGBtoHex((int)119, (int)119, (int)119));
        this.addBlockMimic(Blocks.field_150470_am, Blocks.field_150460_al);
        this.addBlockMimic(Blocks.field_150472_an, Blocks.field_150344_f);
        this.addBlockMimic(Blocks.field_150466_ao, Blocks.field_150344_f);
        this.addBlockColor(Blocks.field_150468_ap, ReikaColorAPI.RGBtoHex((int)170, (int)134, (int)82));
        this.addBlockColor(Blocks.field_150448_aq, ReikaColorAPI.RGBtoHex((int)170, (int)134, (int)82));
        this.addBlockMimic(Blocks.field_150446_ar, Blocks.field_150347_e);
        this.addBlockMimic(Blocks.field_150444_as, Blocks.field_150344_f);
        this.addBlockColor(Blocks.field_150442_at, ReikaColorAPI.RGBtoHex((int)123, (int)98, (int)64));
        this.addBlockMimic(Blocks.field_150456_au, Blocks.field_150348_b);
        this.addBlockColor(Blocks.field_150454_av, ReikaColorAPI.RGBtoHex((int)222, (int)222, (int)222));
        this.addBlockMimic(Blocks.field_150452_aw, Blocks.field_150344_f);
        this.addBlockColor(Blocks.field_150450_ax, ReikaColorAPI.RGBtoHex((int)215, (int)0, (int)0));
        this.addBlockMimic(Blocks.field_150439_ay, Blocks.field_150450_ax);
        this.addBlockMimic(Blocks.field_150437_az, Blocks.field_150429_aA);
        this.addBlockColor(Blocks.field_150429_aA, ReikaColorAPI.RGBtoHex((int)173, (int)0, (int)0));
        this.addBlockMimic(Blocks.field_150430_aB, Blocks.field_150348_b);
        this.addBlockMimic(Blocks.field_150431_aC, Blocks.field_150433_aE);
        this.addBlockColor(Blocks.field_150432_aD, ReikaColorAPI.RGBtoHex((int)117, (int)166, (int)255));
        this.addBlockColor(Blocks.field_150433_aE, ReikaColorAPI.RGBtoHex((int)255, (int)255, (int)255));
        this.addBlockColor(Blocks.field_150434_aF, ReikaColorAPI.RGBtoHex((int)24, (int)126, (int)37));
        this.addBlockColor(Blocks.field_150435_aG, ReikaColorAPI.RGBtoHex((int)171, (int)175, (int)191));
        this.addBlockColor(Blocks.field_150436_aH, ReikaColorAPI.RGBtoHex((int)168, (int)217, (int)115));
        this.addBlockColor(Blocks.field_150421_aI, ReikaColorAPI.RGBtoHex((int)147, (int)90, (int)64));
        this.addBlockMimic(Blocks.field_150422_aJ, Blocks.field_150344_f);
        this.addBlockColor(Blocks.field_150423_aK, ReikaColorAPI.RGBtoHex((int)226, (int)142, (int)34));
        this.addBlockColor(Blocks.field_150424_aL, ReikaColorAPI.RGBtoHex((int)163, (int)66, (int)66));
        this.addBlockColor(Blocks.field_150425_aM, ReikaColorAPI.RGBtoHex((int)92, (int)74, (int)63));
        this.addBlockColor(Blocks.field_150426_aN, ReikaColorAPI.RGBtoHex((int)248, (int)210, (int)154));
        this.addBlockColor((Block)Blocks.field_150427_aO, ReikaColorAPI.RGBtoHex((int)128, (int)0, (int)255));
        this.addBlockMimic(Blocks.field_150428_aP, Blocks.field_150423_aK);
        this.addBlockColor(Blocks.field_150414_aQ, ReikaColorAPI.RGBtoHex((int)165, (int)83, (int)37));
        this.addBlockMimic((Block)Blocks.field_150413_aR, (Block)Blocks.field_150416_aS);
        this.addBlockColor((Block)Blocks.field_150416_aS, ReikaColorAPI.RGBtoHex((int)145, (int)32, (int)48));
        this.addBlockMimic((Block)Blocks.field_150399_cn, Blocks.field_150325_L);
        this.addBlockMimic((Block)Blocks.field_150397_co, (Block)Blocks.field_150399_cn);
        this.addBlockColor(Blocks.field_150415_aT, ReikaColorAPI.RGBtoHex((int)141, (int)106, (int)55));
        this.addBlockColor(Blocks.field_150418_aU, ReikaColorAPI.RGBtoHex((int)156, (int)156, (int)156));
        this.addBlockColor(Blocks.field_150417_aV, ReikaColorAPI.RGBtoHex((int)135, (int)135, (int)135));
        this.addBlockColor(Blocks.field_150420_aW, ReikaColorAPI.RGBtoHex((int)148, (int)113, (int)90));
        this.addBlockColor(Blocks.field_150419_aX, ReikaColorAPI.RGBtoHex((int)179, (int)34, (int)32));
        this.addBlockColor(Blocks.field_150411_aY, ReikaColorAPI.RGBtoHex((int)106, (int)104, (int)106));
        this.addBlockMimic(Blocks.field_150410_aZ, Blocks.field_150359_w);
        this.addBlockColor(Blocks.field_150440_ba, ReikaColorAPI.RGBtoHex((int)175, (int)173, (int)43));
        this.addBlockColor(Blocks.field_150393_bb, ReikaColorAPI.RGBtoHex((int)192, (int)128, (int)140));
        this.addBlockMimic(Blocks.field_150394_bc, Blocks.field_150393_bb);
        this.addBlockColor(Blocks.field_150395_bd, ReikaColorAPI.RGBtoHex((int)26, (int)139, (int)40));
        this.addBlockMimic(Blocks.field_150396_be, Blocks.field_150422_aJ);
        this.addBlockMimic(Blocks.field_150389_bf, Blocks.field_150336_V);
        this.addBlockMimic(Blocks.field_150390_bg, Blocks.field_150417_aV);
        this.addBlockColor((Block)Blocks.field_150391_bh, ReikaColorAPI.RGBtoHex((int)97, (int)82, (int)104));
        this.addBlockColor(Blocks.field_150392_bi, ReikaColorAPI.RGBtoHex((int)30, (int)53, (int)15));
        this.addBlockColor(Blocks.field_150385_bj, ReikaColorAPI.RGBtoHex((int)73, (int)39, (int)46));
        this.addBlockMimic(Blocks.field_150386_bk, Blocks.field_150385_bj);
        this.addBlockMimic(Blocks.field_150387_bl, Blocks.field_150385_bj);
        this.addBlockColor(Blocks.field_150388_bm, ReikaColorAPI.RGBtoHex((int)159, (int)41, (int)45));
        this.addBlockColor(Blocks.field_150381_bn, ReikaColorAPI.RGBtoHex((int)160, (int)46, (int)45));
        this.addBlockColor(Blocks.field_150382_bo, ReikaColorAPI.RGBtoHex((int)196, (int)186, (int)81));
        this.addBlockColor((Block)Blocks.field_150383_bp, ReikaColorAPI.RGBtoHex((int)59, (int)59, (int)59));
        this.addBlockColor(Blocks.field_150384_bq, ReikaColorAPI.RGBtoHex((int)0, (int)0, (int)0));
        this.addBlockColor(Blocks.field_150378_br, ReikaColorAPI.RGBtoHex((int)67, (int)114, (int)102));
        this.addBlockColor(Blocks.field_150377_bs, ReikaColorAPI.RGBtoHex((int)234, (int)247, (int)180));
        this.addBlockColor(Blocks.field_150380_bt, ReikaColorAPI.RGBtoHex((int)48, (int)5, (int)54));
        this.addBlockColor(Blocks.field_150379_bu, ReikaColorAPI.RGBtoHex((int)222, (int)147, (int)71));
        this.addBlockMimic(Blocks.field_150374_bv, Blocks.field_150379_bu);
        this.addBlockMimic((Block)Blocks.field_150373_bw, (Block)Blocks.field_150376_bx);
        this.addBlockMimic((Block)Blocks.field_150376_bx, Blocks.field_150344_f);
        this.addBlockColor(Blocks.field_150375_by, ReikaColorAPI.RGBtoHex((int)177, (int)98, (int)28));
        this.addBlockMimic(Blocks.field_150372_bz, Blocks.field_150322_A);
        this.addBlockColor(Blocks.field_150412_bA, ReikaColorAPI.RGBtoHex((int)23, (int)221, (int)98));
        this.addBlockColor(Blocks.field_150477_bB, ReikaColorAPI.RGBtoHex((int)43, (int)61, (int)63));
        this.addBlockMimic((Block)Blocks.field_150479_bC, Blocks.field_150344_f);
        this.addBlockColor(Blocks.field_150473_bD, ReikaColorAPI.RGBtoHex((int)33, (int)33, (int)33));
        this.addBlockColor(Blocks.field_150475_bE, ReikaColorAPI.RGBtoHex((int)63, (int)213, (int)102));
        this.addBlockColor(Blocks.field_150485_bF, ReikaColorAPI.RGBtoHex((int)127, (int)94, (int)56));
        this.addBlockColor(Blocks.field_150487_bG, ReikaColorAPI.RGBtoHex((int)213, (int)201, (int)139));
        this.addBlockColor(Blocks.field_150481_bH, ReikaColorAPI.RGBtoHex((int)182, (int)133, (int)99));
        this.addBlockColor(Blocks.field_150483_bI, ReikaColorAPI.RGBtoHex((int)199, (int)126, (int)79));
        this.addBlockColor((Block)Blocks.field_150461_bJ, ReikaColorAPI.RGBtoHex((int)44, (int)197, (int)87));
        this.addBlockColor(Blocks.field_150463_bK, ReikaColorAPI.RGBtoHex((int)99, (int)99, (int)99));
        this.addBlockColor(Blocks.field_150457_bL, ReikaColorAPI.RGBtoHex((int)116, (int)63, (int)48));
        this.addBlockColor(Blocks.field_150459_bM, ReikaColorAPI.RGBtoHex((int)4, (int)189, (int)18));
        this.addBlockColor(Blocks.field_150469_bN, ReikaColorAPI.RGBtoHex((int)4, (int)189, (int)18));
        this.addBlockMimic(Blocks.field_150471_bO, Blocks.field_150344_f);
        this.addBlockColor(Blocks.field_150465_bP, ReikaColorAPI.RGBtoHex((int)90, (int)90, (int)90));
        this.addBlockColor(Blocks.field_150467_bQ, ReikaColorAPI.RGBtoHex((int)67, (int)67, (int)67));
        this.addBlockMimic(Blocks.field_150447_bR, (Block)Blocks.field_150486_ae);
        this.addBlockMimic(Blocks.field_150445_bS, Blocks.field_150340_R);
        this.addBlockMimic(Blocks.field_150443_bT, Blocks.field_150339_S);
        this.addBlockMimic((Block)Blocks.field_150441_bU, (Block)Blocks.field_150416_aS);
        this.addBlockMimic((Block)Blocks.field_150455_bV, (Block)Blocks.field_150416_aS);
        this.addBlockColor((Block)Blocks.field_150453_bW, ReikaColorAPI.RGBtoHex((int)71, (int)61, (int)41));
        this.addBlockColor(Blocks.field_150451_bX, ReikaColorAPI.RGBtoHex((int)255, (int)100, (int)0));
        this.addBlockColor(Blocks.field_150449_bY, ReikaColorAPI.RGBtoHex((int)203, (int)191, (int)177));
        this.addBlockColor((Block)Blocks.field_150438_bZ, ReikaColorAPI.RGBtoHex((int)75, (int)75, (int)75));
        this.addBlockColor(Blocks.field_150371_ca, ReikaColorAPI.RGBtoHex((int)236, (int)232, (int)226));
        this.addBlockMimic(Blocks.field_150370_cb, Blocks.field_150371_ca);
        this.addBlockColor(Blocks.field_150408_cc, ReikaColorAPI.RGBtoHex((int)183, (int)12, (int)12));
        this.addBlockMimic(Blocks.field_150409_cd, Blocks.field_150367_z);
        this.addBlockColor(Blocks.field_150406_ce, ReikaColorAPI.RGBtoHex((int)204, (int)172, (int)156));
        this.addBlockColor(Blocks.field_150407_cf, ReikaColorAPI.RGBtoHex((int)255, (int)209, (int)94));
        this.addBlockColor(Blocks.field_150405_ch, ReikaColorAPI.RGBtoHex((int)158, (int)100, (int)73));
        this.addBlockColor(Blocks.field_150402_ci, ReikaColorAPI.RGBtoHex((int)21, (int)21, (int)21));
        boolean bl = renderore = ConfigRegistry.GPRORES.getState() || DragonAPICore.isReikasComputer();
        if (!renderore) {
            for (int i = 0; i < ReikaOreHelper.oreList.length; ++i) {
                ReikaOreHelper ore = ReikaOreHelper.oreList[i];
                Block b = ore.getOreBlockInstance();
                this.addBlockMimic(b, ore.getOreGenBlock());
            }
        }
        this.addRotaryCraft();
        this.addModOres();
        this.addModWood();
        this.addModCrops();
        this.loadModData();
    }

    private void loadModData() {
        Set<BlockKey> keys = BlockColorInterface.getMappedBlocks();
        for (BlockKey key : keys) {
            Block id = key.blockID;
            int meta = key.metadata;
            int color = BlockColorInterface.getColor(id, meta);
            RotaryCraft.logger.log((Object)("Received mod request for block " + id + ":" + meta + " to have color mapping " + Integer.toHexString(color)));
            this.addOrSetColorMapping(id, meta, color, false);
        }
    }

    private void addRotaryCraft() {
        for (int i = 0; i < BlockRegistry.blockList.length; ++i) {
            BlockRegistry r = BlockRegistry.blockList[i];
            this.addBlockColor(r.getBlockInstance(), ReikaColorAPI.RGBtoHex((int)200, (int)200, (int)200));
        }
        this.addBlockColor(BlockRegistry.MININGPIPE, ReikaColorAPI.RGBtoHex((int)80, (int)80, (int)80));
        this.addBlockColor(BlockRegistry.CANOLA, 47872);
        this.addBlockMimic(BlockRegistry.BEDROCKSLICE, Blocks.field_150357_h);
        this.addBlockColor(BlockRegistry.LIGHT, ReikaColorAPI.RGBtoHex((int)33, (int)33, (int)33));
        this.addBlockColor(BlockRegistry.BEAM, ReikaColorAPI.RGBtoHex((int)33, (int)33, (int)33));
        this.addBlockColor(BlockRegistry.BRIDGE, 43775);
        this.addBlockMimic(BlockRegistry.BLASTPANE, Blocks.field_150343_Z);
        this.addBlockMimic(BlockRegistry.BLASTGLASS, Blocks.field_150343_Z);
        Block b = BlockRegistry.DECO.getBlockInstance();
        this.addBlockColor(b, 0, ReikaColorAPI.RGBtoHex((int)210, (int)200, (int)220));
        this.addBlockColor(b, 1, ReikaColorAPI.RGBtoHex((int)240, (int)240, (int)240));
        this.addBlockColor(b, 2, ReikaColorAPI.RGBtoHex((int)15, (int)15, (int)15));
    }

    private void addFluids() {
        for (String s : FluidRegistry.getRegisteredFluids().keySet()) {
            Fluid f = FluidRegistry.getFluid((String)s);
            if (f == null || f.equals(FluidRegistry.WATER) || f.equals(FluidRegistry.LAVA) || !f.canBePlacedInWorld()) continue;
            Block b = f.getBlock();
            int color = f.getColor();
            this.addBlockColor(b, color);
        }
    }

    private void addModCrops() {
        for (int i = 0; i < ModCropList.cropList.length; ++i) {
            ModCropList crop = ModCropList.cropList[i];
            if (!crop.existsInGame()) continue;
            int minmeta = 0;
            int maxmeta = crop.ripeMeta;
            int color = crop.cropColor;
            Block id = null;
            if (crop.isHandlered()) {
                color = 3373651;
            } else {
                id = crop.blockID;
            }
            if (id == null) continue;
            for (int k = minmeta; k <= maxmeta; ++k) {
                this.addOrSetColorMapping(id, k, color, true);
            }
        }
    }

    private void addModOres() {
        for (int i = 0; i < ModOreList.oreList.length; ++i) {
            ModOreList ore = ModOreList.oreList[i];
            int color = ore.oreColor;
            Collection li = ore.getAllOreBlocks();
            for (ItemStack is : li) {
                Block id = Block.func_149634_a((Item)is.func_77973_b());
                int meta = is.func_77960_j();
                this.addOrSetColorMapping(id, meta, color, true);
            }
        }
    }

    private void addModWood() {
        for (int i = 0; i < ModWoodList.woodList.length; ++i) {
            ModWoodList wood = ModWoodList.woodList[i];
            if (!wood.exists()) continue;
            int log = wood.logColor;
            int leaf = wood.leafColor;
            Block logID = wood.getBlock();
            Block leafID = wood.getLeafID();
            Block saplingID = wood.getSaplingID();
            if (saplingID != null) {
                this.addOrSetColorMapping(saplingID, wood.getCorrespondingSapling().func_77960_j(), 3969305, true);
            }
            List logMetas = wood.getLogMetadatas();
            for (int k = 0; k < logMetas.size(); ++k) {
                int meta = (Integer)logMetas.get(k);
                this.addOrSetColorMapping(logID, meta, log, true);
            }
            List leafMetas = wood.getLeafMetadatas();
            for (int k = 0; k < leafMetas.size(); ++k) {
                int meta = (Integer)leafMetas.get(k);
                this.addOrSetColorMapping(leafID, meta, leaf, true);
            }
        }
    }

    private void addOrSetColorMapping(Block b, int meta, int color, boolean allowOverwrite) {
        if (b == null) {
            throw new IllegalArgumentException("Block ID " + b + " does not exist!");
        }
        if (!allowOverwrite && this.map.containsKey(b, meta)) {
            throw new IllegalArgumentException("Cannot overwrite color mapping for " + b + ":" + meta + "!");
        }
        this.addBlockColor(b, meta, color);
    }

    private void addSlabs() {
        int[] colors = new int[]{0xA3A3A3, 14472096, 12359778, 0x969696, 10836807, 0x797979, 3545118, 15262940};
        for (int i = 0; i < colors.length; ++i) {
            this.addBlockColor((Block)Blocks.field_150333_U, i, colors[i]);
        }
    }

    private void addFlowers() {
        int[] colors = new int[]{0xF7070F, 2731771, 12547579, 15921820, 13842967, 14774564, 0xF3F3F3, 0xEABEEA, 13813534};
        for (int i = 0; i < colors.length; ++i) {
            this.addBlockColor((Block)Blocks.field_150328_O, i, colors[i]);
        }
    }

    private void addWool() {
        for (int i = 0; i < 16; ++i) {
            ReikaDyeHelper color = ReikaDyeHelper.dyes[i];
            int meta = color.getWoolMeta();
            this.addBlockColor(Blocks.field_150325_L, meta, color.color);
        }
    }

    private void addDyeGlass() {
        for (int i = 0; i < 16; ++i) {
            ReikaDyeHelper color = ReikaDyeHelper.dyes[i];
            int meta = color.getWoolMeta();
            this.addBlockColor((Block)Blocks.field_150399_cn, meta, color.color);
            this.addBlockColor((Block)Blocks.field_150397_co, meta, color.color);
        }
    }

    private void addBlockColor(Block b, GPRBlockColor rgb) {
        this.addBlockColor(new BlockKey(b), rgb);
    }

    private void addBlockColor(Block b, int rgb) {
        this.addBlockColor(new BlockKey(b), rgb);
    }

    private void addBlockColor(Block b, int meta, int rgb) {
        this.addBlockColor(new BlockKey(b, meta), rgb);
    }

    private void addBlockColor(BlockKey bk, int rgb) {
        this.addBlockColor(bk, (GPRBlockColor)new BasicBlockColor(rgb));
    }

    public void addBlockColor(BlockKey bk, GPRBlockColor rgb) {
        if (this.map.containsKey(bk)) {
            RotaryCraft.logger.logError((Object)("GPR Color Mapping - block " + bk + " already mapped to a color!"));
        } else {
            this.map.put(bk, (Object)rgb);
        }
    }

    private void addBlockColor(BlockRegistry b, int rgb) {
        this.addBlockColor(b.getBlockInstance(), rgb);
    }

    private void addBlockMimic(Block mimic, Block target) {
        this.addBlockMimic(new BlockKey(mimic), new BlockKey(target));
    }

    private void addBlockMimic(Block mimic, BlockKey target) {
        this.addBlockMimic(new BlockKey(mimic), target);
    }

    private void addBlockMimic(BlockRegistry mimic, Block target) {
        this.addBlockMimic(mimic, new BlockKey(target, 0));
    }

    private void addBlockMimic(BlockRegistry mimic, BlockKey target) {
        this.addBlockMimic(new BlockKey(mimic.getBlockInstance()), target);
    }

    private void addBlockMimic(BlockKey mimic, BlockKey target) {
        if (mimic == null || target == null) {
            throw new IllegalArgumentException("Null cannot mimic or be mimicked!");
        }
        if (mimic == target) {
            throw new IllegalArgumentException("A block cannot mimic itself!");
        }
        this.mimics.put(mimic, (Object)target);
    }

    public int getColorForBlock(BlockKey bk) {
        return this.getColorForBlock(bk.blockID, bk.metadata);
    }

    private GPRBlockColor lookupColorForBlock(Block b, int meta) {
        Fluid f;
        Integer clr;
        if (b == Blocks.field_150350_a) {
            return AIR_COLOR;
        }
        if (b == null) {
            return UNKNOWN_COLOR;
        }
        BlockKey mimic = this.getMimic(b, meta);
        if (mimic != null) {
            return this.lookupColorForBlock(mimic.blockID, mimic.metadata);
        }
        GPRBlockColor c = (GPRBlockColor)this.map.get(b, meta);
        if (c == null && (clr = BlockColorInterface.getColor(b, meta)) != null) {
            c = new BasicBlockColor(clr);
            this.map.put(b, meta, (Object)c);
        }
        if (c == null && (f = ReikaFluidHelper.lookupFluidForBlock((Block)b)) != null) {
            c = new BasicBlockColor(f.getColor());
            this.map.put(b, meta, (Object)c);
        }
        return c != null ? c : UNKNOWN_COLOR;
    }

    public int getColorForBlock(Block b, int meta) {
        return this.lookupColorForBlock(b, meta).getColor();
    }

    private BlockKey getMimic(Block b, int meta) {
        BlockKey bk = (BlockKey)this.mimics.get(b, meta);
        if (bk == null) {
            bk = BlockColorInterface.getMimic(b, meta);
        }
        return bk;
    }

    public void loadFromConfig() {
        File f = this.getFullSavePath();
        if (f.exists()) {
            List li = ReikaFileReader.getFileAsLines((File)f, (boolean)false, (Charset)Charsets.UTF_8);
            for (String s : li) {
                this.parseLine(s);
            }
        } else {
            try {
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                RotaryCraft.logger.logError((Object)"Could not create GPR color map config!");
            }
        }
    }

    private void parseLine(String s) {
        if (!s.startsWith("//")) {
            int idx;
            String key = (s = s.substring(1)).substring(0, (idx = s.indexOf(61)) - 1);
            ItemStack item = ReikaItemHelper.lookupItem((String)key);
            if (item == null) {
                throw new IllegalArgumentException("No such item lookup '" + key + "'!");
            }
            if (item.func_77973_b() == null) {
                throw new IllegalArgumentException("Item lookup '" + key + "' returned a null-item stack!");
            }
            Block b = Block.func_149634_a((Item)item.func_77973_b());
            if (b == null) {
                throw new IllegalArgumentException("Item lookup '" + key + "' returned non-block item!");
            }
            String color = s.substring(idx + 2, s.length());
            this.addOrSetColorMapping(b, item.func_77960_j(), Integer.parseInt(color), false);
        }
    }

    private final String getSaveFileName() {
        return "RotaryCraft_CustomGPRColors.cfg";
    }

    private final File getFullSavePath() {
        return new File(RotaryCraft.config.getConfigFolder(), this.getSaveFileName());
    }

    private static class BasicBlockColor
    implements GPRBlockColor {
        private final int color;

        private BasicBlockColor(int c) {
            this.color = c;
        }

        @Override
        public int getColor() {
            return this.color;
        }
    }

    public static interface GPRBlockColor {
        public int getColor();
    }
}

