/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.Registry.ExtractorBonus;
import Reika.RotaryCraft.RotaryCraft;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.codec.Charsets;

public class CustomExtractLoader {
    public static final CustomExtractLoader instance = new CustomExtractLoader();
    private final ArrayList<CustomExtractEntry> data = new ArrayList();

    private CustomExtractLoader() {
    }

    private final String getSaveFileName() {
        return "RotaryCraft_CustomExtracts.cfg";
    }

    private final File getFullSavePath() {
        return new File(RotaryCraft.config.getConfigFolder(), this.getSaveFileName());
    }

    public void loadFile() {
        RotaryCraft.logger.log((Object)"Loading custom extract config.");
        File f = this.getFullSavePath();
        if (!f.exists() && !this.createOreFile(f)) {
            return;
        }
        for (String line : ReikaFileReader.getFileAsLines((File)f, (boolean)true, (Charset)Charsets.UTF_8)) {
            if (line == null || line.isEmpty() || line.startsWith("//")) continue;
            try {
                CustomExtractEntry entry = this.parseString(line);
                if (entry != null) {
                    this.data.add(entry);
                    ExtractorBonus.addCustomOreDelegate(entry);
                    RotaryCraft.logger.log((Object)("Added extract entry " + entry));
                    continue;
                }
                RotaryCraft.logger.logError((Object)("Malformed custom extract entry: " + line));
            }
            catch (Exception e) {
                RotaryCraft.logger.logError((Object)("Malformed custom extract entry [" + e.getLocalizedMessage() + "]: '" + line + "'"));
                e.printStackTrace();
            }
        }
    }

    private boolean createOreFile(File f) {
        ArrayList<String> p = new ArrayList<String>();
        CustomExtractLoader.writeCommentLine(p, "-------------------------------");
        CustomExtractLoader.writeCommentLine(p, " RotaryCraft Custom Extract Loader ");
        CustomExtractLoader.writeCommentLine(p, "-------------------------------");
        CustomExtractLoader.writeCommentLine(p, "");
        CustomExtractLoader.writeCommentLine(p, "Use this file to add custom ores and extracts to the extractor.");
        CustomExtractLoader.writeCommentLine(p, "Specify one per line, and format them as 'Name, Rarity, Product Type, Product Ore Name, Number, Color 1, Color 2, Native Ore, OreDictionary Name(s)'");
        CustomExtractLoader.writeCommentLine(p, "");
        CustomExtractLoader.writeCommentLine(p, "Ore rarity is the rarity of the ore blocks in the world, and affects the multiplication rates.");
        CustomExtractLoader.writeCommentLine(p, "Valid Rarity Values:");
        for (OreType.OreRarity oreRarity : OreType.OreRarity.values()) {
            CustomExtractLoader.writeCommentLine(p, "\t" + oreRarity.name() + " - " + oreRarity.desc + ", like " + oreRarity.examples + "");
        }
        CustomExtractLoader.writeCommentLine(p, "");
        CustomExtractLoader.writeCommentLine(p, "Valid Product Types:");
        for (ProductType productType : ProductType.values()) {
            CustomExtractLoader.writeCommentLine(p, "\t" + productType.displayName + " - " + productType.desc);
        }
        CustomExtractLoader.writeCommentLine(p, "");
        CustomExtractLoader.writeCommentLine(p, "Native ore is the native ore type of the output if you wish for the custom ore to produce the same smelted products as a native ore.");
        CustomExtractLoader.writeCommentLine(p, "Use 'null' for none to have the custom ore produce a unique smelted product.");
        CustomExtractLoader.writeCommentLine(p, "Valid Native Ores:");
        for (ReikaOreHelper reikaOreHelper : ReikaOreHelper.values()) {
            CustomExtractLoader.writeCommentLine(p, "\t" + reikaOreHelper.name() + " - " + reikaOreHelper.getName());
        }
        for (ModOreList modOreList : ModOreList.values()) {
            if (modOreList.isNetherOres()) continue;
            CustomExtractLoader.writeCommentLine(p, "\t" + modOreList.name() + " - " + modOreList.displayName + " " + modOreList.getTypeName());
        }
        CustomExtractLoader.writeCommentLine(p, "");
        CustomExtractLoader.writeCommentLine(p, "Capitalization for the ore dictionary names matters, but is ignored for rarities, types, and native ores.");
        CustomExtractLoader.writeCommentLine(p, "Ensure your OreDict names are correct; not all mods follow the 'oreName' and 'productName' convention.");
        CustomExtractLoader.writeCommentLine(p, "");
        CustomExtractLoader.writeCommentLine(p, "Colors must be hex codes; try to avoid conflicts with existing ores, including those natively handled by RC.");
        CustomExtractLoader.writeCommentLine(p, "");
        CustomExtractLoader.writeCommentLine(p, "'Number' is the number of items normally obtained from the ore block, such as 1 for coal and 4 for redstone,");
        CustomExtractLoader.writeCommentLine(p, "and controls the number of items produced when smelting the flake. Use direct harvesting/smelting, not other processing.");
        CustomExtractLoader.writeCommentLine(p, "");
        CustomExtractLoader.writeCommentLine(p, "Sample Lines:");
        CustomExtractLoader.writeCommentLine(p, "\tSample Ore 1, SCARCE, INGOT, ingotSample, 1, 0xffffff, 0x73cc12, null, oreSample");
        CustomExtractLoader.writeCommentLine(p, "\tSample Ore 2, Common, dust, dustMetal, 4, 0x77003b, 0xb1a700, null, oreNotSample, oreSecondName, oreHasLotsOfVariants");
        CustomExtractLoader.writeCommentLine(p, "\tSample Ore 3, EVerYwHEre, gEm, ImproperIngot, 3, 0x1487a6, 0x27c61a, null, PoorlyNamedOre");
        CustomExtractLoader.writeCommentLine(p, "\tSample Ore 4, rare, Ingot, ingotEndCopper, 1, 0x16723d, 0xcb6faa, COPPER, oreEndCopper");
        CustomExtractLoader.writeCommentLine(p, "");
        CustomExtractLoader.writeCommentLine(p, "Entries missing names, rarities, types, products, or colors, or having less than one Ore Dictionary name, are incorrect.");
        CustomExtractLoader.writeCommentLine(p, "Incorrectly formatted lines will be ignored and will log an error in the console.");
        CustomExtractLoader.writeCommentLine(p, "Lines beginning with '//' are comments and will be ignored, as will empty lines. Spaces are stripped.");
        CustomExtractLoader.writeCommentLine(p, "");
        CustomExtractLoader.writeCommentLine(p, "NOTE WELL: It is your responsibility to choose the ore blocks appropriately.");
        CustomExtractLoader.writeCommentLine(p, "\tWhile you can theoretically make anything processable in the Extractor,");
        CustomExtractLoader.writeCommentLine(p, "\tnull or missing blocks, and non-blocks are likely to crash and corrupt the");
        CustomExtractLoader.writeCommentLine(p, "\tworld. You may also create duplication exploits. No support will be provided in this case.");
        CustomExtractLoader.writeCommentLine(p, "====================================================================================");
        return ReikaFileReader.writeLinesToFile((File)f, p, (boolean)true, (Charset)Charsets.UTF_8);
    }

    private static void writeCommentLine(ArrayList<String> li, String line) {
        li.add("// " + line);
    }

    private CustomExtractEntry parseString(String s) throws Exception {
        String[] parts = s.split(",");
        for (int i = 1; i < parts.length; ++i) {
            parts[i] = ReikaStringParser.stripSpaces((String)parts[i]);
        }
        if (parts.length < 8) {
            throw new IllegalArgumentException("Invalid parameter count.");
        }
        String name = parts[0];
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Empty name is invalid.");
        }
        OreType.OreRarity rarity = OreType.OreRarity.valueOf((String)parts[1].toUpperCase());
        ProductType type = ProductType.valueOf(parts[2].toUpperCase());
        String prod = parts[3];
        int smelt = Integer.parseInt(parts[4]);
        if (parts[5].startsWith("0x")) {
            parts[5] = parts[5].substring(2);
        }
        if (parts[6].startsWith("0x")) {
            parts[6] = parts[6].substring(2);
        }
        int c1 = Integer.parseInt(parts[5], 16);
        int c2 = Integer.parseInt(parts[6], 16);
        OreType ore = this.parseOreType(parts[7]);
        String[] ores = new String[parts.length - 8];
        System.arraycopy(parts, 8, ores, 0, ores.length);
        return new CustomExtractEntry(this.data.size(), name, rarity, type, prod, smelt, c1, c2, ore, ores);
    }

    private OreType parseOreType(String tag) {
        if (tag.equals("null")) {
            return null;
        }
        ModOreList type = null;
        try {
            type = ModOreList.valueOf((String)tag.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (type == null) {
            try {
                type = ReikaOreHelper.valueOf((String)tag.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (type == null) {
            throw new IllegalArgumentException("Native ore type '" + tag + "' is invalid.");
        }
        return type;
    }

    public List<CustomExtractEntry> getEntries() {
        return Collections.unmodifiableList(this.data);
    }

    public CustomExtractEntry getEntryFromOreBlock(ItemStack is) {
        for (CustomExtractEntry e : this.data) {
            if (!ReikaItemHelper.collectionContainsItemStack(e.getAllOreBlocks(), (ItemStack)is)) continue;
            return e;
        }
        return null;
    }

    public static enum ProductType {
        INGOT("Ingots like Iron and Copper"),
        DUST("Dusts like Redstone and Sulfur"),
        GEM("Gems like Diamonds and Amethyst"),
        ITEM("Anything else, like ThaumCraft shards");

        public final String displayName = ReikaStringParser.capFirstChar((String)this.name());
        private final String desc;

        private ProductType(String d) {
            this.desc = d;
        }
    }

    public static class CustomExtractEntry
    implements OreType {
        public final String displayName;
        public final OreType.OreRarity rarity;
        private final ArrayList<ItemStack> oreItems = new ArrayList();
        private final ArrayList<String> oreNames = new ArrayList();
        public final int color1;
        public final int color2;
        public final ProductType type;
        public final String productName;
        public final OreType nativeOre;
        public final int numberSmelted;
        public final int ordinal;

        private CustomExtractEntry(int idx, String name, OreType.OreRarity r, ProductType t, String prod, int n, int c1, int c2, OreType mod, String ... ores) {
            this.displayName = name;
            for (int i = 0; i < ores.length; ++i) {
                String s = ores[i];
                this.oreNames.add(s);
                this.oreItems.addAll(OreDictionary.getOres((String)s));
                if (!this.oreItems.isEmpty()) continue;
                throw new IllegalStateException("Cannot have entries with no corresponding ores!");
            }
            this.rarity = r;
            this.color1 = c1;
            this.color2 = c2;
            this.productName = prod;
            this.type = t;
            this.nativeOre = mod;
            this.numberSmelted = n;
            this.ordinal = idx;
        }

        public String toString() {
            return this.displayName + " to " + this.productName + " with rarity " + this.rarity + " (" + this.oreNames.size() + " ores found from " + this.oreNames + ")";
        }

        public OreType.OreRarity getRarity() {
            return this.rarity;
        }

        public Collection<ItemStack> getAllOreBlocks() {
            return Collections.unmodifiableCollection(this.oreItems);
        }

        public ItemStack getFirstOreBlock() {
            return this.oreItems.get(0).func_77946_l();
        }

        public boolean canGenerateIn(Block b) {
            return false;
        }

        public EnumSet<OreType.OreLocation> getOreLocations() {
            return EnumSet.noneOf(OreType.OreLocation.class);
        }

        public boolean existsInGame() {
            return true;
        }

        public int ordinal() {
            return this.ordinal;
        }

        public String[] getOreDictNames() {
            return (String[])ReikaJavaLibrary.collectionToArray(this.oreNames);
        }

        public String getProductOreDictName() {
            return this.productName;
        }

        public String name() {
            return this.displayName;
        }

        public int getDisplayColor() {
            return this.color1;
        }

        public int getDropCount() {
            return 1;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

