/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.Maps.FluidHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.DragonAPI.ModInteract.RecipeHandlers.SmelteryRecipeHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesCrystallizer
extends RecipeHandler
implements RecipeInterface.CrystallizerManager {
    private static final RecipesCrystallizer CrystallizerBase = new RecipesCrystallizer();
    private final FluidHashMap<CrystallizerRecipe> recipeList = new FluidHashMap();

    public static final RecipesCrystallizer getRecipes() {
        return CrystallizerBase;
    }

    private RecipesCrystallizer() {
        super(MachineRegistry.CRYSTALLIZER);
        RecipeInterface.crystallizer = this;
        this.addRecipe(FluidRegistry.WATER, 1000, new ItemStack(Blocks.field_150432_aD), RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(FluidRegistry.WATER, 200, new ItemStack(Items.field_151126_ay), RecipeHandler.RecipeLevel.PROTECTED);
        this.addRecipe(FluidRegistry.LAVA, 1000, new ItemStack(Blocks.field_150348_b), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe("rc ethanol", 1000, ItemRegistry.ETHANOL.getStackOf(), RecipeHandler.RecipeLevel.PROTECTED);
    }

    @Override
    public void addAPIRecipe(Fluid f, int amount, ItemStack out) {
        this.addRecipe(f, amount, out, RecipeHandler.RecipeLevel.API);
    }

    public void addRecipe(Fluid f, int amount, ItemStack out, RecipeHandler.RecipeLevel rl) {
        CrystallizerRecipe rec = new CrystallizerRecipe(new FluidStack(f, amount), out);
        this.recipeList.put(f, amount, (Object)rec);
        this.onAddRecipe(rec, rl);
    }

    private void addRecipe(String s, int amount, ItemStack out, RecipeHandler.RecipeLevel rl) {
        Fluid f = FluidRegistry.getFluid((String)s);
        if (f != null) {
            this.addRecipe(f, amount, out, rl);
        }
    }

    public ItemStack getFreezingResult(FluidStack liquid) {
        Fluid f = liquid.getFluid();
        CrystallizerRecipe cr = (CrystallizerRecipe)this.recipeList.getForValue(liquid);
        if (cr == null) {
            return null;
        }
        int req = ((CrystallizerRecipe)cr).input.amount;
        if (req > liquid.amount) {
            return null;
        }
        return cr.output.func_77946_l();
    }

    public CrystallizerRecipe getRecipe(ItemStack result) {
        for (CrystallizerRecipe cr : this.recipeList.values()) {
            if (!ReikaItemHelper.matchStacks((ItemStack)result, (ItemStack)cr.output)) continue;
            return cr;
        }
        return null;
    }

    public int getRecipeConsumption(ItemStack result) {
        CrystallizerRecipe cr = this.getRecipe(result);
        return cr != null ? ((CrystallizerRecipe)cr).input.amount : 0;
    }

    public boolean isValidFluid(Fluid f) {
        return this.recipeList.containsKey(f);
    }

    public Collection<CrystallizerRecipe> getAllRecipes() {
        HashSet<CrystallizerRecipe> c = new HashSet<CrystallizerRecipe>();
        for (CrystallizerRecipe cr : this.recipeList.values()) {
            c.add(cr);
        }
        return c;
    }

    @Override
    public void addPostLoadRecipes() {
        List li;
        this.addRecipe("ender", 250, new ItemStack(Items.field_151079_bi), RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe("redstone", 100, new ItemStack(Items.field_151137_ax), RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe("glowstone", 250, new ItemStack(Items.field_151114_aO), RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe("coal", 100, new ItemStack(Items.field_151044_h), RecipeHandler.RecipeLevel.MODINTERACT);
        if (ModList.TINKERER.isLoaded() && (li = SmelteryRecipeHandler.getCastingRecipes()) != null) {
            for (Object o : li) {
                ItemStack cast = SmelteryRecipeHandler.getRecipeCast(o);
                if (!ReikaItemHelper.matchStacks((ItemStack)cast, (ItemStack)TinkerToolHandler.getInstance().getIngotCast())) continue;
                ItemStack out = SmelteryRecipeHandler.getRecipeOutput(o);
                FluidStack fs = SmelteryRecipeHandler.getRecipeFluid(o);
                if (ModList.IC2.isLoaded() && fs.getFluid().getName().toLowerCase(Locale.ENGLISH).equals("steel.molten")) {
                    out = RecipesCrystallizer.getNonRefinedIronSteel(out);
                }
                this.addRecipe(fs.getFluid(), fs.amount, out, RecipeHandler.RecipeLevel.MODINTERACT);
            }
        }
    }

    public static ItemStack getNonRefinedIronSteel(ItemStack out) {
        ItemStack refiron = IC2Handler.IC2Stacks.REFINEDIRON.getItem();
        ItemStack refblock = ReikaItemHelper.lookupItem((String)"IC2:blockMetal:5");
        if (ReikaItemHelper.matchStacks((ItemStack)refiron, (ItemStack)out) || ReikaItemHelper.matchStacks((ItemStack)refblock, (ItemStack)out)) {
            int[] ids;
            RotaryCraft.logger.log((Object)"Handling steel casting to refined iron, finding alternate.");
            String tag = null;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)out)) {
                String s = OreDictionary.getOreName((int)id);
                if (!s.toLowerCase(Locale.ENGLISH).contains("steel")) continue;
                tag = s;
                break;
            }
            RotaryCraft.logger.log((Object)("OreDict tag is '" + tag + "'."));
            if (tag == null) {
                return out;
            }
            ArrayList ingots = OreDictionary.getOres((String)tag);
            if (ingots.size() > 1) {
                for (ItemStack ing : ingots) {
                    if (ReikaItemHelper.matchStacks((ItemStack)refiron, (ItemStack)ing) || ReikaItemHelper.matchStacks((ItemStack)refblock, (ItemStack)ing)) continue;
                    out = ReikaItemHelper.getSizedItemStack((ItemStack)ing, (int)out.field_77994_a);
                    RotaryCraft.logger.log((Object)("Converting to " + out + " (" + RecipesCrystallizer.fullID(out) + ")"));
                    break;
                }
            }
        }
        return out;
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipeList.removeValue((Object)((CrystallizerRecipe)recipe));
    }

    @Override
    protected boolean addCustomRecipe(String n, LuaBlock lb, CustomRecipeList crl) throws Exception {
        ItemStack out = CustomRecipeList.parseItemString((String)lb.getString("output"), (LuaBlock)lb.getChild("output_nbt"), (boolean)false);
        this.verifyOutputItem(out);
        String fluid = lb.getString("input_fluid");
        Fluid f = FluidRegistry.getFluid((String)fluid);
        if (f == null) {
            throw new IllegalArgumentException("Fluid '" + fluid + "' does not exist!");
        }
        int amt = lb.getInt("input_amount");
        this.addRecipe(f, amt, out, RecipeHandler.RecipeLevel.CUSTOM);
        return true;
    }

    public static class CrystallizerRecipe
    implements RecipeHandler.MachineRecipe {
        private final FluidStack input;
        private final ItemStack output;

        private CrystallizerRecipe(FluidStack fs, ItemStack is) {
            this.input = fs;
            this.output = is;
        }

        @Override
        public String getUniqueID() {
            return this.input.getFluid().getName() + ":" + this.input.amount + ">" + RecipeHandler.fullID(this.output);
        }

        @Override
        public String getAllInfo() {
            return "Freezing " + this.input.amount + " of " + this.input.getLocalizedName() + " into " + RecipeHandler.fullID(this.output);
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            return ReikaJavaLibrary.makeListFrom((Object)ReikaFluidHelper.getFluidStackAsItem((FluidStack)this.input));
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public FluidStack getFluid() {
            return this.input.copy();
        }
    }
}

