/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MekToolHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.RedstoneArsenalHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.Interfaces.EnvironmentalHeatSource;
import Reika.RotaryCraft.API.Power.ShaftMachine;
import Reika.RotaryCraft.Auxiliary.OldTextureLoader;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.GuiHandler;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.GuiRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.awt.Color;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RotaryAux {
    public static int blockModel;
    public static final Color[] sideColors;
    public static final String[] sideColorNames;
    public static final boolean getPowerOnClient;
    public static final double tungstenDensity = 10100.0;
    private static Set<Class<? extends TileEntity>> shaftPowerBlacklist;

    public static boolean isBlacklistedIOMachine(TileEntity te) {
        return shaftPowerBlacklist.contains(te.getClass());
    }

    private static void addShaftBlacklist(String name) {
        try {
            Class<?> cl = Class.forName(name);
            shaftPowerBlacklist.add(cl);
            RotaryCraft.logger.log((Object)("Disabling " + name + " for shaft power. Destructive compatibility."));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static final boolean hasGui(World world, int x, int y, int z, EntityPlayer ep) {
        Object GUI;
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, x, y, z);
        if (m == MachineRegistry.ENGINE) {
            TileEntityEngine te = (TileEntityEngine)world.func_147438_o(x, y, z);
            if (te == null) {
                return false;
            }
            if (te.getEngineType() == null) {
                return false;
            }
            return te.getEngineType().hasGui();
        }
        if (m == MachineRegistry.SPLITTER) {
            TileEntitySplitter te = (TileEntitySplitter)world.func_147438_o(x, y, z);
            return te.func_145832_p() >= 8;
        }
        if (m == MachineRegistry.SCREEN) {
            return !ep.func_70093_af();
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && (GUI = GuiHandler.instance.getClientGuiElement(GuiRegistry.MACHINE.ordinal(), ep, world, x, y, z)) != null) {
            return true;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && (GUI = GuiHandler.instance.getServerGuiElement(GuiRegistry.MACHINE.ordinal(), ep, world, x, y, z)) != null;
    }

    public static int get4SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        int i;
        for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
        }
        while (i < 0) {
            i += 4;
        }
        switch (i) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        return -1;
    }

    public static int get6SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        if (MathHelper.func_76135_e((float)ep.field_70125_A) < 60.0f) {
            int i;
            for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
            }
            while (i < 0) {
                i += 4;
            }
            switch (i) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 0;
                }
            }
        } else {
            if (ep.field_70125_A > 0.0f) {
                return 4;
            }
            return 5;
        }
        return -1;
    }

    public static int get2SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        int i;
        for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
        }
        while (i < 0) {
            i += 4;
        }
        switch (i) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public static void flipXMetadatas(TileEntity t) {
        if (!(t instanceof RotaryCraftTileEntity)) {
            return;
        }
        RotaryCraftTileEntity te = (RotaryCraftTileEntity)t;
        int m = te.func_145832_p();
        switch (m) {
            case 0: {
                te.setBlockMetadata(1);
                break;
            }
            case 1: {
                te.setBlockMetadata(0);
            }
        }
    }

    public static void flipZMetadatas(TileEntity t) {
        if (!(t instanceof RotaryCraftTileEntity)) {
            return;
        }
        RotaryCraftTileEntity te = (RotaryCraftTileEntity)t;
        int m = te.func_145832_p();
        switch (m) {
            case 2: {
                te.setBlockMetadata(3);
                break;
            }
            case 3: {
                te.setBlockMetadata(2);
            }
        }
    }

    public static boolean canHarvestSteelMachine(EntityPlayer ep) {
        if (ep.field_71075_bZ.field_75098_d) {
            return false;
        }
        ItemStack eitem = ep.field_71071_by.func_70448_g();
        if (eitem == null) {
            return false;
        }
        if (TinkerToolHandler.getInstance().isHammer(eitem)) {
            return false;
        }
        if (TinkerToolHandler.getInstance().isPick(eitem) && TinkerToolHandler.getInstance().isStoneOrBetter(eitem)) {
            return true;
        }
        if (MekToolHandler.getInstance().isPickTypeTool(eitem) && !MekToolHandler.getInstance().isWood(eitem)) {
            return true;
        }
        if (eitem.func_77973_b() == RedstoneArsenalHandler.getInstance().pickID) {
            return RedstoneArsenalHandler.getInstance().pickLevel > 0;
        }
        return eitem.func_77973_b().canHarvestBlock(Blocks.field_150366_p, eitem);
    }

    public static boolean shouldSetFlipped(World world, int x, int y, int z) {
        boolean softBelow = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
        boolean softAbove = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y + 1), (int)z);
        return !softAbove && softBelow;
    }

    public static boolean isMuffled(TileEntity te) {
        return RotaryAux.isMuffled(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static boolean isMuffled(World world, int x, int y, int z) {
        return RotaryAux.isMufflingBlock(world, x, y + 1, z) && RotaryAux.isMufflingBlock(world, x, y - 1, z);
    }

    public static boolean isMufflingBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        return b.func_149688_o() == Material.field_151580_n || b == Block.func_149684_b((String)"Rockwool");
    }

    public static boolean isNextToIce(World world, int x, int y, int z) {
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151588_w) != null) {
            return true;
        }
        Block b = world.func_147439_a(x, y - 1, z);
        if (b instanceof EnvironmentalHeatSource) {
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y, z) && ehs.getSourceType((IBlockAccess)world, x, y, z).isCold();
        }
        return false;
    }

    public static boolean isNextToWater(World world, int x, int y, int z) {
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h) != null) {
            return true;
        }
        for (int i = 1; i <= 2; ++i) {
            Block b = world.func_147439_a(x, y - i, z);
            if (!(b instanceof EnvironmentalHeatSource)) continue;
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y - i, z) && ehs.getSourceType((IBlockAccess)world, x, y - i, z) == EnvironmentalHeatSource.SourceType.WATER;
        }
        return false;
    }

    public static boolean isNextToFire(World world, int x, int y, int z) {
        if (ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150480_ab) != null) {
            return true;
        }
        for (int i = 1; i <= 2; ++i) {
            Block b = world.func_147439_a(x, y - i, z);
            if (!(b instanceof EnvironmentalHeatSource)) continue;
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y - i, z) && ehs.getSourceType((IBlockAccess)world, x, y - i, z) == EnvironmentalHeatSource.SourceType.FIRE;
        }
        return false;
    }

    public static boolean isNextToLava(World world, int x, int y, int z) {
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i) != null) {
            return true;
        }
        for (int i = 1; i <= 2; ++i) {
            Block b = world.func_147439_a(x, y - i, z);
            if (!(b instanceof EnvironmentalHeatSource)) continue;
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y - i, z) && ehs.getSourceType((IBlockAccess)world, x, y - i, z) == EnvironmentalHeatSource.SourceType.LAVA;
        }
        return false;
    }

    public static boolean isAboveFire(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        if (b == Blocks.field_150480_ab) {
            return true;
        }
        for (int i = 1; i <= 2; ++i) {
            b = world.func_147439_a(x, y - i, z);
            if (!(b instanceof EnvironmentalHeatSource)) continue;
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y - i, z) && ehs.getSourceType((IBlockAccess)world, x, y - i, z) == EnvironmentalHeatSource.SourceType.FIRE;
        }
        return false;
    }

    public static boolean isAboveLava(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        if (b.func_149688_o() == Material.field_151587_i) {
            return true;
        }
        for (int i = 1; i <= 2; ++i) {
            b = world.func_147439_a(x, y - i, z);
            if (!(b instanceof EnvironmentalHeatSource)) continue;
            EnvironmentalHeatSource ehs = (EnvironmentalHeatSource)b;
            return ehs.isActive((IBlockAccess)world, x, y - i, z) && ehs.getSourceType((IBlockAccess)world, x, y - i, z) == EnvironmentalHeatSource.SourceType.LAVA;
        }
        return false;
    }

    public static String formatTemperature(double temp) {
        String unit = "C";
        if (OldTextureLoader.instance.loadOldTextures()) {
            unit = "F";
            temp = temp * 1.8 + 32.0;
        }
        return String.format("%.0f%s", temp, unit);
    }

    public static String formatPressure(double press) {
        String unit = "Pa";
        if (OldTextureLoader.instance.loadOldTextures()) {
            unit = "psi";
            press *= 0.145;
        } else {
            press *= 1000.0;
        }
        double val = ReikaMathLibrary.getThousandBase((double)press);
        String sg = ReikaEngLibrary.getSIPrefix((double)press);
        return String.format("%.3f%s%s", val, sg, unit);
    }

    public static String formatTorque(double t) {
        String unit = "Nm";
        if (OldTextureLoader.instance.loadOldTextures()) {
            unit = "ft-lb";
            t *= 0.738;
        }
        double val = ReikaMathLibrary.getThousandBase((double)t);
        String sg = ReikaEngLibrary.getSIPrefix((double)t);
        return String.format("%.0f %s%s", val, sg, unit);
    }

    public static String formatSpeed(double s) {
        String unit = "rad/s";
        if (OldTextureLoader.instance.loadOldTextures()) {
            unit = "rpm";
            s *= 9.55;
        }
        double val = ReikaMathLibrary.getThousandBase((double)s);
        String sg = ReikaEngLibrary.getSIPrefix((double)s);
        return String.format("%.0f %s%s", val, sg, unit);
    }

    public static String formatPower(double p) {
        String unit = "W";
        if (OldTextureLoader.instance.loadOldTextures()) {
            unit = "hp";
            p /= 745.7;
        }
        double val = ReikaMathLibrary.getThousandBase((double)p);
        String sg = ReikaEngLibrary.getSIPrefix((double)p);
        return String.format("%.3f%s%s", val, sg, unit);
    }

    public static String formatEnergy(double e) {
        String unit = "J";
        if (OldTextureLoader.instance.loadOldTextures()) {
            unit = "ft-lb";
            e /= 1.356;
        }
        double val = ReikaMathLibrary.getThousandBase((double)e);
        String sg = ReikaEngLibrary.getSIPrefix((double)e);
        return String.format("%.3f%s%s", val, sg, unit);
    }

    public static String formatPowerIO(TileEntityIOMachine te) {
        return RotaryAux.formatPowerIO(te.omega, te.power);
    }

    public static String formatPowerIO(ShaftMachine te) {
        return RotaryAux.formatPowerIO(te.getOmega(), te.getPower());
    }

    public static String formatPowerIO(double speed, double power) {
        String unit1 = "W";
        String unit2 = "rad/s";
        if (OldTextureLoader.instance.loadOldTextures()) {
            unit1 = "hp";
            power /= 745.7;
            unit2 = "rpm";
            speed *= 9.55;
        }
        double valp = ReikaMathLibrary.getThousandBase((double)power);
        String sgp = ReikaEngLibrary.getSIPrefix((double)power);
        return String.format("%.3f%s%s @ %.0f %s", valp, sgp, unit1, speed, unit2);
    }

    public static String formatTorqueSpeedPowerForBook(String text, double torque, double speed, double power) {
        String speedunit;
        boolean old = OldTextureLoader.instance.loadOldTextures();
        String powerunit = old ? "hp" : "W";
        String torqueunit = old ? "ft-lb" : "Nm";
        String string = speedunit = old ? "rpm" : "rad/s";
        if (old) {
            speed *= 9.55;
            torque *= 0.738;
            power /= 745.7;
        } else {
            powerunit = ReikaEngLibrary.getSIPrefix((double)power) + powerunit;
            power = ReikaMathLibrary.getThousandBase((double)power);
        }
        text = text.replace("$SPEED_UNIT$", speedunit);
        text = text.replace("$POWER_UNIT$", powerunit);
        text = text.replace("$TORQUE_UNIT$", torqueunit);
        String ret = String.format(text, (int)torque, (int)speed, power);
        return ret;
    }

    public static String formatSingleValueForBook(String text, double value, int torqueSpeedPowerSelector) {
        boolean old = OldTextureLoader.instance.loadOldTextures();
        String unit = null;
        switch (torqueSpeedPowerSelector) {
            case 0: {
                if (old) {
                    value *= 0.738;
                }
                unit = old ? "ft-lb" : "Nm";
                break;
            }
            case 1: {
                if (old) {
                    value *= 9.55;
                }
                unit = old ? "rpm" : "rad/s";
                break;
            }
            case 2: {
                if (old) {
                    value /= 745.7;
                }
                String string = unit = old ? "hp" : "W";
            }
        }
        if (torqueSpeedPowerSelector == 2) {
            unit = ReikaEngLibrary.getSIPrefix((double)value) + unit;
            value = ReikaMathLibrary.getThousandBase((double)value);
        }
        text = text.replace("$SPEED_UNIT$", unit);
        text = text.replace("$POWER_UNIT$", unit);
        text = text.replace("$TORQUE_UNIT$", unit);
        String ret = null;
        ret = torqueSpeedPowerSelector == 2 ? String.format(text, value) : String.format(text, (int)value);
        return ret;
    }

    public static String formatValuesForBook(String text, Object[] vals) {
        if (OldTextureLoader.instance.loadOldTextures()) {
            // empty if block
        }
        return String.format(text, vals);
    }

    public static String formatDistance(double dist) {
        String unit = "m";
        if (OldTextureLoader.instance.loadOldTextures()) {
            unit = "ft";
            dist *= 3.28;
        }
        double val = ReikaMathLibrary.getThousandBase((double)dist);
        String sg = ReikaEngLibrary.getSIPrefix((double)dist);
        return String.format("%.3f%s%s", val, sg, unit);
    }

    public static String formatLiquidAmount(double amt) {
        String unit = "mB";
        if (OldTextureLoader.instance.loadOldTextures()) {
            amt *= 0.264;
            unit = "gal";
        }
        return String.format("%.0f%s", amt, unit);
    }

    public static String formatLiquidAmountWithSI(double amt) {
        String unit = "B";
        if (OldTextureLoader.instance.loadOldTextures()) {
            amt *= 0.264;
            unit = "gal";
        }
        double val = ReikaMathLibrary.getThousandBase((double)amt);
        String sg = ReikaEngLibrary.getSIPrefix((double)amt);
        return String.format("%.3f%s%s", val, sg, unit);
    }

    public static String formatLiquidFillFraction(double amt, double capacity) {
        String unit = "mB";
        if (OldTextureLoader.instance.loadOldTextures()) {
            amt *= 0.264;
            capacity *= 0.264;
            unit = "gal";
        }
        return String.format("%.0f/%.0f %s", amt, capacity, unit);
    }

    public static ItemStack getShaftCrossItem() {
        ItemStack is = ItemRegistry.SHAFT.getStackOf();
        is.field_77990_d = new NBTTagCompound();
        is.field_77990_d.func_74757_a("cross", true);
        return is;
    }

    public static boolean isShaftCross(ItemStack is) {
        return ItemRegistry.SHAFT.matchItem(is) && is.field_77990_d != null && is.field_77990_d.func_74767_n("cross");
    }

    public static boolean isHoldingScrewdriver(EntityPlayer ep) {
        ItemStack is = ep.func_71045_bC();
        if (ModList.THAUMCRAFT.isLoaded() && RotaryAux.isScrewFocusWand(is)) {
            return true;
        }
        return ItemRegistry.SCREWDRIVER.matchItem(is);
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    private static boolean isScrewFocusWand(ItemStack is) {
        return is != null && is.func_77973_b() == ThaumItemHelper.ItemEntry.WAND.getItem().func_77973_b() && ReikaThaumHelper.getWandFocus((ItemStack)is) == ItemRegistry.SCREWFOCUS.getItemInstance();
    }

    static {
        sideColors = new Color[]{Color.CYAN, Color.BLUE, Color.YELLOW, Color.BLACK, new Color(255, 120, 0), Color.MAGENTA};
        sideColorNames = new String[]{"CYAN", "BLUE", "YELLOW", "BLACK", "ORANGE", "MAGENTA"};
        getPowerOnClient = ConfigRegistry.POWERCLIENT.getState() || ReikaObfuscationHelper.isDeObfEnvironment();
        shaftPowerBlacklist = new OneWayCollections.OneWaySet();
    }
}

