/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Instantiable.Event.Client.ResourceReloadEvent;
import Reika.DragonAPI.Instantiable.IO.XMLInterface;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.Power.ReikaEUHelper;
import Reika.DragonAPI.ModInteract.Power.ReikaRFHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesFrictionHeater;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesMagnetizer;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.EnergyToPowerBase;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.Flywheels;
import Reika.RotaryCraft.Registry.HandbookRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.Registry.PowerReceivers;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityEngineController;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityDistillery;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBorer;
import Reika.RotaryCraft.TileEntities.TileEntityVacuum;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBeltHub;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;

public final class RotaryDescriptions {
    private static String PARENT = RotaryDescriptions.getParent(true);
    private static final String DESC_SUFFIX = ":desc";
    private static final String NOTE_SUFFIX = ":note";
    private static final String SUBNOTE_SUFFIX = ":sub";
    private static HashMap<HandbookRegistry, String> data = new HashMap();
    private static PluralMap<String> notes = new PluralMap(2);
    private static HashMap<MachineRegistry, Object[]> machineData = new HashMap();
    private static PluralMap<Object[]> machineNotes = new PluralMap(2);
    private static HashMap<HandbookRegistry, Object[]> miscData = new HashMap();
    private static HashMap<HandbookRegistry, Integer> lengths = new HashMap();
    private static ArrayList<HandbookRegistry> categories = new ArrayList();
    private static final XMLInterface parents = RotaryDescriptions.loadData("categories");
    private static final XMLInterface machines = RotaryDescriptions.loadData("machines");
    private static final XMLInterface trans = RotaryDescriptions.loadData("trans");
    private static final XMLInterface converter = RotaryDescriptions.loadData("converter");
    private static final XMLInterface engines = RotaryDescriptions.loadData("engines");
    private static final XMLInterface tools = RotaryDescriptions.loadData("tools");
    private static final XMLInterface resources = RotaryDescriptions.loadData("resource");
    private static final XMLInterface miscs = RotaryDescriptions.loadData("misc");
    private static final XMLInterface infos = RotaryDescriptions.loadData("info");

    private static XMLInterface loadData(String name) {
        XMLInterface xml = new XMLInterface(RotaryCraft.class, PARENT + name + ".xml", !ReikaObfuscationHelper.isDeObfEnvironment());
        xml.setFallback(RotaryDescriptions.getParent(false) + name + ".xml");
        xml.init();
        return xml;
    }

    public static void addCategory(HandbookRegistry h) {
        categories.add(h);
    }

    private static String getParent(boolean locale) {
        return locale && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? RotaryDescriptions.getLocalizedParent() : "Resources/";
    }

    @SideOnly(value=Side.CLIENT)
    private static String getLocalizedParent() {
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String lang = language.func_135034_a();
        if (RotaryDescriptions.hasLocalizedFor(language) && !"en_US".equals(lang)) {
            return "Resources/" + lang + "/";
        }
        return "Resources/";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SideOnly(value=Side.CLIENT)
    private static boolean hasLocalizedFor(Language language) {
        String lang = language.func_135034_a();
        try (InputStream o = RotaryCraft.class.getResourceAsStream("Resources/" + lang + "/categories.xml");){
            boolean bl = o != null;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getCategoryCount() {
        return categories.size();
    }

    public static String getTOC() {
        List<HandbookRegistry> toctabs = HandbookRegistry.getTOCTabs();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toctabs.size(); ++i) {
            HandbookRegistry h = toctabs.get(i);
            sb.append("Page ");
            sb.append(h.getScreen());
            sb.append(" - ");
            sb.append(h.getTOCTitle());
            if (i >= toctabs.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void addData(MachineRegistry m, Object ... data) {
        machineData.put(m, data);
    }

    private static void addData(HandbookRegistry h, Object ... data) {
        miscData.put(h, data);
    }

    private static void addData(HandbookRegistry h, int[] data) {
        Object[] o = new Object[data.length];
        for (int i = 0; i < o.length; ++i) {
            o[i] = data[i];
        }
        miscData.put(h, o);
    }

    private static void addNotes(MachineRegistry m, Object ... data) {
        machineNotes.put((Object)data, new Object[]{m, 0});
    }

    private static void addSubNotes(MachineRegistry m, int subpage, Object ... data) {
        machineNotes.put((Object)data, new Object[]{m, subpage});
    }

    public static void reload() {
        PARENT = RotaryDescriptions.getParent(true);
        RotaryDescriptions.loadNumericalData();
        machines.reread();
        trans.reread();
        engines.reread();
        tools.reread();
        resources.reread();
        miscs.reread();
        infos.reread();
        parents.reread();
        RotaryDescriptions.loadData();
    }

    private static void addEntry(HandbookRegistry h, String sg) {
        data.put(h, sg);
    }

    public static void loadData() {
        String desc;
        List<HandbookRegistry> parenttabs = HandbookRegistry.getCategoryTabs(false);
        List<HandbookRegistry> enginetabs = HandbookRegistry.getEngineTabs();
        List<HandbookRegistry> transtabs = HandbookRegistry.getTransTabs();
        List<HandbookRegistry> convertertabs = HandbookRegistry.getConverterTabs();
        List<HandbookRegistry> machinetabs = HandbookRegistry.getMachineTabs();
        List<HandbookRegistry> tooltabs = HandbookRegistry.getToolTabs();
        List<HandbookRegistry> resourcetabs = HandbookRegistry.getResourceTabs();
        List<HandbookRegistry> misctabs = HandbookRegistry.getMiscTabs();
        List<HandbookRegistry> infotabs = HandbookRegistry.getInfoTabs();
        for (HandbookRegistry h : parenttabs) {
            desc = parents.getValueAtNode("categories:" + h.name().toLowerCase(Locale.ENGLISH).substring(0, h.name().length() - 4));
            RotaryDescriptions.addEntry(h, desc);
        }
        for (HandbookRegistry h : machinetabs) {
            RotaryDescriptions.loadMachineTab(h, machines);
        }
        for (HandbookRegistry h : convertertabs) {
            RotaryDescriptions.loadMachineTab(h, converter);
        }
        for (HandbookRegistry h : transtabs) {
            MachineRegistry m = h.getMachine();
            String desc2 = trans.getValueAtNode("trans:" + h.name().toLowerCase(Locale.ENGLISH));
            Collection sub = trans.getNodesWithin("trans:" + h.name().toLowerCase(Locale.ENGLISH) + SUBNOTE_SUFFIX);
            if (sub != null && !sub.isEmpty()) {
                int k = 0;
                for (String s : sub) {
                    String val = trans.getValueAtNode(s);
                    if (k == 0) {
                        val = String.format(val, machineData.get((Object)m));
                        val = String.format(val, miscData.get(h));
                        RotaryDescriptions.addEntry(h, val);
                    } else {
                        val = String.format(val, (Object[])machineNotes.get(new Object[]{m, k}));
                        notes.put((Object)val, new Object[]{h, k - 1});
                    }
                    lengths.put(h, ++k);
                }
                continue;
            }
            if ("#NULL!".equals(desc2)) {
                desc2 = "There is no handbook data for this machine yet.";
            }
            if (machineData.containsKey((Object)m)) {
                desc2 = String.format(desc2, machineData.get((Object)m));
            }
            if (miscData.containsKey(h)) {
                desc2 = String.format(desc2, miscData.get(h));
            }
            RotaryDescriptions.addEntry(h, desc2);
        }
        for (HandbookRegistry h : tooltabs) {
            desc = tools.getValueAtNode("tools:" + h.name().toLowerCase(Locale.ENGLISH));
            Collection sub = tools.getNodesWithin("tools:" + h.name().toLowerCase(Locale.ENGLISH) + SUBNOTE_SUFFIX);
            if (sub != null && !sub.isEmpty()) {
                int k = 0;
                for (String s : sub) {
                    String val = tools.getValueAtNode(s);
                    val = String.format(val, miscData.get(h));
                    if (k == 0) {
                        RotaryDescriptions.addEntry(h, val);
                    } else {
                        notes.put((Object)val, new Object[]{h, k - 1});
                    }
                    lengths.put(h, ++k);
                }
                continue;
            }
            desc = String.format(desc, miscData.get(h));
            RotaryDescriptions.addEntry(h, desc);
        }
        for (HandbookRegistry h : resourcetabs) {
            desc = resources.getValueAtNode("resource:" + h.name().toLowerCase(Locale.ENGLISH));
            desc = String.format(desc, miscData.get(h));
            RotaryDescriptions.addEntry(h, desc);
        }
        for (HandbookRegistry h : misctabs) {
            desc = miscs.getValueAtNode("misc:" + h.name().toLowerCase(Locale.ENGLISH));
            desc = String.format(desc, miscData.get(h));
            RotaryDescriptions.addEntry(h, desc);
        }
        for (HandbookRegistry h : infotabs) {
            desc = infos.getValueAtNode("info:" + h.name().toLowerCase(Locale.ENGLISH));
            desc = String.format(desc, miscData.get(h));
            RotaryDescriptions.addEntry(h, desc);
        }
        for (HandbookRegistry h : enginetabs) {
            String aux;
            Collection sub = null;
            EngineType e = h.getEngine();
            if (e != null) {
                desc = engines.getValueAtNode("engines:" + e.name().toLowerCase(Locale.ENGLISH) + DESC_SUFFIX);
                aux = engines.getValueAtNode("engines:" + e.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX);
                sub = engines.getNodesWithin("engines:" + e.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX + SUBNOTE_SUFFIX);
                desc = RotaryAux.formatTorqueSpeedPowerForBook(desc, e.getTorque(), e.getSpeed(), e.getPower());
                aux = RotaryAux.formatTorqueSpeedPowerForBook(aux, e.getTorque(), e.getSpeed(), e.getPower());
            } else {
                desc = engines.getValueAtNode("engines:" + "solar".toLowerCase(Locale.ENGLISH) + DESC_SUFFIX);
                aux = engines.getValueAtNode("engines:" + "solar".toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX);
                desc = RotaryAux.formatSingleValueForBook(desc, 512.0, 1);
                aux = RotaryAux.formatSingleValueForBook(aux, 512.0, 1);
            }
            data.put(h, desc);
            notes.put((Object)aux, new Object[]{h, 0});
            if (sub == null) continue;
            int k = 0;
            for (String s : sub) {
                String val = engines.getValueAtNode(s);
                if (k == 0 && e != null) {
                    val = RotaryAux.formatTorqueSpeedPowerForBook(val, e.getTorque(), e.getSpeed(), e.getPower());
                }
                notes.put((Object)val, new Object[]{h, k});
                lengths.put(h, ++k);
            }
        }
    }

    private static void loadMachineTab(HandbookRegistry h, XMLInterface xml) {
        MachineRegistry m = h.getMachine();
        String desc = xml.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + DESC_SUFFIX);
        String aux = xml.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX);
        Collection sub = machines.getNodesWithin("machines:" + m.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX + SUBNOTE_SUFFIX);
        desc = RotaryAux.formatValuesForBook(desc, machineData.get((Object)m));
        aux = RotaryAux.formatValuesForBook(aux, (Object[])machineNotes.get(new Object[]{m, 0}));
        if ("#NULL!".equals(desc)) {
            desc = "There is no handbook data for this machine yet.";
        }
        if (m.isDummiedOut()) {
            desc = desc + "\nThis machine is currently unavailable.";
            if (m.getModDependency() != null && !m.getModDependency().isLoaded()) {
                desc = desc + "\nThis machine depends on another mod.";
            }
            aux = aux + "\nNote: Dummied Out";
        }
        if (m.hasPrerequisite()) {
            aux = aux + "\nDependencies: " + m.getPrerequisite();
        }
        if (m.isIncomplete()) {
            desc = desc + "\nThis machine is incomplete. Use at your own risk.";
        }
        RotaryDescriptions.addEntry(h, desc);
        notes.put((Object)aux, new Object[]{h, 0});
        if (sub != null) {
            int k = 0;
            for (String s : sub) {
                String val = xml.getValueAtNode(s);
                val = RotaryAux.formatValuesForBook(val, (Object[])machineNotes.get(new Object[]{m, k}));
                notes.put((Object)val, new Object[]{h, k});
                lengths.put(h, ++k);
            }
        }
    }

    public static String getData(HandbookRegistry h) {
        if (!data.containsKey(h)) {
            return "";
        }
        return data.get(h);
    }

    public static String getNotes(HandbookRegistry h, int subpage) {
        if (!notes.containsKeyV(new Object[]{h, --subpage})) {
            return "";
        }
        return (String)notes.get(new Object[]{h, subpage});
    }

    public static int getNotesLength(HandbookRegistry h) {
        return lengths.containsKey(h) ? lengths.get(h) : 1;
    }

    private static void loadNumericalData() {
        RotaryDescriptions.addData(HandbookRegistry.MATERIAL, 800.0, ReikaMathLibrary.getThousandBase((double)2.0E7), ReikaEngLibrary.getSIPrefix((double)2.0E7), ReikaMathLibrary.getThousandBase((double)1.16E7), ReikaEngLibrary.getSIPrefix((double)1.16E7), 3000.0, ReikaMathLibrary.getThousandBase((double)1.0E8), ReikaEngLibrary.getSIPrefix((double)1.0E8), ReikaMathLibrary.getThousandBase((double)4.0E7), ReikaEngLibrary.getSIPrefix((double)4.0E7), 7800.0, ReikaMathLibrary.getThousandBase((double)2.0E8), ReikaEngLibrary.getSIPrefix((double)2.0E8), ReikaMathLibrary.getThousandBase((double)1.16E8), ReikaEngLibrary.getSIPrefix((double)1.16E8), 7800.0, ReikaMathLibrary.getThousandBase((double)4.0E8), ReikaEngLibrary.getSIPrefix((double)4.0E8), ReikaMathLibrary.getThousandBase((double)2.8E8), ReikaEngLibrary.getSIPrefix((double)2.8E8), 19300.0, ReikaMathLibrary.getThousandBase((double)1.08E8), ReikaEngLibrary.getSIPrefix((double)1.08E8), ReikaMathLibrary.getThousandBase((double)6.26E7), ReikaEngLibrary.getSIPrefix((double)6.26E7), 10100.0, ReikaMathLibrary.getThousandBase((double)9.8E8), ReikaEngLibrary.getSIPrefix((double)9.8E8), ReikaMathLibrary.getThousandBase((double)4.0E8), ReikaEngLibrary.getSIPrefix((double)4.0E8), 3500.0, ReikaMathLibrary.getThousandBase((double)5.0E9), ReikaEngLibrary.getSIPrefix((double)5.0E9), ReikaMathLibrary.getThousandBase((double)2.9E9), ReikaEngLibrary.getSIPrefix((double)2.9E9));
        RotaryDescriptions.addData(HandbookRegistry.SHAFTS, MaterialRegistry.getAllLimitLoadsAsInts());
        RotaryDescriptions.addData(HandbookRegistry.FLYWHEELS, Flywheels.getLimitsForDisplay());
        RotaryDescriptions.addData(HandbookRegistry.MODINTERFACE, ReikaMathLibrary.getThousandBase((double)ReikaRFHelper.getWattsPerRF()), ReikaEngLibrary.getSIPrefix((double)ReikaRFHelper.getWattsPerRF()), 50, 80, 90);
        MultiMap<MachineRegistry, Enchantment> map = MachineRegistry.getEnchantableMachineList();
        ArrayList li = new ArrayList(map.keySet());
        Collections.sort(li);
        for (int i = 0; i < li.size(); ++i) {
            List c = (List)map.get(li.get(i));
            CharSequence[] elems = new String[c.size()];
            for (int k = 0; k < elems.length; ++k) {
                elems[k] = StatCollector.func_74838_a((String)((Enchantment)c.get(k)).func_77320_a());
            }
            notes.put((Object)String.join((CharSequence)"\n", elems), new Object[]{HandbookRegistry.ENCHANTING, i});
        }
        RotaryDescriptions.addData(HandbookRegistry.BEARINGS, "25%", "100%");
        RotaryDescriptions.addData(MachineRegistry.BORER, TileEntityBorer.DIGPOWER * 10, TileEntityBorer.calculateTorqueForHardness(ReikaBlockHelper.getHardestBlock().field_149782_v, 0), TileEntityBorer.calculateTorqueForHardness(Blocks.field_150482_ag.field_149782_v, 0));
        RotaryDescriptions.addData(MachineRegistry.PILEDRIVER, 16384);
        RotaryDescriptions.addData(MachineRegistry.EXTRACTOR, PowerReceivers.EXTRACTOR.getMinTorque(0), PowerReceivers.EXTRACTOR.getMinSpeed(2));
        RotaryDescriptions.addData(MachineRegistry.RESERVOIR, 64);
        RotaryDescriptions.addData(MachineRegistry.FAN, PowerReceivers.FAN.getMinPower(), 0x200000L);
        RotaryDescriptions.addData(MachineRegistry.COMPACTOR, 550000, 800);
        RotaryDescriptions.addData(MachineRegistry.BLASTFURNACE, 600, 1450);
        RotaryDescriptions.addData(MachineRegistry.SCALECHEST, 972);
        RotaryDescriptions.addData(MachineRegistry.PURIFIER, 600);
        RotaryDescriptions.addData(MachineRegistry.GENERATOR, ReikaEUHelper.getWattsPerEU());
        RotaryDescriptions.addData(MachineRegistry.BELT, ((TileEntityBeltHub)MachineRegistry.BELT.createTEInstanceForRender(0)).getMaxTorque(), ((TileEntityBeltHub)MachineRegistry.BELT.createTEInstanceForRender(0)).getMaxSmoothSpeed());
        RotaryDescriptions.addData(MachineRegistry.CHAIN, ((TileEntityBeltHub)MachineRegistry.CHAIN.createTEInstanceForRender(0)).getMaxTorque(), ((TileEntityBeltHub)MachineRegistry.CHAIN.createTEInstanceForRender(0)).getMaxSmoothSpeed());
        RotaryDescriptions.addData(MachineRegistry.DYNAMO, 1024, 2048, 8192);
        RotaryDescriptions.addData(MachineRegistry.ITEMCANNON, 524288);
        RotaryDescriptions.addData(MachineRegistry.ADVANCEDGEARS, 64);
        RotaryDescriptions.addData(MachineRegistry.OBSIDIAN, 550, 750);
        RotaryDescriptions.addData(MachineRegistry.SPLITBELT, 64, 16);
        RotaryDescriptions.addNotes(MachineRegistry.BEDROCKBREAKER, PowerReceivers.BEDROCKBREAKER.getMinPower(), PowerReceivers.BEDROCKBREAKER.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.FERMENTER, PowerReceivers.FERMENTER.getMinPower(), PowerReceivers.FERMENTER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.GRINDER, PowerReceivers.GRINDER.getMinPower(), PowerReceivers.GRINDER.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.FLOODLIGHT, PowerReceivers.FLOODLIGHT.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.HEATRAY, PowerReceivers.HEATRAY.getMinPower(), PowerReceivers.HEATRAY.getMinPower(), 256);
        RotaryDescriptions.addNotes(MachineRegistry.PILEDRIVER, 16384, PowerReceivers.PILEDRIVER.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.AEROSOLIZER, PowerReceivers.AEROSOLIZER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.LIGHTBRIDGE, PowerReceivers.LIGHTBRIDGE.getMinPower(), PowerReceivers.LIGHTBRIDGE.getMinPower() / (long)ConfigRegistry.BRIDGERANGE.getValue());
        RotaryDescriptions.addNotes(MachineRegistry.EXTRACTOR, PowerReceivers.EXTRACTOR.getMinPower(0), PowerReceivers.EXTRACTOR.getMinPower(1), PowerReceivers.EXTRACTOR.getMinPower(2), PowerReceivers.EXTRACTOR.getMinPower(3), PowerReceivers.EXTRACTOR.getMinTorque(0), PowerReceivers.EXTRACTOR.getMinTorque(3), PowerReceivers.EXTRACTOR.getMinSpeed(1), PowerReceivers.EXTRACTOR.getMinSpeed(2));
        RotaryDescriptions.addNotes(MachineRegistry.PULSEJET, PowerReceivers.PULSEJET.getMinSpeed(), 1000);
        RotaryDescriptions.addNotes(MachineRegistry.PUMP, PowerReceivers.PUMP.getMinPower(), PowerReceivers.PUMP.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.RESERVOIR, 64);
        RotaryDescriptions.addNotes(MachineRegistry.FAN, PowerReceivers.FAN.getMinPower(), 1024, 512, 64);
        RotaryDescriptions.addNotes(MachineRegistry.COMPACTOR, PowerReceivers.COMPACTOR.getMinPower(), PowerReceivers.COMPACTOR.getMinTorque(), 550000, 800, 600000, 1000);
        RotaryDescriptions.addNotes(MachineRegistry.AUTOBREEDER, PowerReceivers.AUTOBREEDER.getMinPower(), PowerReceivers.AUTOBREEDER.getMinPower(), 2048);
        RotaryDescriptions.addNotes(MachineRegistry.BAITBOX, PowerReceivers.BAITBOX.getMinPower(), PowerReceivers.BAITBOX.getMinPower(), 4096);
        RotaryDescriptions.addNotes(MachineRegistry.FIREWORK, PowerReceivers.FIREWORK.getMinPower(), PowerReceivers.FIREWORK.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.FRACTIONATOR, PowerReceivers.FRACTIONATOR.getMinPower(), PowerReceivers.FRACTIONATOR.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.GPR, PowerReceivers.GPR.getMinPower(), PowerReceivers.GPR.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.HEATER, PowerReceivers.HEATER.getMinPower(), 2000);
        RotaryDescriptions.addNotes(MachineRegistry.OBSIDIAN, PowerReceivers.OBSIDIAN.getMinPower(), PowerReceivers.OBSIDIAN.getMinSpeed(), 1000, 320000);
        RotaryDescriptions.addNotes(MachineRegistry.PLAYERDETECTOR, 128, 100, 32);
        RotaryDescriptions.addNotes(MachineRegistry.SPAWNERCONTROLLER, PowerReceivers.SPAWNERCONTROLLER.getMinPower(), 800);
        RotaryDescriptions.addNotes(MachineRegistry.VACUUM, PowerReceivers.VACUUM.getMinPower(), TileEntityVacuum.FALLOFF);
        RotaryDescriptions.addNotes(MachineRegistry.WOODCUTTER, PowerReceivers.WOODCUTTER.getMinPower(), PowerReceivers.WOODCUTTER.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.MOBRADAR, PowerReceivers.MOBRADAR.getMinPower(), PowerReceivers.MOBRADAR.getMinPower(), 1024);
        RotaryDescriptions.addNotes(MachineRegistry.TNTCANNON, PowerReceivers.TNTCANNON.getMinPower(), PowerReceivers.TNTCANNON.getMinTorque());
        int fudge = 1;
        RotaryDescriptions.addNotes(MachineRegistry.SONICWEAPON, PowerReceivers.SONICWEAPON.getMinPower(), PowerReceivers.SONICWEAPON.getMinPower(), 16384, 1807500L / (long)fudge, 3906200L / (long)fudge, 2971000L / (long)fudge, 100000000L / (long)fudge);
        RotaryDescriptions.addNotes(MachineRegistry.FORCEFIELD, PowerReceivers.FORCEFIELD.getMinPower(), PowerReceivers.FORCEFIELD.getMinPower(), 32768);
        RotaryDescriptions.addNotes(MachineRegistry.MUSICBOX, 1024);
        RotaryDescriptions.addNotes(MachineRegistry.MOBHARVESTER, PowerReceivers.MOBHARVESTER.getMinPower(), PowerReceivers.MOBHARVESTER.getMinPower() * 2L);
        RotaryDescriptions.addNotes(MachineRegistry.PROJECTOR, PowerReceivers.PROJECTOR.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.RAILGUN, PowerReceivers.RAILGUN.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.WEATHERCONTROLLER, PowerReceivers.WEATHERCONTROLLER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.REFRESHER, PowerReceivers.REFRESHER.getMinPower(), PowerReceivers.REFRESHER.getMinPower(), 1024);
        RotaryDescriptions.addNotes(MachineRegistry.CAVESCANNER, PowerReceivers.CAVESCANNER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.SCALECHEST, PowerReceivers.SCALECHEST.getMinPower(), PowerReceivers.SCALECHEST.getMinPower(), 128, 972);
        RotaryDescriptions.addNotes(MachineRegistry.IGNITER, PowerReceivers.IGNITER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.FREEZEGUN, PowerReceivers.FREEZEGUN.getMinPower(), PowerReceivers.FREEZEGUN.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.MAGNETIZER, PowerReceivers.MAGNETIZER.getMinPower(), PowerReceivers.MAGNETIZER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.CONTAINMENT, PowerReceivers.CONTAINMENT.getMinPower(), PowerReceivers.CONTAINMENT.getMinPower(), 8192, 524288, 0x200000);
        RotaryDescriptions.addNotes(MachineRegistry.SCREEN, PowerReceivers.SCREEN.getMinPower(), PowerReceivers.SCREEN.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.PURIFIER, PowerReceivers.PURIFIER.getMinPower(), PowerReceivers.PURIFIER.getMinTorque(), 600);
        RotaryDescriptions.addNotes(MachineRegistry.LASERGUN, PowerReceivers.LASERGUN.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.ITEMCANNON, PowerReceivers.ITEMCANNON.getMinPower(), PowerReceivers.ITEMCANNON.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.FRICTION, PowerReceivers.FRICTION.getMinPower(), PowerReceivers.FRICTION.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.BUCKETFILLER, PowerReceivers.BUCKETFILLER.getMinPower(), PowerReceivers.BUCKETFILLER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.BLOCKCANNON, PowerReceivers.BLOCKCANNON.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.COMPRESSOR, 1000);
        RotaryDescriptions.addNotes(MachineRegistry.LAMP, 12);
        RotaryDescriptions.addNotes(MachineRegistry.ECU, TileEntityEngineController.getSettingsAsString());
        RotaryDescriptions.addNotes(MachineRegistry.BLASTFURNACE, Float.valueOf(0.6f));
        RotaryDescriptions.addNotes(MachineRegistry.FUELENHANCER, PowerReceivers.FUELENHANCER.getMinPower(), PowerReceivers.FUELENHANCER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.ARROWGUN, PowerReceivers.ARROWGUN.getMinPower(), PowerReceivers.ARROWGUN.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.FERTILIZER, PowerReceivers.FERTILIZER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.AGGREGATOR, PowerReceivers.AGGREGATOR.getMinPower(), PowerReceivers.AGGREGATOR.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.FUELENGINE, 2048, 256, 524288);
        RotaryDescriptions.addNotes(MachineRegistry.AIRGUN, PowerReceivers.AIRGUN.getMinPower(), PowerReceivers.AIRGUN.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.SONICBORER, PowerReceivers.SONICBORER.getMinPower(), PowerReceivers.SONICBORER.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.FILLINGSTATION, PowerReceivers.FILLINGSTATION.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.SORTING, PowerReceivers.SORTING.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.DEFOLIATOR, PowerReceivers.DEFOLIATOR.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.BIGFURNACE, PowerReceivers.BIGFURNACE.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.DISTILLER, TileEntityDistillery.getValidConversions());
        RotaryDescriptions.addNotes(MachineRegistry.CRYSTALLIZER, PowerReceivers.CRYSTALLIZER.getMinPower(), PowerReceivers.CRYSTALLIZER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.GRINDSTONE, PowerReceivers.GRINDSTONE.getMinPower(), PowerReceivers.GRINDSTONE.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.BLOWER, PowerReceivers.BLOWER.getMinPower(), PowerReceivers.BLOWER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.REFRIGERATOR, PowerReceivers.REFRIGERATOR.getMinPower(), PowerReceivers.REFRIGERATOR.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.COMPOSTER, 40, 70);
        RotaryDescriptions.addNotes(MachineRegistry.GASTANK, PowerReceivers.GASTANK.getMinPower(), PowerReceivers.GASTANK.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.CRAFTER, PowerReceivers.CRAFTER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.ANTIAIR, PowerReceivers.ANTIAIR.getMinPower(), PowerReceivers.ANTIAIR.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.PIPEPUMP, PowerReceivers.PIPEPUMP.getMinPower(), PowerReceivers.PIPEPUMP.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.CENTRIFUGE, PowerReceivers.CENTRIFUGE.getMinPower(), PowerReceivers.CENTRIFUGE.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.WETTER, PowerReceivers.WETTER.getMinPower(), PowerReceivers.WETTER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.CHUNKLOADER, PowerReceivers.CHUNKLOADER.getMinSpeed(), 0, PowerReceivers.CHUNKLOADER.getMinSpeed(), 524288);
        RotaryDescriptions.addNotes(MachineRegistry.DROPS, PowerReceivers.DROPS.getMinPower(), PowerReceivers.DROPS.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.SPILLER, PowerReceivers.SPILLER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.FILLER, PowerReceivers.FILLER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.GATLING, PowerReceivers.GATLING.getMinPower(), PowerReceivers.GATLING.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.MAGNETIC, 500);
        RotaryDescriptions.addNotes(MachineRegistry.PNEUENGINE, 500);
        RotaryDescriptions.addNotes(MachineRegistry.ELECTRICMOTOR, 500);
        RotaryDescriptions.addNotes(MachineRegistry.STEAMTURBINE, 500);
        RotaryDescriptions.addNotes(MachineRegistry.EMP, 4184000000L);
        RotaryDescriptions.addSubNotes(MachineRegistry.MAGNETIC, 1, EnergyToPowerBase.getTiersAsString());
        RotaryDescriptions.addSubNotes(MachineRegistry.PNEUENGINE, 1, EnergyToPowerBase.getTiersAsString());
        RotaryDescriptions.addSubNotes(MachineRegistry.ELECTRICMOTOR, 1, EnergyToPowerBase.getTiersAsString());
        RotaryDescriptions.addSubNotes(MachineRegistry.STEAMTURBINE, 1, EnergyToPowerBase.getTiersAsString());
        RotaryDescriptions.addSubNotes(MachineRegistry.MAGNETIZER, 1, RecipesMagnetizer.getRecipes().getRecipesAsString());
        RotaryDescriptions.addSubNotes(MachineRegistry.ADVANCEDGEARS, 1, TileEntityAdvancedGear.getMaxStorageCapacity(false), TileEntityAdvancedGear.getMaxStorageCapacityFormatted(false), TileEntityAdvancedGear.getMaxStorageCapacity(true), TileEntityAdvancedGear.getMaxStorageCapacityFormatted(true));
        RotaryDescriptions.addSubNotes(MachineRegistry.ADVANCEDGEARS, 2, TileEntityAdvancedGear.getRequiredInputTorque(), TileEntityAdvancedGear.getRequiredInputPower());
        RotaryDescriptions.addSubNotes(MachineRegistry.ADVANCEDGEARS, 3, TileEntityAdvancedGear.getOutputCap(false), TileEntityAdvancedGear.getOutputCap(false), TileEntityAdvancedGear.getOutputCap(true), TileEntityAdvancedGear.getOutputCap(true), TileEntityAdvancedGear.getOutputFunction());
        RotaryDescriptions.addData(HandbookRegistry.TUNGSTEN, RecipesFrictionHeater.getRecipes().getRecipeByInput((ItemStack)ItemStacks.tungstenflakes).requiredTemperature);
        RotaryDescriptions.addData(HandbookRegistry.UPGRADES, ItemEngineUpgrade.Upgrades.getDescriptionList());
    }

    public static String getParentPage() {
        return PARENT;
    }

    static {
        RotaryDescriptions.loadNumericalData();
        MinecraftForge.EVENT_BUS.register((Object)new ReloadListener());
    }

    public static class ReloadListener {
        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void reload(ResourceReloadEvent evt) {
            RotaryDescriptions.reload();
        }
    }
}

