/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.ItemBasic;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.Flywheels;
import Reika.RotaryCraft.Registry.GearboxTypes;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.RotaryNames;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityACEngine;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBeltHub;
import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemMulti
extends ItemBasic {
    private int type;

    public ItemMulti(int par2type) {
        super(0);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.type = par2type;
        this.field_77777_bU = 64;
    }

    public ItemMulti(int par2type, int max) {
        super(0);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.type = par2type;
        this.field_77777_bU = max;
    }

    @Override
    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        if (super.func_77648_a(is, ep, world, x, y, z, s, a, b, c)) {
            return true;
        }
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, x, y, z);
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.compost)) {
            ItemDye.applyBonemeal((ItemStack)is, (World)world, (int)x, (int)y, (int)z, (EntityPlayer)ep);
        } else {
            if (this.isProperBelt(m, is)) {
                return this.tryBeltConnection(world, x, y, z, is, ep);
            }
            is.field_77990_d = null;
        }
        return false;
    }

    private boolean tryBeltConnection(World world, int x, int y, int z, ItemStack is, EntityPlayer ep) {
        TileEntityBeltHub te = (TileEntityBeltHub)world.func_147438_o(x, y, z);
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            new Coordinate((TileEntity)te).writeToNBT("end1", is.field_77990_d);
            return true;
        }
        Coordinate c1 = Coordinate.readFromNBT((String)"end1", (NBTTagCompound)is.field_77990_d);
        if (c1 == null) {
            ReikaChatHelper.writeString((String)"No valid other end found");
            return false;
        }
        TileEntity te0 = c1.getTileEntity((IBlockAccess)world);
        if (!(te0 instanceof TileEntityBeltHub)) {
            ReikaChatHelper.writeString((String)"Tile at other end is invalid");
            return false;
        }
        int dl = c1.getTaxicabDistanceTo((double)x, (double)y, (double)z) - 1;
        if (is.field_77994_a >= dl || ep.field_71075_bZ.field_75098_d) {
            is.field_77990_d = null;
            TileEntityBeltHub bb = (TileEntityBeltHub)te0;
            bb.resetOther();
            te.resetOther();
            bb.reset();
            te.reset();
            if (te.tryConnect(world, bb.field_145851_c, bb.field_145848_d, bb.field_145849_e) && bb.tryConnect(world, x, y, z)) {
                if (!ep.field_71075_bZ.field_75098_d) {
                    is.field_77994_a -= dl;
                }
                return true;
            }
            ReikaChatHelper.writeString((String)"Connection is invalid");
        }
        return false;
    }

    private boolean isProperBelt(MachineRegistry m, ItemStack is) {
        if ((m == MachineRegistry.BELT || m == MachineRegistry.SPLITBELT) && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.belt)) {
            return true;
        }
        return m == MachineRegistry.CHAIN && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.chain);
    }

    public void func_77663_a(ItemStack is, World world, Entity e, int par4, boolean par5) {
        if ((ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.shaftcore) || ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.tungstenshaftcore)) && is.field_77990_d != null) {
            int mag = is.field_77990_d.func_74762_e("magnet");
            if (mag > 0) {
                int x = (int)e.field_70165_t;
                int y = (int)e.field_70163_u;
                int z = (int)e.field_70161_v;
                for (int i = -6; i <= 6; ++i) {
                    for (int j = -6; j <= 6; ++j) {
                        for (int k = -6; k <= 6; ++k) {
                            if (!(world.func_147438_o(x + i, y + j, z + k) instanceof TileEntityACEngine)) continue;
                            TileEntityACEngine te = (TileEntityACEngine)world.func_147438_o(x + i, y + j, z + k);
                            double dx = (double)(x - te.field_145851_c) - 0.5;
                            double dy = (double)(y - te.field_145848_d) - 0.5;
                            double dz = (double)(z - te.field_145849_e) - 0.5;
                            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
                            double v = ReikaMathLibrary.py3d((double)e.field_70159_w, (double)e.field_70181_x, (double)e.field_70179_y);
                            te.magneticInterference(mag, dd);
                            te.soundtick = 1;
                        }
                    }
                }
            } else {
                is.field_77990_d.func_82580_o("magnet");
                if (is.field_77990_d.func_82582_d()) {
                    is.field_77990_d = null;
                }
            }
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List par3List, boolean par4) {
        if (is.field_77990_d == null) {
            return;
        }
        par3List.add("Additional Data Present.");
        if (is.field_77990_d.func_74764_b("magnet")) {
            if (is.field_77990_d.func_74762_e("magnet") >= 1000000) {
                par3List.add("Magnetized to " + String.format("%.3f", (double)is.field_77990_d.func_74762_e("magnet") / 1000000.0) + " T");
            } else if (is.field_77990_d.func_74762_e("magnet") >= 1000) {
                par3List.add("Magnetized to " + String.format("%.3f", (double)is.field_77990_d.func_74762_e("magnet") / 1000.0) + " mT");
            } else {
                par3List.add("Magnetized to " + is.field_77990_d.func_74762_e("magnet") + " microTeslas");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        int j;
        switch (ItemRegistry.getEntryByID(this)) {
            case SHAFTCRAFT: {
                j = RotaryNames.shaftPartNames.length;
                break;
            }
            case ENGINECRAFT: {
                j = RotaryNames.enginePartNames.length;
                break;
            }
            case MISCCRAFT: {
                j = RotaryNames.miscPartNames.length;
                break;
            }
            case BORECRAFT: {
                j = RotaryNames.borerPartNames.length;
                break;
            }
            case EXTRACTS: {
                j = RotaryNames.extractNames.length;
                break;
            }
            case COMPACTS: {
                j = RotaryNames.compactNames.length;
                break;
            }
            case ENGINE: {
                j = EngineType.engineList.length;
                break;
            }
            case POWDERS: {
                j = RotaryNames.powderNames.length;
                break;
            }
            case MODINTERFACE: {
                j = RotaryNames.interfaceNames.length;
                break;
            }
            case SHAFT: {
                j = MaterialRegistry.matList.length;
                break;
            }
            case GEARBOX: {
                j = 0;
                break;
            }
            case GEARCRAFT: {
                j = GearboxTypes.typeList.length * 16;
                break;
            }
            case FLYWHEELCRAFT: {
                j = Flywheels.list.length;
                break;
            }
            default: {
                j = 0;
            }
        }
        for (int i = 0; i < j; ++i) {
            String unloc;
            ItemStack item = new ItemStack(par1, 1, i);
            if (ItemRegistry.GEARCRAFT.matchItem(item) && (!GearboxTypes.getMaterialFromCraftingItem(item).isLoadable() || item.func_77960_j() % 16 >= GearboxTypes.GearPart.list.length || ReikaItemHelper.matchStacks((ItemStack)item, (ItemStack)GearboxTypes.WOOD.getPart(GearboxTypes.GearPart.SHAFT))) || ItemRegistry.SHAFTCRAFT.matchItem(item) && RotaryNames.shaftPartNames[item.func_77960_j()].isEmpty() || Strings.isNullOrEmpty((String)(unloc = this.func_77667_c(item))) || unloc.endsWith(".")) continue;
            par3List.add(item);
            if (!ReikaItemHelper.matchStacks((ItemStack)item, (ItemStack)ItemStacks.shaftcore) && !ReikaItemHelper.matchStacks((ItemStack)item, (ItemStack)ItemStacks.tungstenshaftcore)) continue;
            ItemStack mag = item.func_77946_l();
            if (DragonAPICore.isReikasComputer()) {
                mag.field_77990_d = new NBTTagCompound();
                mag.field_77990_d.func_74768_a("magnet", 32);
                par3List.add(mag);
                mag = item.func_77946_l();
                mag.field_77990_d = new NBTTagCompound();
                mag.field_77990_d.func_74768_a("magnet", 64000);
                par3List.add(mag);
                mag = item.func_77946_l();
            }
            mag.field_77990_d = new NBTTagCompound();
            mag.field_77990_d.func_74768_a("magnet", 0x1FFFFFFF);
            par3List.add(mag);
        }
    }

    public int func_77647_b(int damageValue) {
        return damageValue;
    }

    public String func_77667_c(ItemStack is) {
        int d = is.func_77960_j();
        String s = super.func_77658_a();
        try {
            switch (ItemRegistry.getEntryByID(this)) {
                case SHAFTCRAFT: {
                    s = super.func_77658_a() + "." + RotaryNames.shaftPartNames[d];
                    break;
                }
                case ENGINECRAFT: {
                    s = super.func_77658_a() + "." + RotaryNames.enginePartNames[d];
                    break;
                }
                case MISCCRAFT: {
                    s = super.func_77658_a() + "." + RotaryNames.miscPartNames[d];
                    break;
                }
                case BORECRAFT: {
                    s = super.func_77658_a() + "." + RotaryNames.borerPartNames[d];
                    break;
                }
                case EXTRACTS: {
                    s = super.func_77658_a() + "." + RotaryNames.extractNames[d];
                    break;
                }
                case COMPACTS: {
                    s = super.func_77658_a() + "." + RotaryNames.compactNames[d];
                    break;
                }
                case ENGINE: {
                    s = super.func_77658_a() + "." + RotaryNames.getEngineName(d);
                    break;
                }
                case POWDERS: {
                    s = super.func_77658_a() + "." + RotaryNames.powderNames[d];
                    break;
                }
                case SHAFT: {
                    s = MaterialRegistry.matList[d].getShaftUnlocName();
                    break;
                }
                case GEARBOX: {
                    break;
                }
                case MODINTERFACE: {
                    s = super.func_77658_a() + "." + RotaryNames.interfaceNames[d];
                    break;
                }
                case GEARCRAFT: {
                    s = super.func_77658_a() + "." + (Object)((Object)GearboxTypes.getMaterialFromCraftingItem(is)) + "." + (Object)((Object)GearboxTypes.GearPart.list[d % 16]);
                    break;
                }
            }
            return ReikaStringParser.stripSpaces((String)s.toLowerCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            return "Invalid item: " + e.toString();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getItemSpriteIndex(ItemStack item) {
        if (ItemRegistry.GEARCRAFT.matchItem(item)) {
            return item.func_77960_j();
        }
        if (ItemRegistry.FLYWHEELCRAFT.matchItem(item)) {
            return this.type + item.func_77960_j();
        }
        int row = this.type % 16 + item.func_77960_j() / 16;
        if (ItemRegistry.EXTRACTS.matchItem(item) && item.func_77960_j() > 31) {
            return 144 + item.func_77960_j() - 32;
        }
        if (ItemRegistry.ENGINECRAFT.matchItem(item) && item.func_77960_j() >= 16) {
            row += 9;
        }
        if (ItemRegistry.POWDERS.matchItem(item) && item.func_77960_j() >= 16) {
            row += 3;
        }
        return 16 * row + item.func_77960_j() % 16;
    }
}

