/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base;

import Reika.ChromatiCraft.API.ChromatiAPI;
import Reika.ChromatiCraft.API.Interfaces.EnchantableItem;
import Reika.ChromatiCraft.ChromaticEventManager;
import Reika.ChromatiCraft.Registry.ChromaEnchants;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Interfaces.Block.Reedlike;
import Reika.DragonAPI.Interfaces.Block.ShearablePlant;
import Reika.DragonAPI.Interfaces.Registry.CropType;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.BoPBlockHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.Base.ItemRotaryTool;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockShears;
import com.InfinityRaider.AgriCraft.api.v2.ICrop;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockReed;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public abstract class ItemSickleBase
extends ItemRotaryTool
implements EnchantableItem {
    private static final ArrayList<ScytheEffect> allEffects = new ArrayList();
    private static final BasicCropEffect crops = new BasicCropEffect(1.0f);
    private final BlockMap<ScytheEffect> effects = new BlockMap();

    public ItemSickleBase(int index) {
        super(index);
    }

    public final int func_77619_b() {
        ItemStack ref = this.getEnchantabilityReference();
        return ref != null ? ref.func_77973_b().getItemEnchantability(ref) : 0;
    }

    public abstract ItemStack getEnchantabilityReference();

    public final boolean onLeftClickEntity(ItemStack is, EntityPlayer ep, Entity e) {
        if (e instanceof EntityLivingBase) {
            EntityLivingBase elb = (EntityLivingBase)e;
            AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)e, (double)2.0).func_72314_b(2.0, 0.0, 2.0);
            List li = ep.field_70170_p.func_72872_a(EntityLivingBase.class, box);
            Class cat = ReikaEntityHelper.getEntityCategoryClass((EntityLivingBase)elb);
            for (EntityLivingBase e2 : li) {
                if (e2 == e || e2 == ep || ReikaEntityHelper.getEntityCategoryClass((EntityLivingBase)e2) != cat) continue;
                e2.func_70097_a(DamageSource.func_76365_a((EntityPlayer)ep), (float)this.damageVsEntity);
            }
            if (this.isBreakable()) {
                is.func_77972_a(10 * li.size(), (EntityLivingBase)ep);
            }
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        TileEntity te;
        ItemSickleBase sc = (ItemSickleBase)is.func_77973_b();
        if (ModList.AGRICRAFT.isLoaded() && !world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof ICrop) {
            int r = this.getCropRange();
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    double ch;
                    ICrop ic;
                    int dx = x + i;
                    int dz = z + k;
                    TileEntity te2 = world.func_147438_o(dx, y, dz);
                    if (!(te2 instanceof ICrop) || !(ic = (ICrop)te2).hasWeed()) continue;
                    ic.clearWeed();
                    ReikaSoundHelper.playBreakSound((World)world, (int)dx, (int)y, (int)dz, (Block)Blocks.field_150329_H);
                    double d = ch = this.isBreakable() ? 40.0 : 80.0;
                    if (!ReikaRandomHelper.doWithChance((double)ch)) continue;
                    this.dropItem(is, ep, world, (double)dx + 0.5, (double)y + 0.5, (double)dz + 0.5, ReikaItemHelper.tallgrass.asItemStack());
                }
            }
            int mined = crops.onBreakAt(world, x, y, z, te.func_145838_q(), te.func_145832_p(), ep, is, sc, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77346_s, (ItemStack)is), false);
            if (sc.isBreakable()) {
                is.func_77972_a(crops.doesDamagePerBlock(is, mined), (EntityLivingBase)ep);
            }
            return false;
        }
        if (!world.field_72995_K && this.tryApplyPlantShear(world, x, y, z, s, ep)) {
            if (sc.isBreakable()) {
                is.func_77972_a(1, (EntityLivingBase)ep);
            }
            return true;
        }
        return false;
    }

    private boolean tryApplyPlantShear(World world, int x, int y, int z, int side, EntityPlayer ep) {
        Block b;
        if (!ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z) && ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)x, (int)y, (int)z) != Material.field_151586_h && ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)x, (int)y, (int)z) != Material.field_151587_i) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if ((b = world.func_147439_a(x, y, z)) instanceof ShearablePlant) {
            if (ep.func_70093_af()) {
                int r = this.getPlantRange();
                for (int i = -r; i <= r; ++i) {
                    for (int j = -r; j <= r; ++j) {
                        for (int k = -r; k <= r; ++k) {
                            int dx = x + i;
                            int dy = y + j;
                            int dz = z + k;
                            if (world.func_147439_a(dx, dy, dz) != b) continue;
                            ((ShearablePlant)b).shearAll(world, dx, dy, dz, ep);
                        }
                    }
                }
            } else {
                ((ShearablePlant)b).shearSide(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), ep);
            }
            ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)b);
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack is, int x, int y, int z, EntityPlayer ep) {
        World world = ep.field_70170_p;
        Block id = world.func_147439_a(x, y, z);
        if (id instanceof BlockTieredResource) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        ScytheEffect eff = this.getEffect(world, x, y, z, id, meta, ForgeDirection.UNKNOWN);
        if (world.field_72995_K) {
            return eff != null;
        }
        if (eff != null) {
            int num = eff.onBreakAt(world, x, y, z, id, meta, ep, is, this, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77346_s, (ItemStack)is), ep.func_70093_af());
            if (this.isBreakable()) {
                int dmg = eff.doesDamagePerBlock(is, num);
                is.func_77972_a(dmg, (EntityLivingBase)ep);
            }
            return true;
        }
        return false;
    }

    private ScytheEffect getEffect(World world, int x, int y, int z, Block id, int meta, ForgeDirection side) {
        ScytheEffect get = (ScytheEffect)this.effects.get(id, meta);
        if (get != null) {
            return get;
        }
        for (ScytheEffect e : allEffects) {
            if (!e.isValidStartingBlock(world, x, y, z, id, meta, side)) continue;
            this.effects.put(id, meta, (Object)e);
            return e;
        }
        return null;
    }

    private void dropItems(ItemStack tool, EntityPlayer ep, World world, double x, double y, double z, ArrayList<ItemStack> drops) {
        if (ModList.CHROMATICRAFT.isLoaded() && this.isAutoCollect(tool)) {
            for (ItemStack is : drops) {
                this.handleItem(is, ep);
            }
        } else {
            ReikaItemHelper.dropItems((World)world, (double)x, (double)y, (double)z, drops);
        }
    }

    private void dropBlockAsItem(ItemStack tool, EntityPlayer ep, Block b2, World world, int x, int y, int z, int meta2, int fortune) {
        if (ModList.CHROMATICRAFT.isLoaded() && this.isAutoCollect(tool)) {
            this.setItemCollection(ep);
        }
        b2.func_149697_b(world, x, y, z, meta2, fortune);
    }

    private void dropItem(ItemStack tool, EntityPlayer ep, World world, double x, double y, double z, ItemStack drop) {
        if (ModList.CHROMATICRAFT.isLoaded() && this.isAutoCollect(tool)) {
            this.handleItem(drop, ep);
        } else {
            ReikaItemHelper.dropItem((World)world, (double)x, (double)y, (double)z, (ItemStack)drop);
        }
    }

    private void handleItem(ItemStack drop, EntityPlayer ep) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new EntityItemPickupEvent(ep, new EntityItem(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, drop)))) {
            ReikaPlayerAPI.addOrDropItem((ItemStack)drop, (EntityPlayer)ep);
        }
    }

    public abstract int getLeafRange();

    public abstract int getPlantRange();

    public abstract int getCropRange();

    public abstract boolean canActAsShears();

    public abstract boolean isBreakable();

    @DependentMethodStripper.ModDependent(value={ModList.CHROMATICRAFT})
    public final Event.Result getEnchantValidity(Enchantment e, ItemStack is) {
        if (is.func_77973_b() == this) {
            if (e == Enchantment.field_77346_s || e == Enchantment.field_77349_p || e == Enchantment.field_77347_r) {
                return Event.Result.ALLOW;
            }
            if (e == ChromaEnchants.AIRMINER.getEnchantment() || e == ChromaEnchants.AUTOCOLLECT.getEnchantment()) {
                return Event.Result.ALLOW;
            }
        }
        return Event.Result.DEFAULT;
    }

    @DependentMethodStripper.ModDependent(value={ModList.CHROMATICRAFT})
    private boolean isAutoCollect(ItemStack tool) {
        return ChromaEnchants.AUTOCOLLECT.getLevel(tool) > 0;
    }

    @DependentMethodStripper.ModDependent(value={ModList.CHROMATICRAFT})
    private void setItemCollection(EntityPlayer ep) {
        ChromaticEventManager.instance.collectItemPlayer = ep;
    }

    public final EnumEnchantmentType getEnchantingCategory() {
        return EnumEnchantmentType.digger;
    }

    static {
        allEffects.add(new BasicPlantEffect(1.0f));
        allEffects.add(new SugarcaneEffect(0.5f));
        allEffects.add(new BasicLeafEffect(1.0f, 1.0f));
        allEffects.add(crops);
        allEffects.add(new IPlantableEffect(1.0f));
        if (ModList.CHROMATICRAFT.isLoaded()) {
            allEffects.add(new DyeLeafEffect(1.0f));
            allEffects.add(new RainbowLeafEffect(1.0f));
            allEffects.add(new DyeFlowerEffect(1.0f));
            allEffects.add(new DecoFlowerEffect(1.0f));
        }
        if (ModList.BOP.isLoaded()) {
            allEffects.add(new BopFlowerEffect(1.0f));
            allEffects.add(new BopCoralEffect(1.0f));
            allEffects.add(new BopFoliageEffect(1.0f));
        }
        if (Loader.isModLoaded((String)"Growthcraft|Apples")) {
            allEffects.add(new AppleEffect(1.0f));
        }
        Collections.sort(allEffects);
    }

    private static class BopFoliageEffect
    extends BlockMatchEffect {
        protected BopFoliageEffect(float r) {
            super(r, r);
        }

        @Override
        protected boolean matchBlock(Block b) {
            return BoPBlockHandler.getInstance().foliage == b;
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getPlantRange();
        }

        @Override
        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return true;
        }
    }

    private static class BopCoralEffect
    extends BlockMatchEffect {
        protected BopCoralEffect(float r) {
            super(r, r);
        }

        @Override
        protected boolean matchBlock(Block b) {
            return BoPBlockHandler.getInstance().isCoral(b);
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getPlantRange();
        }

        @Override
        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return true;
        }
    }

    private static class BopFlowerEffect
    extends BlockMatchEffect {
        protected BopFlowerEffect(float r) {
            super(r, r);
        }

        @Override
        protected boolean matchBlock(Block b) {
            return BoPBlockHandler.getInstance().isFlower(b);
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getPlantRange();
        }

        @Override
        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return true;
        }
    }

    private static class DyeFlowerEffect
    extends BlockMatchEffect {
        protected DyeFlowerEffect(float r) {
            super(r, r);
        }

        @Override
        protected boolean matchBlock(Block b) {
            return ChromatiAPI.getAPI().trees().getDyeFlower() == b;
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getPlantRange();
        }

        @Override
        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return true;
        }
    }

    private static abstract class BlockMatchEffect
    extends MineSimilarEffect {
        protected BlockMatchEffect(float rx, float ry) {
            super(null, rx, ry);
        }

        @Override
        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            return this.matchBlock(b);
        }

        @Override
        protected final boolean matchesBlock(Block src, int srcmeta, Block b, int meta, boolean ignoreMeta) {
            return this.matchBlock(b) && (ignoreMeta || meta == srcmeta);
        }

        protected abstract boolean matchBlock(Block var1);
    }

    private static class AppleEffect
    extends MineSimilarEffect {
        protected AppleEffect(float r) {
            super(null, r, r / 5.0f);
        }

        @Override
        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            return this.matchesBlock(b, meta, b, meta, false);
        }

        @Override
        protected boolean matchesBlock(Block src, int srcmeta, Block b, int meta, boolean ignoreMeta) {
            if (meta < 2) {
                return false;
            }
            String n = b.getClass().getName().toLowerCase(Locale.ENGLISH);
            return n.startsWith("growthcraft.apples") && n.endsWith("apple");
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getCropRange();
        }

        @Override
        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return false;
        }
    }

    private static class DecoFlowerEffect
    extends MineSimilarEffect {
        protected DecoFlowerEffect(float r) {
            super(null, r, r);
        }

        @Override
        protected boolean matchesBlock(Block src, int srcmeta, Block b, int meta, boolean ignoreMeta) {
            return b == ChromatiAPI.getAPI().trees().getDecoFlower() && srcmeta == meta;
        }

        @Override
        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            return b == ChromatiAPI.getAPI().trees().getDecoFlower();
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getPlantRange();
        }

        @Override
        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return true;
        }
    }

    private static class RainbowLeafEffect
    extends MineSimilarEffect {
        protected RainbowLeafEffect(float r) {
            super(null, r, r);
        }

        @Override
        protected boolean matchesBlock(Block src, int srcmeta, Block b, int meta, boolean ignoreMeta) {
            return b == ChromatiAPI.getAPI().trees().getRainbowLeaf();
        }

        @Override
        protected int doesDamagePerBlock(ItemStack is, int mined) {
            return Math.max(1, mined / 9);
        }

        @Override
        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            return b == ChromatiAPI.getAPI().trees().getRainbowLeaf();
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getLeafRange();
        }

        @Override
        protected boolean collateItems() {
            return true;
        }
    }

    private static class DyeLeafEffect
    extends MineSimilarEffect {
        protected DyeLeafEffect(float r) {
            super(null, r, r);
        }

        @Override
        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            return b == ChromatiAPI.getAPI().trees().getDyeLeaf(true) || b == ChromatiAPI.getAPI().trees().getDyeLeaf(false);
        }

        @Override
        protected boolean matchesBlock(Block src, int srcmeta, Block b, int meta, boolean ignoreMeta) {
            return (b == ChromatiAPI.getAPI().trees().getDyeLeaf(false) || b == ChromatiAPI.getAPI().trees().getDyeLeaf(true)) && srcmeta == meta;
        }

        @Override
        protected int doesDamagePerBlock(ItemStack is, int mined) {
            return Math.max(1, mined / 12);
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getLeafRange();
        }
    }

    private static class BasicCropEffect
    extends MineSimilarEffect {
        protected BasicCropEffect(float r) {
            super(null, r, r / 3.0f);
        }

        @Override
        protected boolean matchesBlock(Block src, int srcmeta, World world, int x, int y, int z, Block b2, int meta2, boolean ignoreMeta) {
            CropType c = this.getCrop(b2, meta2);
            return this.getCrop(src, srcmeta) == c && c.isRipe(world, x, y, z);
        }

        @Override
        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            CropType c = this.getCrop(b, meta);
            return c != null && c.isRipe(world, x, y, z);
        }

        private CropType getCrop(Block b, int meta) {
            ReikaCropHelper t = ReikaCropHelper.getCrop((Block)b);
            if (t == null) {
                t = ModCropList.getModCrop((Block)b, (int)meta);
            }
            return t;
        }

        @Override
        protected int doesDamagePerBlock(ItemStack is, int mined) {
            return Math.max(1, mined / 2);
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getCropRange();
        }

        @Override
        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return false;
        }

        @Override
        protected void doDrops(World world, int x, int y, int z, Block b, int meta, EntityPlayer ep, ItemStack is, ItemSickleBase item, int fortune) {
            CropType c = this.getCrop(b, meta);
            ArrayList li = c.getDrops(world, x, y, z, fortune);
            if (!c.destroyOnHarvest()) {
                CropType.CropMethods.removeOneSeed((CropType)c, (ArrayList)li);
            }
            item.dropItems(is, ep, world, x, y, z, li);
        }

        @Override
        protected void breakAt(World world, int x, int y, int z, Block b, int meta) {
            CropType c = this.getCrop(b, meta);
            if (c.destroyOnHarvest()) {
                super.breakAt(world, x, y, z, b, meta);
            } else {
                c.setHarvested(world, x, y, z);
            }
        }
    }

    private static class BasicLeafEffect
    extends MineSimilarEffect {
        protected BasicLeafEffect(float rx, float ry) {
            super(null, rx, ry);
        }

        @Override
        protected boolean matchesBlock(Block src, int srcmeta, Block b, int meta, boolean ignoreMeta) {
            return this.getTree(src, srcmeta) == this.getTree(b, meta);
        }

        @Override
        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            return this.getTree(b, meta) != null;
        }

        private TreeType getTree(Block b, int meta) {
            ReikaTreeHelper t = ReikaTreeHelper.getTreeFromLeaf((Block)b, (int)meta);
            if (t == null) {
                t = ModWoodList.getModWoodFromLeaf((Block)b, (int)meta);
            }
            return t;
        }

        @Override
        protected int doesDamagePerBlock(ItemStack is, int mined) {
            return Math.max(1, mined / 12);
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getLeafRange();
        }

        @Override
        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return false;
        }
    }

    private static class SugarcaneEffect
    extends MineSimilarEffect {
        protected SugarcaneEffect(float r) {
            super(null, r, r);
        }

        @Override
        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            return (b instanceof BlockReed || b instanceof Reedlike) && world.func_147439_a(x, y - 1, z) == b;
        }

        @Override
        protected boolean matchesBlock(Block src, int srcmeta, World world, int x, int y, int z, Block b2, int meta2, boolean ignoreMeta) {
            return super.matchesBlock(src, srcmeta, world, x, y, z, b2, meta2, true) && world.func_147439_a(x, y - 1, z) == src;
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getCropRange();
        }

        @Override
        protected int doesDamagePerBlock(ItemStack is, int mined) {
            return Math.max(1, mined / 2);
        }
    }

    private static class BasicPlantEffect
    extends MineSimilarEffect {
        protected BasicPlantEffect(float r) {
            super(null, r, r);
        }

        @Override
        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            ReikaPlantHelper plant = ReikaPlantHelper.getPlant((Block)b);
            return plant != null && plant != ReikaPlantHelper.CROP && plant != ReikaPlantHelper.SUGARCANE;
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getPlantRange();
        }

        @Override
        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return ReikaPlantHelper.getPlant((Block)b) != ReikaPlantHelper.NETHERWART;
        }

        @Override
        protected boolean matchesBlock(Block src, int srcmeta, Block b, int meta, boolean ignoreMeta) {
            return super.matchesBlock(src, srcmeta, b, meta, ignoreMeta || !this.needsMeta(ReikaPlantHelper.getPlant((Block)b)));
        }

        private boolean needsMeta(ReikaPlantHelper p) {
            if (p == null) {
                return true;
            }
            switch (p) {
                case CACTUS: 
                case LILYPAD: 
                case VINES: {
                    return false;
                }
            }
            return true;
        }
    }

    private static class IPlantableEffect
    extends MineSimilarEffect {
        protected IPlantableEffect(float r) {
            super(null, r, r);
        }

        @Override
        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            return b instanceof IPlantable;
        }

        @Override
        protected int getRange(ItemStack is, ItemSickleBase item) {
            return item.getPlantRange();
        }

        @Override
        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return true;
        }

        @Override
        protected int getPriority() {
            return Integer.MAX_VALUE;
        }
    }

    private static abstract class MineSimilarEffect
    extends ScytheEffect {
        protected MineSimilarEffect(BlockKey bk, float rx, float ry) {
            super(bk, rx, ry);
        }

        protected boolean matchesBlock(Block src, int srcmeta, World world, int x, int y, int z, Block b2, int meta2, boolean ignoreMeta) {
            return this.matchesBlock(src, srcmeta, b2, meta2, ignoreMeta);
        }

        protected boolean matchesBlock(Block src, int srcmeta, Block b, int meta, boolean ignoreMeta) {
            return b == src && (ignoreMeta || srcmeta == meta);
        }

        @Override
        protected final int onBreakAt(World world, int x, int y, int z, Block b, int meta, EntityPlayer ep, ItemStack is, ItemSickleBase item, int fortune, boolean ignoreMeta) {
            int ret = 0;
            int r = this.getRange(is, item);
            int rx = MathHelper.func_76141_d((float)(this.rangeXZ * (float)r));
            int ry = MathHelper.func_76141_d((float)(this.rangeY * (float)r));
            for (int i = -rx; i <= rx; ++i) {
                for (int j = -ry; j <= ry; ++j) {
                    for (int k = -rx; k <= rx; ++k) {
                        int meta2;
                        int dx = x + i;
                        int dy = y + j;
                        int dz = z + k;
                        Block id2 = world.func_147439_a(dx, dy, dz);
                        if (!this.matchesBlock(b, meta, world, dx, dy, dz, id2, meta2 = world.func_72805_g(dx, dy, dz), ignoreMeta)) continue;
                        this.doDrops(world, dx, dy, dz, id2, meta2, ep, is, item, fortune);
                        ReikaSoundHelper.playBreakSound((World)world, (int)dx, (int)dy, (int)dz, (Block)id2);
                        this.breakAt(world, dx, dy, dz, id2, meta2);
                        ++ret;
                    }
                }
            }
            return ret;
        }

        protected void doDrops(World world, int dx, int dy, int dz, Block id2, int meta2, EntityPlayer ep, ItemStack is, ItemSickleBase item, int fortune) {
            ArrayList items = new ArrayList();
            if (this.collateItems()) {
                ReikaItemHelper.addToList(items, (ArrayList)id2.getDrops(world, dx, dy, dz, meta2, fortune));
            } else if (this.allowShearing(world, dx, dy, dz, id2, meta2) && item.canActAsShears() && ItemBedrockShears.getHarvestResult(id2, meta2, ep, world, dx, dy, dz) == Event.Result.ALLOW) {
                if (id2 instanceof IShearable) {
                    ArrayList li = ((IShearable)id2).onSheared(is, (IBlockAccess)world, dx, dy, dz, fortune);
                    item.dropItems(is, ep, world, (double)dx + field_77697_d.nextDouble(), (double)dy + field_77697_d.nextDouble(), (double)dz + field_77697_d.nextDouble(), li);
                } else {
                    item.dropItem(is, ep, world, (double)dx + 0.5, (double)dy + 0.5, (double)dz + 0.5, new ItemStack(id2, 1, ItemBedrockShears.getDroppedMeta(id2, meta2)));
                }
            } else {
                item.dropBlockAsItem(is, ep, id2, world, dx, dy, dz, meta2, fortune);
            }
            if (!items.isEmpty()) {
                item.dropItems(is, ep, world, dx, dy, dz, items);
            }
        }

        protected void breakAt(World world, int x, int y, int z, Block b, int meta) {
            world.func_147468_f(x, y, z);
        }

        protected boolean allowShearing(World world, int x, int y, int z, Block b, int meta) {
            return false;
        }

        protected boolean collateItems() {
            return false;
        }
    }

    private static abstract class ScytheEffect
    implements Comparable<ScytheEffect> {
        protected final BlockKey block;
        protected final float rangeXZ;
        protected final float rangeY;

        protected ScytheEffect(BlockKey bk, float rx, float ry) {
            this.block = bk;
            this.rangeXZ = rx;
            this.rangeY = ry;
        }

        protected abstract int getRange(ItemStack var1, ItemSickleBase var2);

        protected boolean isValidStartingBlock(World world, int x, int y, int z, Block b, int meta, ForgeDirection side) {
            return this.block.match(b, meta);
        }

        protected abstract int onBreakAt(World var1, int var2, int var3, int var4, Block var5, int var6, EntityPlayer var7, ItemStack var8, ItemSickleBase var9, int var10, boolean var11);

        protected int doesDamagePerBlock(ItemStack is, int mined) {
            return 1;
        }

        protected int getPriority() {
            return 0;
        }

        @Override
        public final int compareTo(ScytheEffect e) {
            return Integer.compare(this.getPriority(), e.getPriority());
        }
    }
}

