/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base;

import Reika.DragonAPI.Instantiable.Rendering.LODModelPart;
import Reika.DragonAPI.Interfaces.TileModel;
import Reika.RotaryCraft.RotaryCraft;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;

public abstract class RotaryModelBase
extends ModelBase
implements TileModel {
    public static boolean allowRendering = true;
    protected final float f5 = 0.0625f;
    protected int pass;
    private boolean canBeCompiled = LODModelPart.allowCompiling && this.calcDefaultCompilability();
    private final ArrayList<LODModelPart> renderGroups = new ArrayList();

    public abstract void renderAll(TileEntity var1, ArrayList var2, float var3, float var4);

    private boolean calcDefaultCompilability() {
        String n = ((Object)((Object)this)).getClass().getName();
        return !n.contains("Animated") && !n.contains("Engine") && !n.contains("Turret");
    }

    public void setRenderPass() {
        this.pass = MinecraftForgeClient.getRenderPass();
    }

    public void setCompilable(boolean flag) {
        this.canBeCompiled = LODModelPart.allowCompiling && flag;
    }

    public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f6) {
    }

    public final void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f6) {
    }

    public final void renderAll(TileEntity te, ArrayList conditions) {
        this.renderAll(te, conditions, 0.0f);
    }

    public final void renderAll(TileEntity te, ArrayList conditions, float phi) {
        if (!allowRendering) {
            return;
        }
        if (this.canBeCompiled && phi == 0.0f && !GuiScreen.func_146271_m() && (conditions == null || conditions.isEmpty())) {
            this.renderList(te);
        } else {
            this.renderAll(te, conditions, phi, 0.0f);
        }
    }

    protected final void setRotation(LODModelPart model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
        if (this.canBeCompiled) {
            if (this.renderGroups.isEmpty()) {
                this.setNewRenderingGroup();
            }
            LODModelPart group = this.renderGroups.get(this.renderGroups.size() - 1);
            group.func_78787_b((int)model.field_78801_a, (int)model.field_78799_b);
            group.field_78809_i = false;
            model.field_78809_i = false;
            group.addBox(model);
        }
    }

    protected final void renderList(TileEntity te) {
        if (!LODModelPart.allowCompiling) {
            RotaryCraft.logger.logError((Object)("Attempt to call compiled model for tile " + te + " without compiling enabled!"));
        }
        for (LODModelPart part : this.renderGroups) {
            part.render(te, 0.0625f);
        }
    }

    protected final void renderSubList(TileEntity te, int idx) {
        this.renderGroups.get(idx).render(te, 0.0625f);
    }

    protected final int setNewRenderingGroup() {
        this.renderGroups.add(new LODModelPart((ModelBase)this, 0, 0));
        return this.renderGroups.size() - 1;
    }
}

