/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.ParallelTicker;
import Reika.DragonAPI.Interfaces.TileEntity.PartialInventory;
import Reika.DragonAPI.Interfaces.TileEntity.PartialTank;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaTimeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.AtmosphereHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.IntegratedGearboxable;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.TileEntityInventoryIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Items.Tools.ItemIntegratedGearbox;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityEngineController;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityHydroEngine;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public abstract class TileEntityEngine
extends TileEntityInventoryIOMachine
implements TemperatureTE,
SimpleProvider,
PipeConnector,
PowerGenerator,
IFluidHandler,
PartialInventory,
PartialTank,
IntegratedGearboxable,
IPipeConnection {
    public static final int CAPACITY = 60000;
    public static final int FUELCAP = 240000;
    public static final int LUBECAP = 24000;
    protected final HybridTank lubricant = new HybridTank("enginelube", 24000);
    protected final HybridTank water = new HybridTank("enginewater", 60000);
    protected final HybridTank fuel = new HybridTank("enginefuel", 240000);
    protected final HybridTank air = new HybridTank("engineair", 1000);
    public int temperature;
    public int soundtick = 2000;
    protected EngineType type = EngineType.DC;
    protected int backx;
    protected int backz;
    private boolean isOn;
    private boolean hasO2Boost;
    protected long lastpower = 0L;
    private int integratedGear = 0;
    protected ParallelTicker timer = new ParallelTicker().addTicker("fuel").addTicker("sound").addTicker("temperature", ReikaTimeHelper.SECOND.getDuration());

    @Override
    public int getMaxTemperature() {
        return 1000;
    }

    public final EngineType getEngineType() {
        return this.type != null ? this.type : EngineType.DC;
    }

    public final void setType(ItemStack is) {
        if (ItemRegistry.ENGINE.matchItem(is)) {
            this.type = EngineType.engineList[is.func_77960_j()];
        }
    }

    public final int func_70297_j_() {
        return this.type.allowInventoryStacking() ? 64 : 1;
    }

    public final int func_70302_i_() {
        return 2;
    }

    public boolean hasTemperature() {
        return this.type.isCooled();
    }

    @Override
    public final boolean func_70300_a(EntityPlayer ep) {
        return this.type.hasGui() && super.func_70300_a(ep);
    }

    public final int getWaterScaled(int par1) {
        return this.water.getLevel() * par1 / 60000;
    }

    public final int getTempScaled(int par1) {
        return this.temperature * par1 / this.getMaxTemperature();
    }

    public final int getFuelScaled(int par1) {
        return this.getFuelLevel() * par1 / 240000;
    }

    protected abstract void consumeFuel(float var1);

    protected int getConsumedFuel() {
        return 10;
    }

    protected abstract void internalizeFuel();

    protected abstract boolean getRequirements(World var1, int var2, int var3, int var4, int var5);

    protected final boolean hasAir(World world, int x, int y, int z) {
        if (this.isDrowned(world, x, y, z)) {
            return false;
        }
        return !AtmosphereHandler.isNoAtmo((World)world, (int)(x - this.getWriteDirection().offsetX), (int)y, (int)(z - this.getWriteDirection().offsetZ), (Block)this.field_145854_h, (boolean)true);
    }

    public boolean hasAir() {
        return !this.air.isEmpty() || this.hasAir(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public final boolean isDrowned(World world, int x, int y, int z) {
        boolean flag = false;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block id = world.func_147439_a(dx, dy, dz);
            boolean fluid = id instanceof BlockLiquid || id instanceof BlockFluidBase;
            boolean bl = flag = flag || fluid;
            if (id == Blocks.field_150350_a) {
                return false;
            }
            if (fluid || !ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) continue;
            return false;
        }
        return flag;
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        this.temperature = Math.max(this.temperature, Tamb);
        if (this.temperature > Tamb && !this.isOn) {
            this.offlineCooldown(world, x, y, z, Tamb);
        }
    }

    protected void offlineCooldown(World world, int x, int y, int z, int Tamb) {
        this.temperature -= Math.max(1, (this.temperature - Tamb) / 256);
    }

    public final boolean isOn() {
        return this.isOn;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    private void setPowerData(World world, int x, int y, int z, int meta) {
        int speed;
        this.updateSpeed(speed, (speed = TileEntityEngine.getIntegratedGearSpeed(this.getMaxSpeed(world, x, y, z, meta), this.integratedGear)) >= this.omega && (this.omega > 0 || this.canStart()));
        this.torque = TileEntityEngine.getIntegratedGearTorque(this.getGenTorque(world, x, y, z, meta), this.integratedGear);
    }

    static int getIntegratedGearTorque(int torque, int gear) {
        if (gear != 0) {
            return gear > 0 ? gear * torque : -torque / gear;
        }
        return torque;
    }

    static int getIntegratedGearSpeed(int speed, int gear) {
        if (gear != 0) {
            return gear < 0 ? -gear * speed : speed / gear;
        }
        return speed;
    }

    protected boolean canStart() {
        return true;
    }

    protected int getMaxSpeed(World world, int x, int y, int z, int meta) {
        return this.type.getSpeed();
    }

    protected int getGenTorque(World world, int x, int y, int z, int meta) {
        return this.type.getTorque();
    }

    protected abstract void affectSurroundings(World var1, int var2, int var3, int var4, int var5);

    protected final int getSoundLength() {
        return this.getSoundLength(1.0f);
    }

    protected int getSoundLength(float factor) {
        if (factor == 2.5f && this.type.carNoise()) {
            factor = 1.81f;
        }
        if (factor == 2.5f && this.type.turbineNoise()) {
            factor = 2.0f;
        }
        if (this.type.jetNoise()) {
            factor += 0.0125f;
        }
        return (int)((float)this.type.getSoundLength() * factor);
    }

    private void initialize(World world, int x, int y, int z, int meta) {
        this.timer.setCap("sound", this.getSoundLength());
        if (this.timer.checkCap("temperature")) {
            this.updateTemperature(world, x, y, z, meta);
        }
        boolean on = this.type.isAirBreathing() ? this.hasAir(world, x, y, z) : true;
        this.hasO2Boost = false;
        if (!this.air.isEmpty() && this.type.isAirBreathing()) {
            on = true;
            this.hasO2Boost = true;
        }
        if (on && this.getRequirements(world, x, y, z, meta)) {
            this.isOn = true;
            this.setPowerData(world, x, y, z, meta);
        } else {
            this.isOn = false;
            this.updateSpeed(0, false);
            if (this.omega == 0) {
                this.torque = 0;
            }
            if (this.soundtick == 0 && this.omega == 0) {
                this.soundtick = 2000;
            }
        }
    }

    private void updateSpeed(int maxspeed, boolean revup) {
        if (this.hasECU() && this.canBeThrottled()) {
            TileEntityEngineController te = this.getECU();
            if (te != null) {
                maxspeed = (int)((float)maxspeed * te.getSpeedMultiplier());
            }
            if (this.omega > maxspeed) {
                revup = false;
            }
        }
        if (revup) {
            if (this.omega < maxspeed) {
                this.omega = (int)((double)this.omega + 4.0 * ReikaMathLibrary.logbase((long)(maxspeed + 1), (int)2));
                this.timer.setCap("fuel", Math.max(this.type.getFuelUnitDuration() / 4, 1));
                if (this.omega > maxspeed) {
                    this.omega = maxspeed;
                }
            }
        } else if (this.omega > 0) {
            this.omega -= this.omega / 256 + 1;
        }
    }

    private boolean hasECU() {
        return this.getMachine(this.isFlipped ? ForgeDirection.UP : ForgeDirection.DOWN) == MachineRegistry.ECU;
    }

    private TileEntityEngineController getECU() {
        return (TileEntityEngineController)this.getAdjacentTileEntity(this.isFlipped ? ForgeDirection.UP : ForgeDirection.DOWN);
    }

    protected abstract void playSounds(World var1, int var2, int var3, int var4, float var5, float var6);

    protected final boolean isMuffled(World world, int x, int y, int z) {
        if ((RotaryAux.isMufflingBlock(world, x, y + 1, z) || this.getMachine(ForgeDirection.UP) == MachineRegistry.ECU) && (RotaryAux.isMufflingBlock(world, x, y - 1, z) || this.getMachine(ForgeDirection.DOWN) == MachineRegistry.ECU)) {
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            if (dir == ForgeDirection.DOWN) continue;
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if ((dir == this.write.getOpposite() || dir == this.write) && dir != ForgeDirection.UP || RotaryAux.isMufflingBlock(world, dx, dy, dz)) continue;
            return false;
        }
        return true;
    }

    public final void updateEntity(World world, int x, int y, int z, int meta) {
        TileEntityEngineController te;
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.timer.updateTicker("temperature");
        if (this.isShutdown()) {
            this.torque = 0;
            this.omega = 0;
            this.power = 0L;
        } else {
            if (!this.field_145850_b.field_72995_K || RotaryAux.getPowerOnClient) {
                this.timer.setCap("fuel", this.type.getFuelUnitDuration());
                this.initialize(world, x, y, z, meta);
            }
            this.power = (long)this.torque * (long)this.omega;
            if (this.power > 0L) {
                this.affectSurroundings(world, x, y, z, meta);
            }
        }
        float pitch = 1.0f;
        float soundfactor = 1.0f;
        if (this.type.isECUControllable() && this.hasECU() && (te = this.getECU()) != null) {
            if (te.canProducePower()) {
                if (this.canBeThrottled()) {
                    int fueltime = this.type.getFuelUnitDuration();
                    if ((float)this.omega >= (float)this.type.getSpeed() * te.getSpeedMultiplier()) {
                        int n = (int)((float)this.type.getSpeed() * te.getSpeedMultiplier());
                    } else {
                        fueltime = Math.max(this.type.getFuelUnitDuration() / 4, 1);
                    }
                    this.timer.setCap("fuel", fueltime);
                    int fuelcap = this.timer.getCapOf("fuel");
                    this.timer.setCap("fuel", fuelcap *= te.getFuelMultiplier(this.type.type));
                    pitch = te.getSoundStretch();
                    soundfactor = 1.0f / te.getSoundStretch();
                    int soundcap = this.timer.getCapOf("sound");
                    soundcap = (int)((float)soundcap * soundfactor);
                    this.timer.setCap("sound", soundcap);
                    int tempcap = this.timer.getCapOf("temperature");
                    tempcap = (int)((float)tempcap * soundfactor);
                    this.timer.setCap("temperature", tempcap);
                }
            } else {
                this.resetPower();
                this.soundtick = 0;
            }
        }
        this.basicPowerReceiver();
        this.internalizeFuel();
        if (this.power > 0L) {
            if (this.hasO2Boost) {
                this.air.removeLiquid(1);
            }
            this.timer.updateTicker("fuel");
            if (this.type.burnsFuel() && this.timer.checkCap("fuel") && this.canConsumeFuel()) {
                this.consumeFuel(this.hasO2Boost ? 0.8f : 1.0f);
            }
        }
        if (this.power > 0L) {
            this.playSounds(world, x, y, z, pitch, 1.0f);
        } else if (this.soundtick < this.getSoundLength(soundfactor)) {
            this.soundtick = 2000;
        }
        this.lastpower = this.power;
    }

    protected void resetPower() {
        if (this.omega == 0) {
            this.torque = 0;
        }
        this.power = (long)this.omega * (long)this.torque;
        this.soundtick = 2000;
        this.lastpower = this.power;
    }

    protected boolean canConsumeFuel() {
        return this.getFuelLevel() > 0;
    }

    protected boolean canBeThrottled() {
        return true;
    }

    public final void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.write = ForgeDirection.WEST;
                this.backx = x + 1;
                this.backz = z;
                break;
            }
            case 1: {
                this.write = ForgeDirection.EAST;
                this.backx = x - 1;
                this.backz = z;
                break;
            }
            case 2: {
                this.write = ForgeDirection.NORTH;
                this.backx = x;
                this.backz = z + 1;
                break;
            }
            case 3: {
                this.write = ForgeDirection.SOUTH;
                this.backx = x;
                this.backz = z - 1;
            }
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("type", this.type.ordinal());
        if (this.hasTemperature()) {
            NBT.func_74768_a("temperature", this.temperature);
        }
        if (this.type.needsWater()) {
            this.water.writeToNBT(NBT);
        }
        if (this.type.isEthanolFueled() || this.type.isJetFueled()) {
            this.fuel.writeToNBT(NBT);
        }
        if (this.type.requiresLubricant()) {
            this.lubricant.writeToNBT(NBT);
        }
        if (this.type.burnsFuel()) {
            NBT.func_74768_a("fueltimer", this.timer.getCapOf("fuel"));
        }
        NBT.func_74768_a("gear", this.integratedGear);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.type = EngineType.setType(NBT.func_74762_e("type"));
        if (this.hasTemperature()) {
            this.temperature = NBT.func_74762_e("temperature");
        }
        if (this.type.requiresLubricant()) {
            this.lubricant.readFromNBT(NBT);
        }
        if (this.type.needsWater()) {
            this.water.readFromNBT(NBT);
        }
        if (this.type.isEthanolFueled() || this.type.isJetFueled()) {
            this.fuel.readFromNBT(NBT);
        }
        if (NBT.func_74764_b("fueltimer")) {
            this.timer.setCap("fuel", NBT.func_74762_e("fueltimer"));
        }
        this.integratedGear = NBT.func_74762_e("gear");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        this.timer.writeToNBT(NBT, "engine");
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.timer.readFromNBT(NBT, "engine");
        if (this.omega > this.type.getSpeed()) {
            this.omega = this.type.getSpeed();
        }
        if (this.torque > this.type.getTorque()) {
            this.torque = this.type.getTorque();
        }
    }

    public final boolean func_94041_b(int i, ItemStack is) {
        if (!this.type.isValidFuel(is)) {
            return false;
        }
        if (i >= this.type.getSizeInventory()) {
            return false;
        }
        switch (this.type) {
            case GAS: 
            case AC: {
                return true;
            }
            case SPORT: {
                return i == 0 && is.func_77973_b() == ItemRegistry.ETHANOL.getItemInstance() || i == 1 && this.type.isAdditive(is);
            }
        }
        return false;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public final boolean func_102008_b(int i, ItemStack itemstack, int j) {
        if (this.type == EngineType.AC) {
            if (ReikaItemHelper.matchStacks((ItemStack)itemstack, (ItemStack)ItemStacks.shaftcore) || ReikaItemHelper.matchStacks((ItemStack)itemstack, (ItemStack)ItemStacks.tungstenshaftcore)) {
                if (itemstack.field_77990_d == null) {
                    return true;
                }
                if (itemstack.field_77990_d.func_74762_e("magnet") == 0) {
                    return true;
                }
            }
            return false;
        }
        if (this.type == EngineType.STEAM) {
            return itemstack.func_77973_b() == Items.field_151133_ar;
        }
        return false;
    }

    @Override
    protected final void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        double pow = 1.05;
        double mult = 1.0;
        if (this.type == EngineType.JET) {
            pow = 1.1;
        }
        if (this.type == EngineType.HYDRO) {
            TileEntityHydroEngine te = (TileEntityHydroEngine)this;
            if (te.failed) {
                this.phi += 16.0f;
                return;
            }
            mult = 256.0f / (float)this.type.getSpeed();
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)((int)(mult * (double)this.omega + 1.0)), (int)2), (double)pow));
    }

    @Override
    public final boolean canProvidePower() {
        return true;
    }

    @Override
    public final MachineRegistry getTile() {
        return MachineRegistry.ENGINE;
    }

    @Override
    public final int getThermalDamage() {
        if (this.type.canHurtPlayer() && this.hasTemperature()) {
            return this.temperature / 100;
        }
        return 0;
    }

    public final int getRedstoneOverride() {
        if (this.type.burnsFuel()) {
            if (this.type.isEthanolFueled()) {
                return 15 * this.fuel.getLevel() / 240000;
            }
            if (this.type.isJetFueled()) {
                return 15 * this.fuel.getLevel() / 240000;
            }
            return 15 * this.water.getLevel() / 240000;
        }
        return 0;
    }

    public abstract int getFuelLevel();

    public void setDataFromPlacer(ItemStack is) {
    }

    public final void setTemperature(int temp) {
        this.temperature = temp;
    }

    public final int getFuelCapacity() {
        if (this.type.isEthanolFueled()) {
            return 240000;
        }
        if (this.type.isJetFueled()) {
            return 240000;
        }
        if (this.type == EngineType.STEAM) {
            return 60000;
        }
        return 0;
    }

    public final int getFuelDuration() {
        float factor;
        if (!this.type.burnsFuel()) {
            return -1;
        }
        int fuel = this.getFuelLevel();
        float burnprogress = 0.0f;
        if (fuel > 0) {
            burnprogress = 1.0f - this.timer.getPortionOfCap("fuel") / (float)fuel;
        }
        if ((factor = (float)this.type.getFuelUnitDuration() / (float)this.timer.getCapOf("fuel")) <= 0.0f) {
            return 0;
        }
        return (int)((double)((float)(fuel * this.type.getFuelUnitDuration()) * burnprogress * 5.0f / factor / 1000.0f) * 10.0 / (double)this.getConsumedFuel());
    }

    public final int getFullTankDuration() {
        if (!this.type.burnsFuel()) {
            return -1;
        }
        return this.getFuelCapacity() * this.type.getFuelUnitDuration() * 5;
    }

    @Override
    public final boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe() || m == MachineRegistry.FUELLINE || m == MachineRegistry.HOSE;
    }

    @Override
    public final boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        if (this.type == null) {
            return false;
        }
        if ((this.type.isJetFueled() || this.type.isEthanolFueled()) && (p == MachineRegistry.FUELLINE || p == MachineRegistry.BEDPIPE) && side == (this.isFlipped ? ForgeDirection.UP : ForgeDirection.DOWN)) {
            return true;
        }
        if (this.type.isWaterPiped() && p.isStandardPipe()) {
            switch (side) {
                case EAST: {
                    return this.func_145832_p() == 0;
                }
                case SOUTH: {
                    return this.func_145832_p() == 2;
                }
                case WEST: {
                    return this.func_145832_p() == 1;
                }
                case NORTH: {
                    return this.func_145832_p() == 3;
                }
            }
            return false;
        }
        if (this.type.requiresLubricant() && (p == MachineRegistry.HOSE || p == MachineRegistry.BEDPIPE)) {
            switch (side) {
                case EAST: {
                    return this.func_145832_p() == 0;
                }
                case SOUTH: {
                    return this.func_145832_p() == 2;
                }
                case WEST: {
                    return this.func_145832_p() == 1;
                }
                case NORTH: {
                    return this.func_145832_p() == 3;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public final void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public final int getTemperature() {
        return this.temperature;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public boolean allowHeatExtraction() {
        return this.canBeCooledWithFins();
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    @Override
    public double heatEnergyPerDegree() {
        return 2.0 * super.heatEnergyPerDegree();
    }

    @Override
    public final void onEMP() {
        if (this.type.isEMPImmune()) {
            return;
        }
        super.onEMP();
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        PowerSourceList psl = new PowerSourceList();
        if (this.power > 0L) {
            psl.addSource(this);
        }
        return psl;
    }

    @Override
    public final void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        c.add(this.getAdjacentTileEntity(this.write));
    }

    @Override
    public final long getMaxPower() {
        if (this.type == null) {
            return 0L;
        }
        return this.type.getPower();
    }

    @Override
    public final long getCurrentPower() {
        return this.power;
    }

    @Override
    public final int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        Fluid f = resource.getFluid();
        if (!this.canFill(from, f)) {
            return 0;
        }
        if (f.equals(FluidRegistry.WATER)) {
            return this.water.fill(resource, doFill);
        }
        if (f.equals(FluidRegistry.getFluid((String)"rc lubricant"))) {
            return this.lubricant.fill(resource, doFill);
        }
        if (TileEntityEngine.isAirFluid(f) && this.type.isAirBreathing()) {
            return this.air.fill(resource, doFill);
        }
        return this.fuel.fill(resource, doFill);
    }

    public static boolean isAirFluid(Fluid f) {
        return f.equals(FluidRegistry.getFluid((String)"air")) || f.equals(FluidRegistry.getFluid((String)"oxygen")) || f.equals(FluidRegistry.getFluid((String)"rc oxygen"));
    }

    public final FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public final boolean canFill(ForgeDirection from, Fluid fluid) {
        if (TileEntityEngine.isAirFluid(fluid)) {
            return this.type.isAirBreathing() && from == this.getFuelInputDirection();
        }
        if (!this.type.canReceiveFluid(fluid)) {
            return false;
        }
        if (fluid.equals(FluidRegistry.WATER)) {
            int dx = this.field_145851_c + from.offsetX;
            int dy = this.field_145848_d + from.offsetY;
            int dz = this.field_145849_e + from.offsetZ;
            return dx == this.backx && dy == this.field_145848_d && dz == this.backz;
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc lubricant"))) {
            int dx = this.field_145851_c + from.offsetX;
            int dy = this.field_145848_d + from.offsetY;
            int dz = this.field_145849_e + from.offsetZ;
            return dx == this.backx && dy == this.field_145848_d && dz == this.backz;
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
            return from == this.getFuelInputDirection();
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc ethanol"))) {
            return from == this.getFuelInputDirection();
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"bioethanol"))) {
            return from == this.getFuelInputDirection();
        }
        return false;
    }

    private ForgeDirection getFuelInputDirection() {
        return this.isFlipped ? ForgeDirection.UP : ForgeDirection.DOWN;
    }

    public final boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public final FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.water.getInfo(), this.fuel.getInfo(), this.lubricant.getInfo()};
    }

    public final void addFuel(int amt) {
        this.fuel.addLiquid(amt, this.type.getFuelType());
    }

    public final void addLubricant(int amt) {
        this.lubricant.addLiquid(amt, FluidRegistry.getFluid((String)"rc lubricant"));
    }

    public final void removeLubricant(int amt) {
        this.lubricant.removeLiquid(amt);
    }

    public final void setLube(int amt) {
        this.lubricant.setContents(amt, FluidRegistry.getFluid((String)"rc lubricant"));
    }

    public final int getLube() {
        return this.lubricant.getLevel();
    }

    public final void subtractFuel(int amt) {
        this.fuel.removeLiquid(amt);
    }

    public final void addWater(int amt) {
        this.water.addLiquid(amt, FluidRegistry.WATER);
    }

    public final int getWater() {
        return this.water.getLevel();
    }

    @Override
    public final TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return TileEntityPiping.Flow.INPUT;
    }

    public final boolean hasInventory() {
        return this.type.hasInventory();
    }

    public final boolean hasTank() {
        return this.type.usesFluids();
    }

    @Override
    public final int getEmittingX() {
        return this.field_145851_c + this.write.offsetX;
    }

    @Override
    public final int getEmittingY() {
        return this.field_145848_d + this.write.offsetY;
    }

    @Override
    public final int getEmittingZ() {
        return this.field_145849_e + this.write.offsetZ;
    }

    public boolean isBroken() {
        return false;
    }

    public void breakBlock() {
        if (this.integratedGear != 0) {
            ItemStack is = ItemIntegratedGearbox.getIntegratedGearItem(this.integratedGear, null);
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + rand.nextDouble()), (double)((double)this.field_145848_d + rand.nextDouble()), (double)((double)this.field_145849_e + rand.nextDouble()), (ItemStack)is);
        }
    }

    @Override
    public final boolean applyIntegratedGear(ItemStack is) {
        if (is == null || !ItemRegistry.GEARUPGRADE.matchItem(is)) {
            return false;
        }
        if (this.integratedGear != 0) {
            return false;
        }
        if (this.omega > 0 || this.power > 0L) {
            return false;
        }
        this.integratedGear = ItemIntegratedGearbox.getRatioFromIntegratedGearItem(is, true);
        this.syncAllData(true);
        return this.integratedGear != 0;
    }

    @Override
    public final int getIntegratedGear() {
        return this.integratedGear;
    }

    @DependentMethodStripper.ModDependent(value={ModList.BCTRANSPORT})
    public final IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection side) {
        if (type == IPipeTile.PipeType.FLUID) {
            return this.hasATank() && this.canConnectToPipeOnSide(MachineRegistry.BEDPIPE, side) ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
        }
        if (type == IPipeTile.PipeType.ITEM) {
            return this.hasAnInventory() ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }
}

