/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityAimedCannon;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.Locale;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public abstract class TileEntityFluidCannon
extends TileEntityAimedCannon
implements IFluidHandler,
PipeConnector,
IPipeConnection {
    protected final HybridTank tank = new HybridTank(ReikaStringParser.stripSpaces((String)this.getTEName().toLowerCase(Locale.ENGLISH)), this.getCapacity());

    @Override
    public final boolean hasAmmo() {
        return !this.tank.isEmpty();
    }

    protected int getCapacity() {
        return 1000;
    }

    public final FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public final boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public final FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public final int getLevel() {
        return this.tank.getLevel();
    }

    public final Fluid getContainedFluid() {
        return this.tank.getActualFluid();
    }

    public final void addLiquid(Fluid f, int amt) {
        if (this.isValidFluid(f)) {
            this.tank.addLiquid(amt, f);
        }
    }

    public final boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canReceiveFrom(from) && this.isValidFluid(fluid);
    }

    public abstract boolean isValidFluid(Fluid var1);

    @Override
    public final int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public abstract boolean canReceiveFrom(ForgeDirection var1);

    @Override
    public final boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canReceiveFrom(side.getOpposite()) && this.canConnectToPipe(p);
    }

    public final IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection side) {
        return type == IPipeTile.PipeType.FLUID ? (this.canReceiveFrom(side) ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT) : IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public final TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return this.canReceiveFrom(side) ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }

    public final boolean isEmpty() {
        return this.tank.isEmpty();
    }

    public final boolean isFull() {
        return this.tank.isFull();
    }

    @Override
    protected final double randomOffset() {
        return 0.0;
    }

    @Override
    public final int getOperationTime() {
        return 0;
    }
}

