/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.GUIs.Machine.Inventory;

import Reika.DragonAPI.Instantiable.GUI.ImagedGuiButton;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.RotaryCraft.Base.GuiPowerOnlyMachine;
import Reika.RotaryCraft.Containers.Machine.Inventory.ContainerItemFilter;
import Reika.RotaryCraft.Registry.PacketRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.TileEntityItemFilter;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;

public class GuiItemFilter
extends GuiPowerOnlyMachine {
    private final TileEntityItemFilter filter;
    private static final int LINES = 5;
    private TileEntityItemFilter.SettingType page = TileEntityItemFilter.SettingType.BASIC;
    private ArrayList<TileEntityItemFilter.MatchDisplay> display;
    private int nbtListPos = 0;
    private TileEntityItemFilter.MatchData lastData;

    public GuiItemFilter(EntityPlayer p5ep, TileEntityItemFilter te) {
        super((Container)new ContainerItemFilter(p5ep, te), te);
        this.field_146999_f = 256;
        this.field_147000_g = 217;
        this.ep = p5ep;
        this.filter = te;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        TileEntityItemFilter.MatchData data = this.filter.getData();
        if (data != null) {
            this.display = null;
            switch (this.page) {
                case BASIC: {
                    this.display = data.getMainDisplay();
                    break;
                }
                case NBT: {
                    this.display = data.getNBTDisplay();
                    break;
                }
                case ORE: {
                    this.display = data.getOreDisplay();
                    break;
                }
                case CLASS: {
                    this.display = data.getClassDisplay();
                }
            }
            if (this.display != null) {
                int d = this.page == TileEntityItemFilter.SettingType.NBT ? 1 : 0;
                int max = Math.min(this.nbtListPos + this.display.size(), this.nbtListPos + 5 - d);
                for (int i = this.nbtListPos; i < max && i < this.display.size() + d; ++i) {
                    int i2 = i - this.nbtListPos + d;
                    TileEntityItemFilter.MatchDisplay m = this.display.get(i);
                    int u = m.getSetting() == TileEntityItemFilter.MatchType.MATCH ? 0 : 9;
                    int v = m.getSetting() == TileEntityItemFilter.MatchType.MISMATCH ? 54 : 63;
                    this.field_146292_n.add(new ImagedGuiButton(i, j + 30, k + 18 + i2 * 16, 9, 9, u, v, "Textures/GUI/buttons.png", RotaryCraft.class));
                }
            }
            this.field_146292_n.add(new GuiButton(-1, j + 30, k + 100, 20, 20, "<"));
            this.field_146292_n.add(new GuiButton(-2, j + 50, k + 100, 20, 20, ">"));
            if (this.page == TileEntityItemFilter.SettingType.NBT) {
                if (!this.display.isEmpty()) {
                    for (int i = 0; i < 3; ++i) {
                        int u = i == 0 ? 0 : 9;
                        int v = i == 1 ? 54 : 63;
                        this.field_146292_n.add(new ImagedGuiButton(-5 - i, j + 30 + i * 10, k + 18 + 0, 9, 9, u, v, "Textures/GUI/buttons.png", RotaryCraft.class));
                    }
                }
                if (this.display != null && this.display.size() > 5) {
                    this.field_146292_n.add(new GuiButton(-3, j + 70, k + 100, 20, 20, "+"));
                    this.field_146292_n.add(new GuiButton(-4, j + 90, k + 100, 20, 20, "-"));
                }
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (this.isClickTooSoon()) {
            return;
        }
        if (b.field_146127_k == -1) {
            this.page = this.page.previous();
        } else if (b.field_146127_k == -2) {
            this.page = this.page.next();
        } else if (b.field_146127_k == -3) {
            int d;
            int n = d = this.page == TileEntityItemFilter.SettingType.NBT ? 1 : 0;
            if (this.display != null && this.nbtListPos < this.display.size() - 5 + d) {
                ++this.nbtListPos;
            }
        } else if (b.field_146127_k == -4) {
            if (this.nbtListPos > 0) {
                --this.nbtListPos;
            }
        } else if (b.field_146127_k == -5 || b.field_146127_k == -6 || b.field_146127_k == -7) {
            for (TileEntityItemFilter.MatchDisplay m : this.display) {
                while (m.getSetting().ordinal() != -b.field_146127_k - 5) {
                    m.increment();
                }
            }
            this.sendData();
        } else if (b.field_146127_k >= 0 && b.field_146127_k != 24000) {
            TileEntityItemFilter.MatchDisplay m = this.display.get(b.field_146127_k);
            m.increment();
            this.sendData();
        }
        this.func_73866_w_();
    }

    private void sendData() {
        NBTTagCompound nbt = this.filter.getData().writeToNBT();
        nbt.func_74768_a("posX", this.tile.field_145851_c);
        nbt.func_74768_a("posY", this.tile.field_145848_d);
        nbt.func_74768_a("posZ", this.tile.field_145849_e);
        ReikaPacketHelper.sendNBTPacket((String)"RotaryCraftData", (int)PacketRegistry.FILTERSETTING.ordinal(), (NBTTagCompound)nbt, (PacketTarget)PacketTarget.server);
    }

    @Override
    protected void func_146979_b(int a, int b) {
        super.func_146979_b(a, b);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        int dx = this.inventoryLabelLeft() ? 176 : this.field_146999_f - 50;
        this.field_146289_q.func_78276_b("Blacklist", dx, this.field_147000_g - 96 + 3, 0x404040);
        TileEntityItemFilter.MatchData data = this.filter.getData();
        if (data != this.lastData) {
            this.func_73866_w_();
        }
        this.lastData = data;
        int x = api.getMouseRealX();
        int y = api.getMouseRealY();
        if (this.filter.getData() != null && this.display != null) {
            if (this.display.isEmpty()) {
                this.field_146289_q.func_78276_b("[No Values]", 42, 19, 0);
            }
            int d = this.page == TileEntityItemFilter.SettingType.NBT ? 1 : 0;
            int max = Math.min(this.nbtListPos + this.display.size(), this.nbtListPos + 5 - d);
            for (int i = this.nbtListPos; i < max && i < this.display.size() + d; ++i) {
                int i2 = i - this.nbtListPos + d;
                TileEntityItemFilter.MatchDisplay m = this.display.get(i);
                int tx = 42;
                int ty = 19 + i2 * 16;
                String s = m.displayName + " (" + m.value + "): ";
                this.field_146289_q.func_78276_b(s, tx, ty, 0);
                this.field_146289_q.func_78276_b(m.getSetting().name, tx + this.field_146289_q.func_78256_a(s), ty, m.getSetting().color);
            }
            if (this.page == TileEntityItemFilter.SettingType.NBT && !this.display.isEmpty()) {
                int tx = 42;
                int ty = 19;
                this.field_146289_q.func_78276_b("Toggle All", tx + 22, ty, 0);
            }
        }
    }

    @Override
    protected boolean inventoryLabelLeft() {
        return true;
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par2, par3);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
    }

    @Override
    protected String getGuiTexture() {
        return "filtergui2";
    }
}

