/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Items.Tools.Bedrock;

import Reika.ChromatiCraft.Items.Tools.ItemFloatstoneBoots;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Base.ItemRotaryArmor;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.Satisforestry.Registry.SFBlocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IArmorApiarist;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

@APIStripper.Strippable(value={"forestry.api.apiculture.IArmorApiarist"})
public class ItemBedrockArmor
extends ItemRotaryArmor
implements IArmorApiarist {
    public ItemBedrockArmor(int tex, int render, int type) {
        super(RotaryCraft.BEDROCK, render, type, tex);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs cr, List li) {
        ItemStack is = new ItemStack(id, 1, 0);
        ReikaEnchantmentHelper.applyEnchantments((ItemStack)is, this.getDefaultEnchantments());
        li.add(is);
        if (((ItemArmor)id).field_77881_a == 0) {
            ItemStack is3 = is.func_77946_l();
            for (int i = 0; i < HelmetUpgrades.list.length; ++i) {
                HelmetUpgrades g = HelmetUpgrades.list[i];
                ItemStack is2 = is.func_77946_l();
                if (!g.isAvailable) continue;
                g.enable(is2, true);
                g.enable(is3, true);
                li.add(is2);
            }
            li.add(is3);
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        super.func_77624_a(is, ep, li, vb);
        for (int i = 0; i < HelmetUpgrades.list.length; ++i) {
            HelmetUpgrades g = HelmetUpgrades.list[i];
            if (!g.isAvailable || !g.existsOn(is)) continue;
            li.add("Upgraded: " + g.name());
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer ep, ItemStack is) {
        if (this.field_77881_a == 0 && HelmetUpgrades.NIGHTVISION.existsOn(is)) {
            ep.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 3, 0));
            ReikaEntityHelper.setNoPotionParticles((EntityLivingBase)ep);
        }
        ep.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(Double.MAX_VALUE);
    }

    public HashMap<Enchantment, Integer> getDefaultEnchantments() {
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        if (ItemRegistry.getEntryByID((Item)this).isBedrockArmor()) {
            switch (this.field_77881_a) {
                case 0: {
                    map.put(Enchantment.field_77328_g, 4);
                    map.put(Enchantment.field_77340_h, 3);
                    break;
                }
                case 1: {
                    map.put(Enchantment.field_77327_f, 4);
                    break;
                }
                case 2: {
                    map.put(Enchantment.field_77329_d, 4);
                    break;
                }
                case 3: {
                    map.put(Enchantment.field_77330_e, 4);
                }
            }
        }
        return map;
    }

    public void func_77663_a(ItemStack is, World world, Entity entity, int par4, boolean par5) {
        this.forceEnchantments(is, world, entity, par4);
    }

    public boolean onEntityItemUpdate(EntityItem ei) {
        ItemStack is = ei.func_92059_d();
        HashMap<Enchantment, Integer> map = this.getDefaultEnchantments();
        for (Enchantment e : map.keySet()) {
            if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)e, (ItemStack)is)) continue;
            ei.func_85030_a("random.break", 1.0f, 1.0f);
            ei.func_70106_y();
        }
        return false;
    }

    private void forceEnchantments(ItemStack is, World world, Entity entity, int slot) {
        HashMap<Enchantment, Integer> map = this.getDefaultEnchantments();
        for (Enchantment e : map.keySet()) {
            if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)e, (ItemStack)is)) continue;
            entity.func_85030_a("random.break", 1.0f, 1.0f);
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer ep = (EntityPlayer)entity;
            ep.field_71071_by.func_70299_a(slot, null);
            ep.func_70097_a(DamageSource.field_76377_j, 10.0f);
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)"The damaged tool has broken.");
            is = null;
            break;
        }
    }

    @Override
    public boolean providesProtection() {
        return true;
    }

    @Override
    public boolean isVulnerableTo(DamageSource src) {
        return true;
    }

    @Override
    public boolean canBeDamaged() {
        return false;
    }

    @Override
    public double getDamageMultiplier(DamageSource src) {
        return src.func_76363_c() ? 0.75 : 0.35;
    }

    public int func_77619_b() {
        return ConfigRegistry.PREENCHANT.getState() ? 0 : Items.field_151035_b.func_77619_b();
    }

    public static boolean isWearingFullSuitOf(EntityLivingBase e) {
        return ReikaEntityHelper.isEntityWearingFullSuitOf((EntityLivingBase)e, is -> ItemBedrockArmor.isValidBedrockArmorItem(is));
    }

    public static boolean isValidBedrockArmorItem(ItemStack is) {
        if (is == null) {
            return false;
        }
        if (ModList.CHROMATICRAFT.isLoaded() && ItemBedrockArmor.checkFloatstoneBoots(is)) {
            return true;
        }
        ItemRegistry ir = ItemRegistry.getEntry(is);
        if (ir == null) {
            return false;
        }
        return ir.isBedrockTypeArmor();
    }

    @DependentMethodStripper.ModDependent(value={ModList.CHROMATICRAFT})
    private static boolean checkFloatstoneBoots(ItemStack is) {
        ItemStack in;
        if (ChromaItems.FLOATBOOTS.matchWith(is) && (in = ItemFloatstoneBoots.getSpecialItem((ItemStack)is)) != null) {
            return ItemBedrockArmor.isValidBedrockArmorItem(in);
        }
        return false;
    }

    @Override
    public int getItemSpriteIndex(ItemStack item) {
        return this == ItemRegistry.BEDHELM.getItemInstance() && HelmetUpgrades.NIGHTVISION.existsOn(item) ? 48 : super.getItemSpriteIndex(item);
    }

    public boolean protectEntity(EntityLivingBase entity, ItemStack armor, String cause, boolean doProtect) {
        ItemStack head = entity.func_71124_b(4);
        ItemRegistry ir = head != null ? ItemRegistry.getEntry(head) : null;
        return ir != null && ir.isBedrockArmor() && HelmetUpgrades.APIARIST.existsOn(head);
    }

    @Deprecated
    public boolean protectPlayer(EntityPlayer player, ItemStack armor, String cause, boolean doProtect) {
        return this.protectEntity((EntityLivingBase)player, armor, cause, doProtect);
    }

    public final void setDamage(ItemStack stack, int damage) {
    }

    public static enum HelmetUpgrades {
        NIGHTVISION,
        VISOR,
        APIARIST(ModList.FORESTRY),
        SLUG1(ModList.SATISFORESTRY),
        SLUG2(ModList.SATISFORESTRY),
        SLUG3(ModList.SATISFORESTRY);

        public static final HelmetUpgrades[] list;
        public final boolean isAvailable;

        private HelmetUpgrades() {
            this(true);
        }

        private HelmetUpgrades(ModList mod) {
            this(mod.isLoaded());
        }

        private HelmetUpgrades(boolean b) {
            this.isAvailable = b;
        }

        public boolean existsOn(ItemStack is) {
            return is.field_77990_d != null && is.field_77990_d.func_74767_n(this.getNBT());
        }

        private String getNBT() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public void enable(ItemStack is, boolean set) {
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            is.field_77990_d.func_74757_a(this.getNBT(), set);
            if (set) {
                if (this == SLUG1) {
                    is.field_77990_d.func_74768_a("slugUpgrade", 1);
                }
                if (this == SLUG2) {
                    is.field_77990_d.func_74768_a("slugUpgrade", 2);
                }
                if (this == SLUG3) {
                    is.field_77990_d.func_74768_a("slugUpgrade", 3);
                }
            } else {
                is.field_77990_d.func_82580_o("slugUpgrade");
            }
        }

        public ItemMatch[] getUpgradeItems() {
            switch (this) {
                case NIGHTVISION: {
                    return new ItemMatch[]{new ItemMatch(ItemRegistry.NVG.getStackOf())};
                }
                case VISOR: {
                    return new ItemMatch[]{new ItemMatch((Block)Blocks.field_150399_cn), new ItemMatch(Items.field_151045_i), new ItemMatch((Block)Blocks.field_150399_cn)};
                }
                case APIARIST: {
                    return (ItemMatch[])ReikaArrayHelper.getArrayOf((Object)new ItemMatch(ForestryHandler.CraftingMaterials.WOVENSILK.getItem()), (int)8);
                }
                case SLUG1: {
                    return new ItemMatch[]{this.getPowerSlug(0)};
                }
                case SLUG2: {
                    return new ItemMatch[]{this.getPowerSlug(1)};
                }
                case SLUG3: {
                    return new ItemMatch[]{this.getPowerSlug(2)};
                }
            }
            return null;
        }

        @DependentMethodStripper.ModDependent(value={ModList.SATISFORESTRY})
        private ItemMatch getPowerSlug(int meta) {
            return new ItemMatch(SFBlocks.SLUG.getStackOfMetadata(meta));
        }

        static {
            list = HelmetUpgrades.values();
        }
    }
}

