/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Items.Tools.Bedrock;

import Reika.ChromatiCraft.API.ChromatiAPI;
import Reika.ChromatiCraft.Block.Dye.BlockDyeLeaf;
import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.Base.ItemRotaryShears;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ItemBedrockShears
extends ItemRotaryShears {
    private static final HashSet<Block> noDrops = new HashSet();

    public ItemBedrockShears(int tex) {
        super(tex);
        this.setNoRepair();
        this.func_77656_e(0);
    }

    public void func_77622_d(ItemStack is, World world, EntityPlayer ep) {
        RotaryAchievements.BEDROCKTOOLS.triggerAchievement(ep);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_150894_a(ItemStack is, World world, Block par3, int par4, int par5, int par6, EntityLivingBase e) {
        return true;
    }

    public boolean canHarvestBlock(Block par1Block, ItemStack is) {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack is, int x, int y, int z, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        Block b = player.field_70170_p.func_147439_a(x, y, z);
        int meta = player.field_70170_p.func_72805_g(x, y, z);
        boolean drop = false;
        boolean flag = false;
        Event.Result res = ItemBedrockShears.getHarvestResult(b, meta, player, player.field_70170_p, x, y, z);
        switch (res) {
            case ALLOW: {
                flag = true;
                drop = true;
                break;
            }
            case DEFAULT: {
                flag = super.onBlockStartBreak(is, x, y, z, player);
                break;
            }
            case DENY: {
                flag = false;
                drop = false;
            }
        }
        if (drop) {
            ItemStack block = new ItemStack(b, 1, ItemBedrockShears.getDroppedMeta(b, meta));
            ReikaItemHelper.dropItem((World)player.field_70170_p, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)block);
            player.field_70170_p.func_147468_f(x, y, z);
        }
        return flag;
    }

    public static Event.Result getHarvestResult(Block b, int meta, EntityPlayer player, World world, int x, int y, int z) {
        if (b instanceof BlockTieredResource) {
            return Event.Result.DENY;
        }
        if (noDrops.contains(b)) {
            return Event.Result.DENY;
        }
        if (b.canSilkHarvest(world, player, x, y, z, meta)) {
            return Event.Result.ALLOW;
        }
        if (b == Blocks.field_150321_G) {
            return Event.Result.ALLOW;
        }
        if (ModList.CHROMATICRAFT.isLoaded() && b instanceof BlockDyeLeaf) {
            return Event.Result.DEFAULT;
        }
        if (world.func_147438_o(x, y, z) instanceof TileEntityBase) {
            return Event.Result.DENY;
        }
        if (b instanceof IShearable) {
            ((IShearable)b).onSheared(player.func_71045_bC(), (IBlockAccess)world, x, y, z, 0);
            return Event.Result.ALLOW;
        }
        if (b.func_149688_o() == Material.field_151585_k || b.func_149688_o() == Material.field_151584_j) {
            return Event.Result.ALLOW;
        }
        return Event.Result.DEFAULT;
    }

    public static int getDroppedMeta(Block id, int meta) {
        if (id == Blocks.field_150362_t || id == Blocks.field_150361_u) {
            return meta & 3;
        }
        if (ModList.CHROMATICRAFT.isLoaded() && id == ChromatiAPI.getAPI().trees().getRainbowLeaf()) {
            return 0;
        }
        if (id == Blocks.field_150395_bd) {
            return 0;
        }
        if (id == Blocks.field_150392_bi) {
            return 0;
        }
        if (id == Blocks.field_150345_g) {
            return meta & 3;
        }
        if (id.getClass().getName().equals("vazkii.botania.common.block.BlockModDoubleFlower")) {
            meta &= 7;
            if (id == GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"doubleFlower2")) {
                // empty if block
            }
            return meta;
        }
        if (id instanceof BlockDoublePlant) {
            return meta % BlockDoublePlant.field_149892_a.length;
        }
        ModWoodList wood = ModWoodList.getModWoodFromLeaf((Block)id, (int)meta);
        if (wood != null) {
            return (Integer)wood.getLeafMetadatas().get(0);
        }
        return meta;
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity instanceof IShearable) {
            int z;
            int y;
            IShearable target = (IShearable)entity;
            int x = MathHelper.func_76128_c((double)entity.field_70165_t);
            if (target.isShearable(itemstack, (IBlockAccess)entity.field_70170_p, x, y = MathHelper.func_76128_c((double)entity.field_70163_u), z = MathHelper.func_76128_c((double)entity.field_70161_v))) {
                int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack);
                ArrayList drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, x, y, z, fortune);
                if (ConfigRegistry.FAKEBEDROCK.getState() || !ReikaPlayerAPI.isFake((EntityPlayer)player)) {
                    for (ItemStack stack : drops) {
                        stack.field_77994_a *= 2;
                    }
                }
                ReikaItemHelper.dropItems((World)entity.field_70170_p, (double)((double)x + 0.5), (double)((double)y + 0.8), (double)((double)z + 0.5), (Collection)drops);
            }
            return true;
        }
        return false;
    }

    public float getDigSpeed(ItemStack is, Block b, int meta) {
        float f = 0.75f;
        if (b != null) {
            if (b instanceof IShearable) {
                f = 8.0f;
            } else if (b.func_149688_o() == Material.field_151585_k) {
                f = 8.0f;
            } else if (b.func_149688_o() == Material.field_151569_G || b == Blocks.field_150321_G) {
                f = 40.0f;
            } else if (b.func_149688_o() == Material.field_151580_n || b == Blocks.field_150325_L) {
                f = 16.0f;
            }
        }
        return f;
    }

    static {
        noDrops.add(Blocks.field_150436_aH);
        noDrops.add(Blocks.field_150394_bc);
        noDrops.add(Blocks.field_150393_bb);
    }
}

