/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Items.Tools.Charged;

import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Base.ItemChargedTool;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemPump
extends ItemChargedTool {
    public ItemPump(int index) {
        super(index);
    }

    @Override
    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (ep.func_70093_af()) {
            this.incrementMode(is);
            return is;
        }
        if (is.func_77960_j() <= 0) {
            ReikaChatHelper.clearChat();
            this.noCharge();
            return is;
        }
        if (this.getMode(is) == Modes.DRAIN) {
            int z;
            int y;
            int x;
            Block id;
            this.warnCharge(is);
            MovingObjectPosition mov = ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, (double)5.0, (boolean)true);
            if (mov != null && (id = world.func_147439_a(x = mov.field_72311_b, y = mov.field_72312_c, z = mov.field_72309_d)) != Blocks.field_150350_a) {
                if (ReikaWorldHelper.isLiquidSourceBlock((World)world, (int)x, (int)y, (int)z)) {
                    Fluid f = ReikaFluidHelper.lookupFluidForBlock((Block)id);
                    if (f != null && !world.field_72995_K) {
                        this.drainLiquid(world, x, y, z, is, f);
                    } else {
                        RotaryCraft.logger.debug((Object)("Null fluid for block " + id + ", yet was marked as such!"));
                    }
                } else {
                    RotaryCraft.logger.debug((Object)("Not a fluid block (" + id + ")"));
                }
            }
        }
        return is;
    }

    private void drainLiquid(World world, int x, int y, int z, ItemStack is, Fluid f) {
        Fluid f2;
        Fluid fluid = f2 = is.field_77990_d == null ? null : ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d);
        if (f2 == null) {
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            this.drainAndFill(world, x, y, z, is, f, 1000);
        } else {
            int amt = is.field_77990_d.func_74762_e("lvl");
            if (f2.equals(f)) {
                if (amt < 64000) {
                    this.drainAndFill(world, x, y, z, is, f, amt + 1000);
                } else {
                    RotaryCraft.logger.debug((Object)"Too little space");
                }
            } else {
                RotaryCraft.logger.debug((Object)("Fluid mismatch " + f + " != " + f2));
            }
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77341_i, (ItemStack)is)) {
            int r;
            for (int j = r = 2; j >= -r; --j) {
                for (int i = r; i >= -r; --i) {
                    for (int k = r; k >= -r; --k) {
                        int dx = x + i;
                        int dy = y + j;
                        int dz = z + k;
                        if (!ReikaWorldHelper.isLiquidSourceBlock((World)world, (int)dx, (int)dy, (int)dz)) continue;
                        Block id = world.func_147439_a(dx, dy, dz);
                        Fluid f3 = ReikaFluidHelper.lookupFluidForBlock((Block)id);
                        if (f3 == f) {
                            int amt = is.field_77990_d.func_74762_e("lvl");
                            this.drainAndFill(world, dx, dy, dz, is, f3, amt + 1000);
                        }
                        if (is.field_77990_d.func_74762_e("lvl") < 64000) continue;
                        return;
                    }
                }
            }
        }
    }

    private void drainAndFill(World world, int x, int y, int z, ItemStack is, Fluid f, int amt) {
        ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)is.field_77990_d, (Fluid)f);
        is.field_77990_d.func_74768_a("lvl", amt);
        world.func_147468_f(x, y, z);
        is.func_77964_b(is.func_77960_j() - 1);
    }

    @Override
    public Event.Result getEnchantValidity(Enchantment e, ItemStack is) {
        return e == Enchantment.field_77341_i ? Event.Result.ALLOW : super.getEnchantValidity(e, is);
    }

    public int getItemEnchantability(ItemStack is) {
        return Items.field_151036_c.func_77619_b();
    }

    @Override
    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float par8, float par9, float par10) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IFluidHandler) {
            int amt;
            IFluidHandler fl = (IFluidHandler)te;
            int n = amt = is.field_77990_d != null ? is.field_77990_d.func_74762_e("lvl") : 0;
            if (this.getMode(is) == Modes.PLACE) {
                int space;
                FluidStack fs;
                Fluid f = is.field_77990_d != null ? ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d) : null;
                FluidStack f2 = fl.drain(ForgeDirection.VALID_DIRECTIONS[s], 1, false);
                if (f2 != null && (f == null || f == f2.getFluid()) && (fs = fl.drain(ForgeDirection.VALID_DIRECTIONS[s], space = 64000 - amt, true)) != null) {
                    if (is.field_77990_d == null) {
                        is.field_77990_d = new NBTTagCompound();
                    }
                    is.field_77990_d.func_74768_a("lvl", amt + fs.amount);
                    ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)is.field_77990_d, (Fluid)fs.getFluid());
                }
            } else if (amt > 0) {
                Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d);
                for (int i = 0; i < 6; ++i) {
                    int d = fl.fill(ForgeDirection.VALID_DIRECTIONS[i], new FluidStack(f, amt), true);
                    amt -= d;
                }
                is.field_77990_d.func_74768_a("lvl", amt);
                if (amt == 0) {
                    ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)is.field_77990_d, null);
                }
            }
            return true;
        }
        if (this.getMode(is) == Modes.PLACE) {
            if (is.func_77960_j() > 0) {
                Block b;
                this.warnCharge(is);
                int amt = is.field_77990_d.func_74762_e("lvl");
                Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d);
                if (f != null && amt >= 1000 && (b = f.getBlock()) != null) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s];
                    int dx = x + dir.offsetX;
                    int dy = y + dir.offsetY;
                    int dz = z + dir.offsetZ;
                    if (world.func_147439_a(dx, dy, dz).isAir((IBlockAccess)world, dx, dy, dz) || world.func_147439_a(dx, dy, dz) == b && !ReikaWorldHelper.isLiquidSourceBlock((World)world, (int)dx, (int)dy, (int)dz)) {
                        world.func_147449_b(dx, dy, dz, b);
                        is.field_77990_d.func_74768_a("lvl", amt - 1000);
                        if (amt <= 1000) {
                            ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)is.field_77990_d, null);
                        }
                        is.func_77964_b(is.func_77960_j() - 1);
                        for (int i = -1; i <= 1; ++i) {
                            for (int k = -1; k <= 1; ++k) {
                                world.func_147471_g(dx + i, dy, dz + k);
                                world.func_147439_a(dx + i, dy, dz + k).func_149695_a(world, dx + i, dy, dz + k, b);
                                ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)(dx + i), (int)dy, (int)(dz + k));
                            }
                        }
                    }
                }
            } else {
                ReikaChatHelper.clearChat();
                this.noCharge();
            }
        }
        return false;
    }

    private Modes getMode(ItemStack is) {
        if (is.field_77990_d == null) {
            return Modes.DRAIN;
        }
        return Modes.list[is.field_77990_d.func_74762_e("mode")];
    }

    private void setMode(ItemStack is, Modes m) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74768_a("mode", m.ordinal());
    }

    private void incrementMode(ItemStack is) {
        this.setMode(is, this.getMode(is).next());
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean par4) {
        Fluid f;
        NBTTagCompound nbt = is.field_77990_d;
        if (nbt != null && (f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)nbt)) != null) {
            String fluid = f.getLocalizedName();
            int amt = nbt.func_74762_e("lvl");
            String amount = String.format("%d", amt);
            String s = "Contents: " + amount + " mB of " + fluid;
            li.add(s);
        }
        li.add("Mode: " + this.getMode(is).desc);
    }

    private static enum Modes {
        DRAIN("Drain"),
        PLACE("Place");

        private final String desc;
        private static final Modes[] list;

        private Modes(String s) {
            this.desc = s;
        }

        public Modes next() {
            return list[(this.ordinal() + 1) % list.length];
        }

        static {
            list = Modes.values();
        }
    }
}

