/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Items.Tools;

import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.API.Interfaces.Fillable;
import Reika.RotaryCraft.Base.ItemRotaryTool;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Items.Tools.ItemJetPack;
import Reika.RotaryCraft.ModInterface.TileEntityFuelEngine;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityPulseFurnace;
import Reika.RotaryCraft.TileEntities.Storage.TileEntityReservoir;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ItemFuelTank
extends ItemRotaryTool
implements Fillable {
    private static final ArrayList<Fluid> creativeFluids = new ArrayList();

    public ItemFuelTank(int index) {
        super(index);
    }

    @Override
    public boolean isValidFluid(Fluid f, ItemStack is) {
        return is.field_77990_d != null ? f.equals(ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d)) : true;
    }

    @Override
    public int getCapacity(ItemStack is) {
        return 16000;
    }

    @Override
    public int getCurrentFillLevel(ItemStack is) {
        return is.field_77990_d != null ? is.field_77990_d.func_74762_e("fuel") : 0;
    }

    @Override
    public int addFluid(ItemStack is, Fluid f, int amt) {
        int fuel = 0;
        if (!this.isValidFluid(f)) {
            return 0;
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)is.field_77990_d, (Fluid)f);
        } else {
            fuel = is.field_77990_d.func_74762_e("fuel");
            if (!f.equals(ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d))) {
                return 0;
            }
        }
        int toadd = Math.min(amt, this.getCapacity(is) - fuel);
        is.field_77990_d.func_74768_a("fuel", fuel + toadd);
        return toadd;
    }

    public boolean isValidFluid(Fluid f) {
        if (f == null) {
            return false;
        }
        if (f.equals(FluidRegistry.getFluid((String)"fuel"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rc ethanol"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"bioethanol"))) {
            return true;
        }
        return f.equals(FluidRegistry.getFluid((String)"biofuel"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(ItemRegistry.getEntryByID(par1).getStackOf());
        for (int i = 0; i < creativeFluids.size(); ++i) {
            ItemStack is = ItemRegistry.getEntryByID(par1).getStackOf();
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("fuel", this.getCapacity(is));
            ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)nbt, (Fluid)creativeFluids.get(i));
            is.field_77990_d = nbt;
            par3List.add(is);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean verbose) {
        int i = is.func_77960_j();
        if (is.field_77990_d != null) {
            li.add(this.getDisplayTag(is.field_77990_d));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String getDisplayTag(NBTTagCompound nbt) {
        Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)nbt);
        String fluid = f != null ? f.getLocalizedName() : "Null Fluid";
        int amt = nbt.func_74762_e("fuel");
        String amount = String.format("%d", amt);
        return "Contents: " + amount + " mB of " + fluid;
    }

    private static void addCreativeFluid(String name) {
        Fluid f = FluidRegistry.getFluid((String)name);
        if (f != null) {
            creativeFluids.add(f);
        }
    }

    public static void initCreativeFluids() {
        creativeFluids.clear();
        ItemFuelTank.addCreativeFluid("fuel");
        ItemFuelTank.addCreativeFluid("rc jet fuel");
        ItemFuelTank.addCreativeFluid("rc ethanol");
        ItemFuelTank.addCreativeFluid("bioethanol");
        ItemFuelTank.addCreativeFluid("biofuel");
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (is.field_77990_d != null) {
            Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d);
            int amt = this.getCurrentFillLevel(is);
            int slot = ReikaInventoryHelper.locateIDInInventory((Item)ItemRegistry.JETPACK.getItemInstance(), (IInventory)ep.field_71071_by);
            if (slot == -1) {
                slot = ReikaInventoryHelper.locateIDInInventory((Item)ItemRegistry.BEDPACK.getItemInstance(), (IInventory)ep.field_71071_by);
            }
            if (slot == -1) {
                slot = ReikaInventoryHelper.locateIDInInventory((Item)ItemRegistry.STEELPACK.getItemInstance(), (IInventory)ep.field_71071_by);
            }
            if (slot != -1) {
                ItemStack jet = ep.field_71071_by.func_70301_a(slot);
                ItemJetPack item = (ItemJetPack)jet.func_77973_b();
                int fuel = this.getCurrentFillLevel(is);
                int added = item.addFluid(jet, f, fuel);
                int newfuel = fuel - added;
                is.field_77990_d.func_74768_a("fuel", newfuel);
                if (newfuel <= 0) {
                    is.field_77990_d = null;
                }
            }
        }
        return is;
    }

    private void removeFuel(ItemStack is, int amt) {
        int newfuel = this.getCurrentFillLevel(is) - amt;
        if (newfuel > 0) {
            is.field_77990_d.func_74768_a("fuel", newfuel);
        } else {
            is.field_77990_d = null;
        }
    }

    @Override
    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        Fluid f;
        int amt;
        RotaryCraftTileEntity te;
        if (super.func_77648_a(is, ep, world, x, y, z, s, a, b, c)) {
            return true;
        }
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (m == MachineRegistry.ENGINE) {
            te = (TileEntityEngine)tile;
            EngineType eng = ((TileEntityEngine)te).getEngineType();
            Fluid f2 = this.getCurrentFluid(is);
            if (f2 != null) {
                amt = Math.min(this.getCurrentFillLevel(is), ((TileEntityEngine)te).getFuelCapacity() - ((TileEntityEngine)te).getFuelLevel());
                if (amt > 0) {
                    boolean flag = false;
                    if (eng.isJetFueled() && f2.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
                        ((TileEntityEngine)te).addFuel(amt);
                        flag = true;
                    } else if (eng.isEthanolFueled() && f2.equals(FluidRegistry.getFluid((String)"rc ethanol"))) {
                        ((TileEntityEngine)te).addFuel(amt);
                        flag = true;
                    }
                    if (flag) {
                        ReikaPacketHelper.sendTankSyncPacket((String)"RotaryCraftData", (TileEntity)te, (String)"fuel");
                        this.removeFuel(is, amt);
                        return true;
                    }
                }
            } else {
                amt = Math.min(this.getCapacity(is), ((TileEntityEngine)te).getFuelLevel());
                if (amt > 0) {
                    boolean flag = false;
                    if (eng.isJetFueled()) {
                        this.addFluid(is, FluidRegistry.getFluid((String)"rc jet fuel"), amt);
                        flag = true;
                    } else if (eng.isEthanolFueled()) {
                        this.addFluid(is, FluidRegistry.getFluid((String)"rc ethanol"), amt);
                        flag = true;
                    }
                    if (flag) {
                        ((TileEntityEngine)te).subtractFuel(amt);
                        ReikaPacketHelper.sendTankSyncPacket((String)"RotaryCraftData", (TileEntity)te, (String)"fuel");
                        return true;
                    }
                }
            }
        }
        if (m == MachineRegistry.FUELENGINE) {
            te = (TileEntityFuelEngine)tile;
            f = this.getCurrentFluid(is);
            if (f == null) {
                int amt2 = Math.min(this.getCapacity(is), ((TileEntityFuelEngine)te).getFuelLevel());
                if (amt2 > 0) {
                    this.addFluid(is, FluidRegistry.getFluid((String)"fuel"), amt2);
                    ((TileEntityFuelEngine)te).removeFuel(amt2);
                    return true;
                }
            } else if (TileEntityFuelEngine.isValidFuel(f)) {
                int amt3 = Math.min(this.getCurrentFillLevel(is), 24000 - ((TileEntityFuelEngine)te).getFuelLevel());
                if (amt3 > 0) {
                    ((TileEntityFuelEngine)te).addFuel(amt3, f);
                    ReikaPacketHelper.sendTankSyncPacket((String)"RotaryCraftData", (TileEntity)te, (String)"tank");
                    this.removeFuel(is, amt3);
                    return true;
                }
            }
        }
        if (m == MachineRegistry.PULSEJET) {
            te = (TileEntityPulseFurnace)tile;
            f = this.getCurrentFluid(is);
            if (f == null) {
                int amt4 = Math.min(this.getCapacity(is), ((TileEntityPulseFurnace)te).getFuel());
                if (amt4 > 0) {
                    this.addFluid(is, FluidRegistry.getFluid((String)"rc jet fuel"), amt4);
                    ((TileEntityPulseFurnace)te).removeFuel(amt4);
                    ReikaPacketHelper.sendTankSyncPacket((String)"RotaryCraftData", (TileEntity)te, (String)"fuel");
                    return true;
                }
            } else if (f.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
                int amt5 = Math.min(this.getCurrentFillLevel(is), 8000 - ((TileEntityPulseFurnace)te).getFuel());
                if (amt5 > 0) {
                    ((TileEntityPulseFurnace)te).addFuel(amt5);
                    ReikaPacketHelper.sendTankSyncPacket((String)"RotaryCraftData", (TileEntity)te, (String)"fuel");
                    this.removeFuel(is, amt5);
                    return true;
                }
            }
        }
        if (m == MachineRegistry.RESERVOIR) {
            te = (TileEntityReservoir)tile;
            f = this.getCurrentFluid(is);
            Fluid f2 = ((TileEntityReservoir)te).getFluid();
            if (f != null) {
                amt = Math.min(this.getCurrentFillLevel(is), 64000 - ((TileEntityReservoir)te).getLevel());
                if (amt > 0 && ((TileEntityReservoir)te).canAcceptFluid(f)) {
                    ((TileEntityReservoir)te).addLiquid(amt, f);
                    ReikaPacketHelper.sendTankSyncPacket((String)"RotaryCraftData", (TileEntity)te, (String)"tank");
                    this.removeFuel(is, amt);
                    return true;
                }
            } else if (this.isValidFluid(f2) && (amt = Math.min(this.getCapacity(is), ((TileEntityReservoir)te).getLevel())) > 0) {
                ((TileEntityReservoir)te).removeLiquid(amt);
                ReikaPacketHelper.sendTankSyncPacket((String)"RotaryCraftData", (TileEntity)te, (String)"tank");
                this.addFluid(is, f2, amt);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFull(ItemStack is) {
        return this.getCurrentFillLevel(is) >= this.getCapacity(is);
    }

    @Override
    public Fluid getCurrentFluid(ItemStack is) {
        return is.field_77990_d != null ? ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d) : null;
    }
}

