/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Items.Tools;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.API.Interfaces.Fillable;
import Reika.RotaryCraft.Auxiliary.Interfaces.IntegratedGearboxable;
import Reika.RotaryCraft.Base.ItemRotaryTool;
import Reika.RotaryCraft.Registry.ItemRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemIntegratedGearbox
extends ItemRotaryTool
implements Fillable {
    public ItemIntegratedGearbox(int index) {
        super(index);
        this.func_77656_e(0);
        this.field_77787_bX = true;
    }

    public static ItemStack getIntegratedGearItem(int ratio, Fluid f) {
        if (ratio == 0) {
            return null;
        }
        int meta = Math.abs(ratio);
        meta = ReikaMathLibrary.logbase2((long)meta);
        ItemStack is = ItemRegistry.GEARUPGRADE.getStackOfMetadata(meta);
        if (f != null) {
            ItemIntegratedGearbox i = (ItemIntegratedGearbox)is.func_77973_b();
            i.addFluid(is, f, i.getCapacity(is));
        }
        return is;
    }

    public static int getRatioFromIntegratedGearItem(ItemStack is, boolean requireFill) {
        int meta = is.func_77960_j();
        if (meta == 0) {
            return 0;
        }
        if (requireFill && is.field_77990_d == null) {
            return 0;
        }
        ItemIntegratedGearbox i = (ItemIntegratedGearbox)is.func_77973_b();
        if (requireFill && !i.isFull(is)) {
            return 0;
        }
        boolean pos = !requireFill || i.getCurrentFluid(is) == FluidRegistry.getFluid((String)"rc lubricant");
        int ratio = ReikaMathLibrary.intpow2((int)2, (int)meta);
        return pos ? ratio : -ratio;
    }

    @Override
    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IntegratedGearboxable && ((IntegratedGearboxable)te).applyIntegratedGear(is)) {
            if (!ep.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
            if (is.field_77994_a == 0) {
                is = null;
            }
            ep.func_70062_b(0, is);
            return true;
        }
        return false;
    }

    @Override
    public int getItemSpriteIndex(ItemStack item) {
        int base = super.getItemSpriteIndex(item);
        if (item.func_77960_j() > 0) {
            ++base;
        }
        if (this.isFull(item)) {
            Fluid f = this.getCurrentFluid(item);
            if (f == FluidRegistry.getFluid((String)"rc lubricant")) {
                ++base;
            } else if (f == FluidRegistry.getFluid((String)"rc liquid nitrogen")) {
                base += 2;
            }
        }
        return base;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i <= 4; ++i) {
            ItemStack is = new ItemStack(item, 1, i);
            par3List.add(is);
            if (i <= 0) continue;
            ItemStack is2 = is.func_77946_l();
            this.addFluid(is2, FluidRegistry.getFluid((String)"rc lubricant"), this.getCapacity(is2));
            par3List.add(is2);
            is2 = is.func_77946_l();
            this.addFluid(is2, FluidRegistry.getFluid((String)"rc liquid nitrogen"), this.getCapacity(is2));
            par3List.add(is2);
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        super.func_77624_a(is, ep, li, vb);
        if (is.func_77960_j() > 0) {
            int ratio = ItemIntegratedGearbox.getRatioFromIntegratedGearItem(is, false);
            li.add("Ratio: " + Math.abs(ratio) + "x");
            ratio = ItemIntegratedGearbox.getRatioFromIntegratedGearItem(is, true);
            if (ratio > 0) {
                li.add("Torque Mode");
            } else if (ratio < 0) {
                li.add("Speed Mode");
            } else {
                li.add("Requires Fluid");
                if (is.field_77990_d != null) {
                    int amt = this.getCurrentFillLevel(is);
                    Fluid f = this.getCurrentFluid(is);
                    li.add("Is " + (float)amt * 100.0f / (float)this.getCapacity(is) + "% full of " + f.getLocalizedName(new FluidStack(f, amt)));
                }
            }
        } else {
            li.add("Requires Gears and Fluid");
        }
    }

    @Override
    public boolean isValidFluid(Fluid f, ItemStack is) {
        return is.field_77990_d != null ? f.equals(ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d)) : this.isValidFluid(f);
    }

    private boolean isValidFluid(Fluid f) {
        if (f.equals(FluidRegistry.getFluid((String)"rc liquid nitrogen"))) {
            return true;
        }
        return f.equals(FluidRegistry.getFluid((String)"rc lubricant"));
    }

    @Override
    public int getCapacity(ItemStack is) {
        return 500;
    }

    @Override
    public int getCurrentFillLevel(ItemStack is) {
        return is.field_77990_d != null ? is.field_77990_d.func_74762_e("lvl") : 0;
    }

    @Override
    public int addFluid(ItemStack is, Fluid f, int amt) {
        int liq = 0;
        if (!this.isValidFluid(f)) {
            return 0;
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)is.field_77990_d, (Fluid)f);
        } else {
            liq = is.field_77990_d.func_74762_e("lvl");
            if (!f.equals(ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d))) {
                return 0;
            }
        }
        int toadd = Math.min(amt, this.getCapacity(is) - liq);
        is.field_77990_d.func_74768_a("lvl", liq + toadd);
        return toadd;
    }

    @Override
    public boolean isFull(ItemStack is) {
        return is.field_77990_d != null && this.getCurrentFillLevel(is) >= this.getCapacity(is);
    }

    private boolean canFill(ItemStack is) {
        return !this.isFull(is);
    }

    @Override
    public Fluid getCurrentFluid(ItemStack is) {
        return is.field_77990_d != null ? ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d) : null;
    }
}

