/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.Conversion;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Base.TileEntity.EnergyToPowerBase;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Piping.TileEntityPipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public class TileEntitySteam
extends EnergyToPowerBase
implements PowerGenerator,
SimpleProvider,
IPipeConnection,
IFluidHandler,
PipeConnector {
    public static final int CAPACITY = 300000;

    @Override
    protected double getRelativeEfficiency() {
        return 0.5;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)4), (double)1.0));
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.STEAMTURBINE;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.write = this.getFacing().getOpposite();
        if (this.getTicksExisted() == 0) {
            ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        }
        this.updateSpeed();
        this.basicPowerReceiver();
    }

    private void getSteam(World world, int dx, int dy, int dz) {
        IFluidHandler ic;
        FluidStack liq;
        TileEntity te;
        int drain = 25;
        if (this.storedEnergy <= this.getMaxStorage() - drain && (te = world.func_147438_o(dx, dy, dz)) instanceof IFluidHandler && (liq = (ic = (IFluidHandler)te).drain(this.getFacing().getOpposite(), drain, true)) != null && liq.amount > 0 && liq.getFluid().equals(FluidRegistry.getFluid((String)"water"))) {
            this.addEnergy(liq.amount, true);
        }
    }

    private int addEnergy(int amount, boolean doAdd) {
        int max = this.getMaxStorage() - this.storedEnergy;
        int add = Math.min(max, amount);
        if (doAdd) {
            this.storedEnergy += add;
        }
        return add;
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection dir) {
        return dir == this.getFacing().getOpposite() && type == IPipeTile.PipeType.FLUID ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public int getEmittingX() {
        return this.field_145851_c + this.write.offsetX;
    }

    @Override
    public int getEmittingY() {
        return this.field_145848_d + this.write.offsetY;
    }

    @Override
    public int getEmittingZ() {
        return this.field_145849_e + this.write.offsetZ;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe() || super.canConnectToPipe(m);
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p) && side == this.getFacing() || super.canConnectToPipeOnSide(p, side);
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == this.getFacing() ? TileEntityPiping.Flow.INPUT : super.getFlowForSide(side);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (super.canFill(from, resource.getFluid())) {
            return super.fill(from, resource, doFill);
        }
        return this.canFill(from, resource.getFluid()) ? this.addEnergy(resource.amount, doFill) : 0;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return super.canFill(from, fluid) || from == this.getFacing() && fluid.equals(FluidRegistry.getFluid((String)"steam"));
    }

    @Override
    public boolean isValidSupplier(TileEntity te) {
        return te instanceof IFluidHandler || te instanceof TileEntityPipe;
    }

    @Override
    public int getMaxStorage() {
        return 300000;
    }

    @Override
    protected int getIdealConsumedUnitsPerTick() {
        return MathHelper.func_76143_f((double)Math.sqrt(this.power));
    }

    @Override
    public String getUnitDisplay() {
        return "mB";
    }

    @Override
    public int getPowerColor() {
        return 0xFFFFFF;
    }
}

