/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.Minetweaker;

import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesFrictionHeater;
import Reika.RotaryCraft.ModInterface.Minetweaker.MinetweakerHelper;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rotarycraft.Friction")
public class FrictionTweaker {
    private static final RecipesFrictionHeater recipes = RecipesFrictionHeater.getRecipes();

    @ZenMethod
    public static void addRecipe(IIngredient input, IIngredient output, int temp, int time) {
        ItemStack out = MinetweakerHelper.getStack(output);
        if (!FrictionTweaker.isValid(out)) {
            throw new IllegalArgumentException("You cannot add alternate recipes for native RotaryCraft items!");
        }
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(input, output, temp, time));
    }

    private static boolean isValid(ItemStack out) {
        return !out.func_77973_b().getClass().getName().startsWith("Reika.RotaryCraft.Items");
    }

    private static class AddRecipe
    implements IUndoableAction {
        private ArrayList<ItemStack> inputs = new ArrayList();
        private ItemStack output;
        private int temp;
        private int time;

        public AddRecipe(IIngredient input, IIngredient output, int temp, int time) {
            List<ItemStack> toAddRecipe = MinetweakerHelper.getStacks(input);
            this.temp = temp;
            this.time = time;
            for (ItemStack in : toAddRecipe) {
                if (recipes.getRecipeByInput(in) != null) continue;
                this.inputs.add(in);
            }
        }

        public void apply() {
            for (ItemStack in : this.inputs) {
                recipes.addCustomRecipe(in, this.output, this.temp, this.time);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack in : this.inputs) {
                recipes.removeRecipe(in + ">" + this.output + "@" + this.temp + "#" + this.time);
            }
        }

        public String describe() {
            return "Adding " + this.inputs.size() + " recipe" + (this.inputs.size() > 1 ? "s" : "") + " to Friction Heater for " + this.output.func_82833_r() + " @ " + this.temp + "C";
        }

        public String describeUndo() {
            return "Removing " + this.inputs.size() + " recipe" + (this.inputs.size() > 1 ? "s" : "") + " to Friction Heater for " + this.output.func_82833_r() + " @ " + this.temp + "C";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

