/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders.DMI;

import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Interfaces.Item.IndexedItemSprites;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.RotaryCraft.Auxiliary.IORenderer;
import Reika.RotaryCraft.Base.ItemBlockPlacer;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Models.ModelFillingStation;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityFillingStation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class RenderFillingStation
extends RotaryTERenderer {
    private ModelFillingStation FillingStationModel = new ModelFillingStation();

    public void renderTileEntityFillingStationAt(TileEntityFillingStation tile, double par2, double par4, double par6, float par8) {
        if (!tile.isInWorld()) {
            boolean var9 = false;
        } else {
            int var9 = tile.func_145832_p();
        }
        ModelFillingStation var14 = this.FillingStationModel;
        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/fillingtex.png");
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 2.0f), (float)((float)par6 + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        int var11 = 0;
        if (tile.isInWorld()) {
            switch (tile.func_145832_p()) {
                case 0: {
                    var11 = 180;
                    break;
                }
                case 1: {
                    var11 = 0;
                    break;
                }
                case 2: {
                    var11 = 270;
                    break;
                }
                case 3: {
                    var11 = 90;
                }
            }
            GL11.glRotatef((float)((float)var11 - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        var14.renderAll((TileEntity)tile, null, -tile.phi);
        if (tile.isInWorld()) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (this.doRenderModel((TileEntityBase)((RotaryCraftTileEntity)tile))) {
            this.renderTileEntityFillingStationAt((TileEntityFillingStation)tile, par2, par4, par6, par8);
        }
        if (((RotaryCraftTileEntity)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            this.renderLiquid(tile, par2, par4, par6);
            IORenderer.renderIO(tile, par2, par4, par6);
        }
        this.renderItem(tile, par2, par4, par6);
    }

    private void renderLiquid(TileEntity tile, double par2, double par4, double par6) {
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        TileEntityFillingStation tr = (TileEntityFillingStation)tile;
        double dx = 0.0;
        double dz = 0.0;
        double ddx = 0.0;
        double ddz = 0.0;
        switch (tr.func_145832_p()) {
            case 0: {
                dx = 0.25;
                break;
            }
            case 1: {
                ddx = 0.25;
                break;
            }
            case 2: {
                dz = 0.25;
                break;
            }
            case 3: {
                ddz = 0.25;
            }
        }
        if (!tr.isEmpty() && tr.isInWorld()) {
            Fluid f = tr.getFluid();
            if (!f.equals(FluidRegistry.LAVA)) {
                GL11.glEnable((int)3042);
            }
            ReikaLiquidRenderer.bindFluidTexture((Fluid)f);
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            double h = 0.0625 + 0.875 * (double)tr.getLevel() / 32000.0;
            Tessellator v5 = Tessellator.field_78398_a;
            if (f.getLuminosity() > 0) {
                ReikaRenderHelper.disableLighting();
            }
            v5.func_78382_b();
            v5.func_78375_b(0.0f, 1.0f, 0.0f);
            int clr = -1;
            if (f.canBePlacedInWorld()) {
                clr = f.getBlock().func_149720_d((IBlockAccess)tr.field_145850_b, tr.field_145851_c * 2, tr.field_145848_d * 2, tr.field_145849_e * 2);
            }
            v5.func_78378_d(clr);
            v5.func_78374_a(dx + 0.0, h, -ddz + 1.0, (double)u, (double)dv);
            v5.func_78374_a(-ddx + 1.0, h, -ddz + 1.0, (double)du, (double)dv);
            v5.func_78374_a(-ddx + 1.0, h, dz + 0.0, (double)du, (double)v);
            v5.func_78374_a(dx + 0.0, h, dz + 0.0, (double)u, (double)v);
            v5.func_78381_a();
            ReikaRenderHelper.enableLighting();
        }
        GL11.glTranslated((double)(-par2), (double)(-par4), (double)(-par6));
        GL11.glDisable((int)3042);
    }

    private void renderItem(TileEntity tile, double par2, double par4, double par6) {
        TileEntityFillingStation fs = (TileEntityFillingStation)tile;
        if (!fs.isInWorld()) {
            return;
        }
        ItemStack is = fs.getItemForRender();
        if (is == null) {
            return;
        }
        double in = 0.125;
        double xoff = 0.0;
        double zoff = 0.0;
        float var11 = 0.0f;
        switch (tile.func_145832_p()) {
            case 0: {
                var11 = 180.0f;
                break;
            }
            case 1: {
                var11 = 0.0f;
                xoff = 1.0;
                zoff = -1.0;
                break;
            }
            case 2: {
                var11 = 270.0f;
                in = -in;
                break;
            }
            case 3: {
                var11 = 90.0f;
                xoff = 1.0;
                zoff = 1.0;
                in = -in;
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        GL11.glRotatef((float)(var11 - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)xoff, (double)0.0, (double)zoff);
        GL11.glDisable((int)2884);
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        Item item = is.func_77973_b();
        IItemRenderer iir = MinecraftForgeClient.getItemRenderer((ItemStack)is, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY);
        if (item instanceof IndexedItemSprites && !(item instanceof ItemBlockPlacer)) {
            IndexedItemSprites iis = (IndexedItemSprites)item;
            ReikaTextureHelper.bindTexture((Class)iis.getTextureReferenceClass(), (String)iis.getTexture(is));
            int index = iis.getItemSpriteIndex(is);
            int row = index / 16;
            int col = index % 16;
            float u = (float)col / 16.0f;
            float v = (float)row / 16.0f;
            float du = u + 0.0625f;
            float dv = v + 0.0625f;
            v5.func_78374_a(0.0, 0.0, in, (double)u, (double)dv);
            v5.func_78374_a(-1.0, 0.0, in, (double)du, (double)dv);
            v5.func_78374_a(-1.0, 1.0, in, (double)du, (double)v);
            v5.func_78374_a(0.0, 1.0, in, (double)u, (double)v);
        } else if (iir == null) {
            if (ReikaItemHelper.isBlock((ItemStack)is)) {
                ReikaTextureHelper.bindTerrainTexture();
            } else {
                ReikaTextureHelper.bindItemTexture();
            }
            IIcon ico = item.getIcon(is, MinecraftForgeClient.getRenderPass());
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            v5.func_78374_a(0.0, 0.0, in, (double)u, (double)dv);
            v5.func_78374_a(-1.0, 0.0, in, (double)du, (double)dv);
            v5.func_78374_a(-1.0, 1.0, in, (double)du, (double)v);
            v5.func_78374_a(0.0, 1.0, in, (double)u, (double)v);
        }
        v5.func_78381_a();
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    public String getImageFileName(RenderFetcher te) {
        return "fillingtex.png";
    }
}

