/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders.MI;

import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Interfaces.Item.AnimatedSpritesheet;
import Reika.DragonAPI.Interfaces.Item.IndexedItemSprites;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Models.ModelDryingBed;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityDryingBed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class RenderDryingBed
extends RotaryTERenderer {
    private final ModelDryingBed model = new ModelDryingBed();

    public String getImageFileName(RenderFetcher te) {
        return "dryingbedtex.png";
    }

    public void renderTileEntityDryingBedAt(TileEntityDryingBed tile, double par2, double par4, double par6, float par8) {
        ModelDryingBed var14 = this.model;
        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/dryingbedtex.png");
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 2.0f), (float)((float)par6 + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        boolean var11 = false;
        var14.renderAll((TileEntity)tile, null);
        if (tile.isInWorld()) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        TileEntityDryingBed te = (TileEntityDryingBed)tile;
        if (this.doRenderModel((TileEntityBase)te)) {
            this.renderTileEntityDryingBedAt(te, par2, par4, par6, par8);
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        if (te.isInWorld()) {
            this.renderItem(te);
        }
        if (te.isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            this.renderFluid(te);
        }
        GL11.glPopMatrix();
    }

    private void renderItem(TileEntityDryingBed te) {
        ItemStack is = te.func_70301_a(0);
        if (is != null) {
            float thick = 0.0625f;
            Tessellator v5 = Tessellator.field_78398_a;
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.2f * (float)te.progress / 400.0f));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IItemRenderer iir = MinecraftForgeClient.getItemRenderer((ItemStack)is, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY);
            Item item = is.func_77973_b();
            if (item instanceof IndexedItemSprites) {
                AnimatedSpritesheet a;
                IndexedItemSprites iis = (IndexedItemSprites)item;
                ReikaTextureHelper.bindTexture((Class)iis.getTextureReferenceClass(), (String)iis.getTexture(is));
                int index = iis.getItemSpriteIndex(is);
                int row = index / 16;
                int col = index % 16;
                if (item instanceof AnimatedSpritesheet && (a = (AnimatedSpritesheet)item).useAnimatedRender(is)) {
                    col = a.getColumn(is);
                    int offset = (int)(System.currentTimeMillis() / 32L / (long)a.getFrameSpeed(is) % (long)a.getFrameCount(is));
                    row = a.getBaseRow(is) + offset;
                }
                float u = (float)col / 16.0f;
                float v = (float)row / 16.0f;
                double b = 0.25;
                double dx = 0.125;
                double dz = 0.905;
                double dy = 0.965 - (double)te.progress * 5.0E-5;
                double s = 0.8;
                GL11.glPushMatrix();
                GL11.glTranslated((double)dx, (double)dy, (double)dz);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScaled((double)s, (double)s, (double)s);
                if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
                    ItemRenderer.func_78439_a((Tessellator)v5, (float)(0.0625f * (float)col), (float)(0.0625f * (float)row), (float)(0.0625f + 0.0625f * (float)col), (float)(0.0625f + 0.0625f * (float)row), (int)256, (int)256, (float)thick);
                } else {
                    v5.func_78382_b();
                    v5.func_78374_a(0.0, 0.0, 0.0, (double)(0.0625f * (float)col), (double)(0.0625f + 0.0625f * (float)row));
                    v5.func_78374_a(1.0, 0.0, 0.0, (double)(0.0625f + 0.0625f * (float)col), (double)(0.0625f + 0.0625f * (float)row));
                    v5.func_78374_a(1.0, 1.0, 0.0, (double)(0.0625f + 0.0625f * (float)col), (double)(0.0625f * (float)row));
                    v5.func_78374_a(0.0, 1.0, 0.0, (double)(0.0625f * (float)col), (double)(0.0625f * (float)row));
                    v5.func_78381_a();
                }
                GL11.glPopMatrix();
            } else if (iir == null) {
                if (ReikaItemHelper.isBlock((ItemStack)is)) {
                    ReikaTextureHelper.bindTerrainTexture();
                } else {
                    ReikaTextureHelper.bindItemTexture();
                }
                IIcon ico = item.getIcon(is, MinecraftForgeClient.getRenderPass());
                if (ico == null) {
                    return;
                }
                float u = ico.func_94209_e();
                float v = ico.func_94206_g();
                float du = ico.func_94212_f();
                float dv = ico.func_94210_h();
                double b = 0.65;
                double dx = 0.1;
                double dz = 0.125;
                double dy = 0.925 - (double)te.progress * 5.0E-5;
                double s = 0.8;
                GL11.glPushMatrix();
                GL11.glTranslated((double)dx, (double)dy, (double)dz);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScaled((double)s, (double)s, (double)s);
                if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
                    ItemRenderer.func_78439_a((Tessellator)v5, (float)u, (float)v, (float)du, (float)dv, (int)256, (int)256, (float)thick);
                } else {
                    v5.func_78382_b();
                    v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)v);
                    v5.func_78374_a(1.0, 1.0, 0.0, (double)du, (double)v);
                    v5.func_78374_a(1.0, 0.0, 0.0, (double)du, (double)dv);
                    v5.func_78374_a(0.0, 0.0, 0.0, (double)u, (double)dv);
                    v5.func_78381_a();
                }
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)3042);
        }
    }

    private void renderFluid(TileEntityDryingBed tile) {
        Fluid f = tile.getFluid();
        if (f != null) {
            double h;
            ReikaTextureHelper.bindTerrainTexture();
            Tessellator v5 = Tessellator.field_78398_a;
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            int l = tile.getLevel();
            if (!f.equals(FluidRegistry.LAVA)) {
                GL11.glEnable((int)3042);
            }
            double d = h = l > 0 ? 0.8125 + (double)l * 0.125 / (double)tile.getCapacity() : 0.5;
            if (f.getLuminosity() > 0 && tile.func_145830_o()) {
                ReikaRenderHelper.disableLighting();
            }
            v5.func_78382_b();
            v5.func_78378_d(0xFFFFFF);
            v5.func_78374_a(0.0625, h, 0.9375, (double)u, (double)v);
            v5.func_78374_a(0.9375, h, 0.9375, (double)du, (double)v);
            v5.func_78374_a(0.9375, h, 0.0625, (double)du, (double)dv);
            v5.func_78374_a(0.0625, h, 0.0625, (double)u, (double)dv);
            v5.func_78381_a();
            ReikaRenderHelper.enableLighting();
            GL11.glDisable((int)3042);
        }
    }
}

