/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders;

import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.RotaryCraft.Auxiliary.IORenderer;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Models.Animated.ModelCoil;
import Reika.RotaryCraft.Models.Animated.ModelHighGear;
import Reika.RotaryCraft.Models.Animated.ModelWorm;
import Reika.RotaryCraft.Models.ModelCVT;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderAdvGear
extends RotaryTERenderer {
    private ModelWorm wormModel = new ModelWorm();
    private ModelCVT cvtModel = new ModelCVT();
    private ModelCoil coilModel = new ModelCoil();
    private ModelHighGear highGearModel = new ModelHighGear();
    private int itemMetadata = 0;

    @Override
    protected String getTextureSubfolder() {
        return "Transmission/";
    }

    public void renderTileEntityAdvancedGearAt(TileEntityAdvancedGear tile, double par2, double par4, double par6, float par8) {
        int var9 = !tile.isInWorld() ? 0 : tile.func_145832_p();
        ModelWorm var14 = this.wormModel;
        ModelCVT var15 = this.cvtModel;
        ModelCoil var16 = this.coilModel;
        ModelHighGear var17 = this.highGearModel;
        this.setupGL(tile, par2, par4, par6);
        int var11 = 0;
        if (tile.isInWorld()) {
            switch (tile.func_145832_p() % 4) {
                case 0: {
                    var11 = 0;
                    break;
                }
                case 1: {
                    var11 = 180;
                    break;
                }
                case 2: {
                    var11 = 90;
                    break;
                }
                case 3: {
                    var11 = 270;
                }
            }
        } else {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            switch (this.itemMetadata) {
                case 1: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/Transmission/Shaft/shafttex.png");
                    var14.renderAll((TileEntity)tile, null);
                    break;
                }
                case 2: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/Transmission/cvttex.png");
                    var15.renderAll((TileEntity)tile, null);
                    break;
                }
                case 3: {
                    if (tile.isBedrockCoil()) {
                        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/Transmission/coiltex_bed.png");
                    } else {
                        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/Transmission/coiltex.png");
                    }
                    var16.renderAll((TileEntity)tile, null);
                    break;
                }
                case 4: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/Transmission/highgeartex.png");
                    var17.renderAll((TileEntity)tile, null);
                }
            }
            if (tile.isInWorld()) {
                GL11.glDisable((int)32826);
            }
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        GL11.glRotatef((float)((float)var11 + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        switch (tile.getGearType()) {
            case WORM: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/Transmission/Shaft/shafttex.png");
                var14.renderAll((TileEntity)tile, null, tile.phi);
                break;
            }
            case CVT: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/Transmission/cvttex.png");
                var15.renderAll((TileEntity)tile, null, tile.phi);
                if (!tile.isInWorld()) break;
                GL11.glPushAttrib((int)1048575);
                GL11.glDisable((int)2896);
                ReikaRenderHelper.disableEntityLighting();
                FontRenderer fr = this.getFontRenderer();
                float var10 = 0.53333336f;
                GL11.glScalef((float)var10, (float)(-var10), (float)(-var10));
                float var112 = 0.016666668f * var10;
                GL11.glTranslatef((float)0.0f, (float)(0.61875f * var10), (float)(0.20625f * var10));
                GL11.glRotated((double)-20.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)-0.175f, (float)-0.545f, (float)-0.19f);
                GL11.glScalef((float)var112, (float)(-var112), (float)var112);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDepthMask((boolean)false);
                GL11.glTranslatef((float)5.0f, (float)-48.0f, (float)37.0f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                if (tile.getTicksExisted() / 80 % 2 == 0) {
                    String var15b = RotaryAux.formatPower(tile.power);
                    fr.func_78276_b(var15b, -18, 70, 0xFFFFFF);
                    var15b = RotaryAux.formatTorque(tile.torque);
                    fr.func_78276_b(var15b, -18, 82, 0xFFFFFF);
                    var15b = RotaryAux.formatSpeed(tile.omega);
                    fr.func_78276_b(var15b, -18, 94, 0xFFFFFF);
                } else {
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    GL11.glTranslatef((float)0.075f, (float)0.25f, (float)0.1f);
                    int ratio = tile.getCVTRatio();
                    String var15b = ratio > 0 ? "1:" + ratio : -ratio + ":1";
                    while (var15b.length() < 5) {
                        var15b = " " + var15b;
                    }
                    fr.func_78276_b(var15b, -10, 39, 0xFFFFFF);
                }
                GL11.glPopAttrib();
                break;
            }
            case COIL: {
                if (tile.isBedrockCoil()) {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/Transmission/coiltex_bed.png");
                } else {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/Transmission/coiltex.png");
                }
                var16.renderAll((TileEntity)tile, null, tile.phi);
                break;
            }
            case HIGH: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/Transmission/highgeartex.png");
                var17.renderAll((TileEntity)tile, null, tile.phi);
            }
        }
        this.closeGL(tile);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (par8 <= -999.0f) {
            this.itemMetadata = (int)(-par8) / 1000;
            par8 = 0.0f;
        }
        if (this.doRenderModel((TileEntityBase)((RotaryCraftTileEntity)tile))) {
            this.renderTileEntityAdvancedGearAt((TileEntityAdvancedGear)tile, par2, par4, par6, par8);
        }
        if (((RotaryCraftTileEntity)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            IORenderer.renderIO(tile, par2, par4, par6);
        }
    }

    public String getImageFileName(RenderFetcher t) {
        if (!(t instanceof RenderFetcher)) {
            return "";
        }
        TileEntityIOMachine te = (TileEntityIOMachine)t;
        if (te.isInWorld()) {
            if (te.func_145832_p() < 4) {
                return "shafttex.png";
            }
            if (te.func_145832_p() < 8) {
                return "cvttex.png";
            }
            if (te.func_145832_p() < 12) {
                return "coiltex.png";
            }
            return "highgeartex.png";
        }
        if (this.itemMetadata == 1) {
            return "shafttex.png";
        }
        if (this.itemMetadata == 2) {
            return "cvttex.png";
        }
        if (this.itemMetadata == 3) {
            return "coiltex.png";
        }
        if (this.itemMetadata == 4) {
            return "highgeartex.png";
        }
        return "";
    }
}

