/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Decorative;

import Reika.DragonAPI.Base.OneSlotMachine;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.RotaryCraft.Base.TileEntity.TileEntitySpringPowered;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityParticleEmitter
extends TileEntitySpringPowered
implements OneSlotMachine,
InertIInv {
    public ReikaParticleHelper particleType = ReikaParticleHelper.SMOKE;
    public double pX = 0.0;
    public double pY = 0.0;
    public double pZ = 0.0;
    public int particlesPerTick = 3;
    public boolean useRedstone = false;

    @Override
    public int getBaseDischargeTime() {
        return 600;
    }

    public boolean canEmit(World world, int x, int y, int z) {
        if (!this.hasCoil()) {
            return false;
        }
        return !this.useRedstone || this.hasRedstoneSignal();
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.updateCoil();
        if (this.canEmit(world, x, y, z)) {
            for (int i = 0; i < this.particlesPerTick; ++i) {
                this.particleType.spawnAt(world, (double)x + rand.nextDouble(), (double)(y + 2) + rand.nextDouble() * 4.0, (double)z + rand.nextDouble(), this.pX, this.pY, this.pZ);
            }
        }
    }

    private void updateCoil() {
        if (!this.hasCoil()) {
            return;
        }
        ++this.tickcount;
        if (this.tickcount > this.getUnwindTime()) {
            ItemStack is;
            this.inv[0] = is = this.getDecrementedCharged();
            this.tickcount = 0;
        }
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.PARTICLE;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("type", this.particleType.ordinal());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.particleType = ReikaParticleHelper.values()[NBT.func_74762_e("type")];
    }

    public boolean isParticleValid(ReikaParticleHelper p) {
        if (p == ReikaParticleHelper.DRIPLAVA) {
            return false;
        }
        if (p == ReikaParticleHelper.DRIPWATER) {
            return false;
        }
        if (p == ReikaParticleHelper.SUSPEND) {
            return false;
        }
        return p != ReikaParticleHelper.SNOWSHOVEL;
    }
}

