/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Engine;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RedstoneUpgradeable;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityExtractor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityDCEngine
extends TileEntityEngine
implements RedstoneUpgradeable {
    private boolean hasUpgrade;

    @Override
    protected void consumeFuel(float scale) {
    }

    @Override
    protected void internalizeFuel() {
    }

    @Override
    protected boolean getRequirements(World world, int x, int y, int z, int meta) {
        return this.hasUpgrade || this.hasRedstoneSignal();
    }

    @Override
    protected void playSounds(World world, int x, int y, int z, float pitchMultiplier, float volume) {
        ++this.soundtick;
        if (this.isMuffled(world, x, y, z)) {
            volume *= 0.3125f;
        }
        if (this.soundtick < this.getSoundLength(1.0f / pitchMultiplier) && this.soundtick < 2000) {
            return;
        }
        this.soundtick = 0;
        SoundRegistry.ELECTRIC.playSoundAtBlock(world, x, y, z, 0.125f * volume, 1.0f * pitchMultiplier);
    }

    @Override
    public int getFuelLevel() {
        return 0;
    }

    @Override
    protected void affectSurroundings(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K && this.getAdjacentTileEntity(this.write) instanceof TileEntityExtractor) {
            RotaryAchievements.DUMBEXTRACTOR.triggerAchievement(this.getPlacer());
        }
    }

    @Override
    public void upgrade(ItemStack is) {
        this.addRedstoneUpgrade();
    }

    @Override
    public boolean canUpgradeWith(ItemStack item) {
        return !this.hasRedstoneUpgrade() && ItemRegistry.UPGRADE.matchItem(item) && item.func_77960_j() == ItemEngineUpgrade.Upgrades.REDSTONE.ordinal();
    }

    @Override
    public void addRedstoneUpgrade() {
        this.hasUpgrade = true;
    }

    @Override
    public boolean hasRedstoneUpgrade() {
        return this.hasUpgrade;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("redstoneUpgrade", this.hasUpgrade);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasUpgrade = NBT.func_74767_n("redstoneUpgrade");
    }

    @Override
    public void breakBlock() {
        super.breakBlock();
        if (this.hasRedstoneUpgrade()) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)ItemRegistry.UPGRADE.getStackOfMetadata(ItemEngineUpgrade.Upgrades.REDSTONE.ordinal()));
        }
    }
}

