/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Engine;

import Reika.DragonAPI.Instantiable.Effects.EntityBlockTexFX;
import Reika.DragonAPI.Instantiable.Effects.EntityLiquidParticleFX;
import Reika.DragonAPI.Instantiable.RayTracer;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Entity.EtherealEntity;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.API.Event.JetEngineEnterFailureEvent;
import Reika.RotaryCraft.API.Event.JetEngineExplosionEvent;
import Reika.RotaryCraft.API.Interfaces.ThermalMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.Interfaces.UpgradeableMachine;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.EntityTurretShot;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.PacketRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.VoidMonster.Entity.EntityVoidMonster;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import thaumcraft.common.entities.monster.EntityWisp;

public class TileEntityJetEngine
extends TileEntityEngine
implements NBTMachine,
UpgradeableMachine {
    private boolean isJetFailing = false;
    public int FOD = 0;
    private int dumpx;
    private int dumpz;
    private int dumpvx;
    private int dumpvz;
    private StepTimer jetstarttimer = new StepTimer(479);
    private int afterburnTick = 2000;
    private int chickenCount = 0;
    private boolean isChoking = false;
    private boolean canAfterBurn;
    private boolean burnerActive;
    private static final RayTracer tracer = new RayTracer(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final int BASE_CONSUMPTION = 10;
    public static final int AFTERBURNER_CONSUMPTION = 25;

    @Override
    public int getFuelLevel() {
        return this.fuel.getLevel();
    }

    @Override
    protected void consumeFuel(float scale) {
        this.fuel.removeLiquid(scale * (float)this.getConsumedFuel());
    }

    @Override
    protected int getConsumedFuel() {
        return this.isAfterburning() ? 25 : 10;
    }

    @Override
    protected void internalizeFuel() {
    }

    @Override
    protected boolean canBeThrottled() {
        return !this.isAfterburning();
    }

    @Override
    protected boolean getRequirements(World world, int x, int y, int z, int meta) {
        if (this.FOD >= 8) {
            this.jetstarttimer.reset();
            return false;
        }
        if (this.fuel.getLevel() <= 0) {
            this.jetstarttimer.reset();
            return false;
        }
        if (this.power > 0L) {
            RotaryAchievements.JETENGINE.triggerAchievement(this.getPlacer());
        }
        return true;
    }

    protected void updateTemperature(World world, int x, int y, int z) {
    }

    private void checkJetFailure(World world, int x, int y, int z, int meta) {
        if (this.isJetFailing) {
            this.jetEngineDetonation(world, x, y, z, meta);
        } else if (this.FOD > 0 && rand.nextInt(DifficultyEffects.JETFAILURE.getInt() * (9 - this.FOD)) == 0) {
            this.triggerJetFailing(world, x, y, z);
        }
    }

    public float getChokedFraction(World world, int x, int y, int z, int meta) {
        int[] pos = new int[]{x, z};
        switch (meta) {
            case 0: {
                pos[0] = pos[0] + 1;
                break;
            }
            case 1: {
                pos[0] = pos[0] + -1;
                break;
            }
            case 2: {
                pos[1] = pos[1] + 1;
                break;
            }
            case 3: {
                pos[1] = pos[1] + -1;
            }
        }
        Block b = world.func_147439_a(pos[0], y, pos[1]);
        int dmg = world.func_72805_g(pos[0], y, pos[1]);
        if (b == Blocks.field_150350_a) {
            return 1.0f;
        }
        if (b.func_149668_a(world, pos[0], y, pos[1]) == null) {
            return 1.0f;
        }
        if (b == Blocks.field_150422_aJ || b == Blocks.field_150386_bk) {
            return 0.75f;
        }
        if (b == Blocks.field_150411_aY) {
            return 1.0f;
        }
        if (b == Blocks.field_150463_bK) {
            return 0.25f;
        }
        if (b == Blocks.field_150410_aZ) {
            return 0.5f;
        }
        if (b.func_149753_y() > 0.875 && b.func_149669_A() > 0.875 && b.func_149693_C() > 0.875 && b.func_149704_x() < 0.125 && b.func_149665_z() < 0.125 && b.func_149706_B() < 0.125) {
            return 0.0f;
        }
        double dx = b.func_149753_y() - b.func_149704_x();
        double dy = b.func_149669_A() - b.func_149665_z();
        double dz = b.func_149693_C() - b.func_149706_B();
        if (b.func_149753_y() <= 0.125 || b.func_149704_x() >= 0.875) {
            dx = 0.0;
        }
        if (b.func_149669_A() <= 0.125 || b.func_149665_z() >= 0.875) {
            dy = 0.0;
        }
        if (b.func_149693_C() <= 0.125 || b.func_149706_B() >= 0.875) {
            dz = 0.0;
        }
        if (b.func_149669_A() >= 0.75) {
            dy += 0.125;
        }
        double frac = 1.0 - dx * dy * dz;
        return (float)frac;
    }

    private void heatJet(World world, int x, int y, int z, int meta) {
        int z1;
        int x2;
        int x1;
        if (this.isOn() && this.getTicksExisted() % 10 == 0) {
            int max = this.getMaxExhaustTemperature() * this.omega / this.type.getSpeed();
            if (max > this.temperature) {
                this.temperature = Math.min(this.temperature + Math.max(1, (max - this.temperature) / 16), max);
            } else if (!this.isAfterburning()) {
                this.temperature = Math.max(this.temperature - Math.max(1, (this.temperature - max) / 32), max);
            }
        }
        int T = this.temperature;
        int r = this.isAfterburning() ? 6 : 4;
        for (int i = 1; i < r; ++i) {
            int dx = x + this.write.offsetX * i;
            int dz = z + this.write.offsetZ * i;
            TileEntity te = this.getTileEntity(dx, y, dz);
            if (te instanceof TemperatureTE) {
                if (((TemperatureTE)te).allowExternalHeating()) {
                    int dT = T - ((TemperatureTE)te).getTemperature();
                    ((TemperatureTE)te).addTemperature(dT);
                }
            } else if (te instanceof ThermalMachine) {
                ((ThermalMachine)te).setTemperature(T);
            }
            if (!this.isAfterburning()) continue;
            ReikaWorldHelper.temperatureEnvironment((World)world, (int)dx, (int)y, (int)dz, (int)Math.min(1400, T));
        }
        int n = this.write.offsetX != 0 ? (this.write.offsetX > 0 ? x : x - 4) : (x1 = x);
        int n2 = this.write.offsetX != 0 ? (this.write.offsetX > 0 ? x + 5 : x + 1) : (x2 = x + 1);
        int n3 = this.write.offsetZ != 0 ? (this.write.offsetZ > 0 ? z : z - 4) : (z1 = z);
        int z2 = this.write.offsetZ != 0 ? (this.write.offsetZ > 0 ? z + 5 : z + 1) : z + 1;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x1, (double)y, (double)z1, (double)x2, (double)(y + 1), (double)z2);
        List li = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            RotaryCraft.heatDamage.lastMachine = this;
            e.func_70097_a((DamageSource)RotaryCraft.heatDamage, this.isAfterburning() ? 4.0f : 1.0f);
        }
    }

    public int getMaxExhaustTemperature() {
        return this.isAfterburning() ? 1750 : 1200;
    }

    @Override
    public int getMaxTemperature() {
        return this.isAfterburning() ? 2000 : 1500;
    }

    private void ingest(World world, int x, int y, int z, int meta) {
        if (this.FOD >= 8) {
            return;
        }
        ForgeDirection dir = this.getWriteDirection().getOpposite();
        double px = (double)x + 0.5 + (double)dir.offsetX * 0.49;
        double pz = (double)z + 0.5 + (double)dir.offsetZ * 0.49;
        for (int step = 0; step < 8; ++step) {
            AxisAlignedBB zone = this.getSuctionZone(world, x, y, z, meta, step);
            List inzone = world.func_72872_a(Entity.class, zone);
            for (Entity caught : inzone) {
                if (!this.canSuckTowards(world, x, y, z, caught, px, pz)) continue;
                float mult = this.getSuctionMultiplier(caught);
                if (mult > 0.0f) {
                    caught.field_70159_w += ((double)x + 0.5 - caught.field_70165_t) / 20.0 * (double)mult;
                    caught.field_70181_x += ((double)y + 0.5 - caught.field_70163_u) / 20.0 * (double)mult;
                    caught.field_70179_y += ((double)z + 0.5 - caught.field_70161_v) / 20.0 * (double)mult;
                    if (!world.field_72995_K) {
                        caught.field_70133_I = true;
                    }
                }
                if (!(ReikaMathLibrary.py3d((double)(caught.field_70165_t - px), (double)(caught.field_70163_u - ((double)y + 0.5)), (double)(caught.field_70161_v - pz)) < 1.2)) continue;
                this.ingest(world, x, y, z, caught, mult <= 0.0f);
            }
        }
    }

    private boolean canSuckTowards(World world, int x, int y, int z, Entity e, double px, double pz) {
        int n = 2;
        for (int i = 0; i <= n; ++i) {
            tracer.setOrigins(px, (double)y + 0.5, pz, e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O * (float)i / (float)n), e.field_70161_v);
            if (!tracer.isClearLineOfSight(world)) continue;
            return true;
        }
        return false;
    }

    private float getSuctionMultiplier(Entity e) {
        if (e instanceof EntityPlayer) {
            EntityPlayer epl = (EntityPlayer)e;
            if (epl.field_71075_bZ.field_75098_d) {
                return 0.0f;
            }
            ItemStack is = epl.func_82169_q(0);
            if (is != null) {
                if (is.func_77973_b() == ItemRegistry.BEDBOOTS.getItemInstance()) {
                    return 0.1f;
                }
                if (is.func_77973_b() == ItemRegistry.BEDJUMP.getItemInstance()) {
                    return 0.1f;
                }
            }
        }
        if (e instanceof EntityTurretShot) {
            return 0.0f;
        }
        if (e instanceof EntityDragon) {
            return 0.0f;
        }
        if (ModList.VOIDMONSTER.isLoaded() && e instanceof EntityVoidMonster) {
            if (e.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 16.0) {
                this.isJetFailing = true;
                this.temperature += 2;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    private void ingest(World world, int x, int y, int z, Entity e, boolean immune) {
        if (e instanceof EntityItem) {
            if (!e.field_70128_L) {
                ItemStack is = ((EntityItem)e).func_92059_d();
                e.func_70106_y();
                for (int trycount = 0; trycount < 1 && !ReikaWorldHelper.nonSolidBlocks((IBlockAccess)world, (int)this.dumpx, (int)y, (int)this.dumpz); ++trycount) {
                    if (this.dumpvx == 1) {
                        ++this.dumpx;
                    }
                    if (this.dumpvx == -1) {
                        --this.dumpx;
                    }
                    if (this.dumpvz == 1) {
                        ++this.dumpz;
                    }
                    if (this.dumpvz != -1) continue;
                    --this.dumpz;
                }
                EntityItem item = new EntityItem(world, (double)this.dumpx + 0.5, (double)y + 0.375, (double)this.dumpz + 0.5, is);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)item);
                }
                item.field_70159_w = (double)this.dumpvx * 1.5;
                item.field_70181_x = 0.15;
                item.field_70179_y = (double)this.dumpvz * 1.5;
                ItemStack repl = this.modifyIngestedItem(item.func_92059_d());
                if (repl == null) {
                    item.func_70106_y();
                } else {
                    item.func_92058_a(repl);
                }
                if (!world.field_72995_K) {
                    e.field_70133_I = true;
                }
                if (this.itemDestroysEngine(is)) {
                    e.func_70106_y();
                    this.FOD = 2;
                    this.triggerJetFailing(world, x, y, z);
                }
            }
        } else if (e instanceof EntityXPOrb) {
            if (!e.field_70128_L) {
                int xp = ((EntityXPOrb)e).func_70526_d();
                e.func_70106_y();
                for (int trycount = 0; trycount < 1 && !ReikaWorldHelper.nonSolidBlocks((IBlockAccess)world, (int)this.dumpx, (int)y, (int)this.dumpz); ++trycount) {
                    if (this.dumpvx == 1) {
                        ++this.dumpx;
                    }
                    if (this.dumpvx == -1) {
                        --this.dumpx;
                    }
                    if (this.dumpvz == 1) {
                        ++this.dumpz;
                    }
                    if (this.dumpvz != -1) continue;
                    --this.dumpz;
                }
                EntityXPOrb item = new EntityXPOrb(world, (double)this.dumpx + 0.5, (double)y + 0.375, (double)this.dumpz + 0.5, xp);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)item);
                }
                item.field_70159_w = (double)this.dumpvx * 1.5;
                item.field_70181_x = 0.15;
                item.field_70179_y = (double)this.dumpvz * 1.5;
                if (!world.field_72995_K) {
                    e.field_70133_I = true;
                }
            }
        } else if (!(!(e instanceof EntityLivingBase) || e instanceof EntityPlayer && immune)) {
            e.func_70015_d(2);
            if (!world.field_72995_K && ((EntityLivingBase)e).func_110143_aJ() > 0.0f && this.canDamageEngine(e)) {
                this.damageEngine();
            }
            if (this.FOD > 8) {
                this.FOD = 8;
            }
            if (e instanceof EntityChicken && !e.field_70128_L && ((EntityChicken)e).func_110143_aJ() > 0.0f) {
                ++this.chickenCount;
                if (this.chickenCount >= 50) {
                    RotaryAchievements.JETCHICKEN.triggerAchievement(this.getPlacer());
                }
            }
            if (!(e.field_70128_L || e instanceof EntityLivingBase && ((EntityLivingBase)e).func_110143_aJ() < 0.0f)) {
                SoundRegistry.INGESTION.playSoundAtBlock(world, x, y, z, 1.0f, 1.4f);
            }
            RotaryCraft.jetingest.lastMachine = this;
            e.func_70097_a((DamageSource)RotaryCraft.jetingest, 10000.0f);
            if (e instanceof EntityPlayer && e == this.getPlacer()) {
                RotaryAchievements.SUCKEDINTOJET.triggerAchievement((EntityPlayer)e);
            }
        }
    }

    private ItemStack modifyIngestedItem(ItemStack is) {
        if (is.func_77973_b() instanceof ItemArmor && is.func_77973_b().func_77645_m()) {
            ItemArmor ia = (ItemArmor)is.func_77973_b();
            int max = ia.func_82812_d().func_78046_a(ia.field_77881_a);
            int after = is.func_77960_j() + rand.nextInt(200);
            if (after >= max) {
                return null;
            }
            is.func_77964_b(after);
        } else if (is.func_77973_b() instanceof ItemTool && is.func_77973_b().func_77645_m()) {
            ItemTool ia = (ItemTool)is.func_77973_b();
            int max = ia.getMaxDamage(is);
            int after = is.func_77960_j() + rand.nextInt(40);
            if (after >= max) {
                return null;
            }
            is.func_77964_b(after);
        }
        if (ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150348_b)) {
            is.func_150996_a(Item.func_150898_a((Block)Blocks.field_150347_e));
            this.FOD += 4;
        } else if (ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150347_e)) {
            is.func_150996_a(Item.func_150898_a((Block)Blocks.field_150351_n));
            this.FOD += 2;
        } else if (ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150351_n)) {
            is.func_150996_a(Item.func_150898_a((Block)Blocks.field_150354_m));
            ++this.FOD;
        }
        return is;
    }

    private void triggerJetFailing(World world, int x, int y, int z) {
        RotaryCraft.logger.warn((Object)(this + " just entered failure mode!"));
        this.isJetFailing = true;
        RotaryAchievements.JETFAIL.triggerAchievement(this.getPlacer());
        MinecraftForge.EVENT_BUS.post((Event)new JetEngineEnterFailureEvent((TileEntity)this));
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode", (float)2.0f, (float)0.75f);
        SoundRegistry.INGESTION.playSoundAtBlock((TileEntity)this, 0.5f, 1.0f);
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72321_a((double)(this.write.offsetX * 8), (double)y, (double)(this.write.offsetZ * 8)).func_72314_b(3.0, 3.0, 3.0);
        List li = world.func_72872_a(EntityLivingBase.class, box);
        HashSet<Integer> idSet = new HashSet<Integer>();
        for (EntityLivingBase e : li) {
            e.func_70097_a(DamageSource.field_76377_j, 8.0f);
            idSet.add(e.func_145782_y());
        }
        box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(4.0, 4.0, 4.0);
        li = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            if (idSet.contains(e.func_145782_y())) continue;
            e.func_70097_a(DamageSource.field_76377_j, 4.0f);
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 24; ++i) {
                EntityItem ei = new EntityItem(world, (double)x + 0.5 + (double)this.write.offsetX, (double)y + 0.5, (double)z + 0.5 + (double)this.write.offsetZ, ItemStacks.scrap);
                double v = ReikaRandomHelper.getRandomBetween((double)0.8, (double)2.0);
                ei.field_70159_w = (double)this.write.offsetX * v;
                ei.field_70179_y = (double)this.write.offsetZ * v;
                ei.field_70159_w = ReikaRandomHelper.getRandomPlusMinus((double)ei.field_70159_w, (double)0.25);
                ei.field_70179_y = ReikaRandomHelper.getRandomPlusMinus((double)ei.field_70179_y, (double)0.25);
                ei.field_70181_x = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.25);
                ei.lifespan = ReikaRandomHelper.getRandomBetween((int)10, (int)30);
                world.func_72838_d((Entity)ei);
            }
            int r = 8;
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    for (int k = -r; k <= r; ++k) {
                        int dx = x + i;
                        int dy = y + j;
                        int dz = z + k;
                        ReikaRenderHelper.spawnDropParticles((World)world, (int)x, (int)y, (int)z, (Block)world.func_147439_a(dx, dy, dz), (int)world.func_72805_g(dx, dy, dz));
                    }
                }
            }
        }
    }

    private boolean itemDestroysEngine(ItemStack is) {
        return is.func_77973_b() == ItemRegistry.SCREWDRIVER.getItemInstance() || InterfaceCache.IWRENCH.instanceOf((Object)is.func_77973_b());
    }

    private void damageEngine() {
        ++this.FOD;
        if (DifficultyEffects.JETINGESTFAIL.testChance()) {
            this.isJetFailing = true;
            this.temperature = Math.max(this.temperature, 800);
        }
    }

    private boolean canDamageEngine(Entity caught) {
        if (caught.field_70145_X) {
            return false;
        }
        if (caught instanceof EtherealEntity) {
            return false;
        }
        if (caught instanceof EntityChicken) {
            return false;
        }
        if (caught instanceof EntityBat) {
            return false;
        }
        if (caught instanceof EntitySilverfish) {
            return false;
        }
        if (caught instanceof EntityItem) {
            return false;
        }
        if (caught instanceof EntityXPOrb) {
            return false;
        }
        if (ModList.THAUMCRAFT.isLoaded() && caught instanceof EntityWisp) {
            return false;
        }
        String name = caught.func_70005_c_().toLowerCase(Locale.ENGLISH);
        if (name.contains("bird")) {
            return false;
        }
        if (name.contains("firefly")) {
            return false;
        }
        if (name.contains("butterfly")) {
            return false;
        }
        return caught instanceof EntityLivingBase;
    }

    private AxisAlignedBB getSuctionZone(World world, int x, int y, int z, int meta, int step) {
        int minx = 0;
        int miny = 0;
        int minz = 0;
        int maxx = 0;
        int maxy = 0;
        int maxz = 0;
        switch (meta) {
            case 0: {
                minx = x + 1 + step;
                maxx = x + 1 + step + 1;
                miny = y - step;
                maxy = y + step + 1;
                minz = z - step;
                maxz = z + step + 1;
                this.dumpx = x - 1;
                this.dumpz = z;
                this.dumpvx = -1;
                this.dumpvz = 0;
                break;
            }
            case 1: {
                minx = x - 1 - step;
                maxx = x - 1 - step + 1;
                miny = y - step;
                maxy = y + step + 1;
                minz = z - step;
                maxz = z + step + 1;
                this.dumpx = x + 1;
                this.dumpz = z;
                this.dumpvx = 1;
                this.dumpvz = 0;
                break;
            }
            case 2: {
                minz = z + 1 + step;
                maxz = z + 1 + step + 1;
                miny = y - step;
                maxy = y + step + 1;
                minx = x - step;
                maxx = x + step + 1;
                this.dumpx = x;
                this.dumpz = z - 1;
                this.dumpvx = 0;
                this.dumpvz = -1;
                break;
            }
            case 3: {
                minz = z - 1 - step;
                maxz = z - 1 - step + 1;
                miny = y - step;
                maxy = y + step + 1;
                minx = x - step;
                maxx = x + step + 1;
                this.dumpx = x;
                this.dumpz = z + 1;
                this.dumpvx = 0;
                this.dumpvz = 1;
            }
        }
        return AxisAlignedBB.func_72330_a((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz).func_72314_b(0.25, 0.25, 0.25);
    }

    public void repairJet() {
        this.FOD = 0;
        this.isJetFailing = false;
        this.temperature = Math.max(ReikaWorldHelper.getAmbientTemperatureAt((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e), this.temperature / 2);
    }

    public void repairJetPartial() {
        if (this.FOD > 0) {
            --this.FOD;
        }
    }

    public void repairJetCC(int tier) {
        if (this.FOD > 0 && rand.nextInt(20 - tier * 2) == 0) {
            --this.FOD;
        }
        if (this.FOD == 0 && tier > 3) {
            this.repairJet();
        }
    }

    private void jetEngineDetonation(World world, int x, int y, int z, int meta) {
        AxisAlignedBB zone = this.getFlameZone(world, x, y, z, meta);
        List in = world.func_72872_a(EntityLivingBase.class, zone);
        for (EntityLivingBase e : in) {
            e.func_70015_d(2);
        }
        double vx = (double)(x - this.backx) / 2.0;
        double vz = (double)(z - this.backz) / 2.0;
        for (int i = 0; i < 16; ++i) {
            String part = i % 2 == 0 ? "flame" : "smoke";
            world.func_72869_a(part, (double)x + 0.25 + 0.5 * rand.nextDouble(), (double)y + 0.25 + 0.5 * rand.nextDouble(), (double)z + 0.25 + 0.5 * rand.nextDouble(), vx - 0.1 + 0.2 * rand.nextDouble(), -0.1 + 0.2 * rand.nextDouble(), vz - 0.1 + 0.2 * rand.nextDouble());
        }
        int dx = x - this.backx;
        int dz = z - this.backz;
        for (int i = 0; i < 16; ++i) {
            ReikaWorldHelper.temperatureEnvironment((World)world, (int)(x + dx * i), (int)y, (int)(z + dz * i), (int)800);
        }
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 1.0f, 1.0f);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (this.fuel.getLevel() < 20000 && rand.nextInt(10) == 0) {
                ReikaPacketHelper.sendDataPacketWithRadius((String)"RotaryCraftData", (int)PacketRegistry.ENGINEBACKFIRE.ordinal(), (TileEntity)this, (int)64, (int[])new int[0]);
                this.backFire(world, x, y, z);
            }
            if (this.fuel.getLevel() < 60000 && rand.nextInt(20) == 0) {
                ReikaPacketHelper.sendDataPacketWithRadius((String)"RotaryCraftData", (int)PacketRegistry.ENGINEBACKFIRE.ordinal(), (TileEntity)this, (int)64, (int[])new int[0]);
                this.backFire(world, x, y, z);
            } else if (rand.nextInt(40) == 0) {
                ReikaPacketHelper.sendDataPacketWithRadius((String)"RotaryCraftData", (int)PacketRegistry.ENGINEBACKFIRE.ordinal(), (TileEntity)this, (int)64, (int[])new int[0]);
                this.backFire(world, x, y, z);
            }
        }
        if (rand.nextInt(2) == 0) {
            ++this.temperature;
        }
        if (this.temperature >= 800) {
            RotaryCraft.logger.warn((Object)("WARNING: " + this + " is near explosion!"));
        }
        if (this.temperature > 1000) {
            this.fail(world, x, y, z);
        }
    }

    private void fail(World world, int x, int y, int z) {
        MinecraftForge.EVENT_BUS.post((Event)new JetEngineExplosionEvent((TileEntity)this));
        int r = 6;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    if (ConfigRegistry.BLOCKDAMAGE.getState()) {
                        ReikaWorldHelper.temperatureEnvironment((World)world, (int)(x + i), (int)(y + j), (int)(z + k), (int)1000);
                    }
                    world.func_72869_a("lava", (double)(x + i), (double)(y + j), (double)(z + k), 0.0, 0.0, 0.0);
                    world.func_72869_a("lava", (double)(x + i), (double)(y + j), (double)(z + k), rand.nextDouble() - 0.5, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5);
                }
            }
        }
        if (!world.field_72995_K) {
            world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 12.0f, true, true);
            for (int m = 0; m < 6; ++m) {
                world.func_72885_a(null, (double)(x - 4 + rand.nextInt(11)), (double)(y - 4 + rand.nextInt(11)), (double)(z - 4 + rand.nextInt(11)), 4.0f + rand.nextFloat() * 2.0f, true, true);
            }
        }
    }

    public void backFire(World world, int x, int y, int z) {
        double vx = (double)(x - this.backx) / 2.0;
        double vz = (double)(z - this.backz) / 2.0;
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 2.0f * rand.nextFloat(), false);
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode", (float)1.0f, (float)0.5f);
        for (int i = 0; i < 32; ++i) {
            String part = i % 2 == 0 ? "flame" : "smoke";
            world.func_72869_a(part, (double)x + 0.25 + 0.5 * rand.nextDouble(), (double)y + 0.25 + 0.5 * rand.nextDouble(), (double)z + 0.25 + 0.5 * rand.nextDouble(), -vx - 0.1 + 0.2 * rand.nextDouble(), -0.1 + 0.2 * rand.nextDouble(), -vz - 0.1 + 0.2 * rand.nextDouble());
        }
    }

    private AxisAlignedBB getFlameZone(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                return AxisAlignedBB.func_72330_a((double)(x - 6), (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case 1: {
                return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 7), (double)(y + 1), (double)(z + 1));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)(z - 6), (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 7));
            }
        }
        return null;
    }

    private void launchEntities(World world, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(8.0, 8.0, 8.0);
        List inbox = world.func_72872_a(Entity.class, box);
        for (Entity e : inbox) {
            double dx = e.field_70165_t - (double)x - 0.5;
            double dy = e.field_70163_u - (double)y - 0.5;
            double dz = e.field_70161_v - (double)z - 0.5;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            e.field_70159_w += 2.0 * dx / dd;
            e.field_70181_x += 2.0 * dy / dd;
            e.field_70179_y += 2.0 * dz / dd;
            if (!world.field_72995_K) {
                e.field_70133_I = true;
            }
            if (!(e instanceof EntityPainting) && !(e instanceof EntityItemFrame)) continue;
            e.func_70097_a(DamageSource.field_76377_j, 10.0f);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("choke", this.isChoking);
        NBT.func_74757_a("jetfail", this.isJetFailing);
        NBT.func_74757_a("burn", this.canAfterBurn);
        NBT.func_74757_a("burning", this.burnerActive);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isChoking = NBT.func_74767_n("choke");
        this.isJetFailing = NBT.func_74767_n("jetfail");
        this.canAfterBurn = NBT.func_74767_n("burn");
        this.burnerActive = NBT.func_74767_n("burning");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("FOD", this.FOD);
        NBT.func_74768_a("chickens", this.chickenCount);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.FOD = NBT.func_74762_e("FOD");
        this.chickenCount = NBT.func_74762_e("chickens");
    }

    @Override
    protected void playSounds(World world, int x, int y, int z, float pitchMultiplier, float volume) {
        ++this.soundtick;
        ++this.afterburnTick;
        if (this.FOD > 0 && rand.nextInt(2 * (9 - this.FOD)) == 0) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 1.0f + rand.nextFloat(), 1.0f);
            world.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
        }
        if (this.isMuffled(world, x, y, z)) {
            volume *= 0.3125f;
        }
        if (this.isAfterburning() && this.afterburnTick >= 50) {
            this.afterburnTick = 0;
            float vol = 0.9f;
            if (this.omega < this.type.getSpeed()) {
                vol = (float)((double)vol * Math.pow(0.75, this.type.getSpeed() / this.omega));
            }
            SoundRegistry.AFTERBURN.playSoundAtBlock(world, x, y, z, vol, 1.0f);
            SoundRegistry.AFTERBURN.playSoundAtBlock(world, x, y, z, vol, 1.0f);
        }
        if (this.soundtick < this.getSoundLength(1.0f / pitchMultiplier) && this.soundtick < 2000) {
            return;
        }
        this.soundtick = 0;
        float pitch = 1.0f;
        pitch = 1.0f / (0.125f * (float)this.FOD + 1.0f);
        if (this.jetstarttimer.getTick() >= this.jetstarttimer.getCap()) {
            SoundRegistry.JET.playSoundAtBlock(world, x, y, z, volume, pitch * pitchMultiplier);
        } else {
            this.soundtick = 2000;
        }
    }

    public boolean isAfterburning() {
        return this.canAfterBurn && this.burnerActive;
    }

    @Override
    public boolean hasTemperature() {
        return true;
    }

    @Override
    public int getMaxSpeed(World world, int x, int y, int z, int meta) {
        return (int)((float)EngineType.JET.getSpeed() * this.getChokedFraction(world, x, y, z, meta));
    }

    @Override
    protected boolean canStart() {
        return true;
    }

    @Override
    protected int getGenTorque(World world, int x, int y, int z, int meta) {
        int amt = EngineType.JET.getTorque();
        if (this.isAfterburning()) {
            amt *= 2;
        }
        return amt / ReikaMathLibrary.intpow2((int)2, (int)this.FOD);
    }

    @Override
    protected void affectSurroundings(World world, int x, int y, int z, int meta) {
        this.checkJetFailure(world, x, y, z, meta);
        this.ingest(world, x, y, z, meta);
        this.fluidIngest(world, x, y, z);
        this.heatJet(world, x, y, z, meta);
        if (this.lastpower == 0L) {
            SoundRegistry.JETSTART.playSoundAtBlock(world, x, y, z);
        }
        if (world.field_72995_K) {
            this.spawnSmokeParticles(world, x, y, z, meta);
        }
        this.jetstarttimer.update();
        this.doAfterburning(world, x, y, z);
    }

    private void fluidIngest(World world, int x, int y, int z) {
        int dx = x + this.write.getOpposite().offsetX;
        int dz = z + this.write.getOpposite().offsetZ;
        Block b = world.func_147439_a(dx, y, dz);
        Fluid f = ReikaFluidHelper.lookupFluidForBlock((Block)b);
        if (f != null) {
            if (this.field_145850_b.field_72995_K) {
                this.fluidIngestParticles(world, x, y, z, f);
            } else {
                int temp = f.getTemperature(world, dx, y, dz);
                if (f.getName().toLowerCase(Locale.ENGLISH).contains("fuel")) {
                    if (!this.isJetFailing && rand.nextInt(200) == 0) {
                        this.temperature = 900;
                        this.isJetFailing = true;
                        this.jetEngineDetonation(world, x, y, z, this.func_145832_p());
                    }
                } else if (temp >= 500 && (temp >= 2000 || rand.nextInt(1 + (2000 - temp) / 500) == 0) && this.FOD < 8 && world.func_82737_E() % 20L == 0L && rand.nextInt(1 + 2 * this.FOD) == 0) {
                    this.damageEngine();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void fluidIngestParticles(World world, int x, int y, int z, Fluid f) {
        int n = 1 + rand.nextInt(8);
        for (int i = 0; i < n; ++i) {
            double vx = (double)(x - this.backx) / 4.0;
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.0625);
            double vz = (double)(z - this.backz) / 4.0;
            vx = ReikaRandomHelper.getRandomPlusMinus((double)vx, (double)0.0625);
            vz = ReikaRandomHelper.getRandomPlusMinus((double)vz, (double)0.0625);
            EntityLiquidParticleFX fx = new EntityLiquidParticleFX(world, (double)x + 0.5 + (double)this.write.offsetX * 0.25, (double)y + 0.5, (double)z + 0.5 + (double)this.write.offsetZ * 0.25, vx, vy, vz, f);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void doAfterburning(World world, int x, int y, int z) {
        if (this.isAfterburning()) {
            this.afterBurnParticles(world, x, y, z);
            if (this.getTicksExisted() % 200 == 0) {
                ++this.temperature;
                if (this.temperature > this.getMaxTemperature()) {
                    this.temperature = this.getMaxTemperature();
                    this.fail(world, x, y, z);
                } else if (this.temperature >= 600) {
                    ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
                    ReikaParticleHelper.SMOKE.spawnAroundBlock(world, x, y, z, 8);
                }
            }
        }
    }

    private void afterBurnParticles(World world, int x, int y, int z) {
        double dx = x - this.backx;
        double dz = z - this.backz;
        dx /= 2.0;
        dz /= 2.0;
        double vx = (double)(x - this.backx) * 6.0;
        double vz = (double)(z - this.backz) * 6.0;
        for (int i = 0; i < 16; ++i) {
            int r = 255;
            int g = 0;
            int b = 0;
            double px = dx + (double)x + 0.25 + 0.5 * rand.nextDouble() + vx * rand.nextDouble();
            double pz = dz + (double)z + 0.25 + 0.5 * rand.nextDouble() + vz * rand.nextDouble();
            double dd = Math.abs(px - (double)x) + Math.abs(pz - (double)z);
            if (dd < 1.5 + rand.nextDouble()) {
                r = 0;
                g = 127;
                b = 255;
            } else if (dd < 2.5 + rand.nextDouble()) {
                r = 255;
                g = 255;
                b = 255;
            } else if (dd < 3.0 + rand.nextDouble() * 2.0) {
                g = 255;
            } else if (dd < 5.0 + rand.nextDouble() * 3.0 && rand.nextBoolean()) {
                g = 10;
            }
            ReikaParticleHelper.spawnColoredParticleAt((World)world, (double)px, (double)((double)y + 0.75 * rand.nextDouble()), (double)pz, (double)r, (double)g, (double)b);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnSmokeParticles(World world, int x, int y, int z, int meta) {
        double dx = x - this.backx;
        double dz = z - this.backz;
        double vx = (double)(-(x - this.backx)) / 2.0;
        double vz = (double)(-(z - this.backz)) / 2.0;
        ReikaParticleHelper.SMOKE.spawnAt(world, (dx /= 2.0) + (double)x + 0.25 + 0.5 * rand.nextDouble(), (double)y + 0.5 * rand.nextDouble(), (dz /= 2.0) + (double)z + 0.25 + 0.5 * rand.nextDouble(), -vx - 0.1 + 0.2 * rand.nextDouble(), -0.1 + 0.2 * rand.nextDouble(), -vz - 0.1 + 0.2 * rand.nextDouble());
        int n = 1 + rand.nextInt(8);
        double w = (double)n / 2.0;
        dx = this.write.offsetX == 0 ? ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)w) : (double)x + 0.5 - (double)(n * this.write.offsetX);
        double dy = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5), (double)w);
        dz = this.write.offsetZ == 0 ? ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)w) : (double)z + 0.5 - (double)(n * this.write.offsetZ);
        double v = -0.0625;
        vx = v * (dx - (double)x - 0.5);
        double vy = v * (dy - (double)y - 0.5);
        vz = v * (dz - (double)z - 0.5);
        int bx = MathHelper.func_76128_c((double)dx);
        int by = MathHelper.func_76128_c((double)dy);
        int bz = MathHelper.func_76128_c((double)dz);
        Block b = world.func_147439_a(bx, by, bz);
        int bmeta = world.func_72805_g(bx, by, bz);
        if (b.isAir((IBlockAccess)world, bx, by, bz)) {
            if (rand.nextInt(3) == 0) {
                ReikaParticleHelper.CLOUD.spawnAt(world, dx, dy, dz, vx, vy, vz);
            }
        } else {
            EntityBlockTexFX fx = new EntityBlockTexFX(world, dx, dy + 1.0, dz, vx, vy - 0.03125, vz, b, bmeta).setGravity(0.0f);
            fx.func_70596_a(bx, by, bz);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    protected void resetPower() {
        super.resetPower();
        this.jetstarttimer.reset();
    }

    @Override
    protected int getSoundLength(float factor) {
        return super.getSoundLength(factor) + (int)((float)(Math.min(this.FOD, 7) * 11) * factor);
    }

    @Override
    public void setDataFromPlacer(ItemStack is) {
        super.setDataFromPlacer(is);
        if (is.field_77990_d != null) {
            this.FOD = is.field_77990_d.func_74762_e("damage");
        }
    }

    @Override
    public boolean isBroken() {
        return this.FOD >= 8;
    }

    @Override
    public NBTTagCompound getTagsToWriteToStack() {
        if (this.canAfterBurn) {
            NBTTagCompound NBT = new NBTTagCompound();
            NBT.func_74757_a("burn", this.canAfterBurn);
            return NBT;
        }
        return null;
    }

    @Override
    public void setDataFromItemStackTag(NBTTagCompound NBT) {
        this.canAfterBurn = NBT != null && NBT.func_74767_n("burn");
    }

    @Override
    public ArrayList<NBTTagCompound> getCreativeModeVariants() {
        return new ArrayList<NBTTagCompound>();
    }

    @Override
    public ArrayList<String> getDisplayTags(NBTTagCompound NBT) {
        ArrayList<String> li = new ArrayList<String>();
        if (NBT != null && NBT.func_74767_n("burn")) {
            li.add("With Afterburner");
        }
        return li;
    }

    @Override
    public void upgrade(ItemStack is) {
        this.canAfterBurn = true;
    }

    @Override
    public boolean canUpgradeWith(ItemStack item) {
        return !this.canAfterBurn && ItemRegistry.UPGRADE.matchItem(item) && item.func_77960_j() == ItemEngineUpgrade.Upgrades.AFTERBURNER.ordinal();
    }

    public boolean canAfterBurn() {
        return this.canAfterBurn;
    }

    public boolean burnerActive() {
        return this.burnerActive;
    }

    public void setBurnerActive(boolean burn) {
        this.burnerActive = burn;
    }

    @Override
    public void breakBlock() {
        super.breakBlock();
        if (this.canAfterBurn) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)ItemRegistry.UPGRADE.getStackOfMetadata(ItemEngineUpgrade.Upgrades.AFTERBURNER.ordinal()));
        }
    }

    @Override
    public boolean allowHeatExtraction() {
        return true;
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }
}

