/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.InventoriedRCTileEntity;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityComposter
extends InventoriedRCTileEntity
implements TemperatureTE {
    private int temperature;
    private StepTimer tempTimer = new StepTimer(20);
    private StepTimer timer = new StepTimer(100);
    public int composterCookTime;
    public static final int MINTEMP = 40;
    public static final int KILLTEMP = 70;
    public static final int MAXTEMP = 100;

    public static final ArrayList<ItemStack> getAllCompostables() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < CompostMatter.list.length; ++i) {
            items.addAll(CompostMatter.list[i].getAllItems());
        }
        return items;
    }

    public static int getCompostValue(ItemStack is) {
        CompostMatter c = CompostMatter.getMatterType(is);
        return c != null ? c.value : 0;
    }

    public int getScaledTimer(int a) {
        return a * this.composterCookTime / this.timer.getCap();
    }

    public int getScaledTemperature(int a) {
        return a * this.temperature / 100;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        int value;
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        if ((value = this.getCompostValue()) <= 0) {
            return;
        }
        int time = 1 + (this.temperature - 40) / 4;
        this.timer.update(time);
        if (this.timer.checkCap()) {
            ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
            ReikaInventoryHelper.addOrSetStack((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.compost, (int)value), (ItemStack[])this.inv, (int)2);
            if (rand.nextInt(75 - this.temperature) == 0) {
                ReikaInventoryHelper.decrStack((int)1, (ItemStack[])this.inv);
            }
            this.composterCookTime = 0;
        }
        this.composterCookTime = this.timer.getTick();
    }

    private int getCompostValue() {
        if (this.temperature < 40 || this.temperature > 70) {
            return 0;
        }
        if (this.inv[0] == null || this.inv[1] == null) {
            return 0;
        }
        if (this.inv[1].func_77973_b() != ItemRegistry.YEAST.getItemInstance()) {
            return 0;
        }
        CompostMatter c = CompostMatter.getMatterType(this.inv[0]);
        if (c == null) {
            return 0;
        }
        if (this.inv[2] == null) {
            return c.value;
        }
        if (!ReikaItemHelper.matchStacks((ItemStack)this.inv[2], (ItemStack)ItemStacks.compost)) {
            return 0;
        }
        return this.inv[2].field_77994_a + c.value <= this.inv[2].func_77976_d() ? c.value : 0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i == 2) {
            return false;
        }
        if (i == 1) {
            return itemstack.func_77973_b() == ItemRegistry.YEAST.getItemInstance();
        }
        return CompostMatter.getMatterType(itemstack) != null;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return ReikaItemHelper.matchStacks((ItemStack)itemstack, (ItemStack)ItemStacks.compost);
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (RotaryAux.isNextToWater(world, x, y, z)) {
            Tamb -= 5;
        }
        if (RotaryAux.isNextToIce(world, x, y, z)) {
            Tamb -= 15;
        }
        if (RotaryAux.isNextToFire(world, x, y, z)) {
            Tamb += 50;
        }
        if (RotaryAux.isNextToLava(world, x, y, z)) {
            Tamb += 200;
        }
        if (this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > Tamb * 2) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (this.temperature * 2 < Tamb) {
            ++this.temperature;
        }
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.COMPOSTER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temperature");
        this.composterCookTime = NBT.func_74762_e("timer");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temperature", this.temperature);
        NBT.func_74768_a("timer", this.composterCookTime);
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    @Override
    public boolean allowExternalHeating() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public int getMaxTemperature() {
        return 100;
    }

    @Override
    public boolean allowHeatExtraction() {
        return false;
    }

    private static enum CompostMatter {
        CRAP(1, Items.field_151110_aK, Items.field_151106_aX, Items.field_151015_O, ItemStacks.canolaSeeds, ItemStacks.canolaHusks),
        SUGARCANE(2, Items.field_151120_aE),
        PLANT(1, Blocks.field_150345_g, Blocks.field_150392_bi, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150338_P, Blocks.field_150337_Q),
        LEAF(2, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150349_c, Blocks.field_150395_bd, Blocks.field_150329_H, Blocks.field_150398_cm),
        MEAT(4, Items.field_151082_bd, Items.field_151083_be, Items.field_151157_am, Items.field_151147_al, Items.field_151077_bg, Items.field_151076_bf),
        FISH(3, Items.field_151101_aQ, Items.field_151115_aP),
        VEGGIE(2, Items.field_151174_bG, Items.field_151172_bF, Items.field_151168_bH, Items.field_151170_bI, Items.field_151025_P, Items.field_151034_e, Items.field_151127_ba),
        MOBS(3, Items.field_151078_bh, Items.field_151070_bp);

        private ArrayList<ItemStack> items = new ArrayList();
        public final int value;
        public static final CompostMatter[] list;

        private CompostMatter(int value, Object ... items) {
            this.value = value;
            for (int i = 0; i < items.length; ++i) {
                ItemStack is = null;
                if (items[i] instanceof ItemStack) {
                    is = (ItemStack)items[i];
                } else if (items[i] instanceof Block) {
                    is = new ItemStack((Block)items[i], 1, Short.MAX_VALUE);
                } else if (items[i] instanceof Item) {
                    is = new ItemStack((Item)items[i], 1, Short.MAX_VALUE);
                } else if (items[i] instanceof String) {
                    ArrayList li = OreDictionary.getOres((String)((String)items[i]));
                    this.items.addAll(li);
                    continue;
                }
                if (is == null) continue;
                this.items.add(is);
            }
        }

        public static CompostMatter getMatterType(ItemStack is) {
            for (int i = 0; i < list.length; ++i) {
                CompostMatter c = list[i];
                if (!ReikaItemHelper.collectionContainsItemStack(c.items, (ItemStack)is)) continue;
                return c;
            }
            return null;
        }

        public List<ItemStack> getAllItems() {
            return Collections.unmodifiableList(this.items);
        }

        static {
            list = CompostMatter.values();
        }
    }
}

