/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Registry.CropType;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.AtmosphereHandler;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.RotaryCraft.API.Event.FanHarvestEvent;
import Reika.RotaryCraft.API.Interfaces.CustomFanEntity;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Auxiliary.Interfaces.UpgradeableMachine;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.TileEntityBeamMachine;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityCoolingFin;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFan
extends TileEntityBeamMachine
implements RangedEffect,
UpgradeableMachine,
BreakAction {
    public int distancelimit = Math.max(32, ConfigRegistry.FANRANGE.getValue());
    public static final long MAXPOWER = 0x200000L;
    public static final int FALLOFF = 1024;
    public static final int FALLOFF_WIDE = 2048;
    public static final double AXISSPEEDCAP = 1.0;
    public static final double BASESPEED = 1.25E-4;
    public static final int WEBSPEED = 256;
    public static final int LEAFSPEED = 4096;
    public static final int GRASSSPEED = 1024;
    public static final int FIRESPEED = 64;
    public static final int FIRESPREADSPEED = 16;
    public static final int HARVESTSPEED = 512;
    private final StepTimer sound = new StepTimer(27);
    public boolean wideAreaHarvest = true;
    public boolean wideAreaBlow = false;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        this.power = (long)this.omega * (long)this.torque;
        if (AtmosphereHandler.isNoAtmo((World)world, (int)(x - this.getReadDirection().offsetX), (int)y, (int)(z - this.getReadDirection().offsetZ), (Block)this.field_145854_h, (boolean)false)) {
            return;
        }
        this.makeBeam(world, x, y, z, meta);
        this.sound.update();
        if (this.omega > 0 && this.sound.checkCap()) {
            SoundRegistry.FAN.playSoundAtBlock(world, x, y, z, RotaryAux.isMuffled((TileEntity)this) ? 0.05f : 0.5f, 1.0f);
        }
    }

    private void spreadFire(World world, int x, int y, int z, int meta, int range) {
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151581_o) != null || ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i) != null) {
            int a = 0;
            if (meta > 1) {
                a = 1;
            }
            int b = 1 - a;
            for (int i = 1; i <= range; ++i) {
                int editx = x + i * this.facing.offsetX;
                int edity = y + i * this.facing.offsetY;
                int editz = z + i * this.facing.offsetZ;
                if (rand.nextInt(60) == 0 && ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)editx, (int)edity, (int)editz)) {
                    world.func_147449_b(editx, edity, editz, (Block)Blocks.field_150480_ab);
                }
                editx = -1 * a + x + i * this.facing.offsetX;
                edity = y + i * this.facing.offsetY;
                editz = -1 * b + z + i * this.facing.offsetZ;
                if (rand.nextInt(60) == 0 && ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)editx, (int)edity, (int)editz)) {
                    world.func_147449_b(editx, edity, editz, (Block)Blocks.field_150480_ab);
                }
                editx = -1 * a + x + i * this.facing.offsetX;
                edity = 1 + y + i * this.facing.offsetY;
                editz = -1 * b + z + i * this.facing.offsetZ;
                if (rand.nextInt(60) == 0 && ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)editx, (int)edity, (int)editz)) {
                    world.func_147449_b(editx, edity, editz, (Block)Blocks.field_150480_ab);
                }
                editx = -1 * a + x + i * this.facing.offsetX;
                edity = 2 + y + i * this.facing.offsetY;
                editz = -1 * b + z + i * this.facing.offsetZ;
                if (rand.nextInt(60) == 0 && ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)editx, (int)edity, (int)editz)) {
                    world.func_147449_b(editx, edity, editz, (Block)Blocks.field_150480_ab);
                }
                editx = x + i * this.facing.offsetX;
                edity = y + i * this.facing.offsetY;
                editz = z + i * this.facing.offsetZ;
                if (rand.nextInt(60) == 0 && ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)editx, (int)edity, (int)editz)) {
                    world.func_147449_b(editx, edity, editz, (Block)Blocks.field_150480_ab);
                }
                editx = x + i * this.facing.offsetX;
                edity = 1 + y + i * this.facing.offsetY;
                editz = z + i * this.facing.offsetZ;
                if (rand.nextInt(60) == 0 && ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)editx, (int)edity, (int)editz)) {
                    world.func_147449_b(editx, edity, editz, (Block)Blocks.field_150480_ab);
                }
                editx = x + i * this.facing.offsetX;
                edity = 2 + y + i * this.facing.offsetY;
                editz = z + i * this.facing.offsetZ;
                if (rand.nextInt(60) == 0 && ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)editx, (int)edity, (int)editz)) {
                    world.func_147449_b(editx, edity, editz, (Block)Blocks.field_150480_ab);
                }
                editx = 1 * a + x + i * this.facing.offsetX;
                edity = y + i * this.facing.offsetY;
                editz = 1 * b + z + i * this.facing.offsetZ;
                if (rand.nextInt(60) == 0 && ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)editx, (int)edity, (int)editz)) {
                    world.func_147449_b(editx, edity, editz, (Block)Blocks.field_150480_ab);
                }
                editx = 1 * a + x + i * this.facing.offsetX;
                edity = 2 + y + i * this.facing.offsetY;
                editz = 1 * b + z + i * this.facing.offsetZ;
                if (rand.nextInt(60) != 0 || !ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)editx, (int)edity, (int)editz)) continue;
                world.func_147449_b(editx, edity, editz, (Block)Blocks.field_150480_ab);
            }
        }
    }

    @Override
    public int getRange() {
        if (this.power < this.MINPOWER) {
            return 0;
        }
        int power2 = (int)Math.min(this.power - this.MINPOWER, 0x200000L);
        int range = 8 + power2 / (this.wideAreaBlow ? 2048 : 1024);
        if (range > this.getMaxRange()) {
            range = this.getMaxRange();
        }
        return range;
    }

    private boolean isStoppedBy(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a || b.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        if (ReikaCropHelper.isCrop((Block)b) || ModCropList.isModCrop((Block)b, (int)meta)) {
            return false;
        }
        if (b.func_149662_c() || b.func_149686_d()) {
            return true;
        }
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, x, y, z);
        if (m == MachineRegistry.LAWNSPRINKLER || m == MachineRegistry.SPRINKLER) {
            return false;
        }
        return b.func_149688_o().func_76220_a();
    }

    @Override
    protected void makeBeam(World world, int x, int y, int z, int meta) {
        if (this.power < this.MINPOWER) {
            return;
        }
        long power2 = Math.min(this.power, 0x200000L);
        int range = this.getRange();
        boolean blocked = false;
        for (int i = 1; i <= range && !blocked; ++i) {
            if (!this.isStoppedBy(world, x + i * this.facing.offsetX, y + i * this.facing.offsetY, z + i * this.facing.offsetZ)) continue;
            blocked = true;
            range = i;
        }
        AxisAlignedBB zone = this.wideAreaBlow ? this.getWideBlowZone(meta, range) : this.getBlowZone(meta, range);
        List inzone = world.func_72872_a(Entity.class, zone);
        for (Entity caught : inzone) {
            double a;
            double speedstep;
            double base;
            double multiplier;
            double d;
            if (!this.canBlowEntity(caught)) continue;
            double mass = ReikaEntityHelper.getEntityMass((Entity)caught);
            if (caught instanceof EntityLivingBase) {
                mass += ReikaEntityHelper.getCarriedMass((EntityLivingBase)((EntityLivingBase)caught));
            }
            if (caught.field_70159_w < 1.0 && this.facing.offsetX != 0) {
                d = caught.field_70165_t - (double)x;
                if (d == 0.0) {
                    d = 1.0;
                }
                multiplier = 1.0 / (d - (double)this.getMaxRange());
                if (d - (double)this.getMaxRange() > 12.0) {
                    multiplier = 0.0;
                }
                if (multiplier > 1.0 || multiplier < 0.0) {
                    multiplier = 1.0;
                }
                base = multiplier * (double)power2 * 1.25E-4 * (this.wideAreaBlow ? 0.125 : 1.0);
                speedstep = Math.max(Math.abs(Math.abs(caught.field_70159_w) + base / (mass * Math.abs(d))), 1.0);
                a = this.facing.offsetX > 0 ? 0.004 : 0.0;
                caught.field_70159_w = (double)this.facing.offsetX * speedstep + a;
            }
            if (caught.field_70181_x < 1.0 && this.facing.offsetY != 0) {
                d = caught.field_70163_u - (double)y;
                if (d == 0.0) {
                    d = 1.0;
                }
                multiplier = 1.0 / (d - (double)this.getMaxRange());
                if (d - (double)this.getMaxRange() > 12.0) {
                    multiplier = 0.0;
                }
                if (multiplier > 1.0 || multiplier < 0.0) {
                    multiplier = 1.0;
                }
                base = multiplier * (double)power2 * 1.25E-4 * (this.wideAreaBlow ? 0.125 : 1.0);
                caught.field_70181_x = (double)this.facing.offsetY * Math.max(Math.abs(Math.abs(caught.field_70181_x) + base / (mass * Math.abs(d))), 1.0);
            }
            if (!(caught.field_70179_y < 1.0) || this.facing.offsetZ == 0) continue;
            d = caught.field_70161_v - (double)z;
            if (d == 0.0) {
                d = 1.0;
            }
            multiplier = 1.0 / (d - (double)this.getMaxRange());
            if (d - (double)this.getMaxRange() > 12.0) {
                multiplier = 0.0;
            }
            if (multiplier > 1.0 || multiplier < 0.0) {
                multiplier = 1.0;
            }
            base = multiplier * (double)power2 * 1.25E-4 * (this.wideAreaBlow ? 0.125 : 1.0);
            speedstep = Math.max(Math.abs(Math.abs(caught.field_70179_y) + base / (mass * Math.abs(d))), 1.0);
            a = this.facing.offsetZ > 0 ? 0.004 : 0.0;
            caught.field_70179_y = (double)this.facing.offsetZ * speedstep + a;
        }
        this.clearBlocks(world, x, y, z, meta, range);
        this.spreadFire(world, x, y, z, meta, range);
    }

    private boolean canBlowEntity(Entity e) {
        if (e instanceof CustomFanEntity) {
            CustomFanEntity c = (CustomFanEntity)e;
            if (c.getBlowPower() > this.power) {
                return false;
            }
            double ang = ReikaMathLibrary.py3d((double)(Math.signum(e.field_70159_w) - (double)this.facing.offsetX), (double)(Math.signum(e.field_70181_x) - (double)this.facing.offsetY), (double)(Math.signum(e.field_70179_y) - (double)this.facing.offsetZ));
            return !(ang > c.getMaxDeflection());
        }
        return true;
    }

    private void clearBlocks(World world, int x, int y, int z, int meta, int range) {
        int a = 0;
        if (meta > 1) {
            a = 1;
        }
        int b = 1 - a;
        for (int i = 1; i <= range; ++i) {
            int editx = x + i * this.facing.offsetX;
            int edity = y + i * this.facing.offsetY;
            int editz = z + i * this.facing.offsetZ;
            this.rip2(world, editx, edity, editz);
            this.enhanceFinPower(world, editx, edity, editz);
            if (!this.wideAreaHarvest) continue;
            if (this.facing.offsetY != 0) {
                for (int k = -1; k <= 1; ++k) {
                    for (int j = -1; j <= 1; ++j) {
                        editx = x + k;
                        edity = y + i * this.facing.offsetY;
                        editx = z + j;
                        this.rip2(world, editx, edity, editz);
                    }
                }
                continue;
            }
            ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.facing);
            for (int k = -1; k <= 1; ++k) {
                for (int j = 0; j <= 2; ++j) {
                    editx = x + i * this.facing.offsetX + left.offsetX * k;
                    edity = y + i * this.facing.offsetY + j;
                    editz = z + i * this.facing.offsetZ + left.offsetZ * k;
                    this.rip2(world, editx, edity, editz);
                }
            }
        }
    }

    private void enhanceFinPower(World world, int x, int y, int z) {
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, x, y, z);
        if (m == MachineRegistry.COOLINGFIN) {
            TileEntityCoolingFin te = (TileEntityCoolingFin)world.func_147438_o(x, y, z);
            int[] tg = te.getTarget();
            ReikaParticleHelper.CLOUD.spawnAroundBlock(world, x, y, z, 1);
            if (world.func_82737_E() % 20L == 0L) {
                int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
                if (te.getTemperature() > Tamb) {
                    te.addTemperature(-((int)Math.min(10L, 1L + this.power / 32768L)));
                }
            }
        }
    }

    public void rip2(World world, int x, int y, int z) {
        boolean crop;
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        boolean bl = crop = ReikaCropHelper.isCrop((Block)id) || ModCropList.isModCrop((Block)id, (int)meta);
        if (id != Blocks.field_150433_aE && id != Blocks.field_150321_G && id != Blocks.field_150362_t && id != Blocks.field_150361_u && id != Blocks.field_150329_H && id != Blocks.field_150480_ab && !crop) {
            return;
        }
        int c = this.getHarvestingRand();
        if (id == Blocks.field_150329_H) {
            c /= 3;
        }
        if (rand.nextInt(c = Math.max(1, c)) > 0) {
            return;
        }
        if (id == Blocks.field_150321_G && this.omega < 256) {
            return;
        }
        if ((id == Blocks.field_150362_t || id == Blocks.field_150361_u) && this.omega < 4096) {
            return;
        }
        if (id == Blocks.field_150329_H && this.omega < 1024) {
            return;
        }
        if (id == Blocks.field_150480_ab && this.omega < 64) {
            return;
        }
        if (id == Blocks.field_150433_aE && this.omega < 64) {
            return;
        }
        if (crop && this.omega < 512) {
            return;
        }
        if (crop) {
            this.harvest(world, x, y, z, meta, id);
            return;
        }
        this.dropBlocks(world, x, y, z, id, meta);
        world.func_147468_f(x, y, z);
    }

    private int getHarvestingRand() {
        return Math.max(50, 600 - 25 * ReikaMathLibrary.logbase2((long)this.omega));
    }

    private void harvest(World world, int x, int y, int z, int meta, Block id) {
        ReikaCropHelper crop = ReikaCropHelper.getCrop((Block)id);
        if (crop == null) {
            crop = ModCropList.getModCrop((Block)id, (int)meta);
        }
        if (crop != null && crop.isRipe(world, x, y, z)) {
            if (crop.destroyOnHarvest()) {
                ArrayList li = id.getDrops(world, x, y, z, meta, 0);
                ReikaItemHelper.dropItems((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (Collection)li);
                world.func_147468_f(x, y, z);
            } else {
                ArrayList li = crop.getDrops(world, x, y, z, 0);
                CropType.CropMethods.removeOneSeed((CropType)crop, (ArrayList)li);
                ReikaItemHelper.dropItems((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (Collection)li);
                crop.setHarvested(world, x, y, z);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new FanHarvestEvent((TileEntity)this, x, y, z));
    }

    private void dropBlocks(World world, int x, int y, int z, Block id, int meta) {
        if (id != Blocks.field_150350_a) {
            ReikaItemHelper.dropItems((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (Collection)id.getDrops(world, x, y, z, meta, 0));
        }
        world.func_147468_f(x, y, z);
    }

    public AxisAlignedBB getBlowZone(int meta, int range) {
        return ReikaAABBHelper.getBeamBox((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)this.facing, (int)range);
    }

    public AxisAlignedBB getWideBlowZone(int meta, int range) {
        AxisAlignedBB box = this.getBlowZone(meta, range);
        boolean ex = !ReikaMathLibrary.isValueInsideBoundsIncl((int)0, (int)1, (int)meta);
        boolean ey = !ReikaMathLibrary.isValueInsideBoundsIncl((int)4, (int)5, (int)meta);
        boolean ez = !ReikaMathLibrary.isValueInsideBoundsIncl((int)2, (int)3, (int)meta);
        return box.func_72314_b((double)ex, (double)ey, (double)ez);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < this.MINPOWER) {
            return;
        }
        this.phi = (float)((double)this.phi + 3.0 * ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.FAN;
    }

    @Override
    public int getMaxRange() {
        return this.distancelimit;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void onEMP() {
    }

    @Override
    public void upgrade(ItemStack item) {
        if (!this.wideAreaBlow && ReikaItemHelper.matchStacks((ItemStack)item, (ItemStack)ItemStacks.diffuser)) {
            this.wideAreaBlow = true;
        }
    }

    @Override
    public boolean canUpgradeWith(ItemStack item) {
        return !this.wideAreaBlow && ReikaItemHelper.matchStacks((ItemStack)item, (ItemStack)ItemStacks.diffuser);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("wideh", this.wideAreaHarvest);
        NBT.func_74757_a("wideb", this.wideAreaBlow);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.wideAreaBlow = NBT.func_74767_n("wideb");
        this.wideAreaHarvest = NBT.func_74767_n("wideh");
    }

    public void breakBlock() {
        if (this.wideAreaBlow) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (ItemStack)ItemStacks.diffuser);
        }
    }
}

