/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityGroundHydrator
extends RotaryCraftTileEntity
implements PipeConnector,
IFluidHandler {
    private static final double[][] AREA = new double[][]{{1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 3.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 2.0, 2.0, 3.0, 4.0, 3.0, 2.0, 2.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 2.0, 3.0, 5.0, 6.0, 6.0, 6.0, 5.0, 3.0, 2.0, 1.0, 1.0}, {1.0, 2.0, 3.0, 4.0, 6.0, 7.0, 7.0, 7.0, 6.0, 4.0, 3.0, 2.0, 1.0}, {2.0, 2.0, 4.0, 6.0, 7.0, 8.0, 8.0, 8.0, 7.0, 6.0, 4.0, 2.0, 2.0}, {2.0, 3.0, 6.0, 7.0, 8.0, 9.0, 9.0, 9.0, 8.0, 7.0, 6.0, 3.0, 2.0}, {3.0, 4.0, 6.0, 7.0, 8.0, 9.0, 0.0, 9.0, 8.0, 7.0, 6.0, 4.0, 3.0}, {2.0, 3.0, 6.0, 7.0, 8.0, 9.0, 9.0, 9.0, 8.0, 7.0, 6.0, 3.0, 2.0}, {2.0, 2.0, 4.0, 6.0, 7.0, 8.0, 8.0, 8.0, 7.0, 6.0, 4.0, 2.0, 2.0}, {1.0, 2.0, 3.0, 5.0, 6.0, 7.0, 7.0, 7.0, 6.0, 5.0, 3.0, 2.0, 1.0}, {1.0, 1.0, 2.0, 3.0, 4.0, 6.0, 6.0, 6.0, 4.0, 3.0, 2.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 2.0, 2.0, 3.0, 4.0, 3.0, 2.0, 2.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 3.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0}};
    private static final WeightedRandom<Coordinate> coordinateRand = WeightedRandom.fromArray((double[][])AREA);
    public static final int FLUID_PER_BLOCK = 25;
    private final HybridTank tank = new HybridTank("hydrator", 1000);

    public static int getRange() {
        return (AREA.length - 1) / 2;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.HYDRATOR;
    }

    @Override
    public boolean hasModelTransparency() {
        return true;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K && this.tank.getLevel() >= 25 && rand.nextInt(this.getTickRate(world)) == 0) {
            Coordinate c = ((Coordinate)coordinateRand.getRandomEntry()).offset(x, y, z);
            Block b = c.getBlock((IBlockAccess)world);
            boolean flag = false;
            if (b == Blocks.field_150458_ak) {
                flag = ReikaWorldHelper.hydrateFarmland((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (boolean)false);
            } else if (b == ForestryHandler.BlockEntry.SOIL.getBlock()) {
                int gmeta = c.getBlockMetadata((IBlockAccess)world);
                ForestryHandler.SoilType type = ForestryHandler.SoilType.getTypeFromMeta((int)gmeta);
                if (type == ForestryHandler.SoilType.HUMUS) {
                    flag = this.refreshHumus(world, c.xCoord, c.yCoord, c.zCoord, gmeta);
                } else if (type == ForestryHandler.SoilType.BOG_EARTH && rand.nextInt(4) == 0) {
                    flag = this.matureBog(world, c.xCoord, c.yCoord, c.zCoord, gmeta);
                }
            }
            if (flag) {
                this.tank.removeLiquid(25);
            }
        }
    }

    private int getTickRate(World world) {
        return ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world) && ReikaMystcraftHelper.isSymbolPresent((World)world, (String)"EnvAccel") ? 1 : 2;
    }

    private boolean refreshHumus(World world, int x, int y, int z, int meta) {
        int type = meta & 3;
        int grade = meta >> 2;
        if (grade == 0) {
            return false;
        }
        meta = --grade << 2 | type;
        world.func_72921_c(x, y, z, meta, 3);
        return true;
    }

    private boolean matureBog(World world, int x, int y, int z, int meta) {
        int type = meta & 3;
        int maturity = meta >> 2;
        if (maturity >= 3) {
            return false;
        }
        meta = ++maturity << 2 | type;
        world.func_72921_c(x, y, z, meta, 3);
        return true;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public int getLevel() {
        return this.tank.getLevel();
    }

    public Fluid getFluid() {
        return this.tank.getActualFluid();
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return TileEntityPiping.Flow.INPUT;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b((double)this.getRange(), 0.5, (double)this.getRange());
    }

    public static boolean affectsBlock(Block b, int meta) {
        return b == Blocks.field_150458_ak || b == ForestryHandler.BlockEntry.SOIL.getBlock();
    }
}

