/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Piping;

import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class TileEntityBypass
extends TileEntityPiping {
    private Fluid fluid;
    private int level;
    private boolean[] forcedConnection = new boolean[6];
    private boolean[] tryForcedConnection = new boolean[6];

    @Override
    public void onPlacedAgainst(ForgeDirection dir) {
        if (MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) == this.getTile()) {
            this.tryForcedConnection[dir.ordinal()] = true;
        }
    }

    @Override
    public void recomputeConnections(World world, int x, int y, int z) {
        this.forcedConnection = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            TileEntity te;
            ForgeDirection dir = this.dirs[i];
            if (!this.tryForcedConnection[i] || !((te = this.getAdjacentTileEntity(dir)) instanceof TileEntityBypass)) continue;
            TileEntityBypass tb = (TileEntityBypass)te;
            tb.tryForcedConnection[dir.getOpposite().ordinal()] = true;
            this.forceConnect(dir);
            tb.forceConnect(dir.getOpposite());
            tb.queueConnectionEvaluation(2);
        }
        super.recomputeConnections(world, x, y, z);
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m, ForgeDirection side) {
        return m.isStandardPipe() || m == MachineRegistry.FUELLINE || m == MachineRegistry.HOSE || m == this.getTile() && this.forcedConnection[side.ordinal()];
    }

    public void forceConnect(ForgeDirection dir) {
        this.forcedConnection[dir.ordinal()] = true;
    }

    @Override
    public IIcon getBlockIcon() {
        return Blocks.field_150322_A.func_149691_a(1, 0);
    }

    @Override
    public boolean hasLiquid() {
        return this.level > 0;
    }

    @Override
    public Fluid getFluidType() {
        return this.fluid;
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.BYPASS;
    }

    @Override
    public int getFluidLevel() {
        return this.level;
    }

    @Override
    protected void setFluid(Fluid f) {
        this.fluid = f;
    }

    @Override
    protected void setLevel(int amt) {
        this.level = amt;
    }

    @Override
    protected boolean interactsWithMachines() {
        return false;
    }

    @Override
    protected void onIntake(TileEntity te) {
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return true;
    }

    @Override
    public boolean canReceiveFromPipeOn(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean canEmitToPipeOn(ForgeDirection side) {
        return true;
    }

    @Override
    public Block getPipeBlockType() {
        return Blocks.field_150322_A;
    }

    @Override
    public boolean canIntakeFromIFluidHandler(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean canOutputToIFluidHandler(ForgeDirection side) {
        return false;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74774_a("fconn", ReikaArrayHelper.booleanToByteBitflags((boolean[])this.forcedConnection));
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        boolean update = false;
        boolean[] old = new boolean[this.forcedConnection.length];
        System.arraycopy(this.forcedConnection, 0, old, 0, old.length);
        this.forcedConnection = ReikaArrayHelper.booleanFromByteBitflags((byte)NBT.func_74771_c("fconn"), (int)6);
        boolean bl = update = !Arrays.equals(old, this.forcedConnection);
        if (this.field_145850_b != null && update) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74774_a("tfconn", ReikaArrayHelper.booleanToByteBitflags((boolean[])this.tryForcedConnection));
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        boolean update = false;
        boolean[] old = new boolean[this.tryForcedConnection.length];
        System.arraycopy(this.tryForcedConnection, 0, old, 0, old.length);
        this.tryForcedConnection = ReikaArrayHelper.booleanFromByteBitflags((byte)NBT.func_74771_c("tfconn"), (int)6);
        update = !Arrays.equals(old, this.tryForcedConnection);
    }
}

