/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesDryingBed;
import Reika.RotaryCraft.Base.TileEntity.InventoriedRCFluidReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class TileEntityDryingBed
extends InventoriedRCFluidReceiver {
    public static final int CAPACITY = 2000;
    private StepTimer timer = new StepTimer(400);
    public int progress;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        ItemStack is;
        ItemStack itemStack = is = this.tank.isEmpty() ? null : RecipesDryingBed.getRecipes().getDryingResult(this.tank.getFluid());
        if (this.canMake(is)) {
            this.timer.update();
            if (this.timer.checkCap()) {
                while (this.canMake(is)) {
                    this.make(is);
                    is = this.tank.isEmpty() ? null : RecipesDryingBed.getRecipes().getDryingResult(this.tank.getFluid());
                }
            }
        } else {
            this.timer.reset();
        }
        this.progress = this.timer.getTick();
    }

    public void addLiquid(Fluid f, int amt) {
        this.tank.addLiquid(amt, f);
    }

    private boolean canMake(ItemStack is) {
        return is != null && this.canMakeMore(is);
    }

    private void make(ItemStack is) {
        ReikaInventoryHelper.addOrSetStack((ItemStack)is, (ItemStack[])this.inv, (int)0);
        int amt = RecipesDryingBed.getRecipes().getRecipeConsumption(is);
        this.tank.removeLiquid(amt);
    }

    private boolean canMakeMore(ItemStack is) {
        if (this.inv[0] == null) {
            return true;
        }
        return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.inv[0]) && this.inv[0].field_77994_a + is.field_77994_a <= this.inv[0].func_77976_d();
    }

    public boolean func_102008_b(int i, ItemStack is, int s) {
        return true;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.DRYING;
    }

    @Override
    public boolean hasModelTransparency() {
        return true;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe() || m == MachineRegistry.HOSE || m == MachineRegistry.FUELLINE;
    }

    @Override
    public int getCapacity() {
        return 2000;
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return RecipesDryingBed.getRecipes().isValidFluid(f);
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from != ForgeDirection.DOWN;
    }

    public int getLiquidScaled(int a) {
        return a * this.tank.getLevel() / this.tank.getCapacity();
    }

    public int getProgressScaled(int a) {
        return a * this.progress / this.timer.getCap();
    }

    public Fluid getFluid() {
        return this.tank.getActualFluid();
    }

    public boolean hasFluid() {
        return !this.tank.isEmpty();
    }
}

