/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPoweredLiquidIO;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityFuelConverter
extends InventoriedPoweredLiquidIO {
    public static final int CAPACITY = 5000;
    private static final MultiMap<String, FuelConversion> conversionMap = new MultiMap();
    private static final MultiMap<String, FuelConversion> conversionOutputMap = new MultiMap();

    public static FuelConversion addRecipe(String in, String out, int speed, int fluidRatio, double itemConsumeChance, ItemMatch ... items) {
        return new FuelConversion(in, out, speed, fluidRatio, itemConsumeChance, items);
    }

    public static Collection<FuelConversion> getByInput(ItemStack is) {
        ArrayList<FuelConversion> li = new ArrayList<FuelConversion>();
        for (FuelConversion c : conversionMap.allValues(false)) {
            if (!c.isValidItem(is)) continue;
            li.add(c);
        }
        return li;
    }

    public static Collection<FuelConversion> getByInput(Fluid f) {
        return Collections.unmodifiableCollection(conversionMap.get((Object)f.getName()));
    }

    public static Collection<FuelConversion> getAllRecipes() {
        return Collections.unmodifiableCollection(conversionMap.allValues(false));
    }

    public static Collection<FuelConversion> getByOutput(Fluid f) {
        return Collections.unmodifiableCollection(conversionOutputMap.get((Object)f.getName()));
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.FUELENHANCER;
    }

    @Override
    public boolean hasModelTransparency() {
        return true;
    }

    public int getRedstoneOverride() {
        if (this.input.isEmpty()) {
            return 15;
        }
        if (this.output.isFull()) {
            return 15;
        }
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getPowerBelow();
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.omega < this.MINSPEED) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        Collection<FuelConversion> c = this.getConversionOptions();
        if (c != null) {
            int boost = 1 + ReikaMathLibrary.logbase2((long)(this.omega / this.MINSPEED)) / 2;
            for (FuelConversion fc : c) {
                int spd = boost * fc.speedFactor;
                if (this.getInputLevel() < fc.fluidRatio * spd || fc.condition != null && !fc.condition.isUsable(this) || !this.output.canTakeIn(spd) || !this.hasItems(fc)) continue;
                this.input.removeLiquid(fc.fluidRatio * spd);
                this.output.addLiquid(spd, fc.output);
                this.consumeItems(fc);
                break;
            }
        }
    }

    private Collection<FuelConversion> getConversionOptions() {
        return !this.input.isEmpty() ? conversionMap.get((Object)this.input.getActualFluid().getName()) : null;
    }

    private boolean hasItems(FuelConversion c) {
        for (int i = 0; i < c.ingredients.length; ++i) {
            if (ReikaInventoryHelper.checkForItemStack((ItemMatch)c.ingredients[i], (ItemStack[])this.inv)) continue;
            return false;
        }
        return true;
    }

    private void consumeItems(FuelConversion c) {
        for (int i = 0; i < c.ingredients.length; ++i) {
            if (!ReikaRandomHelper.doWithChance((double)c.itemConsumptionChance)) continue;
            ReikaInventoryHelper.decrStack((int)ReikaInventoryHelper.locateInInventory((ItemMatch)c.ingredients[i], (ItemStack[])this.inv), (ItemStack[])this.inv);
        }
    }

    public int func_70302_i_() {
        return 9;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return !TileEntityFuelConverter.getByInput(is).isEmpty();
    }

    public double getLiquidModelOffset(boolean in) {
        return in ? 0.625 : 0.0625;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.FUELLINE || m.isStandardPipe();
    }

    public Fluid getInputFluidType() {
        return this.input.getActualFluid();
    }

    public Fluid getOutputFluidType() {
        return this.output.getActualFluid();
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return conversionMap.get((Object)f.getName()) != null;
    }

    @Override
    public boolean canOutputTo(ForgeDirection to) {
        return to.offsetY == 0;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from == ForgeDirection.UP;
    }

    @Override
    public int getCapacity() {
        return 5000;
    }

    @Override
    public boolean canIntakeFromPipe(MachineRegistry p) {
        return p.isStandardPipe() || p == MachineRegistry.FUELLINE;
    }

    @Override
    public boolean canOutputToPipe(MachineRegistry p) {
        return p == MachineRegistry.FUELLINE;
    }

    public static interface UsablilityCondition {
        public boolean isUsable(TileEntityFuelConverter var1);

        public String getDescription();
    }

    public static final class FuelConversion {
        public static final FuelConversion BCFUEL = new FuelConversion("fuel", "rc jet fuel", 1, 4, (double)DifficultyEffects.CONSUMEFRAC.getChance() / 100.0 * 1.5, new ItemMatch(Items.field_151065_br), new ItemMatch(ItemStacks.netherrackdust), new ItemMatch(ItemStacks.tar), new ItemMatch(Items.field_151064_bs), new ItemMatch(ReikaItemHelper.pinkDye));
        public static final FuelConversion KEROSENE = new FuelConversion("kerosene", "rc jet fuel", 1, 4, (double)DifficultyEffects.CONSUMEFRAC.getChance() / 100.0, new ItemMatch(Items.field_151065_br), new ItemMatch(ItemStacks.netherrackdust), new ItemMatch(ItemStacks.tar), new ItemMatch(Items.field_151064_bs), new ItemMatch(ReikaItemHelper.pinkDye));
        public final Fluid input;
        public final Fluid output;
        public final int speedFactor;
        public final int fluidRatio;
        public final double itemConsumptionChance;
        private final ItemMatch[] ingredients;
        private UsablilityCondition condition;

        private FuelConversion(String in, String out, int sp, int r, double f, ItemMatch ... items) {
            this.input = FluidRegistry.getFluid((String)in);
            this.output = FluidRegistry.getFluid((String)out);
            this.speedFactor = sp;
            this.fluidRatio = r;
            this.itemConsumptionChance = f;
            this.ingredients = items;
            this.register();
        }

        public FuelConversion setUsability(UsablilityCondition c) {
            this.condition = c;
            return this;
        }

        private void register() {
            if (this.input != null && this.output != null) {
                String n = this.input.getName();
                conversionMap.addValue((Object)n, (Object)this);
                conversionOutputMap.addValue((Object)this.output.getName(), (Object)this);
            }
        }

        public String toString() {
            return this.input + ">" + this.output + " x " + this.itemConsumptionChance + " @ " + this.fluidRatio + ":1 %" + this.itemConsumptionChance;
        }

        public boolean isValid() {
            return this.input != null && this.output != null;
        }

        public boolean isValidItem(ItemStack is) {
            for (int i = 0; i < this.ingredients.length; ++i) {
                if (!this.ingredients[i].match(is)) continue;
                return true;
            }
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public Collection<ItemStack> getIngredientsForDisplay() {
            ArrayList<ItemStack> c = new ArrayList<ItemStack>();
            for (ItemMatch m : this.ingredients) {
                c.add(m.getCycledItem());
            }
            return c;
        }

        public String getCondition() {
            return this.condition == null ? null : this.condition.getDescription();
        }
    }
}

