/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.TemperatureEffect;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.ProcessingMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesPulseFurnace;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityPulseFurnace
extends InventoriedPowerReceiver
implements TemperatureTE,
PipeConnector,
IFluidHandler,
ProcessingMachine,
TemperatureEffect.TemperatureCallback {
    public int pulseFurnaceCookTime;
    public static final int CAPACITY = 3000;
    public static final int MAXFUEL = 8000;
    public static final int MAXTEMP = 1000;
    public static final int SMELTTICKS_BASE = 100;
    public boolean idle = false;
    public int temperature;
    private int tickcount2 = 0;
    public int smelttick = 0;
    private int soundtick = 2000;
    private final HybridTank fuel = new HybridTank("fuel", 8000);
    private final HybridTank water = new HybridTank("water", 3000);
    private final HybridTank accel = new HybridTank("accel", 8000);

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 2;
    }

    public void testIdle() {
        this.idle = this.getRecipe() == null && this.omega > this.MINSPEED;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.pulseFurnaceCookTime = NBT.func_74765_d("CookTime");
        this.water.readFromNBT(NBT);
        this.fuel.readFromNBT(NBT);
        this.accel.readFromNBT(NBT);
        this.temperature = NBT.func_74762_e("temp");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74777_a("CookTime", (short)this.pulseFurnaceCookTime);
        this.water.writeToNBT(NBT);
        this.fuel.writeToNBT(NBT);
        this.accel.writeToNBT(NBT);
        NBT.func_74768_a("temp", this.temperature);
    }

    public int getCookProgressScaled(int par1) {
        return Math.min(par1, this.pulseFurnaceCookTime * par1 / this.getOperationTime());
    }

    public int getFuelScaled(int par1) {
        return this.fuel.getLevel() * par1 / 8000;
    }

    public int getTempScaled(int par1) {
        return this.temperature * par1 / 1000;
    }

    public int getWaterScaled(int par1) {
        return this.water.getLevel() * par1 / 3000;
    }

    public int getFireScaled(int par1) {
        return Math.min(par1, this.smelttick * par1 / this.getSmeltingDuration());
    }

    public int getAccelerantScaled(int a) {
        return this.accel.getLevel() * a / this.accel.getCapacity();
    }

    private void getFuel(World world, int x, int y, int z, int meta) {
        if (this.tickcount2 >= 100) {
            this.fuel.removeLiquid(100);
            this.tickcount2 = 0;
        }
    }

    private void heatAmbient(World world, int x, int y, int z, int meta) {
        if (this.fuel.getLevel() > 0 && this.canHeatUp()) {
            this.temperature += Math.max((1000 - this.temperature) / 8, 4);
        }
        int dT = 2;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (Tamb < -40) {
            dT = 8;
        } else if (Tamb < -5) {
            dT = 6;
        } else if (Tamb < 5) {
            dT = 4;
        }
        if (Tamb >= 300 && this.canHeatUp()) {
            dT = -1;
        } else if (Tamb >= this.temperature) {
            dT = 0;
        } else if (Tamb > 30) {
            dT = 1;
        }
        if (this.water.getLevel() > 0) {
            if (rand.nextInt(3) == 0) {
                int rem = this.temperature * 2 / 1000 * 50;
                if (Tamb >= 180) {
                    rem *= 2;
                }
                if (Tamb >= 90) {
                    rem *= 2;
                }
                if (rem > 0) {
                    this.water.removeLiquid(rem);
                }
            }
            this.temperature = Tamb >= 300 ? (this.temperature -= this.temperature / 256) : (this.temperature -= this.temperature / 64);
        }
        if (dT != 0) {
            this.temperature = dT > 0 ? Math.max(Tamb, this.temperature - dT) : (this.temperature -= dT);
        }
    }

    private boolean canHeatUp() {
        return this.power >= this.MINPOWER && this.omega >= this.MINSPEED && !this.fuel.isEmpty();
    }

    public void smeltHeat() {
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        this.heatAmbient(world, x, y, z, meta);
        if (this.temperature > 915) {
            RotaryCraft.logger.warn((Object)("WARNING: " + this + " is reaching very high temperature!"));
            world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), 0.0, 0.0, 0.0);
        }
        ReikaWorldHelper.temperatureEnvironment((World)world, (int)x, (int)y, (int)z, (int)this.temperature, (TemperatureEffect.TemperatureCallback)this);
        if (this.temperature > 1000) {
            this.overheat(world, x, y, z);
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        RecipesPulseFurnace.PulseJetRecipe recipe;
        super.updateTileEntity();
        this.testIdle();
        ++this.soundtick;
        if (this.tickcount >= 20 && !world.field_72995_K) {
            this.updateTemperature(world, x, y, z, meta);
            this.tickcount = 0;
        }
        if (this.soundtick >= 18 && this.canHeatUp()) {
            this.soundtick = 0;
            SoundRegistry.PULSEJET.playSoundAtBlock(world, x, y, z, 1.0f, 1.0f);
        }
        if ((recipe = this.getRecipe()) != null) {
            this.getFuel(world, x, y, z, meta);
        }
        ++this.tickcount;
        ++this.tickcount2;
        if (!world.field_72995_K) {
            int tick = 1;
            if (!this.fuel.isEmpty() && this.power > 0L && this.omega >= this.MINSPEED && this.accel.getLevel() > 10) {
                tick = 4;
                if (recipe != null || this.temperature >= 875) {
                    this.accel.removeLiquid(10);
                    if (rand.nextInt(4) == 0) {
                        ++this.temperature;
                    }
                }
            }
            int duration = this.getSmeltingDuration();
            this.smelttick = recipe != null ? (this.smelttick += tick) : 0;
            if (recipe != null && this.smelttick >= duration) {
                this.pulseFurnaceCookTime += tick;
                if (this.pulseFurnaceCookTime >= this.getOperationTime()) {
                    this.pulseFurnaceCookTime = 0;
                    this.smeltItem(recipe);
                    this.smelttick = 0;
                }
            } else {
                this.pulseFurnaceCookTime = 0;
            }
        }
    }

    private int getSmeltingDuration() {
        if (this.temperature >= 980) {
            return 12;
        }
        if (this.temperature >= 950) {
            return 25;
        }
        if (this.temperature >= 900) {
            return 50;
        }
        return 100;
    }

    private RecipesPulseFurnace.PulseJetRecipe getRecipe() {
        this.getPowerBelow();
        if (this.power <= 0L || this.omega < this.MINSPEED) {
            return null;
        }
        if (this.inv[0] == null) {
            return null;
        }
        if (this.fuel.isEmpty()) {
            return null;
        }
        RecipesPulseFurnace.PulseJetRecipe rec = RecipesPulseFurnace.getRecipes().getSmeltingResult(this.inv[0]);
        if (rec == null || rec.requiredTemperature > this.temperature) {
            return null;
        }
        if (this.inv[2] != null && !ReikaItemHelper.areStacksCombinable((ItemStack)this.inv[2], (ItemStack)rec.getOutput(), (int)this.func_70297_j_())) {
            return null;
        }
        return rec;
    }

    private void smeltItem(RecipesPulseFurnace.PulseJetRecipe rec) {
        this.smeltHeat();
        ReikaInventoryHelper.addOrSetStack((ItemStack)rec.getOutput(), (ItemStack[])this.inv, (int)2);
        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
    }

    private ItemStack getCraftedScrapIngot() {
        if (ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ItemStacks.scrap)) {
            return ItemStacks.steelingot;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ItemStacks.ironscrap)) {
            return new ItemStack(Items.field_151042_j);
        }
        return null;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.PULSEJET;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        if (slot != 0) {
            return false;
        }
        return RecipesPulseFurnace.getRecipes().getSmeltingResult(is) != null;
    }

    @Override
    public int getThermalDamage() {
        return this.temperature / 100;
    }

    public int getRedstoneOverride() {
        return this.getRecipe() == null ? 15 : 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.FUELLINE || m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side.offsetY == 0;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        ReikaWorldHelper.overheat((World)world, (int)x, (int)y, (int)z, (ItemStack)ItemStacks.scrap.func_77946_l(), (int)0, (int)17, (boolean)true, (float)1.5f, (boolean)false, (boolean)ConfigRegistry.BLOCKDAMAGE.getState(), (float)12.0f);
    }

    public int getAccelerant() {
        return this.accel.getLevel();
    }

    public Fluid getAccelerantType() {
        return this.accel.getActualFluid();
    }

    public int getAccelerantCapacity() {
        return this.accel.getCapacity();
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        Fluid fluid = resource.getFluid();
        if (!this.canFill(from, fluid)) {
            return 0;
        }
        if (fluid.equals(FluidRegistry.WATER)) {
            return this.water.fill(resource, doFill);
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
            return this.fuel.fill(resource, doFill);
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc oxygen"))) {
            return this.accel.fill(resource, doFill);
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"oxygen"))) {
            return this.accel.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (fluid.equals(FluidRegistry.WATER)) {
            return from.offsetY == 0;
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
            return from.offsetY == 0;
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"rc oxygen"))) {
            return from.offsetY == 0;
        }
        if (fluid.equals(FluidRegistry.getFluid((String)"oxygen"))) {
            return from.offsetY == 0;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.water.getInfo(), this.fuel.getInfo(), this.accel.getInfo()};
    }

    public int getWater() {
        return this.water.getLevel();
    }

    public int getFuel() {
        return this.fuel.getLevel();
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY == 0 ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    public void addFuel(int amt) {
        this.fuel.addLiquid(amt, FluidRegistry.getFluid((String)"rc jet fuel"));
    }

    public void addWater(int amt) {
        this.water.addLiquid(amt, FluidRegistry.WATER);
    }

    @Override
    public int getOperationTime() {
        return 20;
    }

    @Override
    public boolean areConditionsMet() {
        return this.getRecipe() != null && !this.fuel.isEmpty();
    }

    @Override
    public String getOperationalStatus() {
        return this.fuel.isEmpty() ? "No Fuel" : (this.areConditionsMet() ? "Operational" : "Invalid or Missing Items");
    }

    public void removeFuel(int amt) {
        this.fuel.removeLiquid(amt);
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    @Override
    public boolean allowHeatExtraction() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public int getMaxTemperature() {
        return 1000;
    }

    public void onApplyTemperature(World world, int x, int y, int z, int temperature) {
        if (world.func_147439_a(x, y, z) == Blocks.field_150480_ab) {
            RotaryAchievements.PULSEFIRE.triggerAchievement(this.getPlacer());
        }
    }

    public boolean hasWork() {
        return this.areConditionsMet();
    }
}

