/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Base.OneSlotMachine;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesWetter;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityWetter
extends InventoriedPowerLiquidReceiver
implements OneSlotMachine {
    private int tick = 0;
    private EntityItem item;
    private int extractionCooldown = 0;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        RecipesWetter.WettingRecipe wr;
        FluidStack fs;
        ItemStack is;
        super.updateTileEntity();
        this.getPowerBelow();
        this.updateItem();
        boolean ticked = false;
        if (this.power >= this.MINPOWER && this.omega >= this.MINSPEED && (is = this.inv[0]) != null && (fs = this.tank.getFluid()) != null && (wr = RecipesWetter.getRecipes().getRecipe(is, fs)) != null) {
            ticked = true;
            if (this.tick >= this.getDuration(wr)) {
                this.tank.removeLiquid(wr.getFluid().amount);
                this.inv[0] = wr.getOutput();
                this.tick = 0;
                this.onItemSet(0, this.inv[0]);
            } else {
                this.tick += 1 + 4 * ReikaMathLibrary.logbase2((long)(this.omega / this.MINSPEED));
                this.extractionCooldown = 10;
            }
        }
        if (ticked) {
            this.extractionCooldown = 10;
        } else {
            if (this.extractionCooldown > 0) {
                --this.extractionCooldown;
            }
            this.tick = 0;
        }
    }

    public int getDuration(RecipesWetter.WettingRecipe wr) {
        return Math.max(1, wr.duration - 5 * (this.omega / this.MINSPEED - 1));
    }

    @Override
    protected void onItemSet(int slot, ItemStack is) {
        this.updateItem();
    }

    private void updateItem() {
        if (this.item == null && this.inv[0] == null) {
            return;
        }
        if (this.item == null && this.inv[0] != null || this.item != null && this.inv[0] == null || !ReikaItemHelper.matchStacks((ItemStack)this.item.func_92059_d(), (ItemStack)this.inv[0])) {
            this.item = this.inv[0] != null ? new InertItem(this.field_145850_b, this.inv[0]) : null;
        }
        this.syncAllData(true);
    }

    public EntityItem getItem() {
        return this.item;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return this.tick == 0 && this.extractionCooldown == 0;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.HOSE || m == MachineRegistry.FUELLINE || m.isStandardPipe();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        if (this.tank.getActualFluid() != null) {
            return RecipesWetter.getRecipes().isWettableWith(is, this.tank.getActualFluid());
        }
        return RecipesWetter.getRecipes().isWettable(is);
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        if (this.tick > 0) {
            return false;
        }
        if (this.inv[0] != null) {
            return RecipesWetter.getRecipes().isWettableWith(this.inv[0], f);
        }
        return RecipesWetter.getRecipes().isValidFluid(f);
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from.offsetY == 0;
    }

    @Override
    public int getCapacity() {
        return 1000;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.WETTER;
    }

    @Override
    public boolean hasModelTransparency() {
        return true;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("extract", this.extractionCooldown);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.extractionCooldown = NBT.func_74762_e("extract");
    }
}

