/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.Base.BlockTileEnum;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.PartialInventory;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.ReikaSpawnerHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TwilightForestHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.Event.BorerDigEvent;
import Reika.RotaryCraft.API.Interfaces.IgnoredByBorer;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.MachineEnchantmentHandler;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityBeamMachine;
import Reika.RotaryCraft.Blocks.BlockMiningPipe;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import buildcraft.api.tiles.IHasWork;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

@APIStripper.Strippable(value={"buildcraft.api.tiles.IHasWork"})
public class TileEntityBorer
extends TileEntityBeamMachine
implements EnchantableMachine,
GuiController,
DiscreteFunction,
IHasWork {
    private final MachineEnchantmentHandler enchantments = new MachineEnchantmentHandler().addFilter(Enchantment.field_77346_s).addFilter(Enchantment.field_77349_p).addFilter(Enchantment.field_77348_q).addFilter(Enchantment.field_77338_j);
    private int pipemeta2 = 0;
    public boolean drops = true;
    private int reqpow;
    private int mintorque;
    public static final int DIGPOWER = (int)(64.0f * ConfigRegistry.getBorerPowerMult());
    private static final int genRange = ConfigRegistry.BORERGEN.getValue();
    private static int anticipationDistance = -1;
    private int step = 1;
    public boolean[][] cutShape = new boolean[7][5];
    private boolean jammed = false;
    private boolean nodig = false;
    private boolean isMiningAir = false;
    private boolean hitProtection = false;
    private int notifiedPlayer = 0;
    private int durability = ConfigRegistry.BORERMAINTAIN.getState() ? 256 : Integer.MAX_VALUE;
    private int soundtick = 0;

    protected void onFirstTick(World world, int x, int y, int z) {
        if (anticipationDistance < 0) {
            anticipationDistance = Math.max(2, Math.max(genRange, this.getServerViewDistance()));
        }
    }

    private int getServerViewDistance() {
        MinecraftServer s = MinecraftServer.func_71276_C();
        return s != null ? s.func_71203_ab().func_72395_o() : 0;
    }

    @Override
    public int getTextureStateForSide(int s) {
        switch (this.func_145832_p()) {
            case 0: {
                return s == 4 ? this.getActiveTexture() : 0;
            }
            case 1: {
                return s == 5 ? this.getActiveTexture() : 0;
            }
            case 3: {
                return s == 2 ? this.getActiveTexture() : 0;
            }
            case 2: {
                return s == 3 ? this.getActiveTexture() : 0;
            }
        }
        return 0;
    }

    @Override
    public void onRedirect() {
        this.reset();
    }

    public boolean repair() {
        if (this.durability > 0) {
            return false;
        }
        this.durability = ConfigRegistry.BORERMAINTAIN.getState() ? 256 : Integer.MAX_VALUE;
        return true;
    }

    public boolean isJammed() {
        return this.jammed;
    }

    public void reset() {
        this.step = 1;
        this.syncAllData(true);
    }

    public int getHeadX() {
        return this.field_145851_c + this.facing.offsetX * this.step;
    }

    public int getHeadZ() {
        return this.field_145849_e + this.facing.offsetZ * this.step;
    }

    @Override
    protected int getActiveTexture() {
        return this.power > 0L && this.power >= (long)this.reqpow && this.torque >= this.mintorque ? 1 : 0;
    }

    private void setJammed(boolean jam) {
        boolean old = this.jammed;
        this.jammed = jam;
        if (old != this.jammed) {
            ReikaWorldHelper.causeAdjacentUpdates((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        EntityPlayer ep;
        int i;
        super.updateTileEntity();
        ++this.tickcount;
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.enchantments.hasEnchantments()) {
            for (i = 0; i < 6; ++i) {
                world.func_72869_a("portal", -0.5 + (double)x + 2.0 * rand.nextDouble(), (double)y + rand.nextDouble(), -0.5 + (double)z + 2.0 * rand.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
        this.power = (long)this.omega * (long)this.torque;
        if (this.power <= 0L) {
            this.setJammed(false);
            this.reset();
            return;
        }
        if (this.hitProtection && this.notifiedPlayer < 10 && world.func_82737_E() % 100L == 0L && (ep = this.getPlacer()) != null) {
            ++this.notifiedPlayer;
            int hx = this.getHeadX();
            int hz = this.getHeadZ();
            String sg = "Your " + this + " has hit a protected area at " + hx + ", " + hz + " and has jammed.";
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)sg);
        }
        if (this.durability <= 0) {
            if (this.tickcount % 5 == 0) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 0.75f, 0.05f);
                for (i = 0; i < 6; ++i) {
                    world.func_72869_a("smoke", (double)x + rand.nextDouble(), (double)(y + 1) + rand.nextDouble() * 0.2, (double)z + rand.nextDouble(), 0.0, 0.0, 0.0);
                    world.func_72869_a("crit", (double)x + rand.nextDouble(), (double)(y + 1) + rand.nextDouble() * 0.2, (double)z + rand.nextDouble(), 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        this.nodig = true;
        for (i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (!this.cutShape[i][j]) continue;
                this.nodig = false;
                j = 7;
                i = 7;
            }
        }
        if (this.jammed && this.tickcount % 5 == 0) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 0.75f, 1.0f);
            for (i = 0; i < 6; ++i) {
                world.func_72869_a("smoke", (double)x + rand.nextDouble(), (double)(y + 1) + rand.nextDouble() * 0.2, (double)z + rand.nextDouble(), 0.0, 0.0, 0.0);
                world.func_72869_a("crit", (double)x + rand.nextDouble(), (double)(y + 1) + rand.nextDouble() * 0.2, (double)z + rand.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
        if (this.nodig) {
            return;
        }
        if (this.omega <= 0) {
            return;
        }
        if (this.tickcount == 1 || this.step == 1) {
            this.isMiningAir = this.checkMiningAir(world, x, y, z, meta);
        }
        if (this.soundtick > 0) {
            --this.soundtick;
        }
        if (!world.field_72995_K && this.tickcount >= this.getOperationTime() || this.isMiningAir && this.tickcount % 5 == 0) {
            this.skipMiningPipes(world, x, y, z, meta, 0, 128);
            this.calcReqPowerSafe(world, x, y, z, meta);
            if (this.power >= (long)this.reqpow && this.reqpow != -1) {
                this.setJammed(false);
                if (!world.field_72995_K) {
                    for (i = 0; i <= anticipationDistance; ++i) {
                        ReikaWorldHelper.forceGenAndPopulate((World)world, (int)(x + (this.step + 16 * i) * this.facing.offsetX), (int)(z + (this.step + 16 * i) * this.facing.offsetZ), (int)genRange);
                    }
                    this.safeDig(world, x, y, z, meta);
                    if (!this.isMiningAir) {
                        if (this.soundtick == 0) {
                            SoundRegistry.RUMBLE.playSoundAtBlock((TileEntity)this);
                            this.soundtick = 5;
                        }
                        --this.durability;
                    }
                }
            } else {
                this.setJammed(true);
            }
            this.tickcount = 0;
            this.isMiningAir = false;
        }
    }

    public String getCurrentRequiredPower() {
        if (this.reqpow < 0) {
            return "Infinity - Blocked";
        }
        double d1 = ReikaMathLibrary.getThousandBase((double)this.reqpow);
        double d2 = ReikaMathLibrary.getThousandBase((double)this.mintorque);
        String s1 = ReikaEngLibrary.getSIPrefix((double)this.reqpow);
        String s2 = ReikaEngLibrary.getSIPrefix((double)this.mintorque);
        return String.format("Required Power: %.3f%sW; Required Torque: %.3f%sNm", d1, s1, d2, s2);
    }

    private void safeDig(World world, int x, int y, int z, int meta) {
        try {
            this.dig(world, x, y, z, meta);
        }
        catch (RuntimeException e) {
            RotaryCraft.logger.logError((Object)(this + " triggered an exception mining a chunk, probably during worldgen!"));
            e.printStackTrace();
        }
    }

    private boolean checkMiningAir(World world, int x, int y, int z, int meta) {
        int a = 0;
        if (meta > 1) {
            a = 1;
        }
        int b = 1 - a;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                int zread;
                int yread;
                int xread;
                if (!this.cutShape[i][j] && this.step != 1 || world.func_147439_a(xread = x + this.step * this.facing.offsetX + a * (i - 3), yread = y + this.step * this.facing.offsetY + (4 - j), zread = z + this.step * this.facing.offsetZ + b * (i - 3)) == Blocks.field_150350_a) continue;
                return false;
            }
        }
        return true;
    }

    private void skipMiningPipes(World world, int x, int y, int z, int meta, int stepped, int max) {
        if (stepped >= max) {
            return;
        }
        int a = 0;
        if (meta > 1) {
            a = 1;
        }
        int b = 1 - a;
        boolean allpipe = true;
        boolean haspipe = false;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                int zread;
                int yread;
                int xread;
                if (!this.cutShape[i][j] && this.step != 1 || world.func_147439_a(xread = x + this.step * this.facing.offsetX + a * (i - 3), yread = y + this.step * this.facing.offsetY + (4 - j), zread = z + this.step * this.facing.offsetZ + b * (i - 3)) != BlockRegistry.MININGPIPE.getBlockInstance()) continue;
                haspipe = true;
                int meta2 = world.func_72805_g(xread, yread, zread);
                ForgeDirection dir = BlockMiningPipe.getDirectionFromMeta(meta2);
                if (meta2 == 3 || Math.abs(dir.offsetX) == Math.abs(this.facing.offsetX) && Math.abs(dir.offsetZ) == Math.abs(this.facing.offsetZ)) continue;
                allpipe = false;
            }
        }
        if (haspipe && allpipe) {
            ++this.step;
            this.skipMiningPipes(world, x, y, z, meta, stepped + 1, max);
        }
    }

    private boolean ignoreBlockExistence(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a) {
            return true;
        }
        if (b.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (ReikaBlockHelper.isLiquid((Block)b)) {
            return true;
        }
        if (b instanceof IgnoredByBorer) {
            return ((IgnoredByBorer)b).ignoreHardness(world, world.field_73011_w.field_76574_g, x, y, z, world.func_72805_g(x, y, z));
        }
        return false;
    }

    private void calcReqPowerSafe(World world, int x, int y, int z, int metadata) {
        try {
            this.calcReqPower(world, x, y, z, metadata);
        }
        catch (RuntimeException e) {
            RotaryCraft.logger.logError((Object)(this + " triggered an exception mining a chunk, probably during worldgen!"));
            e.printStackTrace();
            this.reqpow = -1;
        }
    }

    private void calcReqPower(World world, int x, int y, int z, int metadata) {
        this.reqpow = 0;
        this.mintorque = 0;
        int lowtorque = -1;
        int a = 0;
        if (metadata > 1) {
            a = 1;
        }
        int b = 1 - a;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (!this.cutShape[i][j] && this.step != 1) continue;
                int xread = x + this.step * this.facing.offsetX + a * (i - 3);
                int yread = y + this.step * this.facing.offsetY + (4 - j);
                int zread = z + this.step * this.facing.offsetZ + b * (i - 3);
                this.reqPowAdd(world, xread, yread, zread);
                if (this.reqpow != -1) continue;
                return;
            }
        }
        lowtorque = this.mintorque;
        if (this.torque < lowtorque) {
            this.reqpow = -1;
        }
    }

    private void reqPowAdd(World world, int xread, int yread, int zread) {
        if (this.step > 30000000) {
            this.reqpow = -1;
            return;
        }
        if (!this.ignoreBlockExistence(world, xread, yread, zread)) {
            Block id = world.func_147439_a(xread, yread, zread);
            int meta = world.func_72805_g(xread, yread, zread);
            float hard = id.func_149712_f(world, xread, yread, zread);
            if (TwilightForestHandler.getInstance().isToughBlock(id)) {
                this.mintorque += 2048;
                this.reqpow += 65536;
            } else if (hard < 0.0f) {
                this.reqpow = -1;
            } else if (id == BlockRegistry.DECO.getBlockInstance() && meta == ItemStacks.shieldblock.func_77960_j()) {
                this.reqpow = -1;
            } else if (id instanceof SemiUnbreakable && ((SemiUnbreakable)id).isUnbreakable(world, xread, yread, zread, meta)) {
                this.reqpow = -1;
            } else {
                this.reqpow += (int)((float)(DIGPOWER * 10) * hard);
                int sharp = this.enchantments.getEnchantment(Enchantment.field_77338_j);
                this.mintorque += TileEntityBorer.calculateTorqueForHardness(hard, sharp);
            }
            if (DragonOptions.DEBUGMODE.getState()) {
                RotaryCraft.logger.log((Object)(this + " mined block " + id + ":" + meta + " at " + xread + ", " + yread + ", " + zread + "; pow=" + this.reqpow + ", torq=" + this.mintorque));
            }
        }
    }

    public static int calculateTorqueForHardness(float hard, int sharp) {
        float c = 10.0f - 0.5f * (float)sharp;
        int add = ReikaMathLibrary.ceilPseudo2Exp((int)((int)(c * hard)));
        if (sharp > 0) {
            add = Math.min(add, ReikaMathLibrary.intpow2((int)2, (int)(10 - sharp / 3)));
        }
        return add;
    }

    public int getRequiredTorque() {
        return this.mintorque;
    }

    public long getRequiredPower() {
        return this.reqpow;
    }

    private void support(World world, int x, int y, int z, int metadata) {
        int a = 0;
        if (metadata > 1) {
            a = 1;
        }
        int b = 1 - a;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                int zread;
                int yread;
                int xread;
                Block id;
                if (!this.cutShape[i][j] && this.step != 1 || (id = world.func_147439_a(xread = x + this.step * this.facing.offsetX + a * (i - 3), (yread = y + this.step * this.facing.offsetY + (4 - j)) + 1, zread = z + this.step * this.facing.offsetZ + b * (i - 3))) != Blocks.field_150354_m && id != Blocks.field_150351_n || !this.checkTop(i, j)) continue;
                if (id == Blocks.field_150354_m) {
                    world.func_147449_b(xread, yread + 1, zread, Blocks.field_150322_A);
                    continue;
                }
                world.func_147449_b(xread, yread + 1, zread, Blocks.field_150348_b);
            }
        }
    }

    private boolean checkTop(int i, int j) {
        while (j > 0) {
            if (!this.cutShape[i][--j]) continue;
            return false;
        }
        return true;
    }

    private boolean dropBlocks(int xread, int yread, int zread, World world, int x, int y, int z, Block id, int meta) {
        if (ModList.TWILIGHT.isLoaded() && id == TwilightForestHandler.BlockEntry.MAZESTONE.getBlock()) {
            RotaryAchievements.CUTKNOT.triggerAchievement(this.getPlacer());
        }
        if (id == Blocks.field_150357_h || id == Blocks.field_150378_br) {
            return false;
        }
        if (!world.field_72995_K && !ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)xread, (int)yread, (int)zread, (Block)id, (int)meta, (EntityPlayerMP)this.getServerPlacer())) {
            this.hitProtection = true;
            return false;
        }
        TileEntity tile = this.getTileEntity(xread, yread, zread);
        if (tile instanceof RotaryCraftTileEntity) {
            return false;
        }
        if (this.drops && id != Blocks.field_150350_a) {
            TileEntityMobSpawner spw;
            if (id == Blocks.field_150474_ac && (spw = (TileEntityMobSpawner)tile) != null) {
                ItemStack is = ItemRegistry.SPAWNER.getStackOf();
                ReikaSpawnerHelper.addMobNBTToItem((ItemStack)is, (TileEntityMobSpawner)spw);
                if (!this.chestCheck(world, x, y, z, is)) {
                    ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 1.125), (double)((double)z + 0.5), (ItemStack)is, (double)3.0);
                }
                return true;
            }
            if (tile instanceof IInventory) {
                IInventory ii = (IInventory)tile;
                ArrayList contents = ReikaInventoryHelper.getWholeInventory((IInventory)ii);
                ReikaInventoryHelper.clearInventory((IInventory)ii);
                for (int i = 0; i < contents.size(); ++i) {
                    ItemStack is = (ItemStack)contents.get(i);
                    boolean fits = this.chestCheck(world, x, y, z, is);
                    if (fits) continue;
                    ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 1.125), (double)((double)z + 0.5), (ItemStack)is, (double)3.0);
                }
            }
            if (this.enchantments.getEnchantment(Enchantment.field_77348_q) > 0 && this.canSilk(world, xread, yread, zread)) {
                ItemStack is = ReikaBlockHelper.getSilkTouch((World)world, (int)xread, (int)yread, (int)zread, (Block)id, (int)meta, (EntityPlayer)this.getPlacer(), (boolean)false);
                if (!this.chestCheck(world, x, y, z, is)) {
                    ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 1.125), (double)((double)z + 0.5), (ItemStack)is, (double)3.0);
                }
                return true;
            }
            int fortune = this.enchantments.getEnchantment(Enchantment.field_77346_s);
            if (ModList.CHROMATICRAFT.isLoaded()) {
                // empty if block
            }
            Collection items = id.getDrops(world, xread, yread, zread, meta, fortune);
            MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.HarvestDropsEvent(xread, yread, zread, world, id, meta, fortune, 1.0f, items, this.getPlacer(), false));
            if (id instanceof BlockTieredResource) {
                EntityPlayer ep = this.getPlacer();
                BlockTieredResource bt = (BlockTieredResource)id;
                boolean harvest = ep != null && bt.isPlayerSufficientTier((IBlockAccess)world, xread, yread, zread, ep);
                items = harvest ? bt.getHarvestResources(world, xread, yread, zread, fortune, ep) : bt.getNoHarvestResources(world, xread, yread, zread, fortune, ep);
            } else if (id instanceof BlockTileEnum) {
                items = ReikaJavaLibrary.makeListFrom((Object)((BlockTileEnum)id).getMapping((IBlockAccess)world, xread, yread, zread).getCraftedProduct());
            }
            if (items != null) {
                for (ItemStack is : items) {
                    if (this.chestCheck(world, x, y, z, is)) continue;
                    ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 1.125), (double)((double)z + 0.5), (ItemStack)is, (double)3.0);
                }
            }
        }
        return true;
    }

    private boolean canSilk(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        if (id == Blocks.field_150350_a) {
            return false;
        }
        if (id == Blocks.field_150480_ab) {
            return false;
        }
        if (id == Blocks.field_150383_bp) {
            return false;
        }
        if (id == Blocks.field_150436_aH) {
            return false;
        }
        if (id == Blocks.field_150455_bV || id == Blocks.field_150441_bU) {
            return false;
        }
        if (id == Blocks.field_150416_aS || id == Blocks.field_150413_aR) {
            return false;
        }
        if (id == Blocks.field_150488_af) {
            return false;
        }
        if (id == Blocks.field_150326_M || id == Blocks.field_150332_K) {
            return false;
        }
        if (id == Blocks.field_150466_ao || id == Blocks.field_150454_av) {
            return false;
        }
        if (BlockRegistry.isTechnicalBlock(id)) {
            return false;
        }
        if (id.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (ReikaBlockHelper.isLiquid((Block)id)) {
            return false;
        }
        if (id instanceof BlockTieredResource) {
            return false;
        }
        if (id.hasTileEntity(world.func_72805_g(x, y, z))) {
            return false;
        }
        return !(id instanceof BlockDoublePlant);
    }

    private boolean chestCheck(World world, int x, int y, int z, ItemStack is) {
        if (is == null) {
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (!(te instanceof IInventory)) continue;
            boolean flag = true;
            if (te instanceof PartialInventory && !((PartialInventory)te).hasInventory()) {
                flag = false;
            }
            if (!flag || !ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)((IInventory)te))) continue;
            return true;
        }
        return false;
    }

    private void dig(World world, int x, int y, int z, int metadata) {
        if (this.step == 1) {
            RotaryAchievements.BORER.triggerAchievement(this.getPlacer());
        }
        this.support(world, x, y, z, metadata);
        int a = 0;
        if (metadata > 1) {
            a = 1;
        }
        int b = 1 - a;
        if (this.step == 1) {
            this.pipemeta2 = this.pipemeta;
            this.pipemeta = 3;
        } else if (this.pipemeta > 2 && this.pipemeta2 != 3) {
            this.pipemeta = this.pipemeta2;
        }
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (!this.cutShape[i][j] && this.step != 1) continue;
                int xread = x + this.step * this.facing.offsetX + a * (i - 3);
                int yread = y + this.step * this.facing.offsetY + (4 - j);
                int zread = z + this.step * this.facing.offsetZ + b * (i - 3);
                Block bk = world.func_147439_a(xread, yread, zread);
                if (this.dropBlocks(xread, yread, zread, world, x, y, z, bk, world.func_72805_g(xread, yread, zread))) {
                    ReikaSoundHelper.playBreakSound((World)world, (int)xread, (int)yread, (int)zread, (Block)bk);
                    world.func_147465_d(xread, yread, zread, BlockRegistry.MININGPIPE.getBlockInstance(), this.pipemeta, 3);
                    continue;
                }
                --this.step;
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new BorerDigEvent((TileEntity)this, this.step, x + this.step * this.facing.offsetX, y + this.step * this.facing.offsetY, z + this.step * this.facing.offsetZ, this.enchantments.hasEnchantment(Enchantment.field_77348_q)));
        ++this.step;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("step", this.step);
        NBT.func_74757_a("jam", this.jammed);
        NBT.func_74768_a("dura", this.durability);
        NBT.func_74768_a("reqpow", this.reqpow);
        NBT.func_74768_a("reqtrq", this.mintorque);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.step = NBT.func_74762_e("step");
        this.jammed = NBT.func_74767_n("jam");
        this.durability = NBT.func_74762_e("dura");
        this.mintorque = NBT.func_74762_e("reqtrq");
        this.reqpow = NBT.func_74762_e("reqpow");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74757_a("drops", this.drops);
        NBT.func_74782_a("enchants", (NBTBase)this.enchantments.writeToNBT());
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                NBT.func_74757_a("cut" + String.valueOf(i * 7 + j), this.cutShape[i][j]);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.drops = NBT.func_74767_n("drops");
        this.enchantments.readFromNBT(NBT.func_150295_c("enchants", ReikaNBTHelper.NBTTypes.COMPOUND.ID));
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.cutShape[i][j] = NBT.func_74767_n("cut" + String.valueOf(i * 7 + j));
            }
        }
    }

    @Override
    protected void makeBeam(World world, int x, int y, int z, int meta) {
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.BORER;
    }

    public int getRedstoneOverride() {
        return this.isJammed() ? 15 : 0;
    }

    @Override
    public int getOperationTime() {
        int base = DurationRegistry.BORER.getOperationTime(this.omega);
        float ench = ReikaEnchantmentHelper.getEfficiencyMultiplier((int)this.enchantments.getEnchantment(Enchantment.field_77349_p));
        return (int)((float)base / ench);
    }

    @Override
    public MachineEnchantmentHandler getEnchantmentHandler() {
        return this.enchantments;
    }

    public boolean hasWork() {
        return !this.nodig && !this.isMiningAir;
    }
}

