/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.ChromatiCraft.API.Interfaces.CrystalTank;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySpillway
extends RotaryCraftTileEntity
implements PipeConnector,
IFluidHandler {
    public static final int CAPACITY = 8000;
    private final HybridTank tank = new HybridTank("spillway", 8000);
    private BlockArray liquidPool;
    private Collection<Coordinate> forcedEmpty = new ArrayList<Coordinate>();
    private int activeTick;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.SPILLWAY;
    }

    @Override
    public boolean hasModelTransparency() {
        return true;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        int add;
        TileEntity te;
        Block ab;
        ForgeDirection dir = this.getDrainSide(meta);
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        Block b = world.func_147439_a(dx, dy, dz);
        int metadata = world.func_72805_g(dx, dy, dz);
        Block b2 = world.func_147439_a(dx, dy + 1, dz);
        Fluid f = ReikaFluidHelper.lookupFluidForBlock((Block)b);
        if (InterfaceCache.STREAM.instanceOf((Object)b) && metadata == 0 || InterfaceCache.STREAM.instanceOf((Object)b2)) {
            this.liquidPool = null;
            this.handleStream(world, x, y, z, dx, dy + 1, dz);
        } else if (f == FluidRegistry.WATER) {
            if (ReikaWorldHelper.isLiquidAColumn((World)world, (int)dx, (int)(dy + 1), (int)dz)) {
                this.liquidPool = null;
                this.tank.addLiquid((int)(50.0f * ConfigRegistry.getFreeWaterProduction()), FluidRegistry.WATER);
                this.setActive();
            } else {
                this.formAndDrainPool(world, x, y, z, dx, dy, dz, b);
            }
        } else {
            this.liquidPool = null;
        }
        if (this.activeTick > 0) {
            --this.activeTick;
        }
        if (ReikaFluidHelper.lookupFluidForBlock((Block)(ab = world.func_147439_a(x, y + 1, z))) == FluidRegistry.WATER) {
            world.func_147449_b(x, y + 1, z, Blocks.field_150350_a);
        }
        if ((te = this.getAdjacentTileEntity(ForgeDirection.DOWN)) instanceof CrystalTank && (te = ((CrystalTank)te).getController()) != null && (add = ((CrystalTank)te).addFluid(this.tank.getActualFluid(), Math.max(1, this.tank.getLevel() / 32))) > 0) {
            this.tank.removeLiquid(add);
        }
    }

    private void formAndDrainPool(World world, int x, int y, int z, int dx, int dy, int dz, Block id) {
        if (this.liquidPool == null || this.liquidPool.isEmpty()) {
            this.liquidPool = new BlockArray();
            this.liquidPool.maxDepth = 240;
            this.liquidPool.clampToChunkLoad = true;
            this.liquidPool.recursiveAddWithBoundsMetadata((IBlockAccess)world, dx, dy, dz, id, 0, x - 64, y, z - 64, x + 64, y + 24, z + 64);
            this.liquidPool.sortBlocksByDistance(new Coordinate((TileEntity)this));
            this.liquidPool.sortBlocksByHeight(true);
            this.forcedEmpty.clear();
        }
        if (this.liquidPool.isEmpty()) {
            this.liquidPool = null;
            return;
        }
        if (this.tank.canTakeIn(1000)) {
            Coordinate c = this.liquidPool.getNextAndMoveOn();
            this.forcedEmpty.add(c);
            this.tank.addLiquid(1000, FluidRegistry.WATER);
            this.setActive();
        }
        for (Coordinate c2 : this.forcedEmpty) {
            c2.setBlock(world, Blocks.field_150350_a, 0, 2);
        }
    }

    private void handleStream(World world, int x, int y, int z, int dx, int dy, int dz) {
        boolean act = this.isActive();
        if (this.tank.canTakeIn(250)) {
            this.setActive();
            this.tank.addLiquid(250, FluidRegistry.WATER);
            if (this.getTicksExisted() % 8 == 0) {
                this.syncAllData(false);
            }
        }
        if (act != this.isActive()) {
            this.syncAllData(false);
        }
    }

    private void setActive() {
        boolean lastActive = this.activeTick > 0;
        this.activeTick = 4;
        if (!lastActive) {
            this.syncAllData(false);
        }
    }

    public boolean isActive() {
        return this.activeTick > 0;
    }

    private ForgeDirection getDrainSide(int meta) {
        switch (meta) {
            case 0: {
                return ForgeDirection.EAST;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public ForgeDirection getDrainSide() {
        return this.getDrainSide(this.func_145832_p());
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public int getLevel() {
        return this.tank.getLevel();
    }

    public Fluid getFluid() {
        return this.tank.getActualFluid();
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return from == ForgeDirection.DOWN && resource.getFluid() == FluidRegistry.WATER ? this.tank.drain(resource.amount, doDrain) : null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return from == ForgeDirection.DOWN ? this.tank.drain(maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.DOWN;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == ForgeDirection.DOWN ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        NBT.func_74768_a("active", this.activeTick);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.activeTick = NBT.func_74762_e("active");
    }
}

