/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Surveying;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockVector;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Interfaces.GPRReactive;
import Reika.RotaryCraft.Auxiliary.BlockColorMapper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGPR
extends TileEntityPowerReceiver
implements GuiController,
RangedEffect {
    public static final int MAX_HEIGHT = 96;
    public static final int MAX_WIDTH = 81;
    private BlockKey[][] blocks = new BlockKey[96][81];
    private boolean xdir;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private int oldmeta = 0;

    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public BlockVector getLookDirection() {
        return new BlockVector(this.field_145851_c + this.offsetX, this.field_145848_d + this.offsetY, this.field_145849_e + this.offsetZ, ReikaDirectionHelper.getRightBy90((ForgeDirection)this.getGuiDirection()));
    }

    public void shift(ForgeDirection dir, int amt) {
        if (amt == 0) {
            this.offsetZ = 0;
            this.offsetY = 0;
            this.offsetX = 0;
        } else {
            this.offsetX += dir.offsetX * amt;
            this.offsetY += dir.offsetY * amt;
            this.offsetZ += dir.offsetZ * amt;
        }
    }

    public void shiftInt(int amt) {
        this.shift(this.getGuiDirection(), amt);
    }

    public void resetOffset() {
        this.offsetZ = 0;
        this.offsetY = 0;
        this.offsetX = 0;
    }

    public ForgeDirection getGuiDirection() {
        return this.xdir ? ForgeDirection.SOUTH : ForgeDirection.EAST;
    }

    public double getSpongy(World world, int x, int y, int z) {
        int numcave = 0;
        int numsolid = 0;
        boolean dungeon = false;
        boolean mineshaft = false;
        boolean stronghold = false;
        int range = this.getRange();
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = y; k >= 0; --k) {
                    Block id = world.func_147439_a(x + i, k, z + j);
                    if (ReikaWorldHelper.caveBlock((Block)id)) {
                        ++numcave;
                    } else {
                        ++numsolid;
                    }
                    if (id == Blocks.field_150321_G) {
                        mineshaft = true;
                    }
                    if (id != Blocks.field_150384_bq && id != Blocks.field_150378_br) continue;
                    stronghold = true;
                }
            }
        }
        double ans = (double)numcave / (double)(numcave + numsolid);
        return ans;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        this.power = (long)this.omega * (long)this.torque;
        if (this.power < this.MINPOWER) {
            return;
        }
        RotaryAchievements.GPR.triggerAchievement(this.getPlacer());
        if (this.tickcount == 0) {
            this.eval2(world, x + this.offsetX, y + this.offsetY, z + this.offsetZ, meta);
            this.tickcount = 20;
        }
        --this.tickcount;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor(int x, int y) {
        return TileEntityGPR.getBlockColor(this.getBlock(x, y));
    }

    public BlockKey getBlock(int x, int y) {
        return this.blocks[y - 1][x + this.getRange()];
    }

    @SideOnly(value=Side.CLIENT)
    private static int getBlockColor(BlockKey bk) {
        return bk != null ? BlockColorMapper.instance.getColorForBlock(bk.blockID, bk.metadata) : BlockColorMapper.UNKNOWN_COLOR.getColor();
    }

    private void eval2(World world, int x, int y, int z, int meta) {
        ForgeDirection dir = ReikaDirectionHelper.getRightBy90((ForgeDirection)this.getGuiDirection());
        int r = this.getRange();
        for (int j = -r; j <= r; ++j) {
            for (int dd = 1; dd <= 96; ++dd) {
                BlockKey bk;
                int dy = this.field_145848_d - dd;
                int dx = x + j * Math.abs(dir.offsetX);
                int dz = z + j * Math.abs(dir.offsetZ);
                this.blocks[dd - 1][j + r] = bk = BlockKey.getAt((IBlockAccess)world, (int)dx, (int)dy, (int)dz);
                this.handleBlock(world, dx, dy, dz, bk);
            }
        }
    }

    private void handleBlock(World world, int x, int y, int z, BlockKey bk) {
        if (bk.blockID == Blocks.field_150384_bq || bk.blockID == Blocks.field_150378_br) {
            RotaryAchievements.GPRENDPORTAL.triggerAchievement(this.getPlacer());
        } else if (bk.blockID == Blocks.field_150474_ac) {
            RotaryAchievements.GPRSPAWNER.triggerAchievement(this.getPlacer());
        }
        if (bk.blockID instanceof GPRReactive) {
            ((GPRReactive)bk.blockID).onScanned(world, x, y, z, bk.blockID, bk.metadata);
        }
    }

    @Override
    public int getRange() {
        return Math.min(this.getMaxRange(), 2 * ReikaMathLibrary.logbase2((long)(this.power - this.MINPOWER)));
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.GPR;
    }

    @Override
    public int getMaxRange() {
        return 40;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.offsetX = NBT.func_74762_e("xoff");
        this.offsetY = NBT.func_74762_e("yoff");
        this.offsetZ = NBT.func_74762_e("zoff");
        this.xdir = NBT.func_74767_n("xd");
    }

    @Override
    public void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("xoff", this.offsetX);
        NBT.func_74768_a("yoff", this.offsetY);
        NBT.func_74768_a("zoff", this.offsetZ);
        NBT.func_74757_a("xd", this.xdir);
    }

    public void setDirection(boolean x) {
        this.xdir = x;
        this.syncAllData(false);
        this.triggerBlockUpdate();
    }

    public void flipDirection() {
        this.setDirection(!this.xdir);
    }
}

