/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityPlayerDetector
extends TileEntityPowerReceiver
implements GuiController,
RangedEffect {
    public static final int FALLOFF = 128;
    public static final int SPEEDFACTOR = 32;
    public static final int BASESPEED = 100;
    public boolean analog = false;
    private boolean isActive = false;
    public int powerLevel = 0;
    public int selectedrange;
    private int ticksdetected = 0;

    public boolean isActive() {
        return this.isActive;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        if (this.power < this.MINPOWER) {
            this.isActive = false;
            this.ticksdetected = 0;
            return;
        }
        if (!this.analog) {
            this.powerLevel = 0;
            if (this.checkForPlayers(world, x, y, z)) {
                ++this.ticksdetected;
                if (this.ticksdetected >= this.getReactionTime()) {
                    this.isActive = true;
                }
            } else {
                this.isActive = false;
                this.ticksdetected = 0;
            }
        } else {
            this.isActive = false;
            int level = this.countPlayers(world, x, y, z);
            if (level > 0) {
                ++this.ticksdetected;
                if (this.ticksdetected >= this.getReactionTime()) {
                    this.powerLevel = level;
                }
            } else {
                this.powerLevel = 0;
                this.ticksdetected = 0;
            }
        }
    }

    public int getReactionTime() {
        int time = 100 - this.omega / 32;
        if (time < 1) {
            time = 1;
        }
        return time;
    }

    private int countPlayers(World world, int x, int y, int z) {
        int range = this.getRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)range, (double)range, (double)range);
        List inbox = world.func_72872_a(EntityPlayer.class, box);
        int count = inbox.size();
        if (count > 15) {
            count = 15;
        }
        return count;
    }

    private boolean checkForPlayers(World world, int x, int y, int z) {
        int range = this.getRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)range, (double)range, (double)range);
        List inbox = world.func_72872_a(EntityPlayer.class, box);
        return inbox.size() > 0;
    }

    @Override
    public int getRange() {
        int range = (int)(this.power / 128L);
        if (range > this.getMaxRange()) {
            range = this.getMaxRange();
        }
        if (range > this.selectedrange) {
            return this.selectedrange;
        }
        return range;
    }

    @Override
    public int getMaxRange() {
        int range = (int)(this.power / 128L);
        int max = Math.max(64, ConfigRegistry.DETECTORRANGE.getValue());
        if (range > max) {
            range = max;
        }
        return range;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("range", this.selectedrange);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.selectedrange = NBT.func_74762_e("range");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.PLAYERDETECTOR;
    }

    public int getRedstoneOverride() {
        if (this.isActive) {
            return 15;
        }
        return 0;
    }
}

