/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBeltHub;

public class TileEntitySplitBelt
extends TileEntityBeltHub {
    public static final int TAKEOFF_TORQUE = 64;
    public static final int TAKEOFF_TORQUE_WET = 16;

    @Override
    public boolean isSplitting() {
        return !this.isReceivingEnd;
    }

    @Override
    public int copyTorqueFromDriverSide(int input) {
        return Math.min(input, this.getTakeoff());
    }

    private int getTakeoff() {
        return this.isWet() ? 16 : 64;
    }

    @Override
    public int copyOmegaFromDriverSide(int input) {
        if (this.isWet()) {
            input = (int)((double)input * ReikaRandomHelper.getRandomBetween((double)0.75, (double)1.0));
        }
        return super.copyOmegaFromDriverSide(input);
    }

    @Override
    protected int getPropagatedTorque(int input) {
        return this.hasValidConnection() ? input - this.getTakeoff() : input;
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.SPLITBELT;
    }

    @Override
    protected void setReceiverIOSides() {
        this.write = this.read.getOpposite();
    }

    @Override
    protected boolean mergeReceivingPower() {
        int prevT = this.torque;
        int prevO = this.omega;
        this.getPower(false);
        if (this.power > 0L || prevT > 0 && prevO > 0) {
            this.torque += prevT;
            this.omega = (this.omega + prevO) / 2;
            this.power = (long)this.torque * (long)this.omega;
            return true;
        }
        return false;
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        return super.getPowerSources(io, caller);
    }

    @Override
    public int getBeltColor() {
        return ReikaColorAPI.RGBtoHex((int)48, (int)96, (int)64);
    }
}

