/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAirGun
extends TileEntityPowerReceiver
implements RangedEffect,
DiscreteFunction {
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        if (this.tickcount >= this.getOperationTime() && !world.field_72995_K) {
            AxisAlignedBB box = this.drawAABB(x, y, z, meta);
            List li = world.func_72872_a(EntityLivingBase.class, box);
            if (li.size() > 0 && !ReikaEntityHelper.allAreDead((List)li, (boolean)false)) {
                this.fire(world, x, y, z, meta, li);
            }
            this.tickcount = 0;
        }
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
            }
        }
    }

    private double getFirePower() {
        return ReikaMathLibrary.logbase((long)(this.torque + 1), (int)2);
    }

    @Override
    public int getOperationTime() {
        return Math.max(16 - (int)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), 4);
    }

    private void fire(World world, int x, int y, int z, int meta, List<EntityLivingBase> li) {
        double vx = 0.0;
        double vz = 0.0;
        double v = this.getFirePower() / 4.0;
        switch (meta) {
            case 1: {
                vx = v;
                break;
            }
            case 0: {
                vx = -v;
                break;
            }
            case 3: {
                vz = v;
                break;
            }
            case 2: {
                vz = -v;
            }
        }
        boolean flag = false;
        for (EntityLivingBase e : li) {
            EntityPlayer ep;
            int x2 = (int)Math.floor(e.field_70165_t);
            int z2 = (int)Math.floor(e.field_70161_v);
            int y2 = (int)e.field_70163_u - 1;
            Block b = world.func_147439_a(x2, y2, z2);
            boolean immune = false;
            if (e instanceof EntityPlayer && (this.isPlacer(ep = (EntityPlayer)e) || ReikaPlayerAPI.isReika((EntityPlayer)ep))) {
                immune = true;
            }
            if (immune || b == Blocks.field_150350_a) continue;
            e.field_70159_w = vx;
            e.field_70179_y = vz;
            e.field_70181_x = 0.5;
            e.field_70133_I = true;
            flag = true;
        }
        if (flag) {
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode", (float)1.0f, (float)1.0f);
        }
    }

    private AxisAlignedBB drawAABB(int x, int y, int z, int meta) {
        double d = 0.1;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72331_e(d, d, d);
        switch (meta) {
            case 1: {
                box.func_72317_d(1.0, 0.0, 0.0);
                box.field_72336_d += (double)this.getRange();
                break;
            }
            case 0: {
                box.func_72317_d(-1.0, 0.0, 0.0);
                box.field_72340_a -= (double)this.getRange();
                break;
            }
            case 3: {
                box.func_72317_d(0.0, 0.0, 1.0);
                box.field_72334_f += (double)this.getRange();
                break;
            }
            case 2: {
                box.func_72317_d(0.0, 0.0, -1.0);
                box.field_72339_c -= (double)this.getRange();
            }
        }
        return box;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.AIRGUN;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int getRange() {
        return this.getMaxRange();
    }

    @Override
    public int getMaxRange() {
        return 10 + 2 * (int)ReikaMathLibrary.logbase((long)(this.torque + 1), (int)2);
    }
}

