/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Interfaces.Block.SemiTransparent;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Event.HeatRayNetherDetonationEvent;
import Reika.RotaryCraft.API.Interfaces.Laserable;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityBeamMachine;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityHeatRay
extends TileEntityBeamMachine
implements RangedEffect {
    public static final int FALLOFF = 256;
    private static final HashMap<BlockKey, LaserEffect> blockEffects = new HashMap();
    private static final LaserEffect deletionEffect = new DeletionLaserEffect();
    private static final LaserEffect meltEffectLava = new MeltLaserEffect(FluidRegistry.LAVA);
    private static final LaserEffect meltEffectWater = new MeltLaserEffect(FluidRegistry.WATER);
    private static final LaserEffect igniteEffect = new IgnitionLaserEffect();
    private static final LaserEffect glassifyEffect = new BlockChangeLaserEffect(Blocks.field_150359_w);
    private static final LaserEffect sandifyEffect = new BlockChangeLaserEffect((Block)Blocks.field_150354_m);

    private static void addBlockEffect(Block b, LaserEffect e) {
        blockEffects.put(new BlockKey(b), e);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.power = (long)this.omega * (long)this.torque;
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        this.makeBeam(world, x, y, z, meta);
    }

    @Override
    protected void makeBeam(World world, int x, int y, int z, int metadata) {
        boolean blocked = false;
        if (this.power >= this.MINPOWER) {
            int step;
            int maxdist = this.getRange();
            for (step = 1; !(step >= maxdist || step >= this.getMaxRange() && this.getMaxRange() != -1 || blocked); ++step) {
                int dx = x + step * this.facing.offsetX;
                int dy = y + step * this.facing.offsetY;
                int dz = z + step * this.facing.offsetZ;
                Block id = world.func_147439_a(dx, dy, dz);
                int meta2 = world.func_72805_g(dx, dy, dz);
                if (id != Blocks.field_150350_a && id.isFlammable((IBlockAccess)world, dx, dy, dz, ForgeDirection.UP)) {
                    ReikaWorldHelper.ignite((World)world, (int)dx, (int)dy, (int)dz);
                }
                if (this.affectBlock(world, dx, dy, dz, step, id, meta2, maxdist)) {
                    blocked = true;
                }
                if (id != world.func_147439_a(dx, dy, dz) || meta2 != world.func_72805_g(dx, dy, dz)) {
                    world.func_147471_g(dx, dy, dz);
                }
                if (id instanceof SemiTransparent) {
                    SemiTransparent st = (SemiTransparent)id;
                    if (!st.isOpaque(meta2)) continue;
                    blocked = true;
                    continue;
                }
                if (!id.func_149662_c()) continue;
                blocked = true;
            }
            AxisAlignedBB zone = this.getBurnZone(metadata, step);
            List inzone = this.field_145850_b.func_72872_a(Entity.class, zone);
            for (Entity caught : inzone) {
                if (!(caught instanceof EntityItem)) {
                    caught.func_70015_d(this.getBurnTime());
                }
                if (caught instanceof EntityTNTPrimed) {
                    world.func_72869_a("lava", caught.field_70165_t + (double)rand.nextFloat(), caught.field_70163_u + (double)rand.nextFloat(), caught.field_70161_v + (double)rand.nextFloat(), 0.0, 0.0, 0.0);
                }
                if (!(caught instanceof Laserable)) continue;
                ((Laserable)caught).whenInBeam(world, MathHelper.func_76128_c((double)caught.field_70165_t), MathHelper.func_76128_c((double)caught.field_70163_u), MathHelper.func_76128_c((double)caught.field_70161_v), this.power, step);
            }
        }
    }

    public int getBurnTime() {
        return 2 + (int)(16L * this.power / this.MINPOWER);
    }

    @Override
    public int getRange() {
        int r = (int)(8L + (this.power - this.MINPOWER) / 256L);
        if (r > this.getMaxRange()) {
            return this.getMaxRange();
        }
        return r;
    }

    private AxisAlignedBB getBurnZone(int meta, int step) {
        int minx = 0;
        int miny = 0;
        int minz = 0;
        int maxx = 0;
        int maxy = 0;
        int maxz = 0;
        switch (meta) {
            case 0: {
                minx = this.field_145851_c - step;
                maxx = this.field_145851_c - 1;
                miny = this.field_145848_d;
                maxy = this.field_145848_d;
                minz = this.field_145849_e;
                maxz = this.field_145849_e;
                break;
            }
            case 1: {
                minx = this.field_145851_c + 1;
                maxx = this.field_145851_c + step;
                miny = this.field_145848_d;
                maxy = this.field_145848_d + 1;
                minz = this.field_145849_e;
                maxz = this.field_145849_e + 1;
                break;
            }
            case 2: {
                maxz = this.field_145849_e + step;
                minz = this.field_145849_e + 1;
                miny = this.field_145848_d;
                maxy = this.field_145848_d + 1;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
                break;
            }
            case 3: {
                maxz = this.field_145849_e - 1;
                minz = this.field_145849_e - step;
                miny = this.field_145848_d;
                maxy = this.field_145848_d + 1;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
                break;
            }
            case 4: {
                miny = this.field_145848_d;
                maxz = this.field_145849_e + 1;
                miny = this.field_145848_d + 1;
                maxy = this.field_145848_d + step;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
                break;
            }
            case 5: {
                minz = this.field_145849_e;
                maxz = this.field_145849_e + 1;
                miny = this.field_145848_d - 1;
                maxy = this.field_145848_d - step - 1;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
            }
        }
        return AxisAlignedBB.func_72330_a((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz);
    }

    private boolean affectBlock(World world, int dx, int dy, int dz, int step, Block id, int metadata, int maxdist) {
        TileEntity te;
        if (id == Blocks.field_150350_a) {
            return false;
        }
        if (id.hasTileEntity(metadata) && (te = world.func_147438_o(dx, dy, dz)) instanceof Laserable) {
            ((Laserable)te).whenInBeam(world, dx, dy, dz, this.power, step);
            if (((Laserable)te).blockBeam(world, dx, dy, dz, this.power)) {
                return true;
            }
        }
        if (id instanceof Laserable) {
            ((Laserable)id).whenInBeam(world, dx, dy, dz, this.power, step);
            return ((Laserable)id).blockBeam(world, dx, dy, dz, this.power);
        }
        if (ConfigRegistry.ATTACKBLOCKS.getState()) {
            LaserEffect e = blockEffects.get(new BlockKey(id, metadata));
            if (e != null) {
                long surp = this.power / this.MINPOWER;
                int n = e.getDelayTick(id, metadata, surp, step);
                if (this.tickcount >= n) {
                    this.tickcount = 0;
                    return e.doEffect(world, dx, dy, dz, this.power, step, this.tickcount, this);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.HEATRAY;
    }

    @Override
    public int getMaxRange() {
        return Math.max(64, ConfigRegistry.HEATRAYRANGE.getValue());
    }

    public int getRedstoneOverride() {
        return 0;
    }

    static {
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150329_H, deletionEffect);
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150337_Q, deletionEffect);
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150338_P, deletionEffect);
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150328_O, deletionEffect);
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150327_N, deletionEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150464_aj, deletionEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150393_bb, deletionEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150394_bc, deletionEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150469_bN, deletionEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150459_bM, deletionEffect);
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150330_I, deletionEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150395_bd, deletionEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150392_bi, deletionEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150321_G, deletionEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150431_aC, deletionEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150355_j, deletionEffect);
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150358_i, deletionEffect);
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150362_t, igniteEffect);
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150361_u, igniteEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150364_r, igniteEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150363_s, igniteEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150347_e, meltEffectLava);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150348_b, meltEffectLava);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150322_A, meltEffectLava);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150417_aV, meltEffectLava);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150432_aD, meltEffectWater);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150433_aE, meltEffectWater);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150351_n, new BlockChangeLaserEffect(Blocks.field_150347_e));
        TileEntityHeatRay.addBlockEffect(Blocks.field_150341_Y, new BlockChangeLaserEffect(Blocks.field_150347_e));
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150349_c, new BlockChangeLaserEffect(Blocks.field_150346_d));
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150391_bh, new BlockChangeLaserEffect(Blocks.field_150346_d));
        TileEntityHeatRay.addBlockEffect(Blocks.field_150346_d, sandifyEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150458_ak, sandifyEffect);
        TileEntityHeatRay.addBlockEffect((Block)Blocks.field_150354_m, glassifyEffect);
        TileEntityHeatRay.addBlockEffect(Blocks.field_150335_W, new LaserEffect(){

            @Override
            public boolean doEffect(World world, int x, int y, int z, long power, int range, int tickcount, TileEntityHeatRay te) {
                world.func_147468_f(x, y, z);
                EntityTNTPrimed var6 = new EntityTNTPrimed(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, null);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)var6);
                }
                world.func_72956_a((Entity)var6, "random.fuse", 1.0f, 1.0f);
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), 0.0, 0.0, 0.0);
                return false;
            }

            @Override
            public int getDelayTick(Block b, int meta, long surplus, int dist) {
                return 0;
            }
        });
        TileEntityHeatRay.addBlockEffect(Blocks.field_150424_aL, new LaserEffect(){

            @Override
            public boolean doEffect(World world, int x, int y, int z, long power, int range, int tickcount, TileEntityHeatRay te) {
                if (!world.field_72995_K) {
                    world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 5.0f, true, true);
                    MinecraftForge.EVENT_BUS.post((Event)new HeatRayNetherDetonationEvent(world, x, y, z));
                    if (world.field_73011_w.field_76574_g == -1 && range >= 500) {
                        RotaryAchievements.NETHERHEATRAY.triggerAchievement(te.getPlacer());
                    }
                }
                return true;
            }

            @Override
            public int getDelayTick(Block b, int meta, long surplus, int dist) {
                return 6;
            }
        });
    }

    private static interface LaserEffect {
        public int getDelayTick(Block var1, int var2, long var3, int var5);

        public boolean doEffect(World var1, int var2, int var3, int var4, long var5, int var7, int var8, TileEntityHeatRay var9);
    }

    private static class DeletionLaserEffect
    implements LaserEffect {
        private DeletionLaserEffect() {
        }

        @Override
        public boolean doEffect(World world, int x, int y, int z, long power, int range, int tickcount, TileEntityHeatRay te) {
            world.func_147468_f(x, y, z);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
            return false;
        }

        @Override
        public int getDelayTick(Block b, int meta, long surplus, int dist) {
            return (int)Math.min(Integer.MAX_VALUE, (long)(4 * dist) / (8L * surplus));
        }
    }

    private static class MeltLaserEffect
    implements LaserEffect {
        private final Fluid fluid;

        private MeltLaserEffect(Fluid f) {
            this.fluid = f;
        }

        @Override
        public boolean doEffect(World world, int x, int y, int z, long power, int range, int tickcount, TileEntityHeatRay te) {
            world.func_147465_d(x, y, z, this.getBlock(), 0, 3);
            world.func_147439_a(x, y, z).func_149695_a(world, x, y, z, Blocks.field_150350_a);
            if (this.fluid == FluidRegistry.LAVA) {
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), 0.0, 0.0, 0.0);
            }
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
            return false;
        }

        private Block getBlock() {
            if (this.fluid == FluidRegistry.WATER) {
                return Blocks.field_150358_i;
            }
            if (this.fluid == FluidRegistry.LAVA) {
                return Blocks.field_150356_k;
            }
            return this.fluid.getBlock();
        }

        @Override
        public int getDelayTick(Block b, int meta, long surplus, int dist) {
            int d = 2;
            if (this.fluid == FluidRegistry.WATER) {
                d = 8;
            }
            return (int)Math.min(Integer.MAX_VALUE, (long)(4 * dist) / ((long)d * surplus));
        }
    }

    private static class IgnitionLaserEffect
    implements LaserEffect {
        private IgnitionLaserEffect() {
        }

        @Override
        public boolean doEffect(World world, int x, int y, int z, long power, int range, int tickcount, TileEntityHeatRay te) {
            ReikaWorldHelper.ignite((World)world, (int)x, (int)y, (int)z);
            return false;
        }

        @Override
        public int getDelayTick(Block b, int meta, long surplus, int dist) {
            return 0;
        }
    }

    private static class BlockChangeLaserEffect
    implements LaserEffect {
        private final BlockKey replacement;

        private BlockChangeLaserEffect(Block bk) {
            this(new BlockKey(bk, 0));
        }

        private BlockChangeLaserEffect(BlockKey bk) {
            this.replacement = bk;
        }

        @Override
        public boolean doEffect(World world, int x, int y, int z, long power, int range, int tickcount, TileEntityHeatRay te) {
            this.replacement.place(world, x, y, z);
            return true;
        }

        @Override
        public int getDelayTick(Block b, int meta, long surplus, int dist) {
            return (int)Math.min(Integer.MAX_VALUE, (long)(4 * dist) / surplus);
        }
    }
}

